## $Id: editor.py,v 1.1 2001/06/11 12:52:30 kjetilja Exp $

# the editor class defines the interface for a text editor widget. It
# is not used directly; the subclasses LocalStore and IMAPStore are
# used.

class Editor:
    # create the widget and return it
    def widget( self ):
	raise BaseClassUnimplemented 

    # create the widget.  Editor may call the cb when 
    # the user wants to send the mail.  Editor will try to use the
    # given font.
    def __init__( self, prefs, font='' ):
	raise BaseClassUnimplemented 

    # release all resources
    def destroy( self ):
	raise BaseClassUnimplemented 

    # jump to top or bottom of text 
    # pos='top' or pos='bottom'
    def set_scroll_position( self, pos ):
	raise BaseClassUnimplemented 

    def grab_focus( self ):
	raise BaseClassUnimplemented 

    def freeze( self ):
	raise BaseClassUnimplemented 

    def thaw( self ):
	raise BaseClassUnimplemented 

    def redraw( self ):
	raise BaseClassUnimplemented 

    # insert text.  Possible values for 'pos'
    # are 'top', 'bottom', and 'cursor'
    def insert_text( self, text, pos='cursor' ):
	raise BaseClassUnimplemented 

    def cut_clipboard( self ):
	raise BaseClassUnimplemented 

    def copy_clipboard( self ):
	raise BaseClassUnimplemented 

    def paste_clipboard( self ):
	raise BaseClassUnimplemented 

    def insert_file( self, fname, pos ):
	raise BaseClassUnimplemented 

    def format_paragraph( self, width ):
	raise BaseClassUnimplemented 

    def get_length( self ):
	raise BaseClassUnimplemented

    def get_text( self ):
	raise BaseClassUnimplemented 

