## $Id: fileops.py,v 1.4 2001/06/19 20:02:39 jdhildeb Exp $

## System modules
from gtk import *
import os.path

##
## Function gethomedir ()
##
##    Get the invoking users' home directory.
##
##
def gethomedir():
    import os, pwd
    try:
        uid = os.getuid()
    except AttributeError:
        uid = 1

    if os.environ.has_key('HOME'):
        homedir = os.environ['HOME']
    else:
        homedir = pwd.getpwuid(uid)[6]
    return homedir


##
## Function getmailfile ()
##
##    Get the mail spool file.
##
##
def getmailfile():
    import os, pwd
    try:
        uid = os.getuid()
    except AttributeError:
        uid = 1

    if os.environ.has_key('MAIL'):
        spoolfile = os.environ['MAIL']
    else:
        spoolfile = "/var/spool/mail/" + pwd.getpwuid(uid)[0]

    return spoolfile


##
## 
## FileSelection class which enables setting the name.
## 
##
class _MyFileSelection(GtkFileSelection):
    def __init__(self, name, modal=TRUE):
        GtkFileSelection.__init__(self)
        self.connect("destroy", self.quit)
        self.connect("delete_event", self.quit)
        if modal:
            grab_add(self)
        self.cancel_button.connect('clicked', self.quit)
        self.ok_button.connect('clicked', self.ok_cb)
        self.set_filename(name)
        self.ret = None
    def quit(self, *args):
        self.hide()
        self.destroy()
        mainquit()
    def ok_cb(self, b):
        self.ret = self.get_filename()
        self.quit()


##
## Function getfilename(name)
##
##    Get a filename, using the same directory
##    that was used last time for this action.
##
##
def getfilename( filepaths, name='',title='Select file...',action=None):
    # use the same directory as the last time
    if action and filepaths.has_key( action ):
        if name != '':
            name = os.path.join( filepaths[action], name )
        else:
            name = filepaths[action]
    win = _MyFileSelection(name)
    win.set_title(title)
    win.show()
    mainloop()
    ret = win.ret
    if ret and action:
        # remember the path
        filepaths[action] = os.path.dirname( ret ) + '/'
    return ret

##
## Function getsignature (name)
##
##    Get the signature file contents.
##
##
def getsignature(name):
    try:
        f = open(name).read()
    except:
        return ''
    else:
        return f
