## $Id: newmail.py,v 1.7 2001/01/25 22:14:06 kjetilja Exp $

## System modules
from gtk import *
from gnome.ui import *


##
##
## Main new mail class
##
##
class NewMailWindow:
    ##
    ## Method __init__ (self, folder window class instance)
    ##
    ##    New mail widget constructor.
    ##
    ##
    def __init__(self, fld, msgs):
        self.fld = fld
        self.win = GnomeDialog(':Pygmy - New Mail', 'Dismiss')
        self.win.set_parent(self.fld.win)
        self.win.connect('clicked', self.handle_callbacks)
	self.win.connect('delete_event', self.destroy)
	self.win.connect('destroy', self.destroy)

	l = GtkLabel("You have new mail!")
        l.show()
        self.win.vbox.pack_start(l)

        if msgs != []:
            # We have filtered messages, display in a list of the folders
            # they appear in
            c = GtkCList(2, ['#', 'Folder'])
            c.set_column_width(1, 180)
            for msg in msgs:
                pos = c.append(('%d' % msg[0], msg[1]))
            c.show()
            swin = GtkScrolledWindow()
            swin.show()	
            swin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
            swin.set_usize(220, 100)
            swin.add(c)
            self.win.vbox.pack_start(swin)
        else:
            # No filtered messages, just new stuff in the inbox
            l.set_text("You have new mail in your inbox!")

        self.win.show()


    ##
    ## Method handle_callbacks (self, button, no)
    ##
    ##    Handle callbacks for the action buttons.
    ##
    ##
    def handle_callbacks(self, button, no):
        self.fld.new_mail_win = 1
        self.destroy()

        
    ## Just to short-circuit the window delete/destroy events
    def destroy(self, foo=None, bar=None):
        self.win.destroy()
