
/*
 * Copyright (C) 2000-2001 QuantLib Group
 *
 * This file is part of QuantLib.
 * QuantLib is a C++ open source library for financial quantitative
 * analysts and developers --- http://quantlib.sourceforge.net/
 *
 * QuantLib is free software and you are allowed to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of it under the conditions stated
 * in the QuantLib License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license for more details.
 *
 * You should have received a copy of the license along with this file;
 * if not, contact ferdinando@ametrano.net
 * The license is also available at http://quantlib.sourceforge.net/LICENSE.TXT
 *
 * The members of the QuantLib Group are listed in the Authors.txt file, also
 * available at http://quantlib.sourceforge.net/Authors.txt
*/

/*
    $Id: actualactual.hpp,v 1.3 2001/05/08 17:21:11 lballabio Exp $
    $Source: /cvsroot/quantlib/QuantLib/Include/ql/DayCounters/actualactual.hpp,v $
    $Log: actualactual.hpp,v $
    Revision 1.3  2001/05/08 17:21:11  lballabio
    changed comment

    Revision 1.2  2001/05/03 15:35:53  lballabio
    Fixed line wrappings

    Revision 1.1  2001/04/09 14:03:55  nando
    all the *.hpp moved below the Include/ql level

    Revision 1.2  2001/04/06 18:46:19  nando
    changed Authors, Contributors, Licence and copyright header

*/

/*! \file actualactual.hpp
    \brief act/act day counter
*/

#ifndef quantlib_actualactual_day_counter_h
#define quantlib_actualactual_day_counter_h

#include "ql/qldefines.hpp"
#include "ql/daycounter.hpp"

namespace QuantLib {

    namespace DayCounters {

        //! Actual/actual day count according to ISMA
        class ActualActual : public DayCounter {
          public:
            std::string name() const { return std::string("act/act"); }
            int dayCount(const Date& d1, const Date& d2) const { 
                return (d2-d1); }
            Time yearFraction(const Date& d1, const Date& d2,
              const Date& refPeriodStart = Date(), 
              const Date& refPeriodEnd = Date()) const;
        };

    }

}


#endif
