/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_GRID_H
#define QWT_GRID_H

#include <qglobal.h>
#include <qpen.h>
#include "qwt_dimap.h"
#include "qwt_scldiv.h"
#include <qpainter.h>

/*!
  \brief A class which draws a coordinate grid

  The QwtGrid class can be used to draw a coordinate grid.
  A coordinate grid consists of major and minor vertical
  and horizontal gridlines. The locations of the gridlines
  are determined by the X and Y scale divisions which can
  be assigned with @QwtGrid::setXDiv@ and setYDiv()
  The draw() member draws the grid within a bounding
  rectangle.
*/
class QwtGrid
{

protected:

    bool d_xEnabled;
    bool d_yEnabled;
    bool d_xMinEnabled;
    bool d_yMinEnabled;

    QwtScaleDiv d_sdx;
    QwtScaleDiv d_sdy;

    QPen d_majPen;
    QPen d_minPen;

public:

    QwtGrid();
    virtual ~QwtGrid();
    const QwtGrid &operator=(const QwtGrid &g);

    void draw(QPainter *p, const QRect &r, const QwtDiMap &mx, const QwtDiMap &my);

    void enableX(bool tf);
    void enableY(bool tf);
    void enableXMin(bool tf);
    void enableYMin(bool tf);
    
    void setXDiv(const QwtScaleDiv &sx);
    void setYDiv(const QwtScaleDiv &sy);
    
    void setPen(const QPen &p);
    void setMajPen(const QPen &p);
    void setMinPen(const QPen &p);

  /*!
    \return the pen for the major gridlines
    \sa QwtGrid::setMinPen, QwtGrid:.setPen
  */
  const QPen& majPen() const { return d_majPen; }
  /*!
    \return the pen for the minor gridlines
    \sa QwtGrid::setMinPen, QwtGrid:.setPen
  */
  const QPen& minPen() const { return d_minPen; }
  
  /*!
    \return TRUE if vertical gridlines are enabled
    \sa QwtGrid::enableX
  */
  bool xEnabled() const{ return d_xEnabled; }


  /*!
    \return TRUE if minor vertical gridlines are enabled
    \sa QwtGrid::enableXMin
  */
  bool xMinEnabled() const { return d_xMinEnabled; }

  /*!
    \return TRUE if horizontal gridlines are enabled
    \sa QwtGrid::enableY
  */
  bool yEnabled() const { return d_yEnabled; }

  /*!
    \return TRUE if minor horizontal gridlines are enabled
    \sa QwtGrid::enableYMin
  */
  bool yMinEnabled() const {return d_yMinEnabled; }

  
  /*! \return the scale division of the x axis */
  const QwtScaleDiv &xScaleDiv() const { return d_sdx; }

  /*! \return the scale division of the y axis */
  const QwtScaleDiv &yScaleDiv() const { return d_sdy; }
  
protected:
  /*!
    \brief Notify a change of attributes
    
    This virtual function is called when an attribute of the grid
    has changed. It can be redefined by derived classes. The
    default implementation does nothing.
  */
  virtual void gridChanged() {}
  
};



#endif
