/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_PLOT_CLASSES_H
#define QWT_PLOT_CLASSES_H

#include "qwt_plot_item.h"

//
//  Special classes used by QwtPlot
//

class QwtPlotCurve: public QwtCurve, public QwtPlotMappedItem
{
public:
    QwtPlotCurve(QwtPlot* parent, const char *name = 0)
       : QwtCurve(name), QwtPlotMappedItem(parent) {}
    
    ~QwtPlotCurve() {}
    
protected:
    void curveChanged() { itemChanged(); }

};



class QwtPlotGrid: public QwtGrid, public QwtPlotMappedItem
{
public:

    QwtPlotGrid(QwtPlot *parent)
       : QwtPlotMappedItem(parent) {}
    
    ~QwtPlotGrid() {}

protected:

    void gridChanged() { itemChanged(); }
};


class QwtPlotMarker: public QwtMarker, public QwtPlotMappedItem 
{
private:
    
    double d_xValue;
    double d_yValue;
    
public:
    
    QwtPlotMarker(QwtPlot *parent)
       : QwtPlotMappedItem(parent) {}

    ~QwtPlotMarker() {}
    
    double xValue() const { return d_xValue; }
    double yValue() const { return d_yValue; }

    void setXValue(double val) { d_xValue = val; markerChanged(); }
    void setYValue(double val) { d_yValue = val; markerChanged(); }

protected:

    void markerChanged() { itemChanged(); }

};




#endif




