/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_PLOT_ITEM
#define QWT_PLOT_ITEM

#include <qglobal.h>
//
//	Base classes inherited by all items
//	included by QwtPlot
//

class QwtPlot;

class QwtPlotItem
{
private:
    bool d_enabled;
    QwtPlot *d_parent;

protected:
    QwtPlot *parentPlot() { return d_parent; }

public:
    
    QwtPlotItem(QwtPlot *parent, bool nbl = TRUE);

    virtual void itemChanged();
    
    virtual void setEnabled(bool tf) { d_enabled = tf; itemChanged(); }
    bool enabled() { return d_enabled; }
};
			

class QwtPlotMappedItem : public QwtPlotItem 
{
private:
    int d_xAxis;
    int d_yAxis;
    
public:

    QwtPlotMappedItem(QwtPlot *parent, bool nbl = TRUE)
       : QwtPlotItem(parent, nbl) {  }
    
    int xAxis() const { return d_xAxis; }
    int yAxis() const { return d_yAxis; }

    void setXAxis(int axis);
    void setYAxis(int axis);
};

#endif




