/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_SCALE_H
#define QWT_SCALE_H

#include <qwidget.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>

#include "qwt_sclif.h"
#include "qwt_autoscl.h"

/*!
  \brief A Widget which contains a scale

  This Widget can be used to decorate composite widgets with
  a scale.
*/
class QwtScale : public QWidget
{
    QwtScaleDraw d_scale;
    QwtScaleDiv d_sdiv;
    
    int d_borderDist[2];
    int d_scaleLength;
    int d_baseDist;

    int d_titleOffset;
    QString d_title;
    int d_titleDist;
    QFont d_titleFont;
    QColor d_titleColor;

public:

    enum Orientation { Left, Right, Top, Bottom };

    QwtScale(Orientation, QWidget *parent, const char *name = 0);
    ~QwtScale();
    
    void setTitle(const char *title);
    void setBorderDist(int start, int end);
    void setScale(const QwtScaleDiv &sd);
    void setLabelFormat(char f, int prec);
    
    void setBaselineDist(int bd);
    void setTitleFont(const QFont &f);
    void setTitleColor(const QColor &c);
    void enableTitle(bool tf);

    const QFont &titleFont() const { return d_titleFont; }
    const QColor &titleColor() const { return d_titleColor; }
    const QString& title() const { return d_title; }
    int minBorderDist() const;
	void labelFormat(char &f, int &prec) const;
    
    QSize sizeHint() const;

protected:

    void paintEvent(QPaintEvent *e);
    void resizeEvent(QResizeEvent *e);
    void scaleChange();
    void fontChange(const QFont &oldfont);
    const QwtDiMap &map() const { return d_scale; }

private:
    void resizeScale();
				  
    
};

#endif




