/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_WHEEL_H
#define QWT_WHEEL_H

#include "qwt_sldbase.h"
#include <math.h>
#include <qpixmap.h>


/*!
  \brief The Wheel Widget

  The wheel widget can be used to change values over a very large range
  in very small steps. Using the setMass member, it can be configured
  as a flywheel.

  \sa The radio example.
*/
class QwtWheel : public QwtSliderBase
{

public:
    enum Orientation { Horizontal, Vertical };
private:

    //
    //  PRIVATE DATA
    //
    int minPos;
    int maxPos;
    double viewAngle;
    double totalAngle;
    int tickCnt;
    int d_intBorder;
    int d_borderWidth;
    int d_colorCnt;

    QPixmap d_pixmap;					// background pixmap
    QRect d_sliderRect;
    QColor *d_colors;
    
    Orientation d_orient;

    //
    // PRIVATE MEMBER FUNCTIONS
    //
    void createColors();
    void rebuildPixmap();
    void drawWheel(QPainter *p, const QRect &r);

public:
    //
    //  PUBLIC MEMBER FUNCTIONS
    //

    QwtWheel(QWidget *parent = 0, const char *name = 0);
    ~QwtWheel();

    
    void setTotalAngle (double angle);
    void setTickCnt(int cnt);
    void setOrientation(Orientation o);
    void setViewAngle(double angle);
    void setInternalBorder(int width);
    void setMass(double val);

private:

    void resizeEvent(QResizeEvent *e);
    void paintEvent(QPaintEvent *e);
    //
    // Functions required by QwtSliderBase  
    //
    void valueChange();
    double getValue(const QPoint &p);
    void getScrollMode( const QPoint &p, int &scrollMode, int &direction);
    
};

#endif


















