/*-*- c++ -*-******************************************************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_WHEEL_H
#define QWT_WHEEL_H

#include "qwt_global.h"
#include "qwt_sldbase.h"

/*!
  \brief The Wheel Widget

  The wheel widget can be used to change values over a very large range
  in very small steps. Using the setMass member, it can be configured
  as a flywheel.

  \sa The radio example.
*/
class QWT_EXPORT QwtWheel : public QwtSliderBase
{
    Q_OBJECT 

public:

    QwtWheel(QWidget *parent = 0, const char *name = 0);
    virtual ~QwtWheel();

    void setTotalAngle (double angle);
    void setTickCnt(int cnt);
    void setOrientation(Qt::Orientation o);
    void setViewAngle(double angle);
    void setInternalBorder(int width);
    void setMass(double val);
    void setWheelWidth( int w );

    virtual QSize sizeHint() const;
    virtual QSize minimumSizeHint() const;
    virtual QSizePolicy sizePolicy() const;

protected:
    virtual void resizeEvent(QResizeEvent *e);
    virtual void paintEvent(QPaintEvent *e);

    void layoutWheel( bool update = TRUE );
    void draw(QPainter *p, const QRect& update_rect);
    void drawWheel(QPainter *p, const QRect &r);
    void drawWheelBackground(QPainter *p, const QRect &r);
    void setColorArray();

    virtual void valueChange();
    virtual void paletteChange( const QPalette &);

    virtual double getValue(const QPoint &p);
    virtual void getScrollMode(const QPoint &p, 
        int &scrollMode, int &direction);

private:
    QColor* d_colors;
    QRect d_sliderRect;
    double d_viewAngle;
    double d_totalAngle;
    int d_tickCnt;
    int d_intBorder;
    int d_borderWidth;
    int d_colorCnt;
    int d_wheelWidth;
    int d_allocContext;
    Qt::Orientation d_orient;
};

#endif
