module Irc

  # class to store IRC channel data (users, topic, per-channel configurations)
  class IRCChannel
    # name of channel
    attr_reader :name
    
    # current channel topic
    attr_accessor :topic
    
    # hash containing users currently in the channel
    attr_accessor :users
    
    # if true, bot won't talk in this channel
    attr_accessor :quiet
    
    # name:: channel name
    # create a new IRCChannel
    def initialize(name)
      @name = name
      @users = Hash.new
      @quiet = false
    end

  end

end
