module Irc

  # the bot's language class. This is how the bot communicates, by looking up
  # strings through this class. So instead of saying "okay", the bot looks up
  # "okay" in the Language class, which will return one of several "okay"
  # strings defined in its language file. Different language files can be used
  # for different real languages, or even to simulate different bot
  # personalities.
  class Language

    # Create a language class instance of language +language+
    def initialize(language)
      @language = language
      unless(FileTest.exist?(File.dirname(__FILE__) + "/languages/#{@language}.lang"))
        raise "no such language: #{@language}"
      end
      scan
    end

    # load language data from files
    def scan
      @strings = Hash.new
      current_key = nil
      IO.foreach(File.dirname(__FILE__) + "/languages/#{@language}.lang") {|l|
        next if l =~ /^$/
        next if l =~ /^\s*#/
        if(l =~ /^(\S+):$/)
          @strings[$1] = Array.new
          current_key = $1
        elsif(l =~ /^\s*(.*)$/)
          @strings[current_key] << $1
        end
      }
    end

    # reload language data from files
    def rescan
      scan
    end
    
    # get suitable expression for +key+
    def get(key)
      if(@strings.has_key?(key))
        return @strings[key][rand @strings[key].length]
      else
        raise "undefined language key"
      end
    end
  end

end
