require 'net/http'
require 'uri/common'
Net::HTTP.version_1_2

class BabelPlugin < Plugin
  def help(plugin, topic="")
    "translate to <lang> <string> => translate from english to <lang>, translate from <lang> <string> => translate to english from <lang>, translate <fromlang> <tolang> <string> => translate from <fromlang> to <tolang>. Languages: en, fr, de, it, pt, es"
  end
  def privmsg(m)

    proxy_host = nil
    proxy_port = nil

    if(ENV['http_proxy'])
      if(ENV['http_proxy'] =~ /^http:\/\/(.+):(\d+)$/)
        proxy_host = $1
        proxy_port = $2
      end
    end
    
    langs = ["en", "fr", "de", "it", "pt", "es"]

    query = "/raging/translate.dyn"
    if(m.params =~ /^to\s+(\S+)\s+(.*)/)
      trans_from = "en"
      trans_to = $1
      trans_text = $2
    elsif(m.params =~ /^from\s+(\S+)\s+(.*)/)
      trans_from = $1
      trans_to = "en"
      trans_text = $2
    elsif(m.params =~ /^(\S+)\s+(\S+)\s+(.*)/)
      trans_from = $1
      trans_to = $2
      trans_text = $3
    else
      m.reply "incorrect usage: " + help(m.plugin)
      return
    end
    lang_match = langs.join("|")
    unless(trans_from =~ /^(#{lang_match})$/ && trans_to =~ /^(#{lang_match})$/)
      m.reply "invalid language: valid languagess are: #{langs.join(' ')}"
      return
    end

    data_text = URI.escape trans_text
    trans_pair = "#{trans_from}_#{trans_to}"
    data = "lp=#{trans_pair}&urltext=#{data_text}"

    http = Net::HTTP.new("babelfish.altavista.com", 80, proxy_host, proxy_port)

    http.start {|http|
      resp = http.post(
        query, data, {
          "content-type", "application/x-www-form-urlencoded"
        }
      )
      if resp.code == "200"
        #debug resp.body
        resp.body.each_line {|l|
          if(l =~ /<textarea rows=1 wrap=virtual cols=52 name=.>(.*)$/)
            m.reply $1
            return
          end
        }
      else
        m.reply "couldn't talk to babelfish :("
      end
    }
  end
end
plugin = BabelPlugin.new
plugin.register("translate")

