class DnsPlugin < Plugin
  def help(plugin, topic="")
    "nslookup|dns <hostname|ip> => show local resolution results for hostname or ip address"
  end
  def privmsg(m)
    unless(m.params)
      m.reply "incorrect usage: " + help(m.plugin)
      return
    end
    
    if(m.params =~ /^\d+\.\d+\.\d+\.\d+$/)
      begin
        a = Socket.gethostbyname(m.params)
        m.reply m.params + ": " + a[0] if a
      rescue StandardError => err
        m.reply "#{m.params}: not found"
      end
    elsif(m.params =~ /^(\w|\.)+$/)
      begin
        a = Socket.gethostbyname(m.params)
        list = Socket.getaddrinfo(a[0], 'http')
        addresses = Array.new
        list.each {|line|
          addresses << line[3]
        }
        m.reply m.params + ": " + addresses.join(", ")
      rescue StandardError => err
        m.reply "#{m.params}: not found"
      end
    else
      m.reply "incorrect usage: " + help(m.plugin)
    end
  end
end
plugin = DnsPlugin.new
plugin.register("nslookup")
plugin.register("dns")
