# Author: oct

class SlapPlugin < Plugin
  def initialize
    super
    @verbs=['slaps', 'hits', 'smashes', 'beats', 'bashes', 'smacks', 'slays']
    @tool=['trout','fork','mouse','bear', 'vaccum cleaner','mosquito']
    @size=['large','huge','small','tiny', nil]
    @way=['around the head', 'in the face', 'to death', nil]
  end
  def help(plugin, topic="")
    "slap module: slap nick"
  end
  def privmsg(m)
    unless(m.params)
      m.reply "incorrect usage: " + m.plugin
    end
    verb = @verbs[rand @verbs.length]
    way = @way[rand @way.length]
    size = @size[rand @size.length]
    tool = @tool[rand @tool.length]
    action = "#{verb} #{m.params} #{way + ' ' if way}with a #{size + ' ' if size}#{tool}"
    @bot.action m.replyto, action
  end
end
plugin = SlapPlugin.new
plugin.register("slap")
