module Irc

  # miscellaneous useful functions
  module Utils
    # read a time in string format, turn it into "seconds from now".
    # example formats handled are "5 minutes", "2 days", "five hours",
    # "11:30", "15:45:11", "one day", etc.
    #
    # Throws:: RunTimeError "invalid time string" on parse failure
    def Utils.timestr_offset(timestr)
      case timestr
        when (/^(\S+)\s+(\S+)$/)
          mult = $1
          unit = $2
          if(mult =~ /^([\d.]+)$/)
            num = $1.to_f
            raise "invalid time string" unless num
          else
            case mult
              when(/^(one|an|a)$/)
                num = 1
              when(/^two$/)
                num = 2
              when(/^three$/)
                num = 3
              when(/^four$/)
                num = 4
              when(/^five$/)
                num = 5
              when(/^six$/)
                num = 6
              when(/^seven$/)
                num = 7
              when(/^eight$/)
                num = 8
              when(/^nine$/)
                num = 9
              when(/^ten$/)
                num = 10
              when(/^fifteen$/)
                num = 15
              when(/^twenty$/)
                num = 20
              when(/^thirty$/)
                num = 30
              when(/^sixty$/)
                num = 60
              else
                raise "invalid time string"
            end
          end
          case unit
            when (/^(s|sec(ond)?s?)$/)
              return num
            when (/^(m|min(ute)?s?)$/)
              return num * 60
            when (/^(h|h(ou)?rs?)$/)
              return num * 60 * 60
            when (/^(d|days?)$/)
              return num * 60 * 60 * 24
            else
              raise "invalid time string"
          end
        when (/^(\d+):(\d+):(\d+)$/)
          hour = $1.to_i
          min = $2.to_i
          sec = $3.to_i
          now = Time.now
          later = Time.mktime(now.year, now.month, now.day, hour, min, sec)
          return later - now
        when (/^(\d+):(\d+)$/)
          hour = $1.to_i
          min = $2.to_i
          now = Time.now
          later = Time.mktime(now.year, now.month, now.day, hour, min, now.sec)
          return later - now
        when (/^(\d+):(\d+)(am|pm)$/)
          hour = $1.to_i
          min = $2.to_i
          ampm = $3
          if ampm == "pm"
            hour += 12
          end
          now = Time.now
          later = Time.mktime(now.year, now.month, now.day, hour, min, now.sec)
          return later - now
        when (/^(\S+)$/)
          num = 1
          unit = $1
          case unit
            when (/^(s|sec(ond)?s?)$/)
              return num
            when (/^(m|min(ute)?s?)$/)
              return num * 60
            when (/^(h|h(ou)?rs?)$/)
              return num * 60 * 60
            when (/^(d|days?)$/)
              return num * 60 * 60 * 24
            else
              raise "invalid time string"
          end
        else
          raise "invalid time string"
      end
    end
  end
end
