class CalPlugin < Plugin
  def help(plugin, topic="")
    "cal [options] => show current calendar [unix cal options]"
  end
  def privmsg(m)
    IO.popen("-") {|p|
      if(p)
        m.reply p.readlines.join("\n")
      else
        $stderr = $stdout
        begin
          if m.params && m.params.length > 0
            exec("cal", m.params) 
          else
            exec("cal")
          end
        rescue Exception => e
          puts "cal plugin exception: #{e}"
          Kernel::exit! 0
        end
        puts "exec of cal failed"
        Kernel::exit! 0
      end
    }
    return
  end
end
plugin = CalPlugin.new
plugin.register("cal")
