class HostPlugin < Plugin
  def help(plugin, topic="")
    "host <domain> => query nameserver about domain names and zones for <domain>"
  end
  def privmsg(m)
    unless(m.params =~ /^(\w|\.)+$/)
      m.reply "incorrect usage: " + help(m.plugin)
      return
    end
    IO.popen("-") {|p|
      if(p)
        m.reply p.readlines.join("\n")
      else
        begin
          $stderr = $stdout
          exec("host", m.params)
          Kernel::exit! 0
        rescue Exception => e
          puts "host plugin exception: #{e}"
          Kernel::exit! 0
        end
        puts "exec of host failed"
        Kernel::exit! 0
      end
    }
    return
  end
end
plugin = HostPlugin.new
plugin.register("host")
