Saw = Struct.new("Saw", :nick, :time, :type, :where, :message)

class SeenPlugin < Plugin
  def help(plugin, topic="")
    "seen <nick> => have you seen, or when did you last see <nick>"
  end
  
  def privmsg(m)
    unless(m.params =~ /^(\S)+$/)
      m.reply "incorrect usage: " + help(m.plugin)
      return
    end

    m.params.gsub!(/\?$/, "")

    if @registry.has_key?(m.params)
      m.reply seen(@registry[m.params])
    else
      m.reply "nope!"
    end
  end

  def listen(m)
    # keep database up to date with who last said what
    if m.kind_of?(PrivMessage)
      return if m.private? || m.address?
      if m.action?
        @registry[m.sourcenick] = Saw.new(m.sourcenick.dup, Time.new, "ACTION", 
                                          m.target, m.message.dup)
      else
        @registry[m.sourcenick] = Saw.new(m.sourcenick.dup, Time.new, "PUBLIC",
                                          m.target, m.message.dup)
      end
    elsif m.kind_of?(QuitMessage)
      @registry[m.sourcenick] = Saw.new(m.sourcenick.dup, Time.new, "QUIT", 
                                        nil, m.message.dup)
    elsif m.kind_of?(NickMessage)
      @registry[m.message] = Saw.new(m.sourcenick.dup, Time.new, "NICK", 
                                        nil, m.message.dup)
      @registry[m.sourcenick] = Saw.new(m.sourcenick.dup, Time.new, "NICK", 
                                        nil, m.message.dup)
    elsif m.kind_of?(PartMessage)
      @registry[m.sourcenick] = Saw.new(m.sourcenick.dup, Time.new, "PART", 
                                        m.target, m.message.dup)
    elsif m.kind_of?(JoinMessage)
      @registry[m.sourcenick] = Saw.new(m.sourcenick.dup, Time.new, "JOIN", 
                                        m.target, m.message.dup)
    elsif m.kind_of?(TopicMessage)
      @registry[m.sourcenick] = Saw.new(m.sourcenick.dup, Time.new, "TOPIC", 
                                        m.target, m.message.dup)
    end
  end
  
  def seen(saw)
    ret = "#{saw.nick} was last seen "
    ago = Time.new - saw.time
    
    if (ago.to_i == 0)
      ret += "just now, "
    else
      days = (ago / (60*60*24)).to_i
      ago = ago % (60*60*24)
      hours = (ago / (60*60)).to_i
      ago = ago % (60*60)
      minutes = (ago / 60).to_i
      ago = ago % 60
      seconds = ago.to_i

      ret += "#{days} days " if days > 1
      ret += "#{days} day " if days == 1
      ret += "#{hours} hours " if hours > 1
      ret += "#{hours} hour " if hours == 1
      ret += "#{minutes} minutes " if minutes > 1
      ret += "#{minutes} minute " if minutes == 1
      ret += "#{seconds} seconds " if seconds > 1
      ret += "#{seconds} second " if seconds == 1

      ret += "ago, "
    end

    case saw.type
    when "PUBLIC"
      ret += "saying #{saw.message}"
    when "ACTION"
      ret += "doing #{saw.nick} #{saw.message}"
    when "NICK"
      ret += "changing nick from #{saw.nick} to #{saw.message}"
    when "PART"
      ret += "leaving #{saw.where}"
    when "JOIN"
      ret += "joining #{saw.where}"
    when "QUIT"
      ret += "quiting IRC (#{saw.message})"
    when "TOPIC"
      ret += "changing the topic of #{saw.where} to #{saw.message}"
    end
  end
  
end
plugin = SeenPlugin.new
plugin.register("seen")
