# Author: oct

class SlapPlugin < Plugin
  def initialize
    super
    @verbs=['slaps', 'hits', 'smashes', 'beats', 'bashes', 'smacks', 'blats']
    @tool=['trout','fork','mouse','bear', 'piano', 'chello', 'vacuum cleaner','mosquito']
    @size=['large','huge','small','tiny', nil]
    @way=['around the head', 'viciously', 'repeatedly', 'in the face', 'to death', nil]
  end
  def help(plugin, topic="")
    "slap module: slap nick"
  end
  def privmsg(m)
    unless(m.params)
      m.reply "incorrect usage: " + m.plugin
    end
    target = m.params
    target = m.sourcenick if(m.params == "me")
    if(m.params == "yourself" || m.params == "himself" || m.params == @bot.nick)
      m.reply "piss off!"
      return
    end
    debug m.params
    verb = @verbs[rand @verbs.length]
    way = @way[rand @way.length]
    size = @size[rand @size.length]
    tool = @tool[rand @tool.length]
    action = "#{verb} #{target} #{way + ' ' if way}with a #{size + ' ' if size}#{tool}"
    @bot.action m.replyto, action
  end
end
plugin = SlapPlugin.new
plugin.register("slap")

