Url = Struct.new("Url", :channel, :nick, :time, :url)

class UrlPlugin < Plugin
  def initialize
    super
    @registry.set_default(Array.new)
  end
  def help(plugin, topic="")
    "urls [<max>=4] => list <max> last urls mentioned in current channel, urls <channel> [<max>=4] => list <max> last urls mentioned in <channel>"
  end
  def listen(m)
    return unless m.kind_of?(PrivMessage)
    return if m.address?
    if m.message =~ /http:\/\//
      if m.message =~ /(http:\/\/.*?)(?:\s+|$)/
        url = Url.new(m.target, m.sourcenick, Time.new, $1)
        list = @registry[m.target]
        if list.length > 50
          list.pop
        end
        puts "storing url #{url.url}"
        list.unshift url
        @registry[m.target] = list
      end
    end
  end
  def privmsg(m)
    case m.params
    when nil
      if m.public?
        urls m, m.target
      else
        m.reply "in a private message, you need to specify a channel name for urls"
      end
    when (/^(\d+)$/)
      max = $1.to_i
      if m.public?
        urls m, m.target, max
      else
        m.reply "in a private message, you need to specify a channel name for urls"
      end
    when (/^(#.*?)\s+\d+$/)
      channel = $1
      max = $2.to_i
      urls m, channel, max
    when (/^(#.*?)$/)
      channel = $1
      urls m, channel
    else
      m.reply "incorrect usage: " + help(m.plugin)
    end
  end

  def urls(m, channel, max=4)
    max = 6 if max > 6
    max = 1 if max < 1
    list = @registry[channel]
    if list.empty?
      m.reply "no urls seen yet for channel #{channel}"
    else
      list[0..(max-1)].each do |url|
        m.reply "[#{url.time.strftime('%Y/%m/%d %H:%M:%S')}] <#{url.nick}> #{url.url}"
      end
    end
  end
end
plugin = UrlPlugin.new
plugin.register("urls")
