/* -*- Mode: c; c-basic-offset: 2 -*-
 *
 * rdf_iterator.h - RDF Iterator definition
 *
 * $Id: rdf_iterator.h,v 1.12 2001/03/27 14:27:56 cmdjb Exp $
 *
 * Copyright (C) 2000-2001 David Beckett - http://purl.org/net/dajobe/
 * Institute for Learning and Research Technology - http://www.ilrt.org/
 * University of Bristol - http://www.bristol.ac.uk/
 * 
 * This package is Free Software or Open Source available under the
 * following licenses (these are alternatives):
 *   1. GNU Lesser General Public License (LGPL)
 *   2. GNU General Public License (GPL)
 *   3. Mozilla Public License (MPL)
 * 
 * See LICENSE.html or LICENSE.txt at the top of this package for the
 * full license terms.
 * 
 * 
 */



#ifndef LIBRDF_ITERATOR_H
#define LIBRDF_ITERATOR_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef LIBRDF_INTERNAL

/* used in map_list below */
typedef struct {
  void *context; /* context to pass on to map */
  void* (*fn)(void *context, void *element);
} librdf_iterator_map;

struct librdf_iterator_s {
  librdf_world *world;
  void *context;
  int is_finished; /* 1 when have no more elements */

  /* Used when mapping */
  void *next;            /* stores next element */
  librdf_list *map_list; /* non-empty means there is a list of maps */
  
  int (*is_end)(void*);
  void* (*get_next)(void*);
  void (*finished)(void*);
};

#endif

librdf_iterator* librdf_new_iterator(librdf_world *world, void *context, int (*is_end)(void*), void* (*get_next)(void*), void (*finished)(void*));

void librdf_free_iterator(librdf_iterator*);

int librdf_iterator_end(librdf_iterator* iterator);
int librdf_iterator_have_elements(librdf_iterator* iterator);

int librdf_iterator_finished(librdf_iterator* iterator);

void* librdf_iterator_get_next(librdf_iterator* iterator);

int librdf_iterator_add_map(librdf_iterator* iterator, void* (*fn)(void *context, void *item), void *context);

void* librdf_iterator_map_remove_duplicate_nodes(void *item, void *user_data);

#ifdef __cplusplus
}
#endif

#endif
