=begin
= Ruby/ClibPDF
ClibPDF  ruby 󥿥ե

== Module/Class Hierarchy

  ClibPDF -+
           |
           +- ClibPDF::PDF
           |
           +- ClibPDF::PlotDomain -+
           |                       |
           |                       +- ClibPDF::TimePlotDomain
           |
           +- ClibPDF::Axis -------+
                                   |
                                   +- ClibPDF::TimeAxis

= Module ClibPDF

== 

=== ѥ᡼κ

--- ClibPDF::NMAXOBJECTS

--- ClibPDF::NMAXFONTS

--- ClibPDF::NMAXPAGES

--- ClibPDF::NMAXIMAGES

--- ClibPDF::NMAXANNOTS

=== 

--- ClibPDF::PI

=== YES or NO

--- ClibPDF::YES

--- ClibPDF::NO

=== °

--- ClibPDF::LINEAR

--- ClibPDF::LOGARITHMIC

--- ClibPDF::TIME

=== Υեޥå

--- ClibPDF::MONTH_NUMBER

--- ClibPDF::MONTH_NAME

--- ClibPDF::YEAR_FULL

--- ClibPDF::YEAR_4DIGIT

--- ClibPDF::YEAR_2DIGIT

=== meshΥѥ᡼

--- ClibPDF::X_MESH

--- ClibPDF::Y_MESH

=== ѻθ

--- ClibPDF::PORTRAIT

--- ClibPDF::LANDSCAPE

=== Ĺñ

--- ClibPDF::INCH

--- ClibPDF::CM

--- ClibPDF::POINTSPERINCH

--- ClibPDF::POINTSPERCM

--- ClibPDF::POINTSPERMM

=== Conv factor to get char height of char '0' from font size.

--- ClibPDF::FONTSIZE2HEIGHT

=== ѻ極

--- ClibPDF::LETTER

--- ClibPDF::LEGAL

--- ClibPDF::A4

--- ClibPDF::B5

--- ClibPDF::C5

--- ClibPDF::DL

--- ClibPDF::EXECUTIVE

--- ClibPDF::COMM10

--- ClibPDF::MONARCH

--- ClibPDF::FILM35MM

--- ClibPDF::DEFAULT_PAGESIZE

=== tick/number selector masks

--- ClibPDF::LOGAXSEL_1

--- ClibPDF::LOGAXSEL_13

--- ClibPDF::LOGAXSEL_125

--- ClibPDF::LOGAXSEL_12468

--- ClibPDF::LOGAXSEL_12357

--- ClibPDF::LOGAXSEL_123456789

--- ClibPDF::LOGAXSEL_MIN

--- ClibPDF::LOGAXSEL_MAX

=== ƥȥ󥰥⡼

--- ClibPDF::TEXT_FILL

--- ClibPDF::TEXT_STROKE

--- ClibPDF::TEXT_FILL_STROKE

--- ClibPDF::TEXT_INVISIBLE

--- ClibPDF::TEXT_FILL_CLIP

--- ClibPDF::TEXT_STROKE_CLIP

--- ClibPDF::TEXT_FILL_STROKE_CLIP

--- ClibPDF::TEXT_CLIP

=== ƥ֥⡼

--- ClibPDF::TEXTPOS_LL
--- ClibPDF::TEXTPOS_LM
--- ClibPDF::TEXTPOS_LR
--- ClibPDF::TEXTPOS_ML
--- ClibPDF::TEXTPOS_MM
--- ClibPDF::TEXTPOS_MR
--- ClibPDF::TEXTPOS_UL
--- ClibPDF::TEXTPOS_UM
--- ClibPDF::TEXTPOS_UR

=== ⡼

--- ClibPDF::IMAGE_MASK
--- ClibPDF::CS_GRAY
--- ClibPDF::CS_RGB
--- ClibPDF::CS_CMYK

=== For cpdf_pointer()

--- ClibPDF::PTR_RIGHT

--- ClibPDF::PTR_DOWN

--- ClibPDF::PTR_LEFT

--- ClibPDF::PTR_UP

=== Page transition types

--- ClibPDF::TRANS_NONE
--- ClibPDF::TRANS_SPLIT
--- ClibPDF::TRANS_BLINDS
--- ClibPDF::TRANS_BOX
--- ClibPDF::TRANS_WIPE
--- ClibPDF::TRANS_DISSOLVE
--- ClibPDF::TRANS_GLITTER

=== textBox  align

--- ClibPDF::TBOX_LEFT
--- ClibPDF::TBOX_CENTER
--- ClibPDF::TBOX_RIGHT
--- ClibPDF::TBOX_JUSTIFY

=== Values for pageMode and nonFSPageMode

--- ClibPDF::PM_NONE
--- ClibPDF::PM_OUTLINES
--- ClibPDF::PM_THUMBS
--- ClibPDF::PM_FULLSCREEN

--- ClibPDF::PL_SINGLE
--- ClibPDF::PL_1COLUMN
--- ClibPDF::PL_2LCOLUMN
--- ClibPDF::PL_2RCOLUMN

=== 

--- ClibPDF::JPEG_IMG
--- ClibPDF::G4FAX_IMG
--- ClibPDF::G3FAX_IMG
--- ClibPDF::TIFF_IMG
--- ClibPDF::GIF_IMG
--- ClibPDF::CPDF_IMG

=== Annotation, hyperlink info object

--- ClibPDF::ANNOT_TEXT
--- ClibPDF::ANNOT_URL
--- ClibPDF::ANNOT_GOTO
--- ClibPDF::ANNOT_ACTION

=== Annotation flags, may be OR'ed together

--- ClibPDF::AF_INVISIBLE
--- ClibPDF::AF_HIDDEN
--- ClibPDF::AF_PRINT
--- ClibPDF::AF_NOZOOM
--- ClibPDF::AF_NOROTATE
--- ClibPDF::AF_NOVIEW
--- ClibPDF::AF_READONLY

=== Outline (book mark) destination modes

--- ClibPDF::DEST_NULL
--- ClibPDF::DEST_XYZ
--- ClibPDF::DEST_FIT
--- ClibPDF::DEST_FITH
--- ClibPDF::DEST_FITV
--- ClibPDF::DEST_FITR
--- ClibPDF::DEST_FITB
--- ClibPDF::DEST_FITBH
--- ClibPDF::DEST_FITBV
--- ClibPDF::DEST_Y

--- ClibPDF::OL_SUBENT
--- ClibPDF::OL_SAME
--- ClibPDF::OL_OPEN
--- ClibPDF::OL_CLOSED

== Module Functino

--- ClibPDF.escapeSpecialChars(instr)

= Class ClibPDF::PDF

== Class Methods

--- ClibPDF::PDF.open(pspdf, [nMaxPages, nMaxFonts, nMaxImages, nMaxAnnots, nMaxObjects])
      PDF 饹֤

== Methods

=== λط

--- ClibPDF::PDF#init()
      PDF 饹롣(⤷ ClibPDF::PDF.open() ٤)

--- ClibPDF::PDF#pageInit(pagenum, rot, mediaboxstr, cropboxstr)
      ڡν򤹤롣
      ((|rot|)) ѻθ ClibPDF::PORTRAIT, ClibPDF::LANDSCAPE
      Τ줫ǻꤹ롣
      ((|mediaboxstr|)), ((|mediaboxstr|)) ѻ極ʲΤ줫ǻꤹ롣
      ClibPDF::LETTER, ClibPDF::LEGAL, ClibPDF::A4, ClibPDF::B5, ClibPDF::C5,
      ClibPDF::DL, ClibPDF::EXECUTIVE, ClibPDF::COMM10, ClibPDF::MONARCH, ClibPDF::FILM35MM

--- ClibPDF::PDF#finalizeAll()
      PDF Фλ롣

--- ClibPDF::PDF#close()
      PDF 饹λ롣(ʤ褦ˤ٤)

--- ClibPDF::PDF#setCurrentPage(page)
      ȥڡꤹ롣

--- ClibPDF::PDF#setGlobalDocumentLimits(nMaxPages, nMaxFonts, nMaxImages, nMaxAnnots, nMaxObjects)
      ƥѥ᡼κͤꡣ

--- ClibPDF::PDF#finalizePage(page)
      ڡ ((|page|)) λ롣

--- ClibPDF::PDF#enableCompression(cmpON)
      ̤뤫ɤ ClibPDF::YES, ClibPDF::NO ǻꤹ롣

--- ClibPDF::PDF#setDefaultDomainUnit(defunit)
      ɸñ̤ꤹ롣
      ClibPDF::PDF#pageInit() Ƥ˸Ƥɬפ롣

--- ClibPDF::PDF#setOutputFilename(filename)
      PDF ϥե̾ꤹ롣
      ClibPDF::PDF#init()  ClibPDF::PDF#pageInit() δ֤ǸƤɬפ롣

--- ClibPDF::PDF#useContentMemStream(flag)

--- ClibPDF::PDF#setPageDuration(seconds)
      饤ɥ硼ȤΥڡɽ(ñ)ꤹ롣

--- ClibPDF::PDF#setPageTransition(type, duration, direction, HV, IO)

=== PDF 

--- ClibPDF::PDF#getBufferForPDF(length)

--- ClibPDF::PDF#savePDFmemoryStreamToFile(filename)
      PDF Ƥե¸롣

--- ClibPDF::PDF#openPDFfileInViewer(pdffilepath)
      ((|pdffilepath|)) Ǥ PDFե PDFץӥ塼ɽ롣
      ((|pdffilepath|))  nil ꤷϡ PDF ɽ롣

--- ClibPDF::PDF#launchPreview()
       PDF  PDFץӥ塼ɽ롣

=== եå/ط

--- ClibPDF::PDF#moveto(x, y)
--- ClibPDF::PDF#rawMoveto(x, y)
      ȥݥȤ (((|x|)), ((|y|))) ˰ư롣

--- ClibPDF::PDF#rmoveto(x, y)
--- ClibPDF::PDF#rawRmoveto(x, y)
      ȥݥȤŪ (((|x|)), ((|y|))) Υ줿ݥȤ˰ư롣

--- ClibPDF::PDF#lineto(x, y)
--- ClibPDF::PDF#rawLineto(x, y)
      ȥݥȤ (((|x|)), ((|y|))) ޤ

--- ClibPDF::PDF#rlineto(x, y)
--- ClibPDF::PDF#rawRlineto(x, y)
      ȥݥȤŪ (((|x|)), ((|y|))) Υ줿ݥȤޤ

--- ClibPDF::PDF#curveto(x1, y1, x2, y2, x3, y3)
--- ClibPDF::PDF#rawCurveto(x1, y1, x2, y2, x3, y3)
      ȥݥȤ (((|x3|)), ((|y3|))) ޤǥ٥

--- ClibPDF::PDF#rect(x, y, width, height)
--- ClibPDF::PDF#rawRect(x, y, width, height)
      Ѥκɸ (((|x|)), ((|y|)))  ((|width|))⤵ ((|height|))
      Ĺ

--- ClibPDF::PDF#rectRotated(x, y, width, height, angle)
--- ClibPDF::PDF#rawRectRotated(x, y, width, height, angle)
      Ѥκɸ (((|x|)), ((|y|)))  ((|width|))⤵ ((|height|))
      ((|angle|)) Ĺ

--- ClibPDF::PDF#arc(x, y, r, sangle, eangle, moveto0)
--- ClibPDF::PDF#rawArc(x, y, r, sangle, eangle, moveto0)
      濴ɸ (((|x|)), ((|y|)))Ⱦ ((|r|)) 
      ϳ ((|sangle|))λ((|sangle|))α߸̤
      ((|moveto0|)) 0ʳꤷϡ

--- ClibPDF::PDF#quickCircle(xc, yc, r)
--- ClibPDF::PDF#rawQuickCircle(xc, yc, r)
      濴ɸ (((|xc|)), ((|yc|)))Ⱦ ((|r|)) αߤ

--- ClibPDF::PDF#circle(x, y, r)
--- ClibPDF::PDF#rawCircle(x, y, r)
      濴ɸ (((|x|)), ((|y|)))Ⱦ ((|r|)) αߤ

--- ClibPDF::PDF#newpath()
      ȥѥȥȥݥȤ򥯥ꥢ롣

--- ClibPDF::PDF#closepath()
      ȥѥĤ롣

=== եå/path ط

--- ClibPDF::PDF#clip()
--- ClibPDF::PDF#eoclip()
      ȥѥ򥯥åԥ󥰤ζȤꤹ롣

--- ClibPDF::PDF#fill()
--- ClibPDF::PDF#eofill()
      ߤΥѥĤ줿ʿ̤ɤĤ֤

--- ClibPDF::PDF#fillAndStroke()
--- ClibPDF::PDF#eofillAndStroke()
      ߤΥѥɤĤ֤

--- ClibPDF::PDF#stroke()
      ߤΥѥ

=== եå/ִط

--- ClibPDF::PDF#gsave()
--- ClibPDF::PDF#grestore()
      ߤΥեåطξ֤򥻡֡ꥹȥ롣

--- ClibPDF::PDF#setdash(dashspec)
--- ClibPDF::PDF#nodash()
      Υѥꤹ롣

--- ClibPDF::PDF#concat(a, b, c, d, e, f)
--- ClibPDF::PDF#rawConcat(a, b, c, d, e, f)
      

--- ClibPDF::PDF#rotate(angle)
      ɸϤž롣

--- ClibPDF::PDF#scale(sx, xy)
      ɸϤ硢̾롣

--- ClibPDF::PDF#translate(x, y)
--- ClibPDF::PDF#rawTranslate(x, y)
      ɸ (((|x|)), ((|y|))) ꤹ롣

=== եå/ط

--- ClibPDF::PDF#setlinewidth(width)
       ((|width|)) ꤹ롣

--- ClibPDF::PDF#setlinecap(cap)
      üˡ ((|cap|)) ꤹ롣((|cap|)) ȤƻǤΤ
      ClibPDF::CAP_BUTT, ClibPDF::CAP_ROUND, ClibPDF::CAP_SQUARE Τ줫

--- ClibPDF::PDF#setlinejoin(join)
      ޤγѤˡ ((|join|)) ꤹ롣((|join|)) Ȥ
      ǤΤ ClibPDF::JOIN_MITER, ClibPDF::JOIN_ROUND, ClibPDF::JOIN_BEVEL Τ줫

--- ClibPDF::PDF#setflat(flat)
      flatness parameter  ((|flat|)) ꤹ롣

--- ClibPDF::PDF#setmiterlimit(limit)
      miter limit  ((|limit|)) ꤹ롣

--- ClibPDF::PDF#setstrokeadjust(flag)
      

=== եå/ط

--- ClibPDF::PDF#setgray(gray)
--- ClibPDF::PDF#setrgbcolor(r, g, b)
--- ClibPDF::PDF#setcmykcolor(c, m, y, k)
      stroke  fill color ꤹ롣

--- ClibPDF::PDF#setgrayFill(gray)
--- ClibPDF::PDF#setrgbcolorFill(r, g, b)
--- ClibPDF::PDF#setcmykcolorFill(c, m, y, k)
      fill color ꤹ롣

--- ClibPDF::PDF#setgrayStroke(gray)
--- ClibPDF::PDF#setrgbcolorStroke(r, g, b)
--- ClibPDF::PDF#setcmykcolorStroke(c, m, y, k)
      stroke color ꤹ롣

=== եå/ޡط

--- ClibPDF::PDF#marker(x, y, type, size)
--- ClibPDF::PDF#rawMarker(x, y, type, size)
      ɸ (((|x|)), ((|y|))) ˼ ((|type|))
      礭 ((|size|))Υޡ褹롣

--- ClibPDF::PDF#pointer(x, y, direction, size)
--- ClibPDF::PDF#rawPointer(x, y, direction, size)
      ɸ (((|x|)), ((|y|))) ˼ ((|direction|))
      礭 ((|size|))Υݥ󥿤褹롣

--- ClibPDF::PDF#errorbar(x, y1, y2, capsize)
--- ClibPDF::PDF#rawErrorbar(x, y1, y2, capsize)
      Xɸ ((|x|))  ((|y1|))((|y2|))ޤǤΥ顼С
      顼Сü礭((|capsize|))ǻꡣ

--- ClibPDF::PDF#highLowClose(x, vhigh, vlow, vclose, ticklen)
--- ClibPDF::PDF#rawHighLowClose(x, vhigh, vlow, vclose, ticklen)

=== եȴط

--- ClibPDF::PDF#setFont(basefontname, encodename, size)
      եȤꤹ롣

--- ClibPDF::PDF#setFontDirectories(pfmdir, pfbdir)

--- ClibPDF::PDF#setFontMapFile(mapfile)

--- ClibPDF::PDF#stringWidth(str)
      ʸĹݥ(1/72)֤

--- ClibPDF::PDF#capHeight()

=== ƥȴط

--- ClibPDF::PDF#beginText(clipmode)
--- ClibPDF::PDF#endText()
      ƥȡեȴطγϡλ

--- ClibPDF::PDF#text(x, y, orientation, text)
--- ClibPDF::PDF#rawText(x, y, orientation, text)
      ɸ (((|x|)), ((|y|))) ʸ ((|text|)) 褹롣

--- ClibPDF::PDF#textAligned(x, y, orientation, centmode, text)
--- ClibPDF::PDF#rawTextAligned(x, y, orientation, centmode, text)
      ɸ (((|x|)), ((|y|))) ʸ ((|text|)) 褹롣

--- ClibPDF::PDF#textBox(xl, yl, width, height, angle, linespace, tbattr, text)
--- ClibPDF::PDF#rawTextBox(xl, yl, width, height, angle, linespace, tbattr, text)
      ɸ (((|xl|)), ((|yl|)))  ((|width|))⤵ ((|height|))
      ((|linespace|))Υƥΰʸ ((|text|)) 褹롣

--- ClibPDF::PDF#textBoxFit(xl, yl, width, height, angle, inifontsize, fsdecrement, linespace, tbattr, text)
--- ClibPDF::PDF#rawTextBoxFit(xl, yl, width, height, angle, inifontsize, fsdecrement, linespace, tbattr, text)
      ɸ (((|xl|)), ((|yl|)))  ((|width|))⤵ ((|height|))
      ((|linespace|))Υƥΰʸ ((|text|)) 褹롣

--- ClibPDF::PDF#setTextLeading(leading)

--- ClibPDF::PDF#setTextPosition(x, y)
--- ClibPDF::PDF#rawSetTextPosition(x, y)
      ƥȥȥݥȤɸ (((|x|)), ((|y|))) ꤹ롣

--- ClibPDF::PDF#textShow(text)
--- ClibPDF::PDF#textCRLFshow(text)
      ȥݥȤʸ ((|text|)) 褹롣

--- ClibPDF::PDF#textCRLF()
      ƥȥȥݥȤ򼡤ιԤ˰ư롣

=== primitive PDF text operator functions

--- ClibPDF::PDF#setNextTextLineOffset(x, y)
--- ClibPDF::PDF#rawSetNextTextLineOffset(x, y)

=== ƥ/ɸϴط

--- ClibPDF::PDF#setTextMatrix(a, b, c, d, x, y)
--- ClibPDF::PDF#concatTextMatrix(a, b, c, d, x, y)

--- ClibPDF::PDF#rotateText(degrees)
      ɸϤž롣

--- ClibPDF::PDF#skewText(alpha, beta)

--- ClibPDF::PDF#setCharacterSpacing(spacing)
--- ClibPDF::PDF#setHorizontalScaling(scale)
--- ClibPDF::PDF#setWordSpacing(spacing)

--- ClibPDF::PDF#setTextRenderingMode(mode)

--- ClibPDF::PDF#setTextRise(rise)

=== ᡼ط

--- ClibPDF::PDF#importImage(filename, type, x, y, angle, flags)
--- ClibPDF::PDF#rawImportImage(filename, type, x, y, angle, flags)
       ((|type|)) βե ((|filename|)) 
      ɸ (((|x|)), ((|y|))) ˳ ((|angle|)) 褹롣

--- ClibPDF::PDF#placeInLineImage(imagedata, x, y, angle, width, height, pixwidth, pixheight, bitspercomp, CSorMask, gsave)
--- ClibPDF::PDF#rawPlaceInLineImage(imagedata, x, y, angle, width, height, pixwidth, pixheight, bitspercomp, CSorMask, gsave)

=== ϥѡƥȡ󥯴ط

--- ClibPDF::PDF#setAnnotation(xll, yll, xur, yur, title, str, attr)
--- ClibPDF::PDF#rawSetAnnotation(xll, yll, xur, yur, title, str, attr)
       (((|xll|)), ((|yll|))) (((|xur|)), ((|yur|))) 
      ʸ ((|title|))  annotation(?) 롣
      annotation ° Array ((|attr|)) ǻꤹ롣

--- ClibPDF::PDF#includeTextFileAsAnnotation(xll, yll, xur, yur, title, filename, attr)
--- ClibPDF::PDF#rawIncludeTextFileAsAnnotation(xll, yll, xur, yur, title, filename, attr)
       (((|xll|)), ((|yll|))) (((|xur|)), ((|yur|))) 
      ʸ ((|title|))  ե ((|filename|)) ɤ߹
      annotation(?) 롣
      annotation ° Array ((|attr|)) ǻꤹ롣

--- ClibPDF::PDF#setActionURL(xll, yll, xur, yur, linkspec, attr)
--- ClibPDF::PDF#rawSetActionURL(xll, yll, xur, yur, linkspec, attr)
       (((|xll|)), ((|yll|))) (((|xur|)), ((|yur|))) 
      URL ((|linkspec|))  annotation 롣
      annotation ° Array ((|attr|)) ǻꤹ롣
      Ȥ examples/cover.rb 򻲾ȤΤȡ

--- ClibPDF::PDF#setLinkGoToPage(xll, yll, xur, yur, page, fitmode, attr)
--- ClibPDF::PDF#rawSetLinkGoToPage(xll, yll, xur, yur, page, fitmode, attr)
       (((|xll|)), ((|yll|))) (((|xur|)), ((|yur|))) 
      ڡ ((|page|)) ؤ annotation(?) 롣
      ((|fitmode|))  view ꤹ롣
      annotation ° Array ((|attr|)) ǻꤹ롣

--- ClibPDF::PDF#setLinkAction(xll, yll, xur, yur, action_dict, attr)
--- ClibPDF::PDF#rawSetLinkAction(xll, yll, xur, yur, action_dict, attr)
       (((|xll|)), ((|yll|))) (((|xur|)), ((|yur|))) 
      ((|action_dict|)) ǻꤷ annotation(?) 롣
      annotation ° Array ((|attr|)) ǻꤹ롣

=== ɥ°

--- ClibPDF::PDF#setCreator(pname)
      ɥȤ creator եɤꤹ롣

--- ClibPDF::PDF#setTitle(pname)
      ɥȤ title եɤꤹ롣

--- ClibPDF::PDF#setSubject(pname)
      ɥȤ subject եɤꤹ롣

--- ClibPDF::PDF#setKeywords(pname)
      ɥȤ keywords եɤꤹ롣

--- ClibPDF::PDF#comments(pname)
      Ȥ񤯡

--- ClibPDF::PDF#setViewerPreferences(vP)

--- ClibPDF::PDF#setCompressionFilter(command, filterlist)

=== Page related public functions

--- ClibPDF::PDF#setPageSize(mboxstr, cboxstr)

--- ClibPDF::PDF#setBoundingBox(LLx, LLy, URx, URy)

--- ClibPDF::PDF#setMediaBox(LLx, LLy, URx, URy)

--- ClibPDF::PDF#setCropBox(LLx, LLy, URx, URy)


= Class ClibPDF::PlotDomain

== Class Methods

--- ClibPDF::PlotDomain.new(x, y, w, h, xL, xH, yL, yH, xtype, ytype, reserved)

== Methods

--- ClibPDF::PlotDomain#freePlotDomain()
      PlotDomain Υ󥹥󥹤˴롣(ʤ褦ˤ٤)

--- ClibPDF::PlotDomain#setPlotDomain(pdf, x, y)
--- ClibPDF::PDF#setPlotDomain(domain, x, y)
      ClibPDF::PlotDomain Υ󥹥󥹤 ClibPDF::PDF Ͽ롣

--- ClibPDF::PlotDomain#clipDomain()

--- ClibPDF::PlotDomain#fillDomainWithGray(gray)
      0  1 ϰϤ PlotDomain οꤹ롣

--- ClibPDF::PlotDomain#fillDomainWithRGBcolor(r, g, b)
      PlotDomain Υ顼ꤹ롣

--- ClibPDF::PlotDomain#setMeshColor(meshMajorR, meshMajorG, meshMajorB, meshMinorR, meshMinorG, meshMinorB)
      PlotDomain  grid/mesh Υ顼ꤹ롣

--- ClibPDF::PlotDomain#drawMeshForDomain()
      grid/mesh 褹롣

--- ClibPDF::PlotDomain#setLinearMeshParams(xy, mesh1ValMajor, intervalMajor, mesh1ValMinor, intervalMinor)
      PlotDomain  mesh 򤹤롣

= Class ClibPDF::TimePlotDomain

== Super Class
* ClibPDF::PlotDomain

== Class Methods

--- ClibPDF::TimePlotDomain.new(x, y, w, h, xTL, xTH, yL, yH, xtype, ytype, reserved)

= Class ClibPDF::Axis

== Class Methods

--- ClibPDF::Axis.new(angle, length, type, valL, valH)
      ((|type|)) ǻꤵ줿 ClibPDF::LINEAR  ClibPDF::LOGARITHMIC ˽ä
       ((|angle|)) Ĺ ((|length|))  Axis() 饹֤
      Axis ͤϰϤ ((|valL|)), ((|valH|)) ǻꤹ롣

== Methods

--- ClibPDF::Axis#freeAxis()
      Axis Υ󥹥󥹤˴롣(ʤ褦ˤ٤)

--- ClibPDF::Axis#drawAxis()

--- ClibPDF::Axis#attachAxisToDomain(domain, x, y)
--- ClibPDF::PlotDomain#attachAxisToDomain(anAx, x, y)
      ClibPDF::Axis Υ󥹥󥹤 ClibPDF::PlotDomain Ͽ롣

--- ClibPDF::Axis#setAxisLineParams(axLineWidth, ticLenMaj, ticLenMin, tickWidMaj, tickWidMin)
      Ĺꤹ롣

--- ClibPDF::Axis#setTicNumEnable(ticEnableMaj, ticEnableMin, numEnable)
      ɽ򤹤뤫ɤȼ()ɽ뤫ꤹ롣

--- ClibPDF::Axis#setAxisTicNumLabelPosition(ticPos, numPos, horizNum, horizLab)
      ΥޡμФꤹ롣

--- ClibPDF::Axis#setAxisNumberFormat(format, fontName, fontSize)
      ɽΥեޥåȤե̾եȥꤹ롣

--- ClibPDF::Axis#setTimeAxisNumberFormat(useMonName, use2DigYear, fontName, fontSize)
      ǯɽȥե̾եȥꤹ롣
      ((|useMonName|)) Ƿɽ̾(Jan, Feb, Mar)ȤȤꤹ롣
       ClibPDF::MONTH_NUMBER  ClibPDF::MONTH_NAME ǹԤ
      ((|use2DigYear|)) ǯɽꤹ롣
      ϡClibPDF::YEAR_FULL, ClibPDF::YEAR_4DIGIT, ClibPDF::YEAR_2DIGIT Τ줫ǹԤ
      (ClibPDF::TimeAxisˤɤ)

--- ClibPDF::Axis#setAxisLabel(labelstring, fontName, encoding, fontSize)
      ʸȥե̾եȥꤹ롣

--- ClibPDF::Axis#setLinearAxisParams(tic1ValMajor, intervalMajor, tic1ValMinor, intervalMinor)
      κǾֳ֤͡佾κǾֳ֤͡ꤹ롣

--- ClibPDF::Axis#setLogAxisTickSelector(ticselect)
      Logscale ɽ򤹤롣
      ((|ticselect|)) ϰʲΤ줫ǻꤹ롣
      ClibPDF::LOGAXSEL_1, ClibPDF::LOGAXSEL_13, ClibPDF::LOGAXSEL_125,
      ClibPDF::LOGAXSEL_12468, ClibPDF::LOGAXSEL_12357, ClibPDF::LOGAXSEL_123456789,
      ClibPDF::LOGAXSEL_MIN, ClibPDF::LOGAXSEL_MAX

--- ClibPDF::Axis#setLogAxisNumberSelector(numselect)
      Logscale ɽɽ򤹤롣
      ((|numselect|)) ϰʲΤ줫ǻꤹ롣
      ClibPDF::LOGAXSEL_1, ClibPDF::LOGAXSEL_13, ClibPDF::LOGAXSEL_125,
      ClibPDF::LOGAXSEL_12468, ClibPDF::LOGAXSEL_12357, ClibPDF::LOGAXSEL_123456789,
      ClibPDF::LOGAXSEL_MIN, ClibPDF::LOGAXSEL_MAX

= Class ClibPDF::TimeAxis

== Class Methods

--- ClibPDF::TimeAxis.new(angle, length, type, vtl, vth)
      ּ Axis 饹֤

== Super Class
* ClibPDF::Axis

=end
