#!/usr/bin/env ruby
# $Id: Contract.rb,v 1.2 2001/08/29 14:08:20 matju Exp $
=begin

	MetaRuby
	file: common parts between Array and String

	Copyright (c) 2001 by Mathieu Bouchard
	Licensed under the same license as Ruby.

=end

#--------------------------------------------------------------------------#
# This was really itching me.
# This is the best spot to put it for now.

if not Object.const_defined?(:Boolean) then
	module Boolean; end
	class TrueClass;  include Boolean; end
	class FalseClass; include Boolean; end
end

#--------------------------------------------------------------------------#
# Now the real stuff.

module Contract

	def assert_type(name,value,type)
		type===value or raise TypeError,
			"%s=%s is of type %s, not %s"%[name,value.inspect,value.type,type]
	end

	def assert_range(name,value,range)
		range===value or raise TypeError,
			"%s=%s is not in range %s" % [name,value,range]
	end

	def assert_nonneg(name,value)
		value >= 0 or raise TypeError,
			"%s = %s is negative" % [name,value]
	end

	def assert_index_excl(i); assert_range("i",i,0...length); end
	def assert_index_incl(i); assert_range("i",i,0..length); end
	def assert_extent(i,n); assert_range("%d+%d"%[i,n],i+n,0..length); end

	def assert_eq(name,value,expected)
		value == expected or \
			raise "%s = %s, expected %s" % [name, value, expected]
	end
	# private :assert_i, :assert_n, :assert_i_n

	def assert_not_frozen
#		frozen? and raise TypeError, "can't modify frozen array"
		frozen? and raise "can't modify frozen array"
	end
end
