#!/usr/local/bin/ruby

#$Id: pg_rdbc1.rb,v 1.13 1999/10/24 16:58:46 postgres Exp $

=begin

module PG_RDBC1

=end

require "rdbc1.rb"

module PG_RDBC1
  require "postgres"
  include RDBC1

  # Driver Creator will inherite me.
  class PG_ConnectionBridge < ConnectionBridge
    attr :pg_con
    def initialize(con)
      super
      hostname=(con.prop["HOSTNAME"] || "localhost")
      ipport=(con.prop["IPPORT"] || "5432")
      @pg_con = PGconn.new(hostname, ipport.to_i, "", "", con.prop["DBNAME"],
          con.prop["USER"], con.prop["PASSWD"])
    end
    def commit; p "commit now not implemented"; end
    def rollback; p "rollback now not implemented"; end
    def close
      super
      @pg_con.close
      @pg_con=nil
      p "pg_con closed."
    end
  end

  class PG_StatementBridge < StatementBridge
    attr :pg_res
    def initialize(st)
      super
    end
    def execute(sql)
      if @pg_res
        if ! @resultset
          @pg_res.clear
          p "pg_res cleared"
        end
      end
      @resultset=nil
      @pg_res=nil
      #p sql
      @pg_res=parent.con.bridge.pg_con.exec sql
      #p resultset
      if @pg_res.status == PGresult::COMMAND_OK
        @updatecount=0
      else
        @updatecount=-1
        @resultset=Object.new #dummy
      end
    end
    def close
      if @pg_res
        if ! @resultset
          @pg_res.clear
          p "pg_res cleared"
        end
      end
      @resultset=nil
      @pg_res=nil
      super
    end
  end

  class PG_ResultSetBridge < ResultSetBridge
    attr :fetchline
    attr :pg_res
    def initialize(rs)
      super
      @pg_res=parent.statement.bridge.pg_res
      #p @pg_res.result
      @fetchline=-1
    end
    def close
      @pg_res.clear
      p "pg_res cleared"
      super
    end
    def next
      @fetchline+=1
      if @fetchline < @pg_res.result.size
        true
      else
        false
      end
    end
    def getData(col=nil)
      if (col.is_a?(Integer))
        @pg_res.result[@fetchline][col]
      elsif (col==nil)
        @pg_res.result[@fetchline].dup
      end
      #String is decoded to Integer by ResultSet
    end
  end

  class PG_ResultSetMetaDataBridge < ResultSetMetaDataBridge
    def columncount
      parent.parent.bridge.pg_res.num_fields
    end
    def columnName(index)
      a=parent.parent.bridge.pg_res.fieldname(index)
      if a==""
        ""
      end
      a
    end
    def columnIndex(name)
      a=parent.parent.bridge.pg_res.fieldnum(name)
      if a<0
        nil
      end
      a
    end
  end

  # Driver Creator will inherite me.
  class PG_Driver < Driver
    def url2prop(url)
      # Driver Creator will override me.
      super
    end
    def getConnectionBridgeClass
      # Driver Creator will override me.
      PG_ConnectionBridge
    end
    def getStatementBridgeClass
      # Driver Creator will override me.
      PG_StatementBridge
    end
    def getResultSetBridgeClass
      # Driver Creator will override me.
      PG_ResultSetBridge
    end
    def getResultSetMetaDataBridgeClass
      # Driver Creator will override me.
      PG_ResultSetMetaDataBridge
    end
    def preparable?
      false
    end
  end

  PG_Driver.new
end


if $0 == __FILE__ #debug runner
  p "test start"

  #install your Driver
  include PG_RDBC1
  #dr=PG_Driver.new

  #You can choice 1 of 4 lines below to get a Connection instance.
  #co=dr.connect("rdbc:PG_Driver://localhost:5432/test01", {"USER","postgres"})
  #co=DriverManager.getConnection("rdbc:PG_Driver://localhost:5432/test01", {"USER","postgres"})
  #co=Connection.connect("rdbc:PG_Driver://localhost:5432/test01", {"USER","postgres"})
  co=Connection.new("rdbc:PG_Driver://localhost:5432/test01", {"USER","postgres"})

=begin
test table is:
  create table books(
    title text,
    author text,
    publisher text,
    size text,
    page int,
    price int,
    idbn text,
    color text,
    desing text,
    date date,
    ccopy text,
    note text,
    image text
    );
=end

  st=co.createStatement("select * from books where title = :a ")

  [1, 2].each{ |i|
    p "----------------"
    st.setParam("a", "midibook")  # nakamura loves midi music.
    #st.execute; rs=st.resultset
    rs=st.executeQuery
    names=[]
    for n in 0 .. rs.metadata.columncount-1
      names.push rs.metadata.columnName(n)
    end
    p names
    while rs.next
      p "----"
      p rs.data
      #p rs.data(0)
      #p rs.data("title")
      #p rs.data([0,2,3,1])
      p rs.data(["title", "author", "publisher", "page"])
    end
  }

  st=co.createStatement
  p st.executeUpdate("update books set page=100")
  p st.updatecount

  #this tree has 2 statements, and queried statement has 1 resultset under it.
  co.showtree

  p "test end"
end





