#!/usr/bin/ruby

require 'rice/irc'

include RICE::Command
include RICE::Reply

NICK = 'irb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

# Thread.abort_on_exception = true

c = RICE::Connection.new('localhost', 9999)
th = c.regist do |rq, wq|
  wq.push nick ::NICK
  wq.push user ::USER, '0', '*', ::REAL
  while x = rq.pop
    p x
    if x.kind_of?(PING)
      wq.push pong x.params[0]
    elsif x.kind_of?(RPL_ENDOFMOTD)
      wq.push quit "byebye"
      break
    end
  end
  close
end

begin
  c.start
rescue RICE::Connection::Closed
end
