#!/usr/bin/ruby

require 'rice/irc'
require 'rice/observer'
require 'nkf'

NICK = 'irb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

CHANNEL = '#ricetest'
BYEBYE  = 'byebye > ' + NICK

# Thread.abort_on_exception = true

o = RICE::SimpleClient.new(NICK, USER, REAL, nil, CHANNEL)
class << o
  def response_for_join(subject, message)
    subject.push privmsg message.params[0], 
      NKF::nkf('-Ej', '줿ʬ(SimpleClient)')
  end

  def response_for_privmsg(subject, message)
    msg = message.params[1..-1].join(' ')
    if ::BYEBYE == msg
      subject.push quit
    else
      subject.push privmsg message.params[0], msg
    end
  end
end

c = RICE::Connection.new('localhost', 9999)
c.add_observer(o)

begin
  c.start
rescue RICE::Connection::Closed
  sleep 30
  retry
end
