#!/usr/bin/ruby

require 'rice/irc'
require 'rice/observer'

NICK = 'irb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

CHANNEL = '#ricetest'

#Thread.abort_on_exception = true

o1 = RICE::SimpleClient.new(NICK + '1', USER, REAL, nil, CHANNEL)
c1 = RICE::Connection.new('localhost', 9999)
c1.add_observer(o1)

o2 = RICE::SimpleClient.new(NICK + '2', USER, REAL, nil, CHANNEL)
c2 = RICE::Connection.new('localhost', 9998)
c2.add_observer(o2)

th1 = Thread.new do
  begin
    c1.start
  rescue RICE::Connection::Closed
    sleep 30
    retry
  end
end

th2 = Thread.new do
  begin
    c2.start
  rescue RICE::Connection::Closed
    sleep 30
    retry
  end
end

#p [th1, th2]

th1.join
th2.join

