#
# EditingContext.rb
#
#   $Author: hiroya $
#   $Date: 2000/11/23 01:53:10 $
#   Copyright (C) 2000 Hiroya KUBO
#

require "LimitedArray"

=begin
A class represents an "EditingContext" in "CommandLineEditor".
this class has relation with "EditingLine".

The instance stores
 (1) composite key stroke
 (2) yank history
 (3) editing line history
=end

class EditingContext
  YANK_HISTORY_MAX = 10
  EDITING_HISTORY_MAX = 100

  def initialize
    @currentChar = nil
    @compositeKeyStrokeBuffer = Array.new
    @yankHistory = LimitedArrayWithCursor.new
    @editingHistory = LimitedArrayWithCursor.new

    @yankHistory.set([])
    @yankHistory.moveCursorToEnd()
    @yankHistory.setMaxSize(YANK_HISTORY_MAX)
    @yankHistory.setOffset(0)
    @yankHistoryOffset = 0

    @editingHistory.set([""])
    @editingHistory.moveCursorToEnd()
    @editingHistory.setMaxSize(EDITING_HISTORY_MAX)
    @editingHistory.setOffset(0)

  end

  # --  current char  -- 

  def setCurrentChar(c)
    @currentChar = c
    return c
  end

  def getCurrentChar
    return @currentChar
  end

  # --  composite key  -- 

  def addCompositeKeyStroke(c)
    if(@compositeKeyStrokeBuffer == nil)
      @compositeKeyStrokeBuffer = []
    end
    @compositeKeyStrokeBuffer.push(c)
  end

  def getCompositeKeyStroke
    if(@compositeKeyStrokeBuffer == nil)
      return nil
    else
      return @compositeKeyStrokeBuffer.join('')
    end
  end

  def clearCompositeKeyStroke
    @compositeKeyStrokeBuffer.clear
    @compositeKeyStrokeBuffer = nil
  end

  # --  yank  -- 

  def getYankHistory
    return @yankHistory
  end

  def storeYank(str)
    @yankHistory.push(str)
    @yankHistory.moveCursorToEnd
  end

  def getYank(n)
    @yankHistory.moveCursor(n)
    return @yankHistory.getPointedValue
  end

  def getYankHistoryOffset
    @yankHistoryOffset
  end

  def moveYankHistoryOffset(n)
    @yankHistoryOffset += n
  end

  # --  history  -- 

  def getEditingHistory
    return @editingHistory
  end

  def setEditingHistory(history)
    @editingHistory = history
  end

  def storeCurrentEditingHistory(str)
    @editingHistory[@editingHistory.size-1] = str
    @editingHistory.push("")
    @editingHistory.moveCursorToEnd
  end

  def setCurrentEditingHistory(str)
    x = @editingHistory[@editingHistory.size-1]
    @editingHistory[@editingHistory.size-1] = str
  end

  def browseEditingHistory(n)
    return @editingHistory.moveCursor(n)
  end

  def getCurrentEditingHistory
    return @editingHistory.getPointedValue
  end

  def isCurrentEditingHistory?
    if(@editingHistory.getCursor == @editingHistory.size-1)
      return true
    else
      return false
    end
  end

end

