#
# EditingLine.rb
#
#   $Author: hiroya $
#   $Date: 2000/11/23 01:53:10 $
#   Copyright (C) 2000 Hiroya KUBO
#
=begin
A class represents an "EditingLine" in "CommandLineEditor".
this class has relation with "EditingContext" 

The instance stores
  (1) string value itself
  (2) current cursor position in current line
  (3) previous set-mark position in current line
=end

class EditingLine 
  def initialize
    clear
  end

  def clear
    @value = ""
    @markPosition = nil
    @cursorPosition = 0
  end

  def getCurrentWord
    if(@cursorPosition==0)
      return ""
    end

    p = @value.rindex(/\s/, @cursorPosition-1)
    if(p != nil && p != -1)
      return @value[p+1..@cursorPosition-1]
    elsif(@cursorPosition == 0)
      return ""
    else
      return @value[0..@cursorPosition-1]
    end
  end

  def size
    if(@value == nil)
      return 0
    end
    return @value.size
  end

  def getValue
    return @value
  end

  def setValue(value)
    @value = value
    @cursorPosition = 0
    @markPosition = nil
  end

  def setMark(pos = @cursorPosition)
    return @markPosition = pos
  end

  def getMark
    return @markPosition
  end


  def getCursorPosition
    return @cursorPosition
  end

  def setCursorPosition(p = size)
    return @cursorPosition = p
  end

  def setCursorPositionToEnd
    return setCursorPosition
  end

  def moveCursor(n)
    if( 0 <= @cursorPosition+n && @cursorPosition+n <= size )
      @cursorPosition += n
      return true
    else
      return false
    end
  end

  def delete(n = 1)
    if(size == n )
      @value = ""
      @cursorPosition = 0
      return true
    elsif(size < n )
      @value = ""
      @cursorPosition = 0
      return false
    elsif(size >= n && @cursorPosition==size)
      @value = @value[0..size-1-n]
      @cursorPosition -= n
      return true
    elsif(@cursorPosition-n >= 0 )
      @value =
	@value[0..@cursorPosition-1-n]+
	@value[@cursorPosition..size]
      @cursorPosition -= n
      return true
    end
  end

  def kill_line
    remove(getCursorPosition, size)
  end

  def toString
    return @value[0..@cursorPosition-1]
  end

  def add(str)
    if(str.instance_of?(String))
      if(@value != nil)
	@value = @value + str
      else
	@value = str
      end
      @cursorPosition += str.size
    end
  end

  def insert(str)
    if(size == @cursorPosition)
      add(str)
    elsif(@cursorPosition==0)
      if(@value != nil)
	@value = str + @value
      else
	@value = str
      end
      @cursorPosition += str.size
    elsif(@value != nil)
      @value =
	@value[0..@cursorPosition-1] + str +
	@value[@cursorPosition..size]
      @cursorPosition += str.size
    else
      @value = str
      @cursorPosition += (str.size)+1
    end
  end

  def copy(s, e = size)
    tmp = nil
    if(s == 0 && e == size)
      tmp = @value
    elsif(s == 0 && e < size)
      tmp = @value[0..e-1]
    elsif(0 <= s && e <= size)
      tmp = @value[s..e-1]
    end
    return tmp
  end
  
  def remove(s, e = size)
    if(@value == nil)
      return nil
    end

    if(s == 0 && e == size)
      tmp = @value
      @value = ""
    elsif(s == 0 && e < size)
      tmp = @value[0..e-1]
      @value = @value[e..size-1]
    elsif(e == size)
      tmp = @value[s..e-1]
      @value = @value[0..s-1]
    elsif(0 < s && e <= size)
      tmp = @value[s..e-1]
      @value = @value[0..s-1] + @value[e..size-1]
    else
      tmp = nil
      s = 0
    end

    @cursorPosition = s
    return tmp
  end

  def end_of_line?
    if(@value != nil)
     return (@cursorPosition == @value.size)
    else
      return false
    end
  end
end

