#
# Terminal.rb
#
#   $Author: hiroya $
#   $Date: 2000/11/23 01:53:10 $
#   Copyright (C) 2000 Hiroya KUBO
#
=begin
  * class Terminal represents Charactor User Interface output
=end


class Terminal
  Attributes = {
    'clear'      => 0,
    'reset'      => 0,
    'bold'       => 1,
    'underline'  => 4,
    'underscore' => 4,
    'blink'      => 5,
    'reverse'    => 7,
    'concealed'  => 8,

    'black'      => 30,   'on_black'   => 40, 
    'red'        => 31,   'on_red'     => 41, 
    'green'      => 32,   'on_green'   => 42, 
    'yellow'     => 33,   'on_yellow'  => 43, 
    'blue'       => 34,   'on_blue'    => 44, 
    'magenta'    => 35,   'on_magenta' => 45, 
    'cyan'       => 36,   'on_cyan'    => 46, 
    'white'      => 37,   'on_white'   => 47 };

  def initialize()

#    $log = File.open("/tmp/log", "a")
#    $log.puts("-------------")
#    $log.flush
    
    @this = nil
    @echo = true
    @line_position = 0
    @line_length = 0
    @columns = -1
    @lines = -1
    resize
  end

  def init(this)
    @this = this
  end

  def resize(force = true)
    if(force == true || @columns == -1 || @lines == -1)
      @columns = `tput cols`.to_i
      @lines = `tput lines`.to_i
    end
    return [@columns, @lines]
  end

  def getColumns
    return @columns
  end

# TODO:
#  -- it will be nice to reuse this library in GUI textarea widget --
#  def setColumns(columns)
#    @columns = columns
#  end
#
#  def setLines(lines)
#    @lines = lines
#  end

  def getsize
    return resize
  end

  def echo(f)
    if (f == true)
      system("/bin/stty -raw echo -isig")
    else
      system("/bin/stty raw -echo isig")
    end
    @echo = f
    return @this
  end

  def set(list)
    if (list == nil)
      return
    end
    
    for key in list
      if Attributes[key] != nil then
	Kernel::print "\e["
	Kernel::print Attributes[key]
	Kernel::print "m"
      end
    end
    return @this
  end

  def reset
    code = Attributes['clear']
    Kernel::print "\e[#{code}m"
    return @this
  end

  def reverseline
    Kernel::print "\eM"
    return @this
  end

  def beep
    Kernel::print "\a"
    return @this
  end

  def ln
    print("\r\n")
    return @this    
  end

  def clear
    Kernel::print "\e[2J";
    @line_position = 0
    @line_length = 0
    return @this
  end

  def newline
    if(@echo == false)
      Kernel::print "\r";
    end
    Kernel::print "\n";
    @line_position = 0
    @line_length = 0
    return @this
  end

  def rewind
    ((@line_position-1)/@columns).times do
      reverseline
    end

    @line_position = 0
    Kernel::print "\r";
    return @this
  end

 
  def print(list)
    if(list == nil)
      return @this
    end

    tmp = ""

    list.each do |str|
      if(str != nil)
	tmp = tmp + str
	@line_position += str.size
      end
    end
    if(tmp == "")
      return @this
    end

    if(@line_length <= @line_position)
      @line_length = @line_position
    end

    Kernel::print tmp
    return @this
  end

  def cleanupCurrentLine
    Kernel::print "\r"
    if(@columns < @line_length)
      rewind
    end

    (@line_length).times do
      Kernel::print " "
    end

    @line_position = @line_length
    rewind

    @line_length = 0
  end

  def end_of_line(offset = 0)
    return ((@line_position + offset) % @columns)
  end
end

class TerminalFactory
  def create
    # reference myself
    term = Terminal.new;
    term.init(term)
    return term
  end
end
