=begin
= SMF module

== Classes

* Sequence <format, division>

* Track

* Event <offset>
  * MIDIMessage
    * ChannelMessage <..., ch>
      * VoiceMessage
        * NoteOff <..., note, vel>
        * NoteOn <..., note, vel>
        * PolyphonicKeyPressure <..., note, val>
        * ControlChange <..., num, val>
        * ProgramChange <..., num>
        * ChannelPressure <..., val>
        * PitchBendChange <..., val>
      * ChannelModeMessage <..., num, val>

  * SystemMessage
    * Exclusive
      * ExclusiveF0 <..., data>
      * ExclusiveF7 <..., data>

  * Meta <..., type>
    * SequenceNumber <..., num>
    * Text <..., text>
      * GeneralPurposeText (Text01)
      * CopyrightNotice (Text02)
      * TrackName (SequenceName, Text03)
      * InstrumentName (Text04)
      * Lyric (Text05)
      * Marker (Text06)
      * CuePoint (Text07)
      * ProgramName (Text08)
      * DeviceName (Text09)
      * Text0A
      * Text0B
      * Text0C
      * Text0D
      * Text0E
      * Text0F
    * ChannelPrefix <..., ch>
    * MIDIPort <..., num>
    * EndOfTrack
    * SetTempo <..., tempo>
    * SMPTEOffset <..., hr, mn, se, fr, ff>
    * TimeSignature <..., nn, dd, cc, bb>
    * KeySignature <..., sf, mi>
    * SequencerSpecific <..., data>

== Sequence

=== Super Class

Object

=== Class Methods

: decode(str)
: decodeio(io)
: decodefile(fn)
: new([format=1[, division=96]])

=== Accessors

: format
: division

=== Methods

: length
: size
: ntrks
: self << tr
: self >> tr
: push(tr)
: pop
: unshift(tr)
: shift
: self[n]
: self[n]=tr
: each{|tr| ...}
: encode
: encodeio(io)
: encodefile(fn)

== Track

=== Super Class

Object

=== Class Methods

: new

=== Methods

: length
: size
: nevts
: self << ev
: self >> ev
: push(ev)
: pop
: unshift(ev)
: shift
: self[n]
: self[n]=ev
: each{|ev| ...}

== Event

=== Super Class

Object

=== Included Modules

Comparable

=== Accessors

: offset

=end
