# 
# erbhandler.rb -- ERbHandler Class
#       
# Author: IPR -- Internet Programming with Ruby -- writers
# Copyright (C) 2001 TAKAHASHI Masayoshi, GOTOU Yuuzou
#   
# $IPR: erbhandler.rb,v 1.9 2002/02/05 20:20:40 gotoyuzo Exp $

require 'webrick/httpservlet/abstract.rb'

begin
  require 'erb/erbl'
rescue LoadError
  $stderr.print "cannot load `erb/erbl'\n"
end

module WEBrick
  module HTTPServlet

    class ERbHandler < AbstractServlet
      require_path_info false

      def initialize(config, name)
        super
        @script_filename = name
      end

      def do_GET(request, response)
        raise HTTPStatus::Forbidden unless defined?(ERbLight)
        data = open(@script_filename){|io| io.read }
        env = request.meta_vars
        begin
          response.body = ERbLight.new(data).result(binding)
        rescue Exception => ex
          raise HTTPStatus::InternalServerError, ex.message
        end
        response['content-type'] = "text/html"
      end

      alias do_POST do_GET
    end

  end
end
