=begin
= WebUnit::TestCase
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: testcase.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/converter'

module WebUnit

  class TestCase

    include WebUnit
    include Utils

    def initialize( method, name=self.type.name )
      case USING_FRAMEWORK
      when 'Test::Unit'
        super(method)
      when 'RubyUnit'
        super
      else
        super
        # raise??
      end
      @urlbase = ENV['URLBASE'] ? ENV['URLBASE'] : 'http://localhost/'
      @urlbase = orthop_url( @urlbase )
      @urlbase << '/' unless @urlbase =~ %r!/$!
      $stderr.puts "URLBASE is #{@urlbase}" if $DEBUG
    end

    def setup
      $URLBASE = @urlbase
      Response::reset
      @cookies_kept = Cookies::instance.cookies
    end

    def teardown
      Response::reset
      Cookies::instance.cookies = @cookies_kept
    end

  end

end
