// Copyright (c) 1999-2000 David Muse
// See the COPYING file for more information.

#ifndef CLIENTSOCKET_H
#define CLIENTSOCKET_H

#include <rudiments/genericsocket.h>

// The clientsocket class allows you to write programs that can talk to other
// programs over TCP connections.
//
// The class supports TCP connections over Inet and Unix domain sockets.
// Inet sockets allow clients and servers on different machines to talk over a
// network.  Unix sockets allow clients and servers on the same machine to 
// talk.  Inet sockets can be used by clients and servers on the same machine
// but Unix sockets generally perform better.
//
// The clientsocket class provides methods for connecting to and disconnecting 
// from servers.  Its parent class: genericsocket, provides methods for reading
// and writing data.

class clientsocket : public genericsocket {
	public:
		int	connectToServer(char *hostname, 
					unsigned short int port, 
					int retrytime, int tries);
				// connects to "hostname"/"port"
		int	connectToServer(char *unixport,
					int retrytime, int tries);
				// connects to unix socket "unixport"

		int	closeConnection();
				// disconnects from the server

	protected:
		#include <rudiments/private/clientsocket.h>

};

#endif
