//
// This file is part of the SDTS++ toolkit, written by the U.S.
// Geological Survey.  It is experimental software, written to support
// USGS research and cartographic data production.
// 
// SDTS++ is public domain software.  It may be freely copied,
// distributed, and modified.  The USGS welcomes user feedback, but makes
// no committment to any level of support for this code.  See the SDTS
// web site at http://mcmcweb.er.usgs.gov/sdts for more information,
// including points of contact.
//

#ifndef INCLUDED_SB_XREF_H
#define INCLUDED_SB_XREF_H

// $Id: sb_Xref.h,v 1.6 2000/07/25 20:05:38 mcoletti Exp $ 

#include <list>

#include <string>

#ifndef SB_MODULE_H
#include <sdts++/builder/sb_Module.h>
#endif


#ifndef INCLUDED_SIO8211FIELDFORMAT_H
#include <sdts++/io/sio_8211FieldFormat.h>
#endif

//class  sb_ForeignID;
class  sc_Record;


struct sb_Xref_Imp;


/**
 This class provides a convenient access to XREF records.  It provides
 members to access or set various module field and subfield values.
 It also provides a mechanism for populating an object of this class with
 values found in a valid sc_Record of this module, and for filling a
 sc_Record with the contents of a sb_Xref object.
*/
class sb_Xref : public sb_Module
{
   public:

      sb_Xref();

      ~sb_Xref();

      /**
       Use these members to get subfield/field values.  Pass in an appropriate
       type to receive the value.  These members will return false if the 
       corresponding value is not set.  (It may not be set because a value 
       was not assigned to it, or because you previously tried to assign 
       an invalid value.)  Otherwise they will return true.
      */
      bool getComment( string & ) const;
      bool getCOMT( string& val ) const { return getComment( val ); }

      bool getReferenceDocumentation( string & val ) const;
      bool getRDOC( string& val ) const { return getReferenceDocumentation( val ); }

      bool getReferenceSystemName( string & val ) const;
      bool getRSNM( string& val ) const { return getReferenceSystemName( val ); }

#ifdef NOT_RASTER_PROFILE
      bool getVerticalDatum( string & val ) const;
      bool getVDAT( string& val ) const { return getVerticalDatum( val ); }

      bool getSoundingDatum( string & val ) const;
      bool getSDAT( string& val ) const { return getSoundingDatum( val ); }
#endif

      bool getHorizontalDatum( string & val ) const;
      bool getHDAT( string& val ) const { return getHorizontalDatum( val ); }

      bool getZoneReferenceNumber( string & val ) const;
      bool getZONE( string& val ) const { return getZoneReferenceNumber( val ); }

      bool getProjection( string & val ) const;
      bool getPROJ( string& val ) const { return getProjection( val ); }


      // 

#ifdef NOT_IMPLEMENTED
      bool getAttID( list<sb_ForeignID> & ) const;

      bool getVerticalAttributes() const;

      bool getSoundingAttributes() const;
#endif


      /**
       fill the given record based on the builder's object field/subfield
       values -- return false if in a wedged state. (E.g., a mandatory
       field isn't set or was assigned a value outside it's proper
       domain.
      */
      bool getRecord( sc_Record& val ) const;


      /**
       set the object with values found in the record; if not a valid
       XREF record, this will return false
      */
      bool setRecord( sc_Record const& val );


      /**
       Use these members to set subfield/field values.  Pass in an appropriate
       value for the particular subfield/field to be set to.  They will return
       false if you try to assign a value outside the domain of the given 
       subfield/field.  (Note that this is not too pedantic; for example, we
       do not check to see if a conditionally mandatory or optional field has
       been set.)
      */
      bool setComment( string const & ) ;
      bool setCOMT( string const & val ) { return setComment( val ); }

      bool setReferenceDocumentation( string  const & val ) ;
      bool setRDOC( string const & val ) { return setReferenceDocumentation( val ); }

      bool setReferenceSystemName( string  const & val ) ;
      bool setRSNM( string const & val ) { return setReferenceSystemName( val ); }

#ifdef NOT_RASTER_PROFILE
      bool setVerticalDatum( string  const & val ) ;
      bool setVDAT( string const & val ) { return setVerticalDatum( val ); }

      bool setSoundingDatum( string  const & val ) ;
      bool setSDAT( string const & val ) { return setSoundingDatum( val ); }
#endif

      bool setHorizontalDatum( string  const & val ) ;
      bool setHDAT( string const & val ) { return setHorizontalDatum( val ); }

      bool setZoneReferenceNumber( string  const & val ) ;
      bool setZONE( string const & val ) { return setZoneReferenceNumber( val ); }
      bool setZoneReferenceNumber( int val );
      bool setZONE( int val ) { return setZoneReferenceNumber( val ); }

      bool setProjection( string  const & val ) ;
      bool setPROJ( string const & val ) { return setProjection( val ); }


      // 

#ifdef NOT_IMPLEMENTED
      bool setAttID( list<sb_ForeignID>  const & ) ;

      bool setVerticalAttributes() ;

      bool setSoundingAttributes() ;
#endif




   private:

      /// returns reference to schema
      sio_8211Schema& schema_();

      /// used to create internal schema
      void buildSpecificSchema_();

      
      /// NOT NEEDED
      sb_Xref(sb_Xref const& right);

      /// NOT NEEDED
      sb_Xref const& operator=(sb_Xref const& right);

      /// pointer to hidden opaque data structure
      sb_Xref_Imp* imp_;

}; // sb_Xref


#endif // INCLUDED_SB_XREF_H

