#
# TabNote widget
# Inported from "Effective Tcl/Tk Programming"
# 		written by Mark Harrison&Michael McLennan
#

proc notebook_create {win} {
	global nbInfo

	frame $win -class Notebook
	pack propagate $win 0
	set nbInfo($win-count) 0
	set nbInfo($win-pages) ""
	set nbInfo($win-current) ""
	return $win
}

proc notebook_page {win name} {
	global nbInfo
	set page "$win.page[incr nbInfo($win-count)]"
	lappend nbInfo($win-pages) $page
	set nbInfo($win-page-$name) $page

	frame $page
	if {$nbInfo($win-count) == 1} {
		after idle [list notebook_display $win $name]
	}

	return $page
}

proc notebook_display {win name} {
	global nbInfo
	set page ""
	if {[info exists nbInfo($win-page-$name)]} {
		set page $nbInfo($win-page-$name)
	} elseif {[winfo exists $win.page$name]} {
		set page $win.page$name
	}
	if {$page == ""} {
		error "bad notebook page \"$name\""
	}

	notebook_fix_size $win

	if {$nbInfo($win-current) != ""} {
		pack forget $nbInfo($win-current)
	}
	pack $page -expand yes -fill both
	set nbInfo($win-current) $page
}

proc notebook_fix_size {win} {
	global nbInfo

	update idletasks
	set maxw 0
	set maxh 0
	foreach page $nbInfo($win-pages) {
		set w [winfo reqwidth $page]
		if {$w > $maxw} {
			set maxw $w
		}

		set h [winfo reqheight $page]
		if {$h > $maxh} {
			set maxh $h
		}
	}

	set bd [$win cget -borderwidth]
	set maxw [expr $maxw+2*$bd]
	set maxh [expr $maxh+2*$bd]
	$win configure -width $maxw -height $maxh
}

proc tabnotebook_create {win} {
	global tnInfo rootSolid

	frame $win -class Tabnotebook
	canvas $win.tabs -highlightthickness 0 -bg $rootSolid
	pack $win.tabs -fill x

	notebook_create $win.notebook
	pack $win.notebook -expand yes -fill both

	set tnInfo($win-tabs) ""
	set tnInfo($win-current) ""
	set tnInfo($win-pending) ""

	return $win
}

proc tabnotebook_page {win name} {
	global tnInfo

	set page [notebook_page $win.notebook $name]
	lappend tnInfo($win-tabs) $name

	if {$tnInfo($win-pending) == ""} {
		set id [after idle [list tabnotebook_refresh $win]]
		set tnInfo($win-pending) $id
	}

	return $page
}

proc tabnotebook_refresh {win} {
	global tnInfo

	$win.tabs delete all
#	set margin [option get $win margin Margin]
	set margin 6
	set color [option get $win tabColor Color]
#	set font [option get $win tabFont Font]
	set font -*-helvetica-bold-r-normal--*-120-
	set x 2
	set maxh 0

	foreach name $tnInfo($win-tabs) {
		set id [$win.tabs create text \
			[expr $x+$margin+2] [expr -0.5*$margin] \
			-anchor sw -text $name -font $font -tags [list $name]]

		set bbox [$win.tabs bbox $id]
		set wd [expr [lindex $bbox 2]-[lindex $bbox 0]]
		set ht [expr [lindex $bbox 3]-[lindex $bbox 1]]
		if {$ht > $maxh} {
			set maxh $ht
		}

		$win.tabs create polygon 0 0 $x 0 \
			[expr $x+$margin] [expr -$ht-$margin] \
			[expr $x+$margin+$wd] [expr -$ht-$margin] \
			[expr $x+$wd+2*$margin] 0 \
			2000 0 2000 10 0 10 \
			-outline black -fill $color \
			-tags [list $name tab tab-$name]

		$win.tabs raise $id

		$win.tabs bind $name <ButtonPress-1> \
			[list tabnotebook_display $win $name]

		set x [expr $x+$wd+2*$margin]
	}
	set height [expr $maxh+2*$margin]
	$win.tabs move all 0 $height

	$win.tabs configure -width $x -height [expr $height+4]

	if {$tnInfo($win-current) != ""} {
		tabnotebook_display $win $tnInfo($win-current)
	} else {
		tabnotebook_display $win [lindex $tnInfo($win-tabs) 0]
	}

	set tnInfo($win-pending) ""
}

proc tabnotebook_display {win name} {
	global tnInfo
	global fgColor bgColor

	notebook_display $win.notebook $name

#	set normal [option get $win tabColor Color]
	set normal #a6a6a6
	$win.tabs itemconfigure tab -fill $normal

#	set active [option get $win activeTabColor Color]
	set active $bgColor
	$win.tabs itemconfigure tab-$name -fill $active
	$win.tabs raise $name

	set tnInfo($win-current) $name
}


#tabnotebook_create .tn
#pack .tn
#set p1 [tabnotebook_page .tn "Background"]
#label $p1.mesg -text "Background"
#pack $p1.mesg -side left -expand yes -pady 8

#set p2 [tabnotebook_page .tn "Screensaver"]
#label $p2.mesg -text "Screensavers"
#pack $p2.mesg -side left -expand yes -pady 8
#tabnotebook_display .tn "Background"

#option add *Tabnotebook.tabs.background #666666 widgetDefault
#option add *Tabnotebook.margin 6 widgetDefault
#option add *Tabnotebook.tabColor #a6a6a6 widgetDefault
#option add *Tabnotebook.activeTabColor #d9d9d9 widgetDefault
#option add *Tabnotebook.tabFont -*-helvetica-bold-r-normal--*-120-* widgetDefault
