#
#  backends/iSilo.py
#
#  $Id: iSilo.py,v 1.1 2000/04/18 06:51:06 cdegroot Exp $
#
#  SGMLtools iSilo-based text backend driver.
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from Backend import Backend, BackendGlobals
import os

class iSilo(Backend):

    def preJade(self, fh):
	#
	#  Check whether iSilo is there, if not: die
	#
	if self._autoconf['progs']['iSilo'] == 'N/A':
	    raise Exception, 'iSilo not configured, cannot produce output'
	else:
	    return fh

    def postJade(self, outfile, stdoutfile):
	#
	#  Jade wrote HTML, run it through iSilo.
	#
	destfile = os.path.join(self._fileparts[1], self._fileparts[0] + '.pdb')
	self._tracer.system ("%s -y -I %s %s" \
		    % (self._autoconf['progs']['iSilo'],
                       stdoutfile, destfile))


class iSiloGlobals(BackendGlobals):

    def getName(self):
	#
	#  As long as we're the only txt backend, we pose as 'pdb', not
	#  as 'iSilo'
	#
	return 'pdb'

    def getJadeSettings(self):
	return ('sgmltools-pdb', 'sgml')

