#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmallEiffel The GNU Eiffel Compiler
Release -0.76 (Saturday 11th november 2000)
Copyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE
Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
http://SmallEiffel.loria.fr
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/base.h) contains all basic Eiffel
  type definitions.
  This file is automatically included in the header for all modes of 
  compilation : -boost, -no_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef WIN32
#include <windows.h>
#else
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif
#endif

/*
  Because ANSI C EXIT_FAILURE is not always defined :
 */
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
#define JMP_BUF    sigjmp_buf
#define SETJMP(x)  sigsetjmp( (x), 1)
#define LONGJMP    siglongjmp
#else
#define JMP_BUF    jmp_buf
#define SETJMP(x)  setjmp( (x) )
#define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define EIF_INTEGER T2
#define M2 (0)
#define EIF_INTEGER_BITS (CHAR_BIT*sizeof(int))
#define EIF_MINIMUM_INTEGER (INT_MIN)
#define EIF_MAXIMUM_INTEGER (INT_MAX)

/*
  Eiffel type CHARACTER is #3 :
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T2)(x))
#define T3to_integer(x) ((T2)((char)(x)))
#define T3to_bit(x) (x)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define EIF_REAL T4
#define M4 (0.0)
#define EIF_REAL_BITS (CHAR_BIT*sizeof(float))
#define EIF_MINIMUM_REAL (-(FLT_MAX))
#define EIF_MAXIMUM_REAL (FLT_MAX)
#define T2toT4(x) ((T4)(x))

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(double))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)
#define T2toT5(x) ((T5)(x))
#define T4toT5(x) ((T5)(x))

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define EIF_POINTER T8
#define M8 (NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))

/*
  To use type STRING on the C side :
*/
#define EIF_STRING T7*

/*
  Some Other EIF_* defined in ETL :
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/* 
   Wrappers for `malloc', `calloc' and `realloc' :
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);
void* se_realloc(void *ptr, size_t size);

/* --- Mangling Table Start ---
D 1  T513  R COLLECTION[CECIL_FILE] 489
A 1  T104  E POSITION 104
A*1  T375  R ARRAY[FORMAL_GENERIC_ARG] 375
A*1  T200  R CLIENT_LIST 200
A 3  T199  R FIXED_ARRAY[E_FEATURE] 466,199,100
A 1  T143  R SIMPLE_FEATURE_NAME 143
A 1  T223  R CALL_INFIX_XOR 223
D 2  T404  R ARRAY[LOCAL_ARGUMENT1] 128,272
A 1  T234  R CALL_INFIX_FREEOP 234
A*1  T427  R RUN_REQUIRE 427
A 1  T302  R FIXED_ARRAY[MANIFEST_STRING] 302
D 1  T438  R ARRAYED_COLLECTION[BIT_CONSTANT] 138
A 1  T228  R CALL_INFIX_MINUS 228
D 2  T127  R LOCAL_ARGUMENT1 123,271
A 1  T8    E POINTER 8
A 1  T86   E FILE_TOOLS 86
D    T0    R NONE
A 1  T308  R CST_ATT_DOUBLE 308
D 2  T397  R DECLARATION 407,403
D    T85   R DOUBLE_REF
A 1  T407  R DECLARATION_1 407
D 1  T414  R ARRAYED_COLLECTION[EXPORT_ITEM] 412
A*1  T309  R E_ENSURE 309
A*1  T488  R CECIL_FILE 488
A 1  T187  E NATIVE_ARRAY[BASE_CLASS] 187
D 1  T286  R COLLECTION[FEATURE_CLAUSE] 196
D 2  T394  R ONCE_ROUTINE 395,396
A 1  T6    E BOOLEAN 6
A 1  T89   R NATIVE_C_PLUS_PLUS 89
A 1  T387  R NATIVE_INLINE_WITH_CURRENT 387
A*1  T506  R TUPLE[TYPE,FEATURE_NAME] 506
A 1  T130  E NATIVE_ARRAY[ARGUMENT_NAME1] 130
A 1  T338  R WHEN_ITEM_2 338
A 1  T337  R WHEN_ITEM_1 337
A*1  T179  R CREATION_CLAUSE_LIST 179
D 2  T279  R CALL_INFIX2 278,280
A 1  T436  E NATIVE_ARRAY[DECLARATION_1] 436
D 1  T423  R ARRAYED_COLLECTION[INDEX_CLAUSE] 422
A 1  T296  E NATIVE_ARRAY[INTEGER_CONSTANT] 296
A 1  T335  E NATIVE_ARRAY[WHEN_ITEM] 335
D 1  T508  R ARRAYED_COLLECTION[TUPLE[TYPE,FEATURE_NAME]] 507
D 11 T96   R RUN_FEATURE 526,525,524,523,95,115,501,519,437,152,154
A*1  T428  R ARRAY[E_REQUIRE] 428
D 2  T402  R COLLECTION[DECLARATION] 433,398
D 4  T151  R EFFECTIVE_ROUTINE 395,150,393,396
A 1  T478  E NATIVE_ARRAY[ADDRESS_OF] 478
D 1  T454  R ARRAYED_COLLECTION[CALL_PROC_CALL] 453
A 1  T312  R E_DEBUG 312
A 1  T247  R CALL_1_C 247
D 2  T339  R LOOP_VARIANT 343,342
D 1  T208  R ARRAYED_COLLECTION[ASSERTION] 204
A 1  T246  R CALL_0_C 246
A*1  T45   R DICTIONARY[INTEGER,STRING] 45
A 1  T324  R E_RETRY 324
A*1  T70   R DICTIONARY_NODE[RUN_CLASS,STRING] 70
A*1  T180  R CREATION_CLAUSE 180
A*1  T442  R DICTIONARY_NODE[TYPE,STRING] 442
D 1  T417  R COLLECTION[RENAME_PAIR] 190
A 1  T215  E NATIVE_ARRAY[EXPRESSION] 215
A*1  T161  R FIXED_ARRAY[INSTRUCTION] 161
A 1  T227  R CALL_INFIX_AND_THEN 227
D 3  T285  R COLLECTION[E_FEATURE] 466,199,100
A*1  T74   R FIXED_ARRAY[PARENT] 74
D 8  T141  R CST_ATT 140,308,307,306,301,300,299,293
A*1  T319  R FIXED_ARRAY[IFTHEN] 319
A 1  T263  R ARRAY[INTEGER] 263
D 1  T358  R COLLECTION[TYPE] 147
D    T87   R REAL_REF
A*1  T465  R ONCE_ROUTINE_POOL 465
A 1  T266  R PRECURSOR_EXPRESSION 266
A 1  T430  E NATIVE_ARRAY[E_REQUIRE] 430
A 1  T415  E NATIVE_ARRAY[EXPORT_ITEM] 415
A 1  T3    E CHARACTER 3
A*1  T42   R ID_PROVIDER 42
A 1  T128  R ARRAY[ARGUMENT_NAME1] 128
A*1  T333  R ARRAY[WHEN_ITEM] 333
A 1  T354  R TYPE_LIKE_CURRENT 354
A*1  T196  R FIXED_ARRAY[FEATURE_CLAUSE] 196
A 1  T76   E NATIVE_ARRAY[PARENT] 76
D 1  T148  R ARRAYED_COLLECTION[TYPE] 147
A 1  T321  E NATIVE_ARRAY[IFTHEN] 321
A*1  T288  R FIXED_ARRAY[CLASS_NAME] 288
A*1  T318  R IFTHENLIST 318
D 1  T129  R ARRAYED_COLLECTION[ARGUMENT_NAME1] 128
A*1  T327  R WHEN_LIST 327
A 1  T100  R FIXED_ARRAY[EXTERNAL_ROUTINE] 100
D 1  T291  R COLLECTION[CLASS_NAME] 288
D 1  T419  R COLLECTION[FORMAL_GENERIC_ARG] 375
D 1  T527  R COLLECTION[NATIVE_C_PLUS_PLUS] 92
A 1  T282  R CALL_INFIX_GE 282
A 1  T278  R CALL_INFIX_EQ 278
A 1  T310  R E_CHECK 310
A 1  T284  R CALL_INFIX_GT 284
A 1  T386  R NATIVE_WITH_CURRENT 386
A 1  T281  R CALL_INFIX_LE 281
A*1  T511  R TUPLE[STRING,NONE] 511
A 1  T81   E NATIVE_ARRAY[DICTIONARY_NODE[BASE_CLASS,STRING]] 81
A 1  T283  R CALL_INFIX_LT 283
D 1  T295  R ARRAYED_COLLECTION[INTEGER_CONSTANT] 294
A 1  T299  R CST_ATT_BOOLEAN 299
A 1  T486  E NATIVE_ARRAY[BOOLEAN] 486
A 1  T301  R CST_ATT_STRING 301
A 1  T224  R CALL_INFIX_OR 224
D    T25   R INTEGER_REF
A 1  T356  R TYPE_ANY 356
A 1  T460  E NATIVE_ARRAY[EFFECTIVE_ARG_LIST] 460
D 2  T136  R TYPE_BIT 373,372
D 1  T244  R COLLECTION[FEATURE_NAME] 175
A 1  T171  R LOCAL_VAR_LIST 171
D 30 T168  R CALL_PROC_CALL 223,234,228,247,246,227,282,278,284,281,283,224,218,236,240,233,229,231,256,255,166,242,232,226,230,241,280,248,277,225
D 1  T377  R ARRAYED_COLLECTION[FORMAL_GENERIC_ARG] 375
D 1  T93   R ARRAYED_COLLECTION[NATIVE_C_PLUS_PLUS] 92
A 1  T325  R E_INSPECT 325
D 2  T332  R WHEN_ITEM 338,337
A 1  T275  R ARGUMENT_NAME2 275
A 1  T123  R ARGUMENT_NAME1 123
A 1  T218  R CALL_INFIX_IMPLIES 218
A 1  T33   E NATIVE_ARRAY[DICTIONARY_NODE[STRING,STRING]] 33
D 1  T492  R TUPLE[STRING,RUN_FEATURE] 511
A 1  T406  E NATIVE_ARRAY[LOCAL_ARGUMENT1] 406
A*1  T287  R CLASS_NAME_LIST 287
D 2  T122  R DECLARATION_LIST 171,121
A*1  T144  R DICTIONARY[RUN_FEATURE,STRING] 144
A 1  T236  R CALL_PREFIX_FREEOP 236
A 1  T67   R FIXED_ARRAY[RUN_CLASS] 67
A 1  T240  R CALL_PREFIX_NOT 240
D 3  T201  R ARRAYED_COLLECTION[E_FEATURE] 466,199,100
A*1  T58   R STD_FILE_WRITE 58
A 1  T382  R DEFERRED_PROCEDURE 382
D 8  T98   R ROUTINE 396,395,393,150,119,116,384,382
A*1  T441  R DICTIONARY[TYPE,STRING] 441
A 1  T103  E NATIVE_ARRAY[EXTERNAL_ROUTINE] 103
D    T41   R POINTER_REF
D 2  T257  R BOOLEAN_CONSTANT 259,260
A 1  T403  R DECLARATION_GROUP 403
A 1  T158  E NATIVE_ARRAY[RUN_FEATURE] 158
D 1  T209  R COLLECTION[ASSERTION] 204
A*1  T69   R DICTIONARY[RUN_CLASS,STRING] 69
A*1  T184  R FIXED_ARRAY[BASE_CLASS] 184
A 1  T449  E SWITCH 449
D 1  T186  R COLLECTION[BASE_CLASS] 184
A*1  T474  R ADDRESS_OF_POOL 474
D 1  T487  R ARRAY[RUN_FEATURE] 445
A 1  T307  R CST_ATT_REAL 307
A 1  T146  E NATIVE_ARRAY[DICTIONARY_NODE[RUN_FEATURE,STRING]] 146
A 1  T65   E NATIVE_ARRAY[RUN_CLASS] 65
A 2  T498  R DICTIONARY[EXPRESSION,STRING] 498,471
A*1  T164  R COMMENT 164
A 1  T276  R E_OLD 276
A*1  T83   R C_PRETTY_PRINTER 83
A*1  T451  R DICTIONARY_NODE[DICTIONARY[RUN_FEATURE,STRING],STRING] 451
A*1  T165  R EXCEPTIONS_HANDLER 165
A*1  T173  R DICTIONARY_NODE[E_FEATURE,STRING] 173
D 1  T75   R ARRAYED_COLLECTION[PARENT] 74
A 1  T243  R E_STRIP 243
D 1  T399  R COLLECTION[LOCAL_NAME1] 272
D 1  T320  R ARRAYED_COLLECTION[IFTHEN] 319
A 1  T475  R FIXED_ARRAY[ADDRESS_OF] 475
A 1  T432  E SWITCH_COLLECTION 432
A*1  T35   R DICTIONARY_NODE[STRING,STRING] 35
A*1  T92   R FIXED_ARRAY[NATIVE_C_PLUS_PLUS] 92
D 1  T477  R COLLECTION[ADDRESS_OF] 475
D 53 T126  R EXPRESSION 517,495,123,271,323,218,223,224,225,226,227,284,283,282,281,280,278,228,229,230,231,232,233,277,234,276,275,269,266,265,264,137,262,261,260,259,254,253,252,251,250,248,247,246,143,243,236,242,241,240,217,213,169
A 1  T71   E NATIVE_ARRAY[DICTIONARY_NODE[RUN_CLASS,STRING]] 71
A*1  T493  R FIXED_ARRAY[TUPLE[STRING,RUN_FEATURE]] 493
A 1  T254  R ADDRESS_OF 254
D 1  T510  R COLLECTION[TUPLE[TYPE,FEATURE_NAME]] 507
A 1  T269  R LOCAL_NAME2 269
A 1  T271  R LOCAL_NAME1 271
D 3  T167  R PROC_CALL 256,255,166
A 5  T212  R FIXED_ARRAY[EXPRESSION] 138,475,302,294,212
A*1  T61   R BASE_CLASS 61
D 2  T267  R PRECURSOR_CALL 266,268
A*1  T172  R DICTIONARY[E_FEATURE,STRING] 172
D 1  T315  R COLLECTION[INSTRUCTION] 161
D 1  T298  R COLLECTION[INTEGER_CONSTANT] 294
D 7  T216  R COLLECTION[EXPRESSION] 138,475,128,272,302,294,212
A 1  T323  R EXPRESSION_WITH_COMMENT 323
A 1  T252  R E_VOID 252
A 1  T233  R CALL_INFIX_TIMES 233
A*1  T82   R ERROR_HANDLER 82
A*1  T516  R MEMO[E_OLD] 516
A 1  T261  R CHARACTER_CONSTANT 261
A 1  T111  E BIT 32 111
A 1  T113  E BIT 15 113
A 1  T471  R DICTIONARY[MANIFEST_STRING,STRING] 471
A 1  T114  E BIT 13 114
A*1  T326  R E_WHEN 326
A 1  T352  R TYPE_LIKE_FEATURE 352
A*1  T189  R RENAME_PAIR 189
A 1  T198  E NATIVE_ARRAY[FEATURE_CLAUSE] 198
D 1  T514  R COLLECTION[BIT_CONSTANT] 138
D 1  T410  R COLLECTION[CREATION_CLAUSE] 181
A 1  T464  E NATIVE_ARRAY[DICTIONARY_NODE[TYPE,INTEGER]] 464
A 1  T116  R EXTERNAL_PROCEDURE 116
A 1  T380  R REVERSE_ASSIGNMENT 380
A 1  T409  R FROZEN_FEATURE_NAME 409
A 1  T259  R E_TRUE 259
A 1  T313  R IFTHENELSE 313
D    T34   R BOOLEAN_REF
A 1  T239  R PREFIX_NAME 239
A 1  T395  R ONCE_PROCEDURE 395
A 1  T150  R PROCEDURE 150
A*1  T412  R ARRAY[EXPORT_ITEM] 412
A*1  T470  R MANIFEST_STRING_POOL 470
A*1  T328  R FIXED_ARRAY[E_WHEN] 328
A*1  T422  R ARRAY[INDEX_CLAUSE] 422
A 1  T364  R TYPE_INTEGER 364
A*1  T483  R ARRAY[BOOLEAN] 483
D 8  T91   R NATIVE 89,392,390,389,388,387,386,385
A*1  T413  R EXPORT_LIST 413
A 1  T217  R TUPLE_EXPRESSION 217
A 1  T229  R CALL_INFIX_PLUS 229
A 1  T140  R CST_ATT_INTEGER 140
A*1  T105  R FIXED_ARRAY[POSITION] 105
A*1  T440  R CONVERSION_HANDLER 440
A 1  T472  R DICTIONARY_NODE[MANIFEST_STRING,STRING] 472
D 2  T400  R ARRAYED_COLLECTION[DECLARATION] 433,398
A*1  T462  R DICTIONARY[TYPE,INTEGER] 462
A*1  T60   R RUN_CLASS 60
A 2  T499  R DICTIONARY_NODE[EXPRESSION,STRING] 472,499
A 1  T330  E NATIVE_ARRAY[E_WHEN] 330
A 1  T120  R FIXED_ARRAY[STRING] 120
A*1  T38   R ECHO 38
A 1  T371  R TYPE_EXPANDED 371
A 1  T174  E NATIVE_ARRAY[DICTIONARY_NODE[E_FEATURE,STRING]] 174
A*1  T188  R RENAME_LIST 188
A 1  T300  R CST_ATT_CHARACTER 300
D 1  T512  R COLLECTION[TUPLE[STRING,RUN_FEATURE]] 493
A 1  T424  E NATIVE_ARRAY[INDEX_CLAUSE] 424
A*1  T195  R FEATURE_CLAUSE 195
A*1  T507  R FIXED_ARRAY[TUPLE[TYPE,FEATURE_NAME]] 507
A*1  T204  R ARRAY[ASSERTION] 204
A 4  T155  R FIXED_ARRAY[RUN_FEATURE] 520,502,479,155
D 2  T134  R COLLECTION[INTEGER] 263,132
A 1  T53   E NATIVE_ARRAY[STRING] 53
A*1  T411  R EXPORT_ITEM 411
A 1  T433  R ARRAY[DECLARATION_1] 433
A 1  T213  R MANIFEST_ARRAY 213
D 2  T64   R ARRAYED_COLLECTION[RUN_CLASS] 63,67
D 1  T191  R ARRAYED_COLLECTION[RENAME_PAIR] 190
A*1  T461  R MANIFEST_ARRAY_POOL 461
A 1  T211  E TMP_NAME 211
D 1  T182  R ARRAYED_COLLECTION[CREATION_CLAUSE] 181
A*1  T48   R SYSTEM_TOOLS 48
D 1  T490  R ARRAYED_COLLECTION[CECIL_FILE] 489
D 1  T468  R COLLECTION[ONCE_FUNCTION] 466
A 1  T439  E NATIVE_ARRAY[BIT_CONSTANT] 439
A 1  T509  E NATIVE_ARRAY[TUPLE[TYPE,FEATURE_NAME]] 509
A*1  T205  R CLASS_INVARIANT 205
A*1  T73   R PARENT 73
A*1  T317  R IFTHEN 317
A*1  T57   R RUN_CONTROL 57
D 1  T434  R ARRAYED_COLLECTION[DECLARATION_1] 433
A*1  T297  R COUNTER 297
A 1  T466  R FIXED_ARRAY[ONCE_FUNCTION] 466
A*1  T426  R ASSERTION_COLLECTOR 426
A 1  T367  R TYPE_REAL 367
A*1  T203  R ASSERTION 203
A 1  T183  E NATIVE_ARRAY[CREATION_CLAUSE] 183
A 2  T245  R EFFECTIVE_ARG_LIST 494,245
A 1  T393  R FUNCTION 393
D 1  T304  R COLLECTION[MANIFEST_STRING] 302
A*1  T207  R TAG_NAME 207
A*1  T17   R COMPILE_TO_C 17
D 2  T88   R COLLECTION[STRING] 120,52
A 1  T231  R CALL_INFIX_INT_REM 231
A 1  T121  R FORMAL_ARG_LIST 121
D 1  T101  R ARRAYED_COLLECTION[EXTERNAL_ROUTINE] 100
D 2  T133  R ARRAYED_COLLECTION[INTEGER] 263,132
A*1  T131  R CECIL_POOL 131
D 1  T408  R COLLECTION[ARGUMENT_NAME1] 128
A*1  T80   R DICTIONARY_NODE[BASE_CLASS,STRING] 80
D 27 T222  R CALL 223,234,228,247,246,227,282,278,284,281,283,224,218,236,240,233,229,231,242,232,226,230,241,280,248,277,225
A 1  T202  E NATIVE_ARRAY[E_FEATURE] 202
A 1  T401  E NATIVE_ARRAY[DECLARATION] 401
A 1  T368  R TYPE_STRING 368
D 1  T331  R COLLECTION[E_WHEN] 328
A*1  T77   R CLASS_NAME 77
A 1  T294  R FIXED_ARRAY[INTEGER_CONSTANT] 294
A 1  T369  R TYPE_CLASS 369
A 1  T256  R PROC_CALL_N 256
A 1  T255  R PROC_CALL_1 255
A 1  T166  R PROC_CALL_0 166
A*1  T7    R STRING 7
A*1  T159  R COMPOUND 159
A 1  T365  R TYPE_NONE 365
D 1  T416  R COLLECTION[EXPORT_ITEM] 412
D 1  T106  R ARRAYED_COLLECTION[POSITION] 105
D 1  T336  R COLLECTION[WHEN_ITEM] 333
A*1  T43   R STD_FILE_READ 43
A 1  T149  E NATIVE_ARRAY[TYPE] 149
D 2  T381  R DEFERRED_ROUTINE 382,384
A*1  T453  R FIXED_ARRAY[CALL_PROC_CALL] 453
A 1  T235  R INFIX_NAME 235
A 1  T192  E NATIVE_ARRAY[RENAME_PAIR] 192
A 1  T362  R TYPE_CHARACTER 362
A 1  T357  R TYPE_ARRAY 357
A*1  T420  R INDEX_CLAUSE 420
A 1  T242  R CALL_PREFIX_MINUS 242
D 1  T329  R ARRAYED_COLLECTION[E_WHEN] 328
D 1  T425  R COLLECTION[INDEX_CLAUSE] 422
A 1  T396  R ONCE_FUNCTION 396
D 1  T467  R ARRAYED_COLLECTION[ONCE_FUNCTION] 466
A 1  T519  R RUN_FEATURE_11 519
A 1  T526  R RUN_FEATURE_10 526
A 1  T119  R EXTERNAL_FUNCTION 119
D 1  T435  R COLLECTION[DECLARATION_1] 433
A 1  T232  R CALL_INFIX_INT_DIV 232
A 1  T390  R NATIVE_JVM_INVOKESTATIC 390
D 1  T459  R COLLECTION[EFFECTIVE_ARG_LIST] 457
A 1  T139  R TYPE_TUPLE 139
A 1  T292  E TMP_FEATURE 292
A 1  T366  R TYPE_POINTER 366
D 1  T303  R ARRAYED_COLLECTION[MANIFEST_STRING] 302
A 1  T437  R RUN_FEATURE_1 437
A 1  T152  R RUN_FEATURE_2 152
A 1  T154  R RUN_FEATURE_3 154
A 1  T523  R RUN_FEATURE_4 523
A 1  T524  R RUN_FEATURE_5 524
A 1  T525  R RUN_FEATURE_6 525
A 1  T115  R RUN_FEATURE_7 115
A 1  T95   R RUN_FEATURE_8 95
A 1  T501  R RUN_FEATURE_9 501
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T385  R NATIVE_SMALL_EIFFEL 385
D 1  T455  R COLLECTION[CALL_PROC_CALL] 453
D 2  T56   R ARRAYED_COLLECTION[STRING] 120,52
A*1  T421  R INDEX_LIST 421
A 1  T342  R LOOP_VARIANT_2 342
D 23 T62   R TYPE 522,521,376,373,372,371,370,369,139,368,367,366,365,364,363,362,360,359,357,356,355,354,352
D 1  T197  R ARRAYED_COLLECTION[FEATURE_CLAUSE] 196
A 1  T343  R LOOP_VARIANT_1 343
A 1  T251  R ORDINARY_RESULT 251
D 1  T429  R ARRAYED_COLLECTION[E_REQUIRE] 428
D 1  T496  R ARRAYED_COLLECTION[TUPLE[STRING,RUN_FEATURE]] 493
D 1  T431  R COLLECTION[E_REQUIRE] 428
A 1  T138  R FIXED_ARRAY[BIT_CONSTANT] 138
A*1  T374  R FORMAL_GENERIC_ARG 374
A 1  T305  E NATIVE_ARRAY[MANIFEST_STRING] 305
A 1  T359  R TYPE_NATIVE_ARRAY 359
A 1  T473  E NATIVE_ARRAY[DICTIONARY_NODE[MANIFEST_STRING,STRING]] 473
D 3  T55   R SAFE_EQUAL[STRING] 120,30,52
A 1  T268  R PRECURSOR_INSTRUCTION 268
A 1  T360  R TYPE_BOOLEAN 360
A*1  T444  R GC_HANDLER 444
D 1  T458  R ARRAYED_COLLECTION[EFFECTIVE_ARG_LIST] 457
A 1  T253  R WRITTEN_CURRENT 253
A 1  T293  R CST_ATT_UNIQUE 293
A 1  T316  R INSTRUCTION_WITH_COMMENT 316
A 1  T378  E NATIVE_ARRAY[FORMAL_GENERIC_ARG] 378
A 1  T94   E NATIVE_ARRAY[NATIVE_C_PLUS_PLUS] 94
A 1  T491  E NATIVE_ARRAY[CECIL_FILE] 491
A 1  T355  R TYPE_LIKE_ARGUMENT 355
A 1  T376  R TYPE_FORMAL_GENERIC 376
A 1  T210  E NATIVE_ARRAY[ASSERTION] 210
A 1  T272  R ARRAY[LOCAL_NAME1] 272
D 1  T289  R ARRAYED_COLLECTION[CLASS_NAME] 288
A 1  T495  R CECIL_TARGET 495
D 1  T273  R ARRAYED_COLLECTION[LOCAL_NAME1] 272
D 2  T249  R ABSTRACT_RESULT 251,250
A*1  T118  R FEATURE_NAME_LIST 118
A 1  T30   R DICTIONARY[STRING,STRING] 30
D 1  T107  R COLLECTION[POSITION] 105
A*1  T79   R DICTIONARY[BASE_CLASS,STRING] 79
A*1  T178  R PARSER_BUFFER 178
A 1  T384  R DEFERRED_FUNCTION 384
A 1  T177  E NATIVE_ARRAY[FEATURE_NAME] 177
A 1  T169  R IMPLICIT_CURRENT 169
D 5  T157  R COLLECTION[RUN_FEATURE] 520,502,479,445,155
A 1  T132  R FIXED_ARRAY[INTEGER] 132
A 1  T373  R TYPE_BIT_2 373
A 1  T372  R TYPE_BIT_1 372
D 1  T334  R ARRAYED_COLLECTION[WHEN_ITEM] 333
A*1  T147  R ARRAY[TYPE] 147
A 1  T153  R WRITABLE_ATTRIBUTE 153
A 1  T363  R TYPE_DOUBLE 363
A 1  T445  R ARRAY[RUN_FEATURE_2] 445
D 1  T162  R ARRAYED_COLLECTION[INSTRUCTION] 161
A 1  T456  E NATIVE_ARRAY[CALL_PROC_CALL] 456
A 1  T260  R E_FALSE 260
A 1  T341  R E_LOOP 341
A 1  T2    E INTEGER 2
A 1  T226  R CALL_INFIX_AND 226
A 1  T5    E DOUBLE 5
D 5  T156  R ARRAYED_COLLECTION[RUN_FEATURE] 520,502,479,445,155
D 1  T176  R ARRAYED_COLLECTION[FEATURE_NAME] 175
D 20 T220  R CALL_INFIX 218,223,224,225,226,227,284,283,282,281,280,278,228,229,230,231,232,233,277,234
A 1  T47   E NATIVE_ARRAY[DICTIONARY_NODE[INTEGER,STRING]] 47
A 1  T517  R IMPLICIT_CAST 517
A 1  T265  R INTEGER_CONSTANT 265
A 1  T505  E NATIVE_ARRAY[RUN_FEATURE_9] 505
D 2  T446  R ARRAYED_COLLECTION[RUN_FEATURE_2] 520,445
D 1  T480  R ARRAYED_COLLECTION[RUN_FEATURE_3] 479
A 1  T230  R CALL_INFIX_DIV 230
A 1  T482  E NATIVE_ARRAY[RUN_FEATURE_3] 482
A 1  T447  E NATIVE_ARRAY[RUN_FEATURE_2] 447
A*1  T46   R DICTIONARY_NODE[INTEGER,STRING] 46
A 1  T392  R NATIVE_JVM_INVOKEVIRTUAL 392
D 1  T503  R ARRAYED_COLLECTION[RUN_FEATURE_9] 502
D 1  T485  R COLLECTION[BOOLEAN] 483
A 1  T389  R NATIVE_INLINE_WITHOUT_CURRENT 389
A 1  T521  R TYPE_REF_TO_EXP 521
A 1  T469  E NATIVE_ARRAY[ONCE_FUNCTION] 469
A 1  T52   R ARRAY[STRING] 52
A*1  T145  R DICTIONARY_NODE[RUN_FEATURE,STRING] 145
A*1  T383  R E_REQUIRE 383
A*1  T457  R FIXED_ARRAY[EFFECTIVE_ARG_LIST] 457
A 1  T497  E NATIVE_ARRAY[TUPLE[STRING,RUN_FEATURE]] 497
A 1  T108  E NATIVE_ARRAY[POSITION] 108
A 1  T379  R ASSIGNMENT 379
A*1  T181  R FIXED_ARRAY[CREATION_CLAUSE] 181
A 1  T274  E NATIVE_ARRAY[LOCAL_NAME1] 274
A*1  T340  R LOOP_INVARIANT 340
D 1  T185  R ARRAYED_COLLECTION[BASE_CLASS] 184
A 1  T370  R TYPE_GENERIC 370
D 2  T68   R COLLECTION[RUN_CLASS] 63,67
A 1  T112  E BIT 7 112
A 1  T443  E NATIVE_ARRAY[DICTIONARY_NODE[TYPE,STRING]] 443
D    T36   R CHARACTER_REF
A*1  T190  R FIXED_ARRAY[RENAME_PAIR] 190
A 1  T306  R CST_ATT_BIT 306
A 1  T241  R CALL_PREFIX_PLUS 241
A 1  T500  E NATIVE_ARRAY[DICTIONARY_NODE[EXPRESSION,STRING]] 500
A 1  T264  R REAL_CONSTANT 264
A 1  T388  R NATIVE_WITHOUT_CURRENT 388
D 1  T484  R ARRAYED_COLLECTION[BOOLEAN] 483
A 1  T135  E NATIVE_ARRAY[INTEGER] 135
A 1  T280  R CALL_INFIX_NEQ 280
A*1  T27   R STRING_ALIASER 27
A 1  T163  E NATIVE_ARRAY[INSTRUCTION] 163
A*1  T175  R FIXED_ARRAY[FEATURE_NAME] 175
A 1  T248  R CALL_N 248
A 1  T277  R CALL_INFIX_POWER 277
A*1  T37   R EIFFEL_PARSER 37
A*1  T450  R DICTIONARY[DICTIONARY[RUN_FEATURE,STRING],STRING] 450
A 1  T522  R TYPE_BIT_REF 522
A 1  T225  R CALL_INFIX_OR_ELSE 225
A*1  T194  R FEATURE_CLAUSE_LIST 194
D 5  T238  R CALL_0 246,236,240,242,241
D 1  T322  R COLLECTION[IFTHEN] 319
A 1  T520  R FIXED_ARRAY[RUN_FEATURE_2] 520
D 1  T476  R ARRAYED_COLLECTION[ADDRESS_OF] 475
D 1  T418  R COLLECTION[PARENT] 74
A*1  T59   R SMALL_EIFFEL 59
A 1  T479  R FIXED_ARRAY[RUN_FEATURE_3] 479
A 1  T290  E NATIVE_ARRAY[CLASS_NAME] 290
A 1  T63   R ARRAY[RUN_CLASS] 63
D 2  T448  R COLLECTION[RUN_FEATURE_2] 520,445
A*1  T463  R DICTIONARY_NODE[TYPE,INTEGER] 463
A 1  T137  R BIT_CONSTANT 137
D 1  T481  R COLLECTION[RUN_FEATURE_3] 479
A 1  T502  R FIXED_ARRAY[RUN_FEATURE_9] 502
A 1  T518  R PRECURSOR_NAME 518
D 2  T97   R EXTERNAL_ROUTINE 119,116
D 17 T99   R E_FEATURE 153,396,395,393,150,119,116,384,382,140,308,307,306,301,300,299,293
D 1  T504  R COLLECTION[RUN_FEATURE_9] 502
A 1  T250  R ONCE_RESULT 250
D 2  T405  R ARRAYED_COLLECTION[LOCAL_ARGUMENT1] 128,272
D 7  T214  R ARRAYED_COLLECTION[EXPRESSION] 138,475,128,272,302,294,212
A 1  T494  R CECIL_ARG_LIST 494
A 1  T262  R MANIFEST_STRING 262
A*1  T39   R STD_OUTPUT 39
A*1  T54   R STD_ERROR 54
A*1  T72   R PARENT_LIST 72
A 2  T398  R ARRAY[DECLARATION] 433,398
A 1  T4    E REAL 4
D 17 T160  R INSTRUCTION 380,379,351,349,347,344,341,325,324,313,316,312,310,268,256,255,166
A 1  T351  R CREATION_CALL_4 351
A 1  T349  R CREATION_CALL_3 349
A*1  T193  R FORMAL_GENERIC_LIST 193
A 1  T347  R CREATION_CALL_2 347
A 1  T344  R CREATION_CALL_1 344
D 5  T117  R FEATURE_NAME 518,409,143,235,239
A*1  T489  R FIXED_ARRAY[CECIL_FILE] 489
D 1  T102  R COLLECTION[EXTERNAL_ROUTINE] 100
A*1  T311  R CHECK_INVARIANT 311
A 1  T452  E NATIVE_ARRAY[DICTIONARY_NODE[DICTIONARY[RUN_FEATURE,STRING],STRING]] 452
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S104 T104;
typedef struct S375 T375;
typedef struct S200 T200;
typedef struct S199 T199;
typedef struct S143 T143;
typedef struct S223 T223;
typedef struct S234 T234;
typedef struct S427 T427;
typedef struct S302 T302;
typedef struct S228 T228;
typedef int T86;
typedef struct S308 T308;
typedef struct S407 T407;
typedef struct S309 T309;
typedef struct S488 T488;
typedef struct S61 T61;
typedef struct S89 T89;
typedef struct S387 T387;
typedef struct S506 T506;
typedef struct S123 T123;
typedef struct S338 T338;
typedef struct S337 T337;
typedef struct S179 T179;
typedef struct S265 T265;
typedef struct S428 T428;
typedef struct S254 T254;
typedef struct S312 T312;
typedef struct S247 T247;
typedef struct S246 T246;
typedef struct S45 T45;
typedef struct S324 T324;
typedef struct S70 T70;
typedef struct S180 T180;
typedef struct S442 T442;
typedef struct S161 T161;
typedef struct S227 T227;
typedef struct S74 T74;
typedef struct S319 T319;
typedef struct S263 T263;
typedef void*T465;
typedef struct S266 T266;
typedef struct S383 T383;
typedef struct S411 T411;
typedef struct S42 T42;
typedef struct S128 T128;
typedef struct S333 T333;
typedef struct S354 T354;
typedef struct S196 T196;
typedef struct S73 T73;
typedef struct S317 T317;
typedef struct S288 T288;
typedef struct S318 T318;
typedef struct S327 T327;
typedef struct S100 T100;
typedef struct S282 T282;
typedef struct S278 T278;
typedef struct S310 T310;
typedef struct S284 T284;
typedef struct S386 T386;
typedef struct S281 T281;
typedef struct S511 T511;
typedef struct S80 T80;
typedef struct S283 T283;
typedef struct S299 T299;
typedef struct S301 T301;
typedef struct S224 T224;
typedef struct S356 T356;
typedef struct S245 T245;
typedef struct S171 T171;
typedef struct S325 T325;
typedef struct S275 T275;
typedef struct S218 T218;
typedef struct S35 T35;
typedef struct S287 T287;
typedef struct S144 T144;
typedef struct S236 T236;
typedef struct S67 T67;
typedef struct S240 T240;
typedef struct S58 T58;
typedef struct S382 T382;
typedef struct S441 T441;
typedef struct S403 T403;
typedef struct S69 T69;
typedef struct S184 T184;
typedef int T449;
typedef void*T474;
typedef struct S307 T307;
typedef struct S145 T145;
typedef struct S60 T60;
typedef struct S498 T498;
typedef struct S164 T164;
typedef struct S276 T276;
typedef struct S83 T83;
typedef struct S451 T451;
typedef struct S165 T165;
typedef struct S173 T173;
typedef struct S243 T243;
typedef struct S475 T475;
typedef int T432;
typedef struct S92 T92;
typedef struct S493 T493;
typedef struct S269 T269;
typedef struct S271 T271;
typedef struct S212 T212;
typedef struct S172 T172;
typedef struct S323 T323;
typedef struct S252 T252;
typedef struct S233 T233;
typedef struct S82 T82;
typedef struct S516 T516;
typedef struct S261 T261;
typedef unsigned int T111;
typedef unsigned int T113;
typedef struct S471 T471;
typedef unsigned int T114;
typedef struct S326 T326;
typedef struct S352 T352;
typedef struct S189 T189;
typedef struct S195 T195;
typedef struct S463 T463;
typedef struct S116 T116;
typedef struct S380 T380;
typedef struct S409 T409;
typedef struct S259 T259;
typedef struct S313 T313;
typedef struct S239 T239;
typedef struct S395 T395;
typedef struct S150 T150;
typedef struct S412 T412;
typedef void*T470;
typedef struct S328 T328;
typedef struct S422 T422;
typedef struct S364 T364;
typedef struct S483 T483;
typedef struct S413 T413;
typedef struct S217 T217;
typedef struct S229 T229;
typedef struct S140 T140;
typedef struct S105 T105;
typedef struct S440 T440;
typedef struct S472 T472;
typedef struct S462 T462;
typedef struct S499 T499;
typedef struct S120 T120;
typedef struct S38 T38;
typedef struct S371 T371;
typedef struct S188 T188;
typedef struct S300 T300;
typedef struct S420 T420;
typedef struct S507 T507;
typedef struct S204 T204;
typedef struct S155 T155;
typedef struct S7 T7;
typedef struct S433 T433;
typedef struct S213 T213;
typedef void*T461;
typedef struct S211 T211;
typedef struct S48 T48;
typedef struct S137 T137;
typedef struct S205 T205;
typedef struct S57 T57;
typedef struct S297 T297;
typedef struct S466 T466;
typedef struct S426 T426;
typedef struct S367 T367;
typedef struct S203 T203;
typedef struct S393 T393;
typedef struct S207 T207;
typedef struct S17 T17;
typedef struct S231 T231;
typedef struct S121 T121;
typedef struct S131 T131;
typedef struct S368 T368;
typedef struct S77 T77;
typedef struct S294 T294;
typedef struct S369 T369;
typedef struct S256 T256;
typedef struct S255 T255;
typedef struct S166 T166;
typedef struct S159 T159;
typedef struct S365 T365;
typedef struct S43 T43;
typedef struct S453 T453;
typedef struct S235 T235;
typedef struct S362 T362;
typedef struct S357 T357;
typedef struct S242 T242;
typedef struct S396 T396;
typedef struct S519 T519;
typedef struct S526 T526;
typedef struct S119 T119;
typedef struct S232 T232;
typedef struct S390 T390;
typedef struct S139 T139;
typedef struct S292 T292;
typedef struct S366 T366;
typedef struct S437 T437;
typedef struct S152 T152;
typedef struct S154 T154;
typedef struct S523 T523;
typedef struct S524 T524;
typedef struct S525 T525;
typedef struct S115 T115;
typedef struct S95 T95;
typedef struct S501 T501;
typedef struct S385 T385;
typedef struct S421 T421;
typedef struct S342 T342;
typedef struct S343 T343;
typedef struct S251 T251;
typedef struct S138 T138;
typedef struct S374 T374;
typedef struct S262 T262;
typedef struct S359 T359;
typedef struct S268 T268;
typedef struct S360 T360;
typedef struct S444 T444;
typedef struct S253 T253;
typedef struct S293 T293;
typedef struct S316 T316;
typedef struct S355 T355;
typedef struct S376 T376;
typedef struct S272 T272;
typedef struct S495 T495;
typedef struct S118 T118;
typedef struct S30 T30;
typedef struct S79 T79;
typedef struct S178 T178;
typedef struct S384 T384;
typedef struct S169 T169;
typedef struct S132 T132;
typedef struct S373 T373;
typedef struct S372 T372;
typedef struct S147 T147;
typedef struct S153 T153;
typedef struct S363 T363;
typedef struct S445 T445;
typedef struct S260 T260;
typedef struct S341 T341;
typedef struct S226 T226;
typedef struct S46 T46;
typedef struct S517 T517;
typedef struct S230 T230;
typedef struct S392 T392;
typedef struct S389 T389;
typedef struct S521 T521;
typedef struct S52 T52;
typedef struct S457 T457;
typedef struct S379 T379;
typedef struct S181 T181;
typedef struct S340 T340;
typedef struct S370 T370;
typedef unsigned char T112;
typedef struct S190 T190;
typedef struct S306 T306;
typedef struct S241 T241;
typedef struct S264 T264;
typedef struct S388 T388;
typedef struct S280 T280;
typedef void*T27;
typedef struct S175 T175;
typedef struct S248 T248;
typedef struct S277 T277;
typedef struct S37 T37;
typedef struct S450 T450;
typedef struct S522 T522;
typedef struct S225 T225;
typedef struct S194 T194;
typedef struct S520 T520;
typedef struct S59 T59;
typedef struct S479 T479;
typedef struct S63 T63;
typedef struct S502 T502;
typedef struct S518 T518;
typedef struct S250 T250;
typedef struct S494 T494;
typedef void*T39;
typedef void*T54;
typedef struct S72 T72;
typedef struct S398 T398;
typedef struct S351 T351;
typedef struct S349 T349;
typedef struct S193 T193;
typedef struct S347 T347;
typedef struct S344 T344;
typedef struct S489 T489;
typedef struct S311 T311;

/*C Header Pass 2 :*/
typedef T0**T187;
typedef T0**T130;
typedef T0**T436;
typedef T0**T296;
typedef T0**T335;
typedef T0**T478;
typedef T0**T215;
typedef T0**T430;
typedef T0**T415;
typedef T0**T76;
typedef T0**T321;
typedef T0**T81;
typedef T6*T486;
typedef T0**T460;
typedef T0**T33;
typedef T0**T406;
typedef T0**T103;
typedef T0**T158;
typedef T0**T146;
typedef T0**T65;
typedef T0**T71;
typedef T0**T198;
typedef T0**T464;
typedef T0**T330;
typedef T0**T174;
typedef T0**T424;
typedef T0**T53;
typedef T0**T439;
typedef T0**T509;
typedef T0**T183;
typedef T0**T202;
typedef T0**T401;
typedef T0**T149;
typedef T0**T192;
typedef T3*T9;
typedef T0**T305;
typedef T0**T473;
typedef T0**T378;
typedef T0**T94;
typedef T0**T491;
typedef T0**T210;
typedef T0**T177;
typedef T0**T456;
typedef T0**T47;
typedef T0**T505;
typedef T0**T482;
typedef T0**T447;
typedef T0**T469;
typedef T0**T497;
typedef T104*T108;
typedef T0**T274;
typedef T0**T443;
typedef T0**T500;
typedef T2*T135;
typedef T0**T163;
typedef T0**T290;
typedef T0**T452;

/*C Header Pass 3 :*/
struct S104{T0* _base_class;T111 _mangling;};
int se_cmpT104(T104 o1,T104 o2);
struct S211{T104 _start_position;T0* _aliased_string_memory;};
int se_cmpT211(T211 o1,T211 o2);
struct S292{T0* _arguments;T0* _type;T0* _header_comment;T0* _obsolete_mark;T0* _require_assertion;T0* _local_vars;T0* _routine_body;};
int se_cmpT292(T292 o1,T292 o2);

/*C Header Pass 4 :*/
extern T104 M104;
struct S375{T378 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T375 M375;
struct S200{T104 _start_position;T0* _list;};
extern T200 M200;
struct S199{Tid id;T202 _storage;T2 _capacity;T2 _upper;};
extern T199 M199;
struct S143{Tid id;T104 _start_position;T0* _to_string;T0* _run_feature_2;};
extern T143 M143;
struct S223{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T223 M223;
struct S234{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T234 M234;
struct S427{T0* _list;};
extern T427 M427;
struct S302{Tid id;T305 _storage;T2 _capacity;T2 _upper;};
extern T302 M302;
struct S228{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T228 M228;
extern T86 M86;
struct S308{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T308 M308;
struct S407{Tid id;T0* _name;};
extern T407 M407;
struct S309{T104 _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_ensure_then;};
extern T309 M309;
struct S488{T0* _path;T0* _path_h;T0* _entries;};
extern T488 M488;
struct S89{Tid id;T0* _external_tag;T0* _rf7_memory;T0* _rf8_memory;};
extern T89 M89;
struct S387{Tid id;T0* _external_tag;};
extern T387 M387;
struct S506{T0* _second;T0* _first;};
extern T506 M506;
T0*new_tuple506(T0* i1,T0* i2);
struct S338{Tid id;T0* _e_when;T0* _lower;T0* _upper;T2 _lower_value;T2 _upper_value;};
extern T338 M338;
struct S337{Tid id;T0* _e_when;T0* _expression;T2 _expression_value;};
extern T337 M337;
struct S179{T0* _list;};
extern T179 M179;
struct S428{T430 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T428 M428;
struct S312{Tid id;T104 _start_position;T0* _current_type;T0* _list;T0* _compound;};
extern T312 M312;
struct S247{Tid id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T247 M247;
struct S246{Tid id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T246 M246;
struct S45{T47 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T45 M45;
struct S324{Tid id;T104 _start_position;T0* _run_feature;};
extern T324 M324;
struct S70{T0* _item;T0* _key;T0* _next;};
extern T70 M70;
struct S180{T104 _start_position;T0* _clients;T0* _comment;T0* _procedure_list;};
extern T180 M180;
struct S442{T0* _item;T0* _key;T0* _next;};
extern T442 M442;
struct S161{T163 _storage;T2 _capacity;T2 _upper;};
extern T161 M161;
struct S227{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T227 M227;
struct S74{T76 _storage;T2 _capacity;T2 _upper;};
extern T74 M74;
struct S319{T321 _storage;T2 _capacity;T2 _upper;};
extern T319 M319;
struct S263{Tid id;T135 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T263 M263;
extern T465 M465;
struct S266{Tid id;T104 _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T266 M266;
struct S42{T2 _max_id;};
extern T42 M42;
struct S128{Tid id;T130 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T128 M128;
struct S333{T335 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T333 M333;
struct S354{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _run_type;};
extern T354 M354;
struct S196{T198 _storage;T2 _capacity;T2 _upper;};
extern T196 M196;
struct S288{T290 _storage;T2 _capacity;T2 _upper;};
extern T288 M288;
struct S318{T0* _list;T0* _current_type;};
extern T318 M318;
struct S327{T0* _e_inspect;T0* _list;};
extern T327 M327;
struct S100{Tid id;T103 _storage;T2 _capacity;T2 _upper;};
extern T100 M100;
struct S282{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T282 M282;
struct S278{Tid id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T278 M278;
struct S310{Tid id;T0* _check_invariant;T0* _current_type;};
extern T310 M310;
struct S284{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T284 M284;
struct S386{Tid id;T0* _external_tag;};
extern T386 M386;
struct S281{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T281 M281;
struct S511{T0* _second;T0* _first;};
extern T511 M511;
T0*new_tuple511(T0* i1,T0* i2);
struct S283{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T283 M283;
struct S299{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T299 M299;
struct S301{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _first_value;T0* _remainder;};
extern T301 M301;
struct S224{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T224 M224;
struct S356{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T356 M356;
struct S171{Tid id;T0* _list;T0* _flat_list;};
extern T171 M171;
struct S325{Tid id;T104 _start_position;T0* _expression;T0* _when_list;T104 _else_position;T0* _else_compound;T0* _current_type;};
extern T325 M325;
struct S275{Tid id;T104 _start_position;T2 _rank;T0* _formal_arg_list;};
extern T275 M275;
struct S123{Tid id;T104 _start_position;T0* _to_string;T0* _result_type;T2 _rank;};
extern T123 M123;
struct S218{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T218 M218;
struct S287{T0* _first;T0* _remainder;};
extern T287 M287;
struct S144{T146 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T144 M144;
struct S236{Tid id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T236 M236;
struct S67{Tid id;T65 _storage;T2 _capacity;T2 _upper;};
extern T67 M67;
struct S240{Tid id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T240 M240;
struct S58{T0* _path;T8 _output_stream;};
extern T58 M58;
struct S382{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;};
extern T382 M382;
struct S441{T443 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T441 M441;
struct S403{Tid id;T0* _name_list;};
extern T403 M403;
struct S69{T71 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T69 M69;
struct S184{T187 _storage;T2 _capacity;T2 _upper;};
extern T184 M184;
extern T449 M449;
extern T474 M474;
struct S307{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T307 M307;
struct S498{Tid id;T500 _buckets;T2 _capacity;T2 _count;T2 _cache_user;};
extern T498 M498;
struct S164{T104 _start_position;T0* _list;};
extern T164 M164;
struct S276{Tid id;T0* _expression;T0* _current_type;T0* _local_c_name_memory;};
extern T276 M276;
struct S83{T2 _inlined_procedure_count;T2 _inlined_function_count;T2 _procedure_count;T2 _function_count;T2 _precursor_routine_count;T2 _real_procedure_count;T2 _real_function_count;T2 _static_expression_count;T2 _top;T2 _check_id_count;T2 _direct_call_count;T2 _sure_void_count;T2 _switch_count;T6 _no_split;T6 _no_main;T6 _wedit;T0* _c_plus_plus;T0* _out_h;T0* _current_out;T0* _check_assertion_mode;T2 _inspect_level;T2 _inline_level;T2 _split_count;T2 _elt_c_count;T6 _executable_is_up_to_date;T0* _bit_constant_pool;T2 _se_tmp_level;};
extern T83 M83;
struct S451{T0* _item;T0* _key;T0* _next;};
extern T451 M451;
struct S165{T6 _used;};
extern T165 M165;
struct S173{T0* _item;T0* _key;T0* _next;};
extern T173 M173;
struct S243{Tid id;T0* _current_type;T104 _start_position;T0* _list;T0* _result_type_memory;};
extern T243 M243;
struct S475{Tid id;T478 _storage;T2 _capacity;T2 _upper;};
extern T475 M475;
extern T432 M432;
struct S35{T0* _item;T0* _key;T0* _next;};
extern T35 M35;
struct S92{T94 _storage;T2 _capacity;T2 _upper;};
extern T92 M92;
struct S493{T497 _storage;T2 _capacity;T2 _upper;};
extern T493 M493;
struct S254{Tid id;T0* _feature_name;T0* _run_feature;T0* _current_type;};
extern T254 M254;
struct S269{Tid id;T104 _start_position;T2 _rank;T0* _local_var_list;};
extern T269 M269;
struct S271{Tid id;T104 _start_position;T0* _to_string;T0* _result_type;T2 _rank;T6 _is_used;};
extern T271 M271;
struct S212{Tid id;T215 _storage;T2 _capacity;T2 _upper;};
extern T212 M212;
struct S61{T2 _id;T0* _path;T0* _index_list;T0* _heading_comment1;T6 _is_deferred;T6 _is_expanded;T0* _name;T0* _formal_generic_list;T0* _heading_comment2;T0* _obsolete_type_string;T0* _parent_list;T0* _creation_clause_list;T0* _feature_clause_list;T0* _class_invariant;T0* _end_comment;T0* _feature_dictionary;T0* _once_mark_list;};
extern T61 M61;
struct S172{T174 _buckets;T2 _capacity;T2 _count;T2 _cache_user;};
extern T172 M172;
struct S323{Tid id;T0* _expression;T0* _comment;};
extern T323 M323;
struct S252{Tid id;T104 _start_position;};
extern T252 M252;
struct S233{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T233 M233;
struct S82{T2 _error_counter;T2 _warning_counter;T6 _no_warning;};
extern T82 M82;
struct S516{T0* _item;};
extern T516 M516;
struct S261{Tid id;T104 _start_position;T3 _value;T2 _pretty_print_mode;};
extern T261 M261;
struct S471{Tid id;T473 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T471 M471;
struct S326{T104 _start_position;T0* _header_comment;T0* _compound;T0* _when_list;T0* _values;T0* _list;};
extern T326 M326;
struct S352{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _like_what;T0* _written_mark;T0* _run_type;};
extern T352 M352;
struct S189{T0* _new_name;T0* _old_name;};
extern T189 M189;
struct S116{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;};
extern T116 M116;
struct S380{Tid id;T0* _left_side;T0* _right_side;T0* _current_type;};
extern T380 M380;
struct S409{Tid id;T0* _feature_name;};
extern T409 M409;
struct S259{Tid id;T104 _start_position;};
extern T259 M259;
struct S313{Tid id;T104 _start_position;T0* _ifthenlist;T0* _else_compound;T0* _current_type;};
extern T313 M313;
struct S239{Tid id;T104 _start_position;T0* _to_string;T0* _to_key;};
extern T239 M239;
struct S395{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T395 M395;
struct S150{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T150 M150;
struct S412{T415 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T412 M412;
extern T470 M470;
struct S328{T330 _storage;T2 _capacity;T2 _upper;};
extern T328 M328;
struct S422{T424 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T422 M422;
struct S364{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T364 M364;
struct S483{T486 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T483 M483;
struct S413{T104 _start_position;T0* _items;};
extern T413 M413;
struct S217{Tid id;T104 _start_position;T0* _result_type;T0* _list;T0* _current_type;};
extern T217 M217;
struct S229{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T229 M229;
struct S140{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T140 M140;
struct S105{T108 _storage;T2 _capacity;T2 _upper;};
extern T105 M105;
struct S440{T0* _destination;T0* _source;T0* _entry;};
extern T440 M440;
struct S472{Tid id;T0* _item;T0* _key;T0* _next;};
extern T472 M472;
struct S462{T464 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T462 M462;
struct S60{T0* _current_type;T0* _run_time_mark;T0* _base_class;T0* _base_class_name;T2 _id;T6 _at_run_time;T0* _running;T0* _class_invariant;T6 _compile_to_c_done;T0* _feature_dictionary;T2 _tagged_mem;T0* _actuals_clients;T0* _writable_attributes_mem;T6 _runnable_class_invariant_done;T2 _c_header_pass_level_done;};
extern T60 M60;
struct S499{Tid id;T0* _item;T0* _key;T0* _next;};
extern T499 M499;
struct S120{Tid id;T53 _storage;T2 _capacity;T2 _upper;};
extern T120 M120;
struct S38{T6 _verbose;};
extern T38 M38;
struct S371{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _written_mark;T0* _mapped;T0* _run_time_mark;T0* _run_type;};
extern T371 M371;
struct S188{T0* _list;};
extern T188 M188;
struct S300{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T300 M300;
struct S195{T0* _clients;T0* _comment;T0* _list;};
extern T195 M195;
struct S507{T509 _storage;T2 _capacity;T2 _upper;};
extern T507 M507;
struct S204{T210 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T204 M204;
struct S155{Tid id;T158 _storage;T2 _capacity;T2 _upper;};
extern T155 M155;
struct S411{T0* _clients;T0* _list;};
extern T411 M411;
struct S433{Tid id;T436 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T433 M433;
struct S213{Tid id;T104 _start_position;T0* _result_type;T0* _list;T0* _current_type;};
extern T213 M213;
extern T461 M461;
extern T211 M211;
struct S48{T0* _system_name;T0* _sys_directory;T0* _bin_directory;T0* _c_compiler;T6 _no_strip;};
extern T48 M48;
struct S205{T104 _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T205 M205;
struct S73{T0* _type;T0* _base_class;T0* _base_class_name;T0* _parent_list;T0* _rename_list;T0* _export_list;T0* _undefine_list;T0* _redefine_list;T0* _select_list;T0* _comment;T0* _undefine_memory1;T0* _undefine_memory2;};
extern T73 M73;
struct S317{T0* _expression;T0* _then_compound;T0* _current_type;};
extern T317 M317;
struct S57{T2 _level;T6 _trace;T0* _root_class;T6 _generating_type_used;T6 _generator_used;T6 _deep_twin_used;T6 _is_deep_equal_used;T0* _output_name;T0* _root_procedure_memory;};
extern T57 M57;
struct S297{T2 _value;};
extern T297 M297;
struct S466{Tid id;T469 _storage;T2 _capacity;T2 _upper;};
extern T466 M466;
struct S426{T6 _processing_require;T0* _header_comment;};
extern T426 M426;
struct S367{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T367 M367;
struct S203{T0* _tag;T0* _expression;T0* _comment;T0* _current_type;};
extern T203 M203;
struct S245{Tid id;T0* _first_one;T0* _remainder;T0* _current_type;};
extern T245 M245;
struct S393{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T393 M393;
struct S207{T0* _to_string;T104 _start_position;};
extern T207 M207;
struct S17{T0* _level_flag;};
extern T17 M17;
struct S231{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T231 M231;
struct S121{Tid id;T0* _list;T0* _flat_list;};
extern T121 M121;
struct S131{T0* _cecil_files;};
extern T131 M131;
struct S80{T0* _item;T0* _key;T0* _next;};
extern T80 M80;
struct S368{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T368 M368;
struct S77{T104 _start_position;T0* _to_string;};
extern T77 M77;
struct S294{Tid id;T296 _storage;T2 _capacity;T2 _upper;};
extern T294 M294;
struct S369{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T369 M369;
struct S256{Tid id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T256 M256;
struct S255{Tid id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T255 M255;
struct S166{Tid id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T166 M166;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S159{T0* _header_comment;T0* _current_type;T0* _first_one;T0* _remainder;};
extern T159 M159;
struct S365{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T365 M365;
struct S43{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T43 M43;
struct S453{T456 _storage;T2 _capacity;T2 _upper;};
extern T453 M453;
struct S235{Tid id;T104 _start_position;T0* _to_string;T0* _to_key;};
extern T235 M235;
struct S362{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T362 M362;
struct S357{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T357 M357;
struct S420{T0* _tag;T0* _list;};
extern T420 M420;
struct S242{Tid id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T242 M242;
struct S396{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T396 M396;
struct S519{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T519 M519;
struct S526{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T526 M526;
struct S119{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;T0* _result_type;};
extern T119 M119;
struct S232{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T232 M232;
struct S390{Tid id;T0* _external_tag;};
extern T390 M390;
struct S139{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _base_class_name;T0* _written_mark;T0* _run_time_mark;T0* _run_type;T0* _types;T0* _run_types;T6 _load_basic_features_flag;};
extern T139 M139;
extern T292 M292;
struct S366{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T366 M366;
struct S437{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _value;T0* _result_type;};
extern T437 M437;
struct S152{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _result_type;};
extern T152 M152;
struct S154{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;T2 _in_line_status;};
extern T154 M154;
struct S523{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;T2 _static_value_mem;T2 _in_line_status;T6 _is_static_flag;};
extern T523 M523;
struct S524{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T524 M524;
struct S525{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T525 M525;
struct S115{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _ensure_assertion;};
extern T115 M115;
struct S95{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T2 _static_value_mem;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T95 M95;
struct S501{Tid id;T0* _clients_memory;T0* _current_type;T0* _run_class;T0* _name;T2 _use_current_state;T2 _stupid_switch_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T501 M501;
struct S385{Tid id;T0* _external_tag;};
extern T385 M385;
struct S421{T0* _list;};
extern T421 M421;
struct S342{Tid id;T0* _comment;T0* _expression;T0* _current_type;T0* _tag;};
extern T342 M342;
struct S343{Tid id;T0* _comment;T0* _expression;T0* _current_type;};
extern T343 M343;
struct S251{Tid id;T104 _start_position;T0* _run_feature;};
extern T251 M251;
struct S138{Tid id;T439 _storage;T2 _capacity;T2 _upper;};
extern T138 M138;
struct S374{T0* _name;T0* _constraint;T2 _rank;};
extern T374 M374;
struct S359{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type;};
extern T359 M359;
struct S268{Tid id;T104 _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T268 M268;
struct S360{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T360 M360;
struct S444{T6 _is_off;T6 _info_flag;T6 _dispose_flag;};
extern T444 M444;
struct S253{Tid id;T104 _start_position;T0* _result_type;};
extern T253 M253;
struct S293{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _values;};
extern T293 M293;
struct S316{Tid id;T0* _instruction;T0* _comment;};
extern T316 M316;
struct S355{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _like_what;T0* _written_mark;T0* _run_feature;};
extern T355 M355;
struct S376{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _written_mark;T0* _run_type;T0* _run_time_mark;T2 _rank;T0* _formal_name;T0* _formal_generic_arg;T0* _constraint_memory;};
extern T376 M376;
struct S272{Tid id;T274 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T272 M272;
struct S495{Tid id;T0* _run_feature;};
extern T495 M495;
struct S118{T0* _first;T0* _remainder;};
extern T118 M118;
struct S30{Tid id;T33 _buckets;T2 _capacity;T2 _count;T2 _cache_user;};
extern T30 M30;
struct S79{T81 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T79 M79;
struct S178{T0* _path;T2 _count;};
extern T178 M178;
struct S384{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _result_type;};
extern T384 M384;
struct S169{Tid id;T104 _start_position;T0* _result_type;};
extern T169 M169;
struct S132{Tid id;T135 _storage;T2 _capacity;T2 _upper;};
extern T132 M132;
struct S373{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _written_mark;T0* _n;T0* _run_type;};
extern T373 M373;
struct S372{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _written_mark;T0* _n;};
extern T372 M372;
struct S147{T149 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T147 M147;
struct S153{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;};
extern T153 M153;
struct S363{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;};
extern T363 M363;
struct S445{Tid id;T447 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T445 M445;
struct S260{Tid id;T104 _start_position;};
extern T260 M260;
struct S341{Tid id;T104 _start_position;T0* _initialize;T0* _invariant_clause;T0* _variant_clause;T0* _until_expression;T0* _loop_body;T0* _current_type;};
extern T341 M341;
struct S226{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T226 M226;
struct S517{Tid id;T0* _expression;T0* _source_type;T0* _destination_type;};
extern T517 M517;
struct S265{Tid id;T104 _start_position;T2 _value;};
extern T265 M265;
struct S230{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T230 M230;
struct S46{T2 _item;T0* _key;T0* _next;};
extern T46 M46;
struct S392{Tid id;T0* _external_tag;};
extern T392 M392;
struct S389{Tid id;T0* _external_tag;};
extern T389 M389;
struct S521{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _written_mark;T0* _expanded_type;};
extern T521 M521;
struct S52{Tid id;T53 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T52 M52;
struct S145{T0* _item;T0* _key;T0* _next;};
extern T145 M145;
struct S383{T104 _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_require_else;};
extern T383 M383;
struct S457{T460 _storage;T2 _capacity;T2 _upper;};
extern T457 M457;
struct S379{Tid id;T0* _left_side;T0* _right_side;};
extern T379 M379;
struct S181{T183 _storage;T2 _capacity;T2 _upper;};
extern T181 M181;
struct S340{T104 _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T340 M340;
struct S370{Tid id;T0* _base_class_memory;T0* _run_class_memory;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T370 M370;
struct S190{T192 _storage;T2 _capacity;T2 _upper;};
extern T190 M190;
struct S306{Tid id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T306 M306;
struct S241{Tid id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T241 M241;
struct S264{Tid id;T104 _start_position;T0* _to_string;};
extern T264 M264;
struct S388{Tid id;T0* _external_tag;};
extern T388 M388;
struct S280{Tid id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T280 M280;
extern T27 M27;
struct S175{T177 _storage;T2 _capacity;T2 _upper;};
extern T175 M175;
struct S248{Tid id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T248 M248;
struct S277{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T277 M277;
struct S37{T6 _case_insensitive;T6 _no_style_warning;T6 _is_running;T0* _last_comment;T6 _inside_function;T6 _inside_once_function;T0* _formal_generic_list;T6 _in_ensure;T6 _in_rescue;T0* _arguments;T0* _local_vars;T6 _ok;T211 _tmp_name;T2 _last_ascii_code;T0* _last_base_class;T0* _last_base_type;T0* _last_binary;T0* _last_bit_constant;T0* _last_boolean_constant;T0* _last_character_constant;T0* _last_class_name;T0* _last_class_type;T0* _last_expression;T0* _last_feature_declaration;T0* _last_feature_name;T0* _last_feature_name_list;T0* _last_type_formal_generic;T0* _last_infix;T0* _last_prefix;T0* _last_integer_constant;T0* _last_instruction;T0* _last_index_value;T0* _last_manifest_constant;T0* _last_manifest_string;T0* _last_parent;T0* _last_real_constant;T0* _last_type;T0* _last_tag_mark;T2 _start_line;T2 _start_column;T2 _column;T2 _line;T0* _current_line;T3 _cc;T292 _tmp_feature;T6 _drop_comments;T2 _current_id;};
extern T37 M37;
struct S450{T452 _buckets;T2 _capacity;T2 _count;T2 _cache_user;T0* _cache_node;T2 _cache_buckets;};
extern T450 M450;
struct S522{Tid id;T0* _base_class_memory;T0* _run_class_memory;T104 _start_position;T0* _type_bit;T0* _run_time_mark;};
extern T522 M522;
struct S225{Tid id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T225 M225;
struct S194{T0* _list;};
extern T194 M194;
struct S520{Tid id;T447 _storage;T2 _capacity;T2 _upper;};
extern T520 M520;
struct S59{T0* _root_procedure;T6 _is_ready;T6 _short_flag;T6 _pretty_flag;T2 _magic_count;};
extern T59 M59;
struct S479{Tid id;T482 _storage;T2 _capacity;T2 _upper;};
extern T479 M479;
struct S63{Tid id;T65 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T63 M63;
struct S463{T0* _item;T2 _key;T0* _next;};
extern T463 M463;
struct S137{Tid id;T104 _start_position;T0* _value;T0* _result_type;T0* _hexa;};
extern T137 M137;
struct S502{Tid id;T505 _storage;T2 _capacity;T2 _upper;};
extern T502 M502;
struct S518{Tid id;T0* _to_key;T0* _enclosing;};
extern T518 M518;
struct S250{Tid id;T104 _start_position;T0* _run_feature;};
extern T250 M250;
struct S494{Tid id;T0* _first_one;T0* _remainder;T0* _current_type;};
extern T494 M494;
struct S262{Tid id;T104 _start_position;T0* _to_string;T0* _break;T0* _ascii;T0* _percent;T0* _mangling;};
extern T262 M262;
extern T39 M39;
extern T54 M54;
struct S72{T0* _base_class;T104 _start_position;T0* _heading_comment;T0* _list;};
extern T72 M72;
struct S398{Tid id;T401 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T398 M398;
struct S351{Tid id;T104 _start_position;T0* _writable;T0* _run_feature;T0* _current_type;T0* _type;T0* _call;};
extern T351 M351;
struct S349{Tid id;T104 _start_position;T0* _writable;T0* _run_feature;T0* _current_type;T0* _call;};
extern T349 M349;
struct S193{T104 _start_position;T0* _list;};
extern T193 M193;
struct S347{Tid id;T104 _start_position;T0* _writable;T0* _current_type;T0* _type;};
extern T347 M347;
struct S344{Tid id;T104 _start_position;T0* _writable;T0* _current_type;};
extern T344 M344;
struct S489{T491 _storage;T2 _capacity;T2 _upper;};
extern T489 M489;
struct S311{T104 _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T311 M311;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/

/*
  This file (SmallEiffel/sys/runtime/boost.h) is automatically included when
  `run_control.boost' is true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/basic_getenv.h) is automatically 
  included when the GENERAL.basic_getenv feature is used (ie. in live code).
*/

EIF_POINTER basic_getenv(EIF_POINTER name);
T6 r6_ix_not(T6 C);
T6 r6_px_and(T6 C,T6 a1);
T6 r3_px_6061(T3 C,T3 a1);
T6 r3is_digit(T3 C);
T6 r3is_separator(T3 C);
T6 r3_px_6261(T3 C,T3 a1);
T2 r3value(T3 C);
T6 r3is_letter(T3 C);
T6 r3_px_60(T3 C,T3 a1);
T6 r3same_as(T3 C,T3 a1);
T2 r3decimal_value(T3 C);
T3 r3to_upper(T3 C);
T3 r3to_lower(T3 C);
T2 r2to_octal(T2 C);
T2 r2max(T2 C,T2 a1);
T0* r2to_string(T2 C);
extern T0*oBC2tmp_string;
T2 r2min(T2 C,T2 a1);
T3 r2digit(T2 C);
T2 r2hash_code(T2 C);
void r2append_in(T2 C,T0* a1);
T2 r2_px_94(T2 C,T2 a1);
T3 r2hexadecimal_digit(T2 C);
extern T9 oBC5sprintf_double_buffer;
extern int fBC5sprintf_double_buffer;
T9 r5sprintf_double_buffer(void);
void r5append_in_format(T5 C,T0* a1,T2 a2);
T111 r111_px_646060(T111 C,T2 a1);
T111 r111_px_646262(T111 C,T2 a1);
T187 r187realloc(T187 C,T2 a1,T2 a2);
void r187clear(T187 C,T2 a1,T2 a2);
T2 r187fast_index_of(T187 C,T0* a1,T2 a2);
void r187copy_from(T187 C,T187 a1,T2 a2);
T130 r130realloc(T130 C,T2 a1,T2 a2);
void r130set_all_with(T130 C,T0* a1,T2 a2);
void r130copy_from(T130 C,T130 a1,T2 a2);
T436 r436realloc(T436 C,T2 a1,T2 a2);
void r436copy_from(T436 C,T436 a1,T2 a2);
void r296clear_all(T296 C,T2 a1);
T296 r296realloc(T296 C,T2 a1,T2 a2);
void r296clear(T296 C,T2 a1,T2 a2);
void r296copy_from(T296 C,T296 a1,T2 a2);
T335 r335realloc(T335 C,T2 a1,T2 a2);
void r335copy_from(T335 C,T335 a1,T2 a2);
void r478clear_all(T478 C,T2 a1);
T478 r478realloc(T478 C,T2 a1,T2 a2);
void r478clear(T478 C,T2 a1,T2 a2);
void r478copy_from(T478 C,T478 a1,T2 a2);
void r215clear_all(T215 C,T2 a1);
T215 r215realloc(T215 C,T2 a1,T2 a2);
void r215clear(T215 C,T2 a1,T2 a2);
void r215copy_from(T215 C,T215 a1,T2 a2);
T430 r430realloc(T430 C,T2 a1,T2 a2);
void r430copy_from(T430 C,T430 a1,T2 a2);
T415 r415realloc(T415 C,T2 a1,T2 a2);
void r415copy_from(T415 C,T415 a1,T2 a2);
T76 r76realloc(T76 C,T2 a1,T2 a2);
void r76clear(T76 C,T2 a1,T2 a2);
void r76copy_from(T76 C,T76 a1,T2 a2);
T321 r321realloc(T321 C,T2 a1,T2 a2);
void r321clear(T321 C,T2 a1,T2 a2);
void r321copy_from(T321 C,T321 a1,T2 a2);
T486 r486realloc(T486 C,T2 a1,T2 a2);
void r486move(T486 C,T2 a1,T2 a2,T2 a3);
void r486set_all_with(T486 C,T6 a1,T2 a2);
void r486clear(T486 C,T2 a1,T2 a2);
void r486copy_from(T486 C,T486 a1,T2 a2);
T460 r460realloc(T460 C,T2 a1,T2 a2);
void r460clear(T460 C,T2 a1,T2 a2);
void r460copy_from(T460 C,T460 a1,T2 a2);
void r103clear_all(T103 C,T2 a1);
T103 r103realloc(T103 C,T2 a1,T2 a2);
void r103clear(T103 C,T2 a1,T2 a2);
T2 r103fast_index_of(T103 C,T0* a1,T2 a2);
void r103copy_from(T103 C,T103 a1,T2 a2);
T158 r158realloc(T158 C,T2 a1,T2 a2);
void r158clear(T158 C,T2 a1,T2 a2);
T2 r158fast_index_of(T158 C,T0* a1,T2 a2);
void r158copy_from(T158 C,T158 a1,T2 a2);
T65 r65realloc(T65 C,T2 a1,T2 a2);
void r65clear(T65 C,T2 a1,T2 a2);
T2 r65fast_index_of(T65 C,T0* a1,T2 a2);
void r65copy_from(T65 C,T65 a1,T2 a2);
T198 r198realloc(T198 C,T2 a1,T2 a2);
void r198clear(T198 C,T2 a1,T2 a2);
void r198copy_from(T198 C,T198 a1,T2 a2);
void r330clear_all(T330 C,T2 a1);
T330 r330realloc(T330 C,T2 a1,T2 a2);
void r330clear(T330 C,T2 a1,T2 a2);
void r330copy_from(T330 C,T330 a1,T2 a2);
T424 r424realloc(T424 C,T2 a1,T2 a2);
void r424copy_from(T424 C,T424 a1,T2 a2);
T6 r53safe_equal(T0* a1,T0* a2);
T53 r53realloc(T53 C,T2 a1,T2 a2);
T2 r53index_of(T53 C,T0* a1,T2 a2);
void r53clear(T53 C,T2 a1,T2 a2);
T2 r53fast_index_of(T53 C,T0* a1,T2 a2);
void r53copy_from(T53 C,T53 a1,T2 a2);
void r439clear_all(T439 C,T2 a1);
T439 r439realloc(T439 C,T2 a1,T2 a2);
void r439clear(T439 C,T2 a1,T2 a2);
void r439copy_from(T439 C,T439 a1,T2 a2);
T509 r509realloc(T509 C,T2 a1,T2 a2);
void r509clear(T509 C,T2 a1,T2 a2);
void r509copy_from(T509 C,T509 a1,T2 a2);
T183 r183realloc(T183 C,T2 a1,T2 a2);
void r183clear(T183 C,T2 a1,T2 a2);
void r183copy_from(T183 C,T183 a1,T2 a2);
void r202clear_all(T202 C,T2 a1);
T202 r202realloc(T202 C,T2 a1,T2 a2);
void r202clear(T202 C,T2 a1,T2 a2);
T2 r202fast_index_of(T202 C,T0* a1,T2 a2);
void r202copy_from(T202 C,T202 a1,T2 a2);
T401 r401realloc(T401 C,T2 a1,T2 a2);
void r401copy_from(T401 C,T401 a1,T2 a2);
T149 r149realloc(T149 C,T2 a1,T2 a2);
void r149set_all_with(T149 C,T0* a1,T2 a2);
void r149copy_from(T149 C,T149 a1,T2 a2);
T192 r192realloc(T192 C,T2 a1,T2 a2);
void r192clear(T192 C,T2 a1,T2 a2);
void r192copy_from(T192 C,T192 a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
void r9move(T9 C,T2 a1,T2 a2,T2 a3);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
void r9clear(T9 C,T2 a1,T2 a2);
T2 r9fast_nb_occurrences(T9 C,T3 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
void r305clear_all(T305 C,T2 a1);
T305 r305realloc(T305 C,T2 a1,T2 a2);
void r305clear(T305 C,T2 a1,T2 a2);
void r305copy_from(T305 C,T305 a1,T2 a2);
T378 r378realloc(T378 C,T2 a1,T2 a2);
void r378copy_from(T378 C,T378 a1,T2 a2);
T94 r94realloc(T94 C,T2 a1,T2 a2);
void r94clear(T94 C,T2 a1,T2 a2);
void r94copy_from(T94 C,T94 a1,T2 a2);
T491 r491realloc(T491 C,T2 a1,T2 a2);
void r491clear(T491 C,T2 a1,T2 a2);
void r491copy_from(T491 C,T491 a1,T2 a2);
T210 r210realloc(T210 C,T2 a1,T2 a2);
void r210set_all_with(T210 C,T0* a1,T2 a2);
T2 r210fast_index_of(T210 C,T0* a1,T2 a2);
void r210copy_from(T210 C,T210 a1,T2 a2);
T177 r177realloc(T177 C,T2 a1,T2 a2);
void r177clear(T177 C,T2 a1,T2 a2);
void r177copy_from(T177 C,T177 a1,T2 a2);
T456 r456realloc(T456 C,T2 a1,T2 a2);
void r456clear(T456 C,T2 a1,T2 a2);
void r456copy_from(T456 C,T456 a1,T2 a2);
T505 r505realloc(T505 C,T2 a1,T2 a2);
void r505clear(T505 C,T2 a1,T2 a2);
T2 r505fast_index_of(T505 C,T0* a1,T2 a2);
void r505copy_from(T505 C,T505 a1,T2 a2);
T482 r482realloc(T482 C,T2 a1,T2 a2);
void r482clear(T482 C,T2 a1,T2 a2);
T2 r482fast_index_of(T482 C,T0* a1,T2 a2);
void r482copy_from(T482 C,T482 a1,T2 a2);
T447 r447realloc(T447 C,T2 a1,T2 a2);
void r447clear(T447 C,T2 a1,T2 a2);
T2 r447fast_index_of(T447 C,T0* a1,T2 a2);
void r447copy_from(T447 C,T447 a1,T2 a2);
void r469clear_all(T469 C,T2 a1);
T469 r469realloc(T469 C,T2 a1,T2 a2);
void r469clear(T469 C,T2 a1,T2 a2);
T2 r469fast_index_of(T469 C,T0* a1,T2 a2);
void r469copy_from(T469 C,T469 a1,T2 a2);
T497 r497realloc(T497 C,T2 a1,T2 a2);
void r497clear(T497 C,T2 a1,T2 a2);
void r497copy_from(T497 C,T497 a1,T2 a2);
T108 r108realloc(T108 C,T2 a1,T2 a2);
void r108clear(T108 C,T2 a1,T2 a2);
T2 r108fast_index_of(T108 C,T104 a1,T2 a2);
void r108copy_from(T108 C,T108 a1,T2 a2);
T274 r274realloc(T274 C,T2 a1,T2 a2);
void r274set_all_with(T274 C,T0* a1,T2 a2);
void r274copy_from(T274 C,T274 a1,T2 a2);
T135 r135realloc(T135 C,T2 a1,T2 a2);
void r135move(T135 C,T2 a1,T2 a2,T2 a3);
void r135set_all_with(T135 C,T2 a1,T2 a2);
void r135clear(T135 C,T2 a1,T2 a2);
void r135copy_from(T135 C,T135 a1,T2 a2);
void r163clear_all(T163 C,T2 a1);
T163 r163realloc(T163 C,T2 a1,T2 a2);
void r163clear(T163 C,T2 a1,T2 a2);
void r163copy_from(T163 C,T163 a1,T2 a2);
T290 r290realloc(T290 C,T2 a1,T2 a2);
void r290clear(T290 C,T2 a1,T2 a2);
void r290copy_from(T290 C,T290 a1,T2 a2);
void r7copy(T7* C,T0* a1);
void r7remove_first(T7* C,T2 a1);
T3 r7last(T7* C);
void r7remove_between(T7* C,T2 a1,T2 a2);
T6 r7is_equal(T7* C,T0* a1);
extern T0*oBC7split_buffer;
T0* r7split(T7* C);
void r7prepend(T7* C,T0* a1);
void r7append(T7* C,T0* a1);
T6 r7has_string(T7* C,T0* a1);
extern T0*oBC7tmp_string;
T6 r7has_suffix(T7* C,T0* a1);
void r7reverse(T7* C);
void r7make(T7* C,T2 a1);
T6 r7has_prefix(T7* C,T0* a1);
void r7head(T7* C,T2 a1);
void r7add_first(T7* C,T3 a1);
T0* r7_px_43(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T2 r7hash_code(T7* C);
void r7to_hexadecimal(T7* C);
void r7remove_last(T7* C,T2 a1);
T6 r7_px_60(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
T2 r7to_integer(T7* C);
T6 r7same_as(T7* C,T0* a1);
void r7extend_unless(T7* C,T3 a1);
void r7resize(T7* C,T2 a1);
void r7to_upper(T7* C);
T2 r7index_of_string(T7* C,T0* a1);
T2 r7substring_index(T7* C,T0* a1,T2 a2);
void r7from_external_copy(T7* C,T8 a1);
T8 r7to_external(T7* C);
void r7to_lower(T7* C);
T0* r7twin(T7* C);
T2 r7nb_occurrences(T7* C,T3 a1);
void r7split_in(T7* C,T0* a1);
void r7swap(T7* C,T2 a1,T2 a2);
T2 r375count(T375* C);
T0* r375item(T375* C,T2 a1);
void r375add_last(T375* C,T0* a1);
void r375with_capacity(T375* C,T2 a1,T2 a2);
void r199copy(T199* C,T0* a1);
T2 r199count(T199* C);
T0* r199item(T199* C,T2 a1);
T6 r199valid_index(T199* C,T2 a1);
T6 r199is_empty(T199* C);
T6 r199fast_has(T199* C,T0* a1);
void r199add_last(T199* C,T0* a1);
T2 r199fast_index_of(T199* C,T0* a1);
T0* r199twin(T199* C);
void r199with_capacity(T199* C,T2 a1);
void r302copy(T302* C,T0* a1);
void r302make(T302* C,T2 a1);
void r302add_last(T302* C,T0* a1);
void r302resize(T302* C,T2 a1);
T0* r302twin(T302* C);
void r302with_capacity(T302* C,T2 a1);
T2 r428count(T428* C);
T0* r428item(T428* C,T2 a1);
void r428add_last(T428* C,T0* a1);
void r428with_capacity(T428* C,T2 a1,T2 a2);
void r428swap(T428* C,T2 a1,T2 a2);
void r161copy(T161* C,T0* a1);
void r161add_last(T161* C,T0* a1);
T0* r161twin(T161* C);
void r161with_capacity(T161* C,T2 a1);
T0* r74last(T74* C);
void r74remove_last(T74* C);
void r74add_last(T74* C,T0* a1);
void r74with_capacity(T74* C,T2 a1);
void r319add_last(T319* C,T0* a1);
void r319with_capacity(T319* C,T2 a1);
T2 r263count(T263* C);
T2 r263item(T263* C,T2 a1);
void r263make(T263* C,T2 a1,T2 a2);
void r263add_last(T263* C,T2 a1);
void r263resize(T263* C,T2 a1,T2 a2);
void r263with_capacity(T263* C,T2 a1,T2 a2);
void r128copy(T128* C,T0* a1);
T2 r128count(T128* C);
T0* r128item(T128* C,T2 a1);
void r128make(T128* C,T2 a1,T2 a2);
void r128add_last(T128* C,T0* a1);
T0* r128twin(T128* C);
void r128with_capacity(T128* C,T2 a1,T2 a2);
void r333copy(T333* C,T0* a1);
T2 r333count(T333* C);
T0* r333item(T333* C,T2 a1);
void r333add_last(T333* C,T0* a1);
T0* r333twin(T333* C);
void r333with_capacity(T333* C,T2 a1,T2 a2);
void r196add_last(T196* C,T0* a1);
void r196with_capacity(T196* C,T2 a1);
void r288add_last(T288* C,T0* a1);
void r288with_capacity(T288* C,T2 a1);
void r100copy(T100* C,T0* a1);
T6 r100valid_index(T100* C,T2 a1);
T6 r100fast_has(T100* C,T0* a1);
void r100add_last(T100* C,T0* a1);
T2 r100fast_index_of(T100* C,T0* a1);
T0* r100twin(T100* C);
void r100with_capacity(T100* C,T2 a1);
T6 r67valid_index(T67* C,T2 a1);
T6 r67fast_has(T67* C,T0* a1);
void r67add_last(T67* C,T0* a1);
T2 r67fast_index_of(T67* C,T0* a1);
void r67with_capacity(T67* C,T2 a1);
T6 r184valid_index(T184* C,T2 a1);
T6 r184fast_has(T184* C,T0* a1);
void r184add_last(T184* C,T0* a1);
T2 r184fast_index_of(T184* C,T0* a1);
void r184with_capacity(T184* C,T2 a1);
void r475copy(T475* C,T0* a1);
void r475make(T475* C,T2 a1);
void r475add_last(T475* C,T0* a1);
void r475resize(T475* C,T2 a1);
T0* r475twin(T475* C);
void r475with_capacity(T475* C,T2 a1);
void r92add_last(T92* C,T0* a1);
void r92with_capacity(T92* C,T2 a1);
void r493add_last(T493* C,T0* a1);
void r493with_capacity(T493* C,T2 a1);
void r212copy(T212* C,T0* a1);
T2 r212count(T212* C);
T0* r212item(T212* C,T2 a1);
void r212make(T212* C,T2 a1);
void r212add_last(T212* C,T0* a1);
void r212resize(T212* C,T2 a1);
T0* r212twin(T212* C);
void r212with_capacity(T212* C,T2 a1);
T2 r412count(T412* C);
T0* r412item(T412* C,T2 a1);
void r412add_last(T412* C,T0* a1);
void r412with_capacity(T412* C,T2 a1,T2 a2);
void r328copy(T328* C,T0* a1);
void r328add_last(T328* C,T0* a1);
T0* r328twin(T328* C);
void r328with_capacity(T328* C,T2 a1);
T2 r422count(T422* C);
void r422add_last(T422* C,T0* a1);
void r422with_capacity(T422* C,T2 a1,T2 a2);
void r483force(T483* C,T6 a1,T2 a2);
T2 r483count(T483* C);
T6 r483item(T483* C,T2 a1);
void r483make(T483* C,T2 a1,T2 a2);
void r483add_last(T483* C,T6 a1);
void r483resize(T483* C,T2 a1,T2 a2);
T6 r105valid_index(T105* C,T2 a1);
T6 r105fast_has(T105* C,T104 a1);
void r105add_last(T105* C,T104 a1);
T2 r105fast_index_of(T105* C,T104 a1);
void r105with_capacity(T105* C,T2 a1);
T6 r120valid_index(T120* C,T2 a1);
T2 r120index_of(T120* C,T0* a1);
void r120make(T120* C,T2 a1);
T6 r120has(T120* C,T0* a1);
T6 r120fast_has(T120* C,T0* a1);
void r120add_last(T120* C,T0* a1);
void r120resize(T120* C,T2 a1);
T2 r120fast_index_of(T120* C,T0* a1);
void r120with_capacity(T120* C,T2 a1);
void r507add_last(T507* C,T0* a1);
void r507with_capacity(T507* C,T2 a1);
void r204copy(T204* C,T0* a1);
T2 r204count(T204* C);
T0* r204item(T204* C,T2 a1);
T6 r204valid_index(T204* C,T2 a1);
void r204make(T204* C,T2 a1,T2 a2);
T6 r204is_empty(T204* C);
T6 r204fast_has(T204* C,T0* a1);
void r204add_last(T204* C,T0* a1);
void r204clear(T204* C);
T2 r204fast_index_of(T204* C,T0* a1);
T0* r204twin(T204* C);
void r204with_capacity(T204* C,T2 a1,T2 a2);
T0* r155last(T155* C);
T2 r155count(T155* C);
T0* r155item(T155* C,T2 a1);
T6 r155valid_index(T155* C,T2 a1);
void r155make(T155* C,T2 a1);
void r155remove_last(T155* C);
T6 r155fast_has(T155* C,T0* a1);
void r155add_last(T155* C,T0* a1);
void r155resize(T155* C,T2 a1);
T2 r155fast_index_of(T155* C,T0* a1);
void r155with_capacity(T155* C,T2 a1);
T2 r433count(T433* C);
T0* r433item(T433* C,T2 a1);
void r433add_last(T433* C,T0* a1);
void r433with_capacity(T433* C,T2 a1,T2 a2);
void r466copy(T466* C,T0* a1);
T6 r466valid_index(T466* C,T2 a1);
T6 r466fast_has(T466* C,T0* a1);
void r466add_last(T466* C,T0* a1);
T2 r466fast_index_of(T466* C,T0* a1);
T0* r466twin(T466* C);
void r466with_capacity(T466* C,T2 a1);
void r294copy(T294* C,T0* a1);
void r294make(T294* C,T2 a1);
void r294add_last(T294* C,T0* a1);
void r294resize(T294* C,T2 a1);
T0* r294twin(T294* C);
void r294with_capacity(T294* C,T2 a1);
void r453make(T453* C,T2 a1);
void r453resize(T453* C,T2 a1);
void r138copy(T138* C,T0* a1);
void r138make(T138* C,T2 a1);
void r138add_last(T138* C,T0* a1);
void r138resize(T138* C,T2 a1);
T0* r138twin(T138* C);
void r138with_capacity(T138* C,T2 a1);
void r272copy(T272* C,T0* a1);
T2 r272count(T272* C);
T0* r272item(T272* C,T2 a1);
void r272make(T272* C,T2 a1,T2 a2);
void r272add_last(T272* C,T0* a1);
T0* r272twin(T272* C);
void r272with_capacity(T272* C,T2 a1,T2 a2);
void r132make(T132* C,T2 a1);
void r132resize(T132* C,T2 a1);
void r147copy(T147* C,T0* a1);
T2 r147count(T147* C);
T0* r147item(T147* C,T2 a1);
void r147make(T147* C,T2 a1,T2 a2);
void r147add_last(T147* C,T0* a1);
T0* r147twin(T147* C);
void r147with_capacity(T147* C,T2 a1,T2 a2);
T2 r445count(T445* C);
T0* r445item(T445* C,T2 a1);
void r445add_last(T445* C,T0* a1);
void r445with_capacity(T445* C,T2 a1,T2 a2);
void r445swap(T445* C,T2 a1,T2 a2);
void r52copy(T52* C,T0* a1);
T2 r52count(T52* C);
T0* r52item(T52* C,T2 a1);
T6 r52valid_index(T52* C,T2 a1);
T2 r52index_of(T52* C,T0* a1);
T6 r52is_empty(T52* C);
T6 r52fast_has(T52* C,T0* a1);
void r52add_last(T52* C,T0* a1);
void r52clear(T52* C);
T2 r52fast_index_of(T52* C,T0* a1);
T0* r52twin(T52* C);
void r52with_capacity(T52* C,T2 a1,T2 a2);
void r457make(T457* C,T2 a1);
void r457resize(T457* C,T2 a1);
void r181add_last(T181* C,T0* a1);
void r181with_capacity(T181* C,T2 a1);
void r190add_last(T190* C,T0* a1);
void r190with_capacity(T190* C,T2 a1);
void r175make(T175* C,T2 a1);
void r175add_last(T175* C,T0* a1);
void r175with_capacity(T175* C,T2 a1);
T0* r520last(T520* C);
T6 r520valid_index(T520* C,T2 a1);
void r520make(T520* C,T2 a1);
void r520remove_last(T520* C);
T6 r520fast_has(T520* C,T0* a1);
void r520add_last(T520* C,T0* a1);
void r520resize(T520* C,T2 a1);
T2 r520fast_index_of(T520* C,T0* a1);
void r520with_capacity(T520* C,T2 a1);
T0* r479last(T479* C);
T6 r479valid_index(T479* C,T2 a1);
void r479make(T479* C,T2 a1);
void r479remove_last(T479* C);
T6 r479fast_has(T479* C,T0* a1);
void r479add_last(T479* C,T0* a1);
void r479resize(T479* C,T2 a1);
T2 r479fast_index_of(T479* C,T0* a1);
void r479with_capacity(T479* C,T2 a1);
void r63copy(T63* C,T0* a1);
T2 r63count(T63* C);
T0* r63item(T63* C,T2 a1);
T6 r63valid_index(T63* C,T2 a1);
T6 r63fast_has(T63* C,T0* a1);
void r63add_last(T63* C,T0* a1);
T2 r63fast_index_of(T63* C,T0* a1);
void r63with_capacity(T63* C,T2 a1,T2 a2);
void r63swap(T63* C,T2 a1,T2 a2);
T0* r502last(T502* C);
T6 r502valid_index(T502* C,T2 a1);
void r502make(T502* C,T2 a1);
void r502remove_last(T502* C);
T6 r502fast_has(T502* C,T0* a1);
void r502add_last(T502* C,T0* a1);
void r502resize(T502* C,T2 a1);
T2 r502fast_index_of(T502* C,T0* a1);
void r502with_capacity(T502* C,T2 a1);
T2 r398count(T398* C);
T0* r398item(T398* C,T2 a1);
void r398add_last(T398* C,T0* a1);
void r398with_capacity(T398* C,T2 a1,T2 a2);
void r489add_last(T489* C,T0* a1);
void r489with_capacity(T489* C,T2 a1);
T0* r45key(T45* C,T2 a1);
T2 r45at(T45* C,T0* a1);
void r45put(T45* C,T2 a1,T0* a2);
T0* r45fast_key_at(T45* C,T2 a1);
T2 r45item(T45* C,T2 a1);
void r45set_cache_user(T45* C,T2 a1);
void r45increase_capacity(T45* C);
T6 r45has(T45* C,T0* a1);
void r45with_capacity(T45* C,T2 a1);
T2 r45prime_number_for(T2 a1);
void r70make(T70* C,T0* a1,T0* a2,T0* a3);
void r442make(T442* C,T0* a1,T0* a2,T0* a3);
T0* r144at(T144* C,T0* a1);
void r144put(T144* C,T0* a1,T0* a2);
T0* r144item(T144* C,T2 a1);
void r144set_cache_user(T144* C,T2 a1);
void r144remove(T144* C,T0* a1);
void r144increase_capacity(T144* C);
T6 r144has(T144* C,T0* a1);
void r144add(T144* C,T0* a1,T0* a2);
void r144with_capacity(T144* C,T2 a1);
T2 r144prime_number_for(T2 a1);
T0* r441key(T441* C,T2 a1);
T0* r441at(T441* C,T0* a1);
void r441put(T441* C,T0* a1,T0* a2);
T0* r441item(T441* C,T2 a1);
void r441set_cache_user(T441* C,T2 a1);
void r441increase_capacity(T441* C);
T6 r441has(T441* C,T0* a1);
void r441with_capacity(T441* C,T2 a1);
T2 r441prime_number_for(T2 a1);
T0* r69at(T69* C,T0* a1);
void r69put(T69* C,T0* a1,T0* a2);
T0* r69item(T69* C,T2 a1);
void r69set_cache_user(T69* C,T2 a1);
void r69increase_capacity(T69* C);
T6 r69has(T69* C,T0* a1);
void r69item_map_in(T69* C,T0* a1);
void r69with_capacity(T69* C,T2 a1);
T2 r69prime_number_for(T2 a1);
void r498put(T498* C,T0* a1,T0* a2);
void r498make(T498* C);
void r498increase_capacity(T498* C);
void r498with_capacity(T498* C,T2 a1);
T2 r498prime_number_for(T2 a1);
void r451make(T451* C,T0* a1,T0* a2,T0* a3);
void r173make(T173* C,T0* a1,T0* a2,T0* a3);
void r35make(T35* C,T0* a1,T0* a2,T0* a3);
T0* r172at(T172* C,T0* a1);
void r172increase_capacity(T172* C);
T6 r172has(T172* C,T0* a1);
void r172add(T172* C,T0* a1,T0* a2);
void r172with_capacity(T172* C,T2 a1);
T2 r172prime_number_for(T2 a1);
void r471put(T471* C,T0* a1,T0* a2);
T0* r471item(T471* C,T2 a1);
void r471set_cache_user(T471* C,T2 a1);
void r471remove(T471* C,T0* a1);
void r471increase_capacity(T471* C);
T6 r471has(T471* C,T0* a1);
void r471with_capacity(T471* C,T2 a1);
T2 r471prime_number_for(T2 a1);
void r472make(T472* C,T0* a1,T0* a2,T0* a3);
void r462put(T462* C,T0* a1,T2 a2);
T0* r462item(T462* C,T2 a1);
void r462set_cache_user(T462* C,T2 a1);
void r462increase_capacity(T462* C);
T6 r462has(T462* C,T2 a1);
void r462with_capacity(T462* C,T2 a1);
T2 r462prime_number_for(T2 a1);
void r499make(T499* C,T0* a1,T0* a2,T0* a3);
void r80make(T80* C,T0* a1,T0* a2,T0* a3);
T0* r30at(T30* C,T0* a1);
void r30put(T30* C,T0* a1,T0* a2);
void r30increase_capacity(T30* C);
T6 r30has(T30* C,T0* a1);
void r30add(T30* C,T0* a1,T0* a2);
void r30with_capacity(T30* C,T2 a1);
T2 r30prime_number_for(T2 a1);
T0* r79at(T79* C,T0* a1);
void r79put(T79* C,T0* a1,T0* a2);
T0* r79item(T79* C,T2 a1);
void r79set_cache_user(T79* C,T2 a1);
void r79increase_capacity(T79* C);
T6 r79has(T79* C,T0* a1);
void r79with_capacity(T79* C,T2 a1);
T2 r79prime_number_for(T2 a1);
void r46make(T46* C,T2 a1,T0* a2,T0* a3);
void r145make(T145* C,T0* a1,T0* a2,T0* a3);
T0* r450at(T450* C,T0* a1);
void r450put(T450* C,T0* a1,T0* a2);
T0* r450item(T450* C,T2 a1);
void r450set_cache_user(T450* C,T2 a1);
void r450increase_capacity(T450* C);
T6 r450has(T450* C,T0* a1);
void r450with_capacity(T450* C,T2 a1);
T2 r450prime_number_for(T2 a1);
void r463make(T463* C,T0* a1,T2 a2,T0* a3);
void r200vape_check(T200* C,T104 a1,T0* a2);
T6 r200gives_permission_to(T200* C,T0* a1);
extern T0*oBC19eh;
T0* r200append(T200* C,T0* a1);
extern T0*oBC19small_eiffel;
void r200merge(T200* C,T104 a1,T0* a2,T0* a3);
void r200gives_permission_error(T200* C,T6 a1,T0* a2);
void r200make(T200* C,T104 a1,T0* a2);
T6 r200gives_permission_to_any(T200* C);
T6 r200is_omitted(T200* C);
T0* r200merge_with(T200* C,T0* a1);
T6 r143can_be_dropped(T143* C);
void r143error(T104 a1,T0* a2);
void r143with(T143* C,T0* a1,T0* a2);
extern T0*oBC19cpp;
void r143compile_to_c(T143* C);
T6 r143stupid_switch(T143* C,T0* a1);
void r143make(T143* C,T0* a1,T104 a2);
void r143fatal_error(T0* a1);
void r143to_integer_error(T143* C);
void r143undefine_in(T143* C,T0* a1);
T0* r143run_feature(T143* C,T0* a1);
void r143mapping_c_target(T143* C,T0* a1);
T2 r143to_integer_or_error(T143* C);
T0* r143add_comment(T143* C,T0* a1);
T0* r143to_runnable(T143* C,T0* a1);
T0* r143origin_base_class(T143* C);
T0* r143static_result_base_class(T143* C);
extern T432 oBC19switch_collection;
void r223run_feature_match(T223* C,T0* a1);
T0* r223runnable_expression(T0* a1,T0* a2);
T6 r223call_proc_call_stupid_switch(T223* C,T0* a1);
T6 r223is_static(T223* C);
T0* r223operator(void);
void r223with(T223* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r223run_feature_has_result(T223* C);
T6 r223stupid_switch(T223* C,T0* a1);
void r223make(T223* C,T0* a1,T104 a2,T0* a3);
void r223fatal_error(T0* a1);
void r223to_integer_error(T223* C);
T0* r223arg1(T223* C);
void r223assertion_check(T223* C,T3 a1);
T0* r223result_type(T223* C);
void r223afd_check(T223* C);
T6 r223use_current(T223* C);
extern T0*oBC19conversion_handler;
void r223c_declare_for_old(T223* C);
void r223compile_to_c_old(T223* C);
T0* r223runnable_args(T0* a1,T0* a2);
void r223mapping_c_target(T223* C,T0* a1);
T0* r223run_feature_for(T223* C,T0* a1,T0* a2);
T2 r223to_integer_or_error(T223* C);
T0* r223add_comment(T223* C,T0* a1);
T0* r223to_runnable(T223* C,T0* a1);
void r223collect_c_tmp(T223* C);
void r223finalize(T223* C);
T0* r223static_result_base_class(T223* C);
void r234run_feature_match(T234* C,T0* a1);
T0* r234runnable_expression(T0* a1,T0* a2);
T6 r234call_is_static(T234* C);
T6 r234call_proc_call_stupid_switch(T234* C,T0* a1);
void r234with(T234* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r234run_feature_has_result(T234* C);
T6 r234stupid_switch(T234* C,T0* a1);
void r234make(T234* C,T0* a1,T0* a2,T0* a3);
void r234fatal_error(T0* a1);
void r234to_integer_error(T234* C);
T0* r234arg1(T234* C);
void r234assertion_check(T234* C,T3 a1);
T0* r234result_type(T234* C);
void r234afd_check(T234* C);
T6 r234use_current(T234* C);
void r234c_declare_for_old(T234* C);
void r234compile_to_c_old(T234* C);
T0* r234runnable_args(T0* a1,T0* a2);
void r234mapping_c_target(T234* C,T0* a1);
T0* r234run_feature_for(T234* C,T0* a1,T0* a2);
T2 r234to_integer_or_error(T234* C);
T0* r234add_comment(T234* C,T0* a1);
T0* r234to_runnable(T234* C,T0* a1);
void r234collect_c_tmp(T234* C);
void r234finalize(T234* C);
T0* r234static_result_base_class(T234* C);
void r427clear_run_feature(T427* C);
void r427compile_to_c(T427* C);
void r427make(T427* C,T0* a1);
void r427afd_check(T427* C);
T6 r427use_current(T427* C);
void r427add(T427* C,T0* a1);
void r228run_feature_match(T228* C,T0* a1);
T0* r228runnable_expression(T0* a1,T0* a2);
T6 r228call_proc_call_stupid_switch(T228* C,T0* a1);
T6 r228is_static(T228* C);
T0* r228operator(void);
void r228with(T228* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r228run_feature_has_result(T228* C);
T6 r228stupid_switch(T228* C,T0* a1);
void r228make(T228* C,T0* a1,T104 a2,T0* a3);
void r228fatal_error(T0* a1);
void r228to_integer_error(T228* C);
T2 r228isa_dca_inline_argument(T228* C);
void r228dca_inline_argument(T228* C,T0* a1);
T0* r228arg1(T228* C);
void r228assertion_check(T228* C,T3 a1);
T0* r228result_type(T228* C);
void r228afd_check(T228* C);
T6 r228use_current(T228* C);
void r228c_declare_for_old(T228* C);
void r228compile_to_c_old(T228* C);
T0* r228runnable_args(T0* a1,T0* a2);
void r228mapping_c_target(T228* C,T0* a1);
T0* r228run_feature_for(T228* C,T0* a1,T0* a2);
T2 r228to_integer_or_error(T228* C);
T0* r228add_comment(T228* C,T0* a1);
T0* r228to_runnable(T228* C,T0* a1);
void r228collect_c_tmp(T228* C);
void r228finalize(T228* C);
T0* r228static_result_base_class(T228* C);
T0* r308try_to_undefine_aux(T308* C,T0* a1,T0* a2);
void r308error(T104 a1,T0* a2);
T6 r308can_hide(T308* C,T0* a1,T0* a2);
void r308merge_header_comments(T308* C,T0* a1);
void r308add_into(T308* C,T0* a1);
T0* r308try_to_undefine(T308* C,T0* a1,T0* a2);
void r308make(T308* C,T0* a1,T0* a2,T0* a3);
void r308check_obsolete(T308* C,T104 a1);
T0* r308to_run_feature(T308* C,T0* a1,T0* a2);
T6 r308is_not_mergeable_with(T308* C,T0* a1);
T104 r308start_position(T308* C);
void r407make(T407* C,T0* a1,T0* a2);
void r407append_in(T407* C,T0* a1);
void r426require_start(T426* C);
void r426error(T104 a1,T0* a2);
T0* r426invariant_end(T426* C,T0* a1);
void r426invariant_start(T426* C);
void r426assertion_add_last(T426* C,T0* a1);
extern T0*oBC426collector;
T0* r426require_end(T426* C,T0* a1,T0* a2);
T0* r426runnable(T0* a1,T0* a2,T0* a3,T3 a4);
void r426invariant_add_last(T426* C,T0* a1);
void r426ensure_start(T426* C);
T0* r426ensure_end(T426* C,T0* a1,T0* a2);
extern T0*oBC19type_any;
extern int fBC19type_any;
T0* r488type_any(void);
extern T0*oBC19eiffel_parser;
extern T0*oBC19cecil_pool;
void r488fatal_error(T0* a1);
extern T0*oBC19echo;
void r488afd_check(T488* C);
void r488parse(T488* C);
void r488c_define_users(T488* C);
extern T0*oBC91body;
T2 r89parse_include(T89* C,T2 a1,T0* a2);
extern T0*oBC90buffer;
void r89c_plus_plus_function_definition(T89* C,T0* a1);
void r89c_define_function(T89* C,T0* a1,T0* a2,T0* a3);
void r89c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r89parse_external(T89* C,T2 a1,T0* a2,T0* a3);
extern T0*oBC89external_routine_memory;
void r89standard_c_define_function(T0* a1,T0* a2,T0* a3);
void r89standard_c_define_procedure(T0* a1,T0* a2,T0* a3);
void r89c_define_procedure(T89* C,T0* a1,T0* a2,T0* a3);
void r89c_mapping_external(T0* a1,T2 a2);
void r89c_plus_plus_definition(T89* C);
extern T0*oBC19run_control;
void r89wrapped_external_call(T0* a1,T2 a2);
T2 r89parse_args(T89* C,T2 a1,T0* a2,T2 a3,T2 a4);
extern T0*oBC89include_memory;
void r89c_mapping_function(T0* a1,T0* a2,T0* a3);
T2 r89parse_cpp_class(T89* C,T2 a1,T0* a2);
void r89c_plus_plus_procedure_definition(T89* C,T0* a1);
T2 r89error_at(T89* C,T2 a1,T0* a2,T2 a3);
void r387c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r387standard_c_define_function(T0* a1,T0* a2,T0* a3);
void r387standard_c_define_procedure(T0* a1,T0* a2,T0* a3);
void r387c_mapping_external(T0* a1,T2 a2);
void r387wrapped_external_call(T0* a1,T2 a2);
void r387c_mapping_function(T0* a1,T0* a2,T0* a3);
void r338error(T104 a1,T0* a2);
void r338make(T338* C,T0* a1,T0* a2);
T0* r338to_runnable_character(T338* C,T0* a1);
T0* r338to_runnable_integer(T338* C,T0* a1);
T0* r338twin(T338* C);
T104 r338start_position(T338* C);
void r337error(T104 a1,T0* a2);
T0* r337to_runnable_character(T337* C,T0* a1);
T0* r337to_runnable_integer(T337* C,T0* a1);
T0* r337twin(T337* C);
T104 r337start_position(T337* C);
void r179check_expanded_with(T179* C,T0* a1);
void r179make(T179* C,T0* a1);
void r179fatal_error(T0* a1);
T0* r179expanded_initializer(T179* C,T0* a1);
T0* r179root_procedure_name(T179* C,T0* a1);
T0* r179get_clause(T179* C,T0* a1);
T104 r179start_position(T179* C);
void r312compile_to_c(T312* C);
void r312make(T312* C,T104 a1,T0* a2,T0* a3);
void r312afd_check(T312* C);
T6 r312use_current(T312* C);
T0* r312add_comment(T312* C,T0* a1);
T0* r312to_runnable(T312* C,T0* a1);
void r247run_feature_match(T247* C,T0* a1);
T0* r247runnable_expression(T0* a1,T0* a2);
T6 r247call_proc_call_stupid_switch(T247* C,T0* a1);
T6 r247is_static(T247* C);
void r247with(T247* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r247run_feature_has_result(T247* C);
T6 r247stupid_switch(T247* C,T0* a1);
void r247make(T247* C,T0* a1,T0* a2,T0* a3);
void r247fatal_error(T0* a1);
void r247to_integer_error(T247* C);
T0* r247arg1(T247* C);
void r247assertion_check(T247* C,T3 a1);
T0* r247result_type(T247* C);
void r247afd_check(T247* C);
T6 r247use_current(T247* C);
T2 r247static_value(T247* C);
void r247c_declare_for_old(T247* C);
void r247compile_to_c_old(T247* C);
T0* r247runnable_args(T0* a1,T0* a2);
void r247mapping_c_target(T247* C,T0* a1);
T0* r247run_feature_for(T247* C,T0* a1,T0* a2);
T2 r247to_integer_or_error(T247* C);
T0* r247add_comment(T247* C,T0* a1);
T0* r247to_runnable(T247* C,T0* a1);
void r247collect_c_tmp(T247* C);
void r247finalize(T247* C);
T0* r247static_result_base_class(T247* C);
T104 r247start_position(T247* C);
void r246run_feature_match(T246* C);
T6 r246can_be_dropped(T246* C);
T0* r246runnable_expression(T0* a1,T0* a2);
T6 r246call_proc_call_stupid_switch(T246* C,T0* a1);
T6 r246is_static(T246* C);
void r246with(T246* C,T0* a1,T0* a2,T0* a3);
void r246run_feature_has_result(T246* C);
void r246compile_to_c(T246* C);
T6 r246stupid_switch(T246* C,T0* a1);
void r246make(T246* C,T0* a1,T0* a2);
void r246fatal_error(T0* a1);
void r246to_integer_error(T246* C);
void r246assertion_check(T246* C,T3 a1);
T0* r246result_type(T246* C);
void r246afd_check(T246* C);
T6 r246use_current(T246* C);
T2 r246static_value(T246* C);
void r246c_declare_for_old(T246* C);
void r246compile_to_c_old(T246* C);
void r246mapping_c_target(T246* C,T0* a1);
T0* r246run_feature_for(T246* C,T0* a1,T0* a2);
T2 r246to_integer_or_error(T246* C);
T6 r246is_pre_computable(T246* C);
T0* r246add_comment(T246* C,T0* a1);
T0* r246to_runnable(T246* C,T0* a1);
void r246collect_c_tmp(T246* C);
void r246finalize(T246* C);
T0* r246static_result_base_class(T246* C);
T104 r246start_position(T246* C);
void r324compile_to_c(T324* C);
T0* r324add_comment(T324* C,T0* a1);
T0* r324to_runnable(T324* C,T0* a1);
void r180check_expanded_with(T180* C,T0* a1);
void r180make(T180* C,T104 a1,T0* a2,T0* a3,T0* a4);
void r180fatal_error(T0* a1);
T6 r180has(T180* C,T0* a1);
T0* r180expanded_initializer(T180* C,T0* a1);
T0* r180root_procedure_name(T180* C,T0* a1);
void r227run_feature_match(T227* C,T0* a1);
T0* r227runnable_expression(T0* a1,T0* a2);
T6 r227call_proc_call_stupid_switch(T227* C,T0* a1);
T6 r227is_static(T227* C);
T0* r227operator(void);
void r227with(T227* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r227run_feature_has_result(T227* C);
T6 r227stupid_switch(T227* C,T0* a1);
void r227make(T227* C,T0* a1,T104 a2,T0* a3);
void r227fatal_error(T0* a1);
void r227to_integer_error(T227* C);
T0* r227arg1(T227* C);
void r227assertion_check(T227* C,T3 a1);
T0* r227result_type(T227* C);
void r227afd_check(T227* C);
T6 r227use_current(T227* C);
void r227c_declare_for_old(T227* C);
void r227compile_to_c_old(T227* C);
T0* r227runnable_args(T0* a1,T0* a2);
void r227mapping_c_target(T227* C,T0* a1);
T0* r227run_feature_for(T227* C,T0* a1,T0* a2);
T2 r227to_integer_or_error(T227* C);
T0* r227add_comment(T227* C,T0* a1);
T0* r227to_runnable(T227* C,T0* a1);
void r227collect_c_tmp(T227* C);
void r227finalize(T227* C);
T0* r227static_result_base_class(T227* C);
void r266error(T104 a1,T0* a2);
void r266compile_to_c(T266* C);
void r266make(T266* C,T104 a1,T0* a2,T0* a3);
void r266fatal_error(T0* a1);
void r266to_integer_error(T266* C);
T0* r266result_type(T266* C);
T0* r266super_feature(T266* C,T0* a1);
void r266afd_check(T266* C);
void r266prepare_arguments(T266* C,T0* a1);
T0* r266precursor_name(T0* a1,T0* a2);
void r266c_declare_for_old(T266* C);
void r266compile_to_c_old(T266* C);
T2 r266to_integer_or_error(T266* C);
T0* r266add_comment(T266* C,T0* a1);
T0* r266to_runnable(T266* C,T0* a1);
void r266collect_c_tmp(T266* C);
T0* r266static_result_base_class(T266* C);
extern T0*oBC59run_class_dictionary;
T0* r59load_class(T59* C,T0* a1);
extern T0*oBC59rename_dictionary;
extern int fBC59rename_dictionary;
T0* r59rename_dictionary(T59* C);
extern T0*oBC19tmp_file_read;
void r59warning(T104 a1,T0* a2);
void r59register_sys_runtime_basic_of(T0* a1);
extern T0*oBC59registered_for_c_define;
extern T0*oBC59run_class_map;
T6 r59is_used(T0* a1);
extern T0*oBC19manifest_string_pool;
extern T0*oBC59basic_sys_runtime;
extern T0*oBC19system_tools;
extern int fBC19system_tools;
T0* r59system_tools(void);
extern T0*oBC19manifest_array_pool;
extern T0*oBC19tmp_path;
void r59push(T0* a1);
extern T0*oBC59c_code;
void r59compile_to_c(T59* C);
extern T0*oBC19parser_buffer;
extern T0*oBC59rf9_memory;
T0* r59get_class(T0* a1);
T6 r59stupid_switch(T0* a1,T0* a2);
extern T0*oBC19address_of_pool;
extern T0*oBC19type_string;
extern int fBC19type_string;
T0* r59type_string(void);
void r59fatal_error(T0* a1);
extern T0*oBC19gc_handler;
void r59add_base_class(T59* C,T0* a1);
extern T0*oBC59tmp_tail;
T0* r59run_class_for(T0* a1);
T0* r59base_class(T59* C,T0* a1);
T6 r59parser_buffer_for(T59* C,T0* a1);
void r59reference_to_expanded(T0* a1);
void r59afd_check_deferred(T0* a1);
extern T0*oBC59base_class_dictionary;
T6 r59string_at_run_time(void);
extern T0*oBC59parser_buffer_path;
T6 r59same_base_feature(T0* a1,T0* a2);
T0* r59get_run_class_map(void);
extern T0*oBC59run_feature_stack;
extern T0*oBC19id_provider;
extern int fBC19id_provider;
T0* r59id_provider(void);
void r59id_extra_information(T0* a1,T0* a2);
void r59incr_magic_count(T59* C);
T0* r59memory_class_used(void);
extern T0*oBC59loading_path;
extern int fBC59loading_path;
T0* r59loading_path(void);
T0* r59run_class(T0* a1);
T6 r59is_tagged(T0* a1);
void r59get_started(T59* C,T0* a1,T0* a2);
void r354c_initialize_in(T354* C,T0* a1);
void r354c_type_for_external_in(T354* C,T0* a1);
T0* r354generic_list(T354* C);
extern T0*oBC19c_frame_descriptor_format;
T0* r354written_mark(void);
T6 r354is_bit(T354* C);
T6 r354has_creation(T354* C,T0* a1);
T0* r354run_time_mark(T354* C);
T6 r354is_any(T354* C);
T2 r354c_sizeof(T354* C);
void r354c_type_for_result_in(T354* C,T0* a1);
T6 r354is_native_array(T354* C);
void r354gc_mark_in(T354* C,T0* a1);
void r354just_before_gc_mark_in(T354* C,T0* a1);
void r354with(T354* C,T0* a1,T0* a2);
T6 r354is_pointer(T354* C);
T2 r354id(T354* C);
void r354mapping_cast(T354* C);
T0* r354static_base_class_name(T354* C);
T6 r354is_real(T354* C);
T6 r354is_none(T354* C);
void r354c_initialize(T354* C);
T6 r354need_gc_mark_function(T354* C);
void r354fatal_error_generic_list(T354* C);
void r354c_type_for_argument_in(T354* C,T0* a1);
T6 r354is_integer(T354* C);
void r354c_frame_descriptor(T354* C);
T0* r354base_class_name(T354* C);
T6 r354is_character(T354* C);
T6 r354is_expanded(T354* C);
T6 r354is_array(T354* C);
void r354gc_info_in(T354* C,T0* a1);
T0* r354base_class(T354* C);
T6 r354is_dummy_expanded(T354* C);
extern T0*oBC62mapping_cast_buffer;
T6 r354need_c_struct(T354* C);
T6 r354is_reference(T354* C);
void r354gc_define1(T354* C);
void r354gc_define2(T354* C);
void r354c_type_for_target_in(T354* C,T0* a1);
T0* r354expanded_initializer(T354* C);
T0* r354actual_reference(T354* C,T0* a1);
T6 r354is_a_in(T354* C,T0* a1,T0* a2);
void r354demangling_in(T354* C,T0* a1);
T6 r354is_generic(T354* C);
T6 r354is_double(T354* C);
void r354id_extra_information(T354* C,T0* a1);
T6 r354is_user_expanded(T354* C);
T6 r354is_a(T354* C,T0* a1);
T6 r354is_boolean(T354* C);
T0* r354to_runnable(T354* C,T0* a1);
T6 r354is_string(T354* C);
T0* r354run_class(T354* C);
void r354c_header_pass1(T354* C);
void r354c_header_pass2(T354* C);
void r354c_header_pass3(T354* C);
void r354c_header_pass4(T354* C);
T6 r354is_basic_eiffel_expanded(T354* C);
T0* r354smallest_ancestor(T354* C,T0* a1);
void r354gc_call_new_in(T354* C,T0* a1);
T2 r318compile_to_c(T318* C);
T6 r318stupid_switch(T318* C,T0* a1);
void r318make(T318* C,T0* a1);
void r318afd_check(T318* C);
T6 r318use_current(T318* C);
T0* r318to_runnable(T318* C,T0* a1);
void r318collect_c_tmp(T318* C);
void r327error(T104 a1,T0* a2);
T6 r327includes_integer(T327* C,T2 a1);
void r327compile_to_c(T327* C,T104 a1);
T6 r327stupid_switch(T327* C,T0* a1);
T6 r327includes_integer_between(T327* C,T2 a1,T2 a2);
void r327make(T327* C,T0* a1);
T0* r327to_runnable_character(T327* C,T0* a1);
void r327afd_check(T327* C);
T6 r327use_current(T327* C);
void r327from_when_list(T327* C,T0* a1);
T0* r327to_runnable_integer(T327* C,T0* a1);
T2 r327largest_range_of_values(T327* C);
void r327compile_to_c_switch(T327* C,T104 a1);
T104 r327start_position(T327* C);
void r282run_feature_match(T282* C,T0* a1);
T0* r282runnable_expression(T0* a1,T0* a2);
T6 r282call_proc_call_stupid_switch(T282* C,T0* a1);
T6 r282is_static(T282* C);
T0* r282operator(void);
void r282with(T282* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r282run_feature_has_result(T282* C);
void r282compile_to_c(T282* C);
T6 r282stupid_switch(T282* C,T0* a1);
void r282make(T282* C,T0* a1,T104 a2,T0* a3);
void r282fatal_error(T0* a1);
void r282to_integer_error(T282* C);
T0* r282arg1(T282* C);
void r282assertion_check(T282* C,T3 a1);
T0* r282result_type(T282* C);
void r282afd_check(T282* C);
T6 r282use_current(T282* C);
void r282c2c_cast_op(T282* C,T0* a1,T0* a2);
void r282c_declare_for_old(T282* C);
void r282compile_to_c_old(T282* C);
T0* r282runnable_args(T0* a1,T0* a2);
void r282mapping_c_target(T282* C,T0* a1);
T0* r282run_feature_for(T282* C,T0* a1,T0* a2);
T2 r282to_integer_or_error(T282* C);
T0* r282add_comment(T282* C,T0* a1);
T0* r282to_runnable(T282* C,T0* a1);
void r282collect_c_tmp(T282* C);
void r282finalize(T282* C);
T0* r282static_result_base_class(T282* C);
void r278cmp_bit(T278* C,T6 a1,T0* a2);
T0* r278runnable_expression(T0* a1,T0* a2);
T6 r278is_static_eq_void(T0* a1);
T6 r278call_proc_call_stupid_switch(T278* C,T0* a1);
T6 r278is_static(T278* C);
T0* r278operator(void);
void r278with(T278* C,T0* a1,T0* a2,T0* a3);
void r278compile_to_c(T278* C);
void r278check_comparison(T278* C,T0* a1);
T6 r278stupid_switch(T278* C,T0* a1);
void r278make(T278* C,T0* a1,T104 a2,T0* a3);
void r278error_comparison(T278* C,T0* a1,T0* a2);
void r278fatal_error(T0* a1);
void r278dca_inline(T278* C,T0* a1);
void r278to_integer_error(T278* C);
T0* r278arg1(T278* C);
void r278assertion_check(T278* C,T3 a1);
void r278afd_check(T278* C);
T6 r278use_current(T278* C);
extern T0*oBC19type_boolean;
extern int fBC19type_boolean;
T0* r278type_boolean(void);
T2 r278static_value(T278* C);
void r278cmp_basic_ref(T278* C,T6 a1);
void r278c_declare_for_old(T278* C);
void r278cmp_user_expanded(T278* C,T6 a1,T0* a2);
void r278compile_to_c_old(T278* C);
T0* r278runnable_args(T0* a1,T0* a2);
void r278mapping_c_target(T278* C,T0* a1);
void r278c2c_exp_ref(T0* a1,T0* a2,T0* a3,T0* a4);
T2 r278to_integer_or_error(T278* C);
void r278bit_limitation(T278* C,T0* a1,T0* a2);
T0* r278add_comment(T278* C,T0* a1);
T2 r278static_eq_void(T0* a1);
T0* r278to_runnable(T278* C,T0* a1);
void r278collect_c_tmp(T278* C);
T0* r278static_result_base_class(void);
void r278cmp_basic_eiffel_expanded(T278* C,T6 a1,T0* a2,T0* a3);
void r310compile_to_c(T310* C);
void r310make(T310* C,T104 a1,T0* a2,T0* a3);
void r310afd_check(T310* C);
T6 r310use_current(T310* C);
T6 r310is_pre_computable(T310* C);
T0* r310add_comment(T310* C,T0* a1);
T0* r310to_runnable(T310* C,T0* a1);
T104 r310start_position(T310* C);
void r284run_feature_match(T284* C,T0* a1);
T0* r284runnable_expression(T0* a1,T0* a2);
T6 r284call_proc_call_stupid_switch(T284* C,T0* a1);
T6 r284is_static(T284* C);
T0* r284operator(void);
void r284with(T284* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r284run_feature_has_result(T284* C);
void r284compile_to_c(T284* C);
T6 r284stupid_switch(T284* C,T0* a1);
void r284make(T284* C,T0* a1,T104 a2,T0* a3);
void r284fatal_error(T0* a1);
void r284to_integer_error(T284* C);
T0* r284arg1(T284* C);
void r284assertion_check(T284* C,T3 a1);
T0* r284result_type(T284* C);
void r284afd_check(T284* C);
T6 r284use_current(T284* C);
void r284c2c_cast_op(T284* C,T0* a1,T0* a2);
void r284c_declare_for_old(T284* C);
void r284compile_to_c_old(T284* C);
T0* r284runnable_args(T0* a1,T0* a2);
void r284mapping_c_target(T284* C,T0* a1);
T0* r284run_feature_for(T284* C,T0* a1,T0* a2);
T2 r284to_integer_or_error(T284* C);
T0* r284add_comment(T284* C,T0* a1);
T0* r284to_runnable(T284* C,T0* a1);
void r284collect_c_tmp(T284* C);
void r284finalize(T284* C);
T0* r284static_result_base_class(T284* C);
void r386c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r386standard_c_define_function(T0* a1,T0* a2,T0* a3);
void r386standard_c_define_procedure(T0* a1,T0* a2,T0* a3);
void r386c_mapping_external(T0* a1,T2 a2);
void r386wrapped_external_call(T0* a1,T2 a2);
void r386c_mapping_function(T0* a1,T0* a2,T0* a3);
void r281run_feature_match(T281* C,T0* a1);
T0* r281runnable_expression(T0* a1,T0* a2);
T6 r281call_proc_call_stupid_switch(T281* C,T0* a1);
T6 r281is_static(T281* C);
T0* r281operator(void);
void r281with(T281* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r281run_feature_has_result(T281* C);
void r281compile_to_c(T281* C);
T6 r281stupid_switch(T281* C,T0* a1);
void r281make(T281* C,T0* a1,T104 a2,T0* a3);
void r281fatal_error(T0* a1);
void r281to_integer_error(T281* C);
T0* r281arg1(T281* C);
void r281assertion_check(T281* C,T3 a1);
T0* r281result_type(T281* C);
void r281afd_check(T281* C);
T6 r281use_current(T281* C);
void r281c2c_cast_op(T281* C,T0* a1,T0* a2);
void r281c_declare_for_old(T281* C);
void r281compile_to_c_old(T281* C);
T0* r281runnable_args(T0* a1,T0* a2);
void r281mapping_c_target(T281* C,T0* a1);
T0* r281run_feature_for(T281* C,T0* a1,T0* a2);
T2 r281to_integer_or_error(T281* C);
T0* r281add_comment(T281* C,T0* a1);
T0* r281to_runnable(T281* C,T0* a1);
void r281collect_c_tmp(T281* C);
void r281finalize(T281* C);
T0* r281static_result_base_class(T281* C);
void r283run_feature_match(T283* C,T0* a1);
T0* r283runnable_expression(T0* a1,T0* a2);
T6 r283call_proc_call_stupid_switch(T283* C,T0* a1);
T6 r283is_static(T283* C);
T0* r283operator(void);
void r283with(T283* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r283run_feature_has_result(T283* C);
void r283compile_to_c(T283* C);
T6 r283stupid_switch(T283* C,T0* a1);
void r283make(T283* C,T0* a1,T104 a2,T0* a3);
void r283fatal_error(T0* a1);
void r283to_integer_error(T283* C);
T0* r283arg1(T283* C);
void r283assertion_check(T283* C,T3 a1);
T0* r283result_type(T283* C);
void r283afd_check(T283* C);
T6 r283use_current(T283* C);
void r283c2c_cast_op(T283* C,T0* a1,T0* a2);
void r283c_declare_for_old(T283* C);
void r283compile_to_c_old(T283* C);
T0* r283runnable_args(T0* a1,T0* a2);
void r283mapping_c_target(T283* C,T0* a1);
T0* r283run_feature_for(T283* C,T0* a1,T0* a2);
T2 r283to_integer_or_error(T283* C);
T0* r283add_comment(T283* C,T0* a1);
T0* r283to_runnable(T283* C,T0* a1);
void r283collect_c_tmp(T283* C);
void r283finalize(T283* C);
T0* r283static_result_base_class(T283* C);
T0* r299try_to_undefine_aux(T299* C,T0* a1,T0* a2);
void r299error(T104 a1,T0* a2);
T6 r299can_hide(T299* C,T0* a1,T0* a2);
void r299merge_header_comments(T299* C,T0* a1);
void r299add_into(T299* C,T0* a1);
T0* r299try_to_undefine(T299* C,T0* a1,T0* a2);
void r299make(T299* C,T0* a1,T0* a2,T0* a3);
void r299check_obsolete(T299* C,T104 a1);
T0* r299to_run_feature(T299* C,T0* a1,T0* a2);
T6 r299is_not_mergeable_with(T299* C,T0* a1);
T104 r299start_position(T299* C);
T0* r301try_to_undefine_aux(T301* C,T0* a1,T0* a2);
void r301error(T104 a1,T0* a2);
T6 r301can_hide(T301* C,T0* a1,T0* a2);
void r301merge_header_comments(T301* C,T0* a1);
void r301add_into(T301* C,T0* a1);
T0* r301try_to_undefine(T301* C,T0* a1,T0* a2);
void r301make(T301* C,T0* a1,T0* a2,T0* a3);
T0* r301value(T301* C,T2 a1);
void r301check_obsolete(T301* C,T104 a1);
T0* r301to_run_feature(T301* C,T0* a1,T0* a2);
T6 r301is_not_mergeable_with(T301* C,T0* a1);
T104 r301start_position(T301* C);
void r224run_feature_match(T224* C,T0* a1);
T0* r224runnable_expression(T0* a1,T0* a2);
T6 r224call_proc_call_stupid_switch(T224* C,T0* a1);
T6 r224is_static(T224* C);
T0* r224operator(void);
void r224with(T224* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r224run_feature_has_result(T224* C);
T6 r224stupid_switch(T224* C,T0* a1);
void r224make(T224* C,T0* a1,T104 a2,T0* a3);
void r224fatal_error(T0* a1);
void r224to_integer_error(T224* C);
T0* r224arg1(T224* C);
void r224assertion_check(T224* C,T3 a1);
T0* r224result_type(T224* C);
void r224afd_check(T224* C);
T6 r224use_current(T224* C);
void r224c_declare_for_old(T224* C);
void r224compile_to_c_old(T224* C);
T0* r224runnable_args(T0* a1,T0* a2);
void r224mapping_c_target(T224* C,T0* a1);
T0* r224run_feature_for(T224* C,T0* a1,T0* a2);
T2 r224to_integer_or_error(T224* C);
T0* r224add_comment(T224* C,T0* a1);
T0* r224to_runnable(T224* C,T0* a1);
void r224collect_c_tmp(T224* C);
void r224finalize(T224* C);
T0* r224static_result_base_class(T224* C);
void r356gc_store_in(T0* a1);
void r356c_type_for_external_in(T0* a1);
T0* r356generic_list(T356* C);
extern T0*oBC62body;
T0* r356written_mark(void);
T6 r356has_creation(T356* C,T0* a1);
T0* r356run_time_mark(void);
void r356gc_store_chunk_in(T0* a1);
void r356error(T104 a1,T0* a2);
void r356standard_gc_define2(T356* C);
void r356standard_gc_define1(T356* C);
T6 r356is_native_array(T356* C);
void r356gc_mark_in(T0* a1);
T2 r356c_sizeof_pointer(void);
void r356standard_gc_info_in(T0* a1);
void r356standard_c_typedef(T356* C);
extern T0*oBC62tmp_string;
void r356fatal_error_generic_list(T356* C);
void r356make(T356* C,T104 a1);
T0* r356base_class(T356* C);
void r356standard_c_print_function(T356* C);
extern int fBC356check_type;
void r356check_type(T356* C);
T6 r356need_c_struct(T356* C);
void r356c_type_for_target_in(T0* a1);
void r356gc_free_in(T0* a1);
T6 r356is_a_in(T356* C,T0* a1,T0* a2);
void r356demangling_in(T0* a1);
void r356gc_align_mark_in(T0* a1);
void r356standard_c_struct(T356* C);
void r356gc_initialize_chunk(T2 a1,T0* a2);
void r356id_extra_information(T0* a1);
T6 r356is_a(T356* C,T0* a1);
T0* r356to_runnable(T356* C,T0* a1);
void r356standard_c_object_model(T356* C);
T0* r356run_class(T356* C);
void r356gc_store_left_in(T0* a1);
void r356c_header_pass4(T356* C);
void r356standard_just_before_gc_mark_in(T0* a1);
void r356gc_info_nb_in(T0* a1);
void r356gc_call_new_in(T0* a1);
extern T0*oBC62header;
void r171check_name_clash(T171* C,T0* a1);
T2 r171rank_of(T171* C,T0* a1);
void r171error(T104 a1,T0* a2);
T6 r171is_runnable(T171* C,T0* a1);
T0* r171type(T171* C,T2 a1);
void r171fatal_error(T0* a1);
void r171c_declare(T171* C);
void r171inline_one_pc(T171* C);
void r171add_last(T171* C,T0* a1);
void r171dynamic_runnable(T171* C,T0* a1);
void r171declaration_list_make(T171* C,T0* a1);
void r171initialize_expanded(T171* C);
T0* r171twin(T171* C);
T0* r171to_runnable(T171* C,T0* a1);
T6 r171produce_c(T171* C);
void r325error(T104 a1,T0* a2);
void r325add_when(T325* C,T0* a1);
extern T0*oBC19exceptions_handler;
void r325compile_to_c(T325* C);
T6 r325stupid_switch(T325* C,T0* a1);
void r325make(T325* C,T104 a1,T0* a2);
void r325set_else_compound(T325* C,T104 a1,T0* a2);
void r325afd_check(T325* C);
T6 r325use_current(T325* C);
T0* r325twin(T325* C);
T0* r325add_comment(T325* C,T0* a1);
T6 r325use_c_switch_statement(T325* C);
T0* r325to_runnable(T325* C,T0* a1);
void r121check_name_clash(T121* C,T0* a1);
void r121compile_to_c_in(T121* C,T0* a1);
T2 r121rank_of(T121* C,T0* a1);
void r121error(T104 a1,T0* a2);
T6 r121is_runnable(T121* C,T0* a1);
extern T0*oBC19c_frame_descriptor_locals;
void r121with(T121* C,T0* a1,T0* a2);
T0* r121type(T121* C,T2 a1);
extern T0*oBC121tmp_string;
extern T0*oBC19c_frame_descriptor_local_count;
void r121make(T121* C,T0* a1);
void r121fatal_error(T0* a1);
void r121inline_one_pc(T121* C);
void r121add_last(T121* C,T0* a1);
void r121external_prototype_in(T121* C,T0* a1);
void r121dynamic_runnable(T121* C,T0* a1);
T6 r121is_a_in(T121* C,T0* a1,T0* a2);
void r121declaration_list_make(T121* C,T0* a1);
void r121afd_notify_conversion(T121* C,T0* a1);
T104 r121start_position(T121* C);
T0* r123base_class_written(T123* C);
void r123error(T104 a1,T0* a2);
void r123name_clash_for(T123* C,T0* a1,T0* a2);
T6 r123stupid_switch(T123* C,T0* a1);
void r123make(T123* C,T104 a1,T0* a2);
void r123to_integer_error(T123* C);
void r123mapping_c_target(T123* C,T0* a1);
T0* r123twin(T123* C);
T2 r123to_integer_or_error(T123* C);
T0* r123add_comment(T123* C,T0* a1);
T0* r123to_runnable(T123* C,T0* a1);
T0* r123static_result_base_class(T123* C);
void r218run_feature_match(T218* C,T0* a1);
T0* r218runnable_expression(T0* a1,T0* a2);
T6 r218call_proc_call_stupid_switch(T218* C,T0* a1);
T6 r218is_static(T218* C);
T0* r218operator(void);
void r218with(T218* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r218run_feature_has_result(T218* C);
T6 r218stupid_switch(T218* C,T0* a1);
void r218make(T218* C,T0* a1,T104 a2,T0* a3);
void r218fatal_error(T0* a1);
void r218to_integer_error(T218* C);
T0* r218arg1(T218* C);
void r218assertion_check(T218* C,T3 a1);
T0* r218result_type(T218* C);
void r218afd_check(T218* C);
T6 r218use_current(T218* C);
void r218c_declare_for_old(T218* C);
void r218compile_to_c_old(T218* C);
T0* r218runnable_args(T0* a1,T0* a2);
void r218mapping_c_target(T218* C,T0* a1);
T0* r218run_feature_for(T218* C,T0* a1,T0* a2);
T2 r218to_integer_or_error(T218* C);
T0* r218add_comment(T218* C,T0* a1);
T0* r218to_runnable(T218* C,T0* a1);
void r218collect_c_tmp(T218* C);
void r218finalize(T218* C);
T0* r218static_result_base_class(T218* C);
void r287warning(T104 a1,T0* a2);
T6 r287gives_permission_to(T287* C,T0* a1);
T2 r287count(T287* C);
T0* r287item(T287* C,T2 a1);
void r287merge(T287* C,T0* a1,T0* a2);
T2 r287index_of(T287* C,T0* a1);
T6 r287gives_permission_to_any(T287* C);
void r287add_last(T287* C,T0* a1);
void r236run_feature_match(T236* C);
T6 r236can_be_dropped(T236* C);
T0* r236runnable_expression(T0* a1,T0* a2);
T6 r236call_proc_call_stupid_switch(T236* C,T0* a1);
T6 r236is_static(T236* C);
void r236with(T236* C,T0* a1,T0* a2,T0* a3);
void r236run_feature_has_result(T236* C);
T6 r236stupid_switch(T236* C,T0* a1);
void r236make(T236* C,T0* a1,T0* a2);
void r236fatal_error(T0* a1);
void r236to_integer_error(T236* C);
void r236assertion_check(T236* C,T3 a1);
T0* r236result_type(T236* C);
void r236afd_check(T236* C);
T6 r236use_current(T236* C);
T2 r236static_value(T236* C);
void r236c_declare_for_old(T236* C);
void r236compile_to_c_old(T236* C);
void r236mapping_c_target(T236* C,T0* a1);
T0* r236run_feature_for(T236* C,T0* a1,T0* a2);
T2 r236to_integer_or_error(T236* C);
T0* r236add_comment(T236* C,T0* a1);
T0* r236to_runnable(T236* C,T0* a1);
void r236collect_c_tmp(T236* C);
void r236finalize(T236* C);
T0* r236static_result_base_class(T236* C);
void r240run_feature_match(T240* C);
T6 r240can_be_dropped(T240* C);
T0* r240runnable_expression(T0* a1,T0* a2);
T6 r240call_proc_call_stupid_switch(T240* C,T0* a1);
T6 r240is_static(T240* C);
T0* r240operator(void);
void r240with(T240* C,T0* a1,T0* a2,T0* a3);
void r240run_feature_has_result(T240* C);
void r240compile_to_c(T240* C);
T6 r240stupid_switch(T240* C,T0* a1);
void r240make(T240* C,T104 a1,T0* a2);
void r240fatal_error(T0* a1);
void r240to_integer_error(T240* C);
void r240assertion_check(T240* C,T3 a1);
T0* r240result_type(T240* C);
void r240afd_check(T240* C);
T6 r240use_current(T240* C);
T2 r240static_value(T240* C);
void r240c_declare_for_old(T240* C);
void r240compile_to_c_old(T240* C);
void r240mapping_c_target(T240* C,T0* a1);
T0* r240run_feature_for(T240* C,T0* a1,T0* a2);
T2 r240to_integer_or_error(T240* C);
T0* r240add_comment(T240* C,T0* a1);
T0* r240to_runnable(T240* C,T0* a1);
void r240collect_c_tmp(T240* C);
void r240finalize(T240* C);
T0* r240static_result_base_class(T240* C);
void r58disconnect(T58* C);
extern T0*oBC40tmp_string;
void r58connect_to(T58* C,T0* a1);
void r58put_integer(T58* C,T2 a1);
void r58put_string(T58* C,T0* a1);
void r382error(T104 a1,T0* a2);
void r382from_effective(T382* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T6 r382can_hide(T382* C,T0* a1,T0* a2);
void r382merge_header_comments(T382* C,T0* a1);
void r382add_into(T382* C,T0* a1);
void r382make_routine(T382* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r382try_to_undefine(T382* C,T0* a1,T0* a2);
void r382check_obsolete(T382* C,T104 a1);
T0* r382to_run_feature(T382* C,T0* a1,T0* a2);
void r382set_header_comment(T382* C,T0* a1);
T6 r382is_not_mergeable_with(T382* C,T0* a1);
T104 r382start_position(T382* C);
void r382set_rescue_compound(T382* C,T0* a1);
T2 r403count(T403* C);
void r403make(T403* C,T0* a1,T0* a2);
void r403append_in(T403* C,T0* a1);
T0* r307try_to_undefine_aux(T307* C,T0* a1,T0* a2);
void r307error(T104 a1,T0* a2);
T6 r307can_hide(T307* C,T0* a1,T0* a2);
void r307merge_header_comments(T307* C,T0* a1);
void r307add_into(T307* C,T0* a1);
T0* r307try_to_undefine(T307* C,T0* a1,T0* a2);
void r307make(T307* C,T0* a1,T0* a2,T0* a3);
void r307check_obsolete(T307* C,T104 a1);
T0* r307to_run_feature(T307* C,T0* a1,T0* a2);
T6 r307is_not_mergeable_with(T307* C,T0* a1);
T104 r307start_position(T307* C);
void r164warning(T104 a1,T0* a2);
void r164good_end(T164* C,T0* a1);
void r164append(T164* C,T0* a1);
void r164make(T164* C,T104 a1,T0* a2);
void r276error(T104 a1,T0* a2);
extern T0*oBC276vaol_check_memory;
extern T0*oBC276tmp_string;
T0* r276local_c_name(T276* C);
void r276to_integer_error(T276* C);
void r276assertion_check(T276* C,T3 a1);
T0* r276result_type(T276* C);
void r276afd_check(T276* C);
T6 r276use_current(T276* C);
void r276c_declare_for_old(T276* C);
void r276compile_to_c_old(T276* C);
T2 r276to_integer_or_error(T276* C);
T0* r276add_comment(T276* C,T0* a1);
T0* r276to_runnable(T276* C,T0* a1);
T0* r276static_result_base_class(T276* C);
T104 r276start_position(T276* C);
void r165se_evobt(T165* C);
void r165initialize_runtime(T165* C);
void r165bad_inspect_value(T165* C,T104 a1);
void r165get_started(T165* C);
T0* r243type_any(void);
void r243compile_to_c(T243* C);
T2 r243array_count(T243* C,T0* a1);
void r243make(T243* C,T104 a1,T0* a2);
void r243to_integer_error(T243* C);
T0* r243result_type(T243* C);
void r243vwst1_check(T243* C,T0* a1);
void r243afd_check(T243* C);
T2 r243to_integer_or_error(T243* C);
T0* r243add_comment(T243* C,T0* a1);
T0* r243to_runnable(T243* C,T0* a1);
T0* r243static_result_base_class(void);
extern T0*oBC19type_pointer;
extern int fBC19type_pointer;
T0* r254type_pointer(void);
void r254compile_to_c(T254* C);
void r254to_integer_error(T254* C);
T2 r254to_integer_or_error(T254* C);
T0* r254add_comment(T254* C,T0* a1);
T0* r254to_runnable(T254* C,T0* a1);
T0* r254static_result_base_class(void);
T104 r254start_position(T254* C);
T0* r269to_string(T269* C);
T6 r269stupid_switch(T269* C,T0* a1);
void r269fatal_error(T0* a1);
void r269to_integer_error(T269* C);
void r269assertion_check(T269* C,T3 a1);
T0* r269result_type(T269* C);
void r269refer_to(T269* C,T104 a1,T0* a2,T2 a3);
void r269mapping_c_target(T269* C,T0* a1);
T2 r269to_integer_or_error(T269* C);
T0* r269add_comment(T269* C,T0* a1);
T0* r269to_runnable(T269* C,T0* a1);
T0* r269static_result_base_class(T269* C);
void r271warning(T104 a1,T0* a2);
T0* r271base_class_written(T271* C);
void r271error(T104 a1,T0* a2);
void r271name_clash_for(T271* C,T0* a1,T0* a2);
extern T0*oBC270tmp_string;
T6 r271stupid_switch(T271* C,T0* a1);
void r271c_frame_descriptor(T271* C,T0* a1);
void r271make(T271* C,T104 a1,T0* a2);
void r271to_integer_error(T271* C);
void r271c_declare(T271* C);
void r271mapping_c_target(T271* C,T0* a1);
T0* r271twin(T271* C);
T2 r271to_integer_or_error(T271* C);
T0* r271add_comment(T271* C,T0* a1);
T0* r271to_runnable(T271* C,T0* a1);
T6 r271produce_c(T271* C);
T0* r271static_result_base_class(T271* C);
T6 r61has_simple_feature_name(T61* C,T0* a1);
T0* r61up_to_original(T61* C,T0* a1,T0* a2);
T6 r61is_platform(T61* C);
T0* r61super_look_up_for(T61* C,T0* a1,T0* a2);
T0* r61going_up(T61* C,T0* a1,T0* a2,T0* a3);
void r61inherit_cycle_check(T61* C);
extern T0*oBC19class_any;
extern int fBC19class_any;
T0* r61class_any(void);
T0* r61run_ensure(T61* C,T0* a1);
T0* r61super_e_feature(T61* C,T0* a1);
T0* r61type_any(void);
void r61warning(T104 a1,T0* a2);
T0* r61new_name_of(T61* C,T0* a1,T0* a2);
extern T0*oBC61mem_fn;
extern int fBC61mem_fn;
T0* r61mem_fn(void);
T6 r61has_creation(T61* C,T0* a1);
T6 r61is_any(T61* C);
T0* r61look_up_for(T61* C,T0* a1,T0* a2);
void r61error(T104 a1,T0* a2);
T6 r61has_redefine(T61* C,T0* a1);
T0* r61run_require(T61* C,T0* a1);
extern T0*oBC19class_general;
extern int fBC19class_general;
T0* r61class_general(void);
T6 r61once_flag(T61* C,T0* a1);
void r61set_is_expanded(T61* C);
T0* r61clients_for(T61* C,T0* a1);
extern T0*oBC19assertion_collector;
void r61add_index_clause(T61* C,T0* a1);
void r61check_expanded_with(T61* C,T0* a1);
T6 r61is_none(T61* C);
T0* r61new_name_of_original(T61* C,T0* a1,T0* a2);
T0* r61get_copy(T61* C);
void r61add_feature_clause(T61* C,T0* a1);
T6 r61is_a_vncg(T61* C,T0* a1,T0* a2);
extern T0*oBC61going_up_trace;
void r61make(T61* C,T0* a1,T0* a2,T2 a3);
void r61check_generic_formal_arguments(T61* C);
T0* r61get_default_rescue(T61* C,T0* a1,T0* a2);
void r61fatal_error(T0* a1);
T0* r61original_name(T61* C,T0* a1,T0* a2);
void r61vdrd6(T0* a1,T0* a2,T0* a3);
T6 r61proper_has(T61* C,T0* a1);
void r61fatal_error_vdrd6(T0* a1,T0* a2,T0* a3);
T6 r61is_subclass_of(T61* C,T0* a1);
void r61add_creation_clause(T61* C,T0* a1);
T6 r61has(T61* C,T0* a1);
T0* r61general_default_rescue(T61* C);
void r61set_is_deferred(T61* C);
void r61set_obsolete_type_string(T61* C,T0* a1);
void r61set_invariant(T61* C,T104 a1,T0* a2,T0* a3);
void r61collect_invariant(T61* C,T0* a1);
T0* r61e_feature(T61* C,T0* a1);
T6 r61is_general(T61* C);
void r61fatal_undefine(T61* C,T0* a1);
T0* r61expanded_initializer(T61* C,T0* a1);
extern T0*oBC61visited;
T0* r61run_feature_for(T61* C,T0* a1,T0* a2,T0* a3,T0* a4);
T0* r61root_procedure_name(T61* C,T0* a1);
void r61id_extra_information(T61* C,T0* a1);
void r61set_parent_list(T61* C,T104 a1,T0* a2,T0* a3);
T0* r61root_procedure(T61* C,T0* a1);
void r61collect_assertion(T61* C,T0* a1);
void r61get_started(T61* C);
T0* r61smallest_ancestor(T61* C,T0* a1,T0* a2);
T6 r323c_simple(T323* C);
T6 r323can_be_dropped(T323* C);
T6 r323is_manifest_string(T323* C);
T6 r323is_static(T323* C);
T6 r323is_void(T323* C);
void r323compile_to_c(T323* C);
T6 r323is_result(T323* C);
T6 r323stupid_switch(T323* C,T0* a1);
void r323mapping_c_arg(T323* C,T0* a1);
void r323make(T323* C,T0* a1,T0* a2);
T6 r323is_manifest_array(T323* C);
T2 r323isa_dca_inline_argument(T323* C);
void r323dca_inline_argument(T323* C,T0* a1);
void r323assertion_check(T323* C,T3 a1);
T0* r323result_type(T323* C);
void r323afd_check(T323* C);
T6 r323use_current(T323* C);
T2 r323static_value(T323* C);
void r323c_declare_for_old(T323* C);
void r323compile_to_c_old(T323* C);
void r323mapping_c_target(T323* C,T0* a1);
T2 r323to_integer_or_error(T323* C);
T6 r323is_pre_computable(T323* C);
T0* r323add_comment(T323* C,T0* a1);
T0* r323to_runnable(T323* C,T0* a1);
void r323collect_c_tmp(T323* C);
T6 r323is_current(T323* C);
T104 r323start_position(T323* C);
T0* r323static_result_base_class(T323* C);
extern T0*oBC252result_type;
extern int fBC252result_type;
T0* r252result_type(void);
T0* r252add_comment(T252* C,T0* a1);
void r233run_feature_match(T233* C,T0* a1);
T0* r233runnable_expression(T0* a1,T0* a2);
T6 r233call_proc_call_stupid_switch(T233* C,T0* a1);
T6 r233is_static(T233* C);
T0* r233operator(void);
void r233with(T233* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r233run_feature_has_result(T233* C);
T6 r233stupid_switch(T233* C,T0* a1);
void r233make(T233* C,T0* a1,T104 a2,T0* a3);
void r233fatal_error(T0* a1);
void r233to_integer_error(T233* C);
T0* r233arg1(T233* C);
void r233assertion_check(T233* C,T3 a1);
T0* r233result_type(T233* C);
void r233afd_check(T233* C);
T6 r233use_current(T233* C);
void r233c_declare_for_old(T233* C);
void r233compile_to_c_old(T233* C);
T0* r233runnable_args(T0* a1,T0* a2);
void r233mapping_c_target(T233* C,T0* a1);
T0* r233run_feature_for(T233* C,T0* a1,T0* a2);
T2 r233to_integer_or_error(T233* C);
T0* r233add_comment(T233* C,T0* a1);
T0* r233to_runnable(T233* C,T0* a1);
void r233collect_c_tmp(T233* C);
void r233finalize(T233* C);
T0* r233static_result_base_class(T233* C);
void r261compile_to_c(T261* C);
void r261make(T261* C,T104 a1,T3 a2,T2 a3);
T2 r261isa_dca_inline_argument(void);
extern T0*oBC261result_type;
extern int fBC261result_type;
T0* r261result_type(void);
T0* r261add_comment(T261* C,T0* a1);
T0* r261to_runnable(T261* C,T0* a1);
T0* r261static_result_base_class(void);
void r326from_e_when(T326* C,T0* a1);
void r326error(T104 a1,T0* a2);
void r326add_value(T326* C,T0* a1);
T6 r326includes_integer(T326* C,T2 a1);
void r326compile_to_c(T326* C);
T6 r326stupid_switch(T326* C,T0* a1);
T6 r326includes_integer_between(T326* C,T2 a1,T2 a2);
void r326make(T326* C,T104 a1,T0* a2);
void r326add_when_item_1(T326* C,T0* a1);
void r326add_when_item_2(T326* C,T0* a1);
T0* r326to_runnable_character(T326* C,T0* a1);
void r326afd_check(T326* C);
T6 r326use_current(T326* C);
T0* r326to_runnable_integer(T326* C,T0* a1);
T2 r326locate_in_values(T326* C,T2 a1);
void r326err_occ(T326* C,T2 a1,T104 a2);
T2 r326largest_range_of_values(T326* C);
void r326add_slice(T326* C,T0* a1,T0* a2);
void r326compile_to_c_switch(T326* C);
void r352c_initialize_in(T352* C,T0* a1);
void r352c_type_for_external_in(T352* C,T0* a1);
T0* r352generic_list(T352* C);
T6 r352is_bit(T352* C);
extern T0*oBC353written_mark_buffer;
T6 r352has_creation(T352* C,T0* a1);
T0* r352run_time_mark(T352* C);
T6 r352is_any(T352* C);
T2 r352c_sizeof(T352* C);
void r352c_type_for_result_in(T352* C,T0* a1);
T6 r352is_native_array(T352* C);
void r352gc_mark_in(T352* C,T0* a1);
void r352just_before_gc_mark_in(T352* C,T0* a1);
void r352with(T352* C,T0* a1,T0* a2);
T6 r352is_pointer(T352* C);
T2 r352id(T352* C);
void r352mapping_cast(T352* C);
T0* r352static_base_class_name(T352* C);
T6 r352is_real(T352* C);
T6 r352is_none(T352* C);
void r352c_initialize(T352* C);
T6 r352need_gc_mark_function(T352* C);
void r352fatal_error_generic_list(T352* C);
void r352c_type_for_argument_in(T352* C,T0* a1);
void r352anchor_cycle_end(T352* C);
T6 r352is_integer(T352* C);
void r352c_frame_descriptor(T352* C);
void r352make(T352* C,T104 a1,T0* a2);
T0* r352base_class_name(T352* C);
void r352fatal_error(T0* a1);
T6 r352is_character(T352* C);
T6 r352is_expanded(T352* C);
T6 r352is_array(T352* C);
void r352gc_info_in(T352* C,T0* a1);
extern T0*oBC19string_aliaser;
extern int fBC19string_aliaser;
T0* r352string_aliaser(void);
T0* r352base_class(T352* C);
T6 r352is_dummy_expanded(T352* C);
T6 r352need_c_struct(T352* C);
T6 r352is_reference(T352* C);
void r352gc_define1(T352* C);
void r352gc_define2(T352* C);
void r352c_type_for_target_in(T352* C,T0* a1);
T0* r352expanded_initializer(T352* C);
T0* r352actual_reference(T352* C,T0* a1);
T6 r352is_a_in(T352* C,T0* a1,T0* a2);
void r352demangling_in(T352* C,T0* a1);
extern T0*oBC353visited;
T6 r352is_generic(T352* C);
T6 r352is_double(T352* C);
void r352id_extra_information(T352* C,T0* a1);
T6 r352is_user_expanded(T352* C);
T6 r352is_a(T352* C,T0* a1);
T6 r352is_boolean(T352* C);
void r352anchor_cycle_start(T352* C);
T0* r352to_runnable(T352* C,T0* a1);
T6 r352is_string(T352* C);
T0* r352run_class(T352* C);
void r352c_header_pass1(T352* C);
void r352c_header_pass2(T352* C);
void r352c_header_pass3(T352* C);
void r352c_header_pass4(T352* C);
T6 r352is_basic_eiffel_expanded(T352* C);
T0* r352smallest_ancestor(T352* C,T0* a1);
void r352gc_call_new_in(T352* C,T0* a1);
void r189make(T189* C,T0* a1,T0* a2);
void r189fatal_error(T0* a1);
T0* r116try_to_undefine_aux(T116* C,T0* a1,T0* a2);
void r116error(T104 a1,T0* a2);
T6 r116can_hide(T116* C,T0* a1,T0* a2);
void r116make_external_routine(T116* C,T0* a1,T0* a2);
void r116merge_header_comments(T116* C,T0* a1);
void r116add_into(T116* C,T0* a1);
void r116make_routine(T116* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r116try_to_undefine(T116* C,T0* a1,T0* a2);
void r116make(T116* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r116check_obsolete(T116* C,T104 a1);
T6 r116use_current(T116* C);
T0* r116external_name(T116* C);
T0* r116to_run_feature(T116* C,T0* a1,T0* a2);
void r116set_header_comment(T116* C,T0* a1);
T6 r116is_not_mergeable_with(T116* C,T0* a1);
T104 r116start_position(T116* C);
void r116set_rescue_compound(T116* C,T0* a1);
T0* r116c_plus_plus_name(T116* C);
T0* r380left_type(T380* C);
void r380warning(T104 a1,T0* a2);
void r380error(T104 a1,T0* a2);
void r380compile_to_c(T380* C);
T6 r380stupid_switch(T380* C,T0* a1);
void r380make(T380* C,T0* a1,T0* a2);
void r380fatal_error(T0* a1);
void r380afd_check(T380* C);
T6 r380use_current(T380* C);
T0* r380add_comment(T380* C,T0* a1);
T0* r380to_runnable(T380* C,T0* a1);
void r380collect_c_tmp(T380* C);
T0* r380right_type(T380* C);
T104 r380start_position(T380* C);
void r409error(T104 a1,T0* a2);
T0* r409to_key(T409* C);
T0* r409to_string(T409* C);
void r409undefine_in(T409* C,T0* a1);
void r409declaration_in(T409* C,T0* a1);
void r409mapping_c_in(T409* C,T0* a1);
T0* r409origin_base_class(T409* C);
T104 r409start_position(T409* C);
void r409put_cpp_tag(T409* C);
T2 r259isa_dca_inline_argument(void);
T0* r259type_boolean(void);
T0* r259add_comment(T259* C,T0* a1);
T0* r259to_runnable(T259* C,T0* a1);
T0* r259static_result_base_class(void);
void r313add_if_then(T313* C,T0* a1,T0* a2);
void r313compile_to_c(T313* C);
T6 r313stupid_switch(T313* C,T0* a1);
void r313afd_check(T313* C);
T6 r313use_current(T313* C);
T0* r313twin(T313* C);
T0* r313add_comment(T313* C,T0* a1);
T0* r313to_runnable(T313* C,T0* a1);
void r239error(T104 a1,T0* a2);
void r239make(T239* C,T0* a1,T104 a2);
void r239undefine_in(T239* C,T0* a1);
T0* r239string_aliaser(void);
void r239declaration_in(T239* C,T0* a1);
T0* r239origin_base_class(T239* C);
T0* r395try_to_undefine_aux(T395* C,T0* a1,T0* a2);
void r395error(T104 a1,T0* a2);
T6 r395can_hide(T395* C,T0* a1,T0* a2);
void r395merge_header_comments(T395* C,T0* a1);
void r395add_into(T395* C,T0* a1);
void r395make_routine(T395* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r395try_to_undefine(T395* C,T0* a1,T0* a2);
void r395make(T395* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r395check_obsolete(T395* C,T104 a1);
T0* r395to_run_feature(T395* C,T0* a1,T0* a2);
void r395set_header_comment(T395* C,T0* a1);
T6 r395is_not_mergeable_with(T395* C,T0* a1);
T104 r395start_position(T395* C);
T0* r150try_to_undefine_aux(T150* C,T0* a1,T0* a2);
void r150error(T104 a1,T0* a2);
T6 r150can_hide(T150* C,T0* a1,T0* a2);
void r150merge_header_comments(T150* C,T0* a1);
T0* r150a_default_rescue(T150* C,T0* a1,T0* a2);
void r150add_into(T150* C,T0* a1);
void r150make_routine(T150* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r150try_to_undefine(T150* C,T0* a1,T0* a2);
void r150make(T150* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r150check_obsolete(T150* C,T104 a1);
void r150attribute_writer(T150* C,T0* a1,T0* a2,T0* a3);
T0* r150to_run_feature(T150* C,T0* a1,T0* a2);
void r150set_header_comment(T150* C,T0* a1);
T6 r150is_not_mergeable_with(T150* C,T0* a1);
T104 r150start_position(T150* C);
void r265make(T265* C,T2 a1,T104 a2);
T2 r265isa_dca_inline_argument(void);
extern T0*oBC265result_type;
extern int fBC265result_type;
T0* r265result_type(void);
T0* r265to_real_constant(T265* C);
void r265unary_minus(T265* C);
T0* r265add_comment(T265* C,T0* a1);
T0* r265to_runnable(T265* C,T0* a1);
T0* r265static_result_base_class(void);
T0* r413clients_for(T413* C,T0* a1);
void r413make(T413* C,T104 a1,T0* a2);
void r217error(T104 a1,T0* a2);
void r217compile_to_c(T217* C);
T6 r217stupid_switch(T217* C,T0* a1);
void r217make(T217* C,T104 a1,T0* a2);
void r217to_integer_error(T217* C);
void r217assertion_check(T217* C,T3 a1);
void r217afd_check(T217* C);
T6 r217use_current(T217* C);
void r217c_declare_for_old(T217* C);
void r217compile_to_c_old(T217* C);
void r217mapping_c_target(T217* C,T0* a1);
T2 r217to_integer_or_error(T217* C);
T6 r217is_pre_computable(T217* C);
T0* r217add_comment(T217* C,T0* a1);
T0* r217to_runnable(T217* C,T0* a1);
void r217collect_c_tmp(T217* C);
void r229run_feature_match(T229* C,T0* a1);
T0* r229runnable_expression(T0* a1,T0* a2);
T6 r229call_proc_call_stupid_switch(T229* C,T0* a1);
T6 r229is_static(T229* C);
T0* r229operator(void);
void r229with(T229* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r229run_feature_has_result(T229* C);
T6 r229stupid_switch(T229* C,T0* a1);
void r229make(T229* C,T0* a1,T104 a2,T0* a3);
void r229fatal_error(T0* a1);
void r229to_integer_error(T229* C);
T2 r229isa_dca_inline_argument(T229* C);
void r229dca_inline_argument(T229* C,T0* a1);
T0* r229arg1(T229* C);
void r229assertion_check(T229* C,T3 a1);
T0* r229result_type(T229* C);
void r229afd_check(T229* C);
T6 r229use_current(T229* C);
void r229c_declare_for_old(T229* C);
void r229compile_to_c_old(T229* C);
T0* r229runnable_args(T0* a1,T0* a2);
void r229mapping_c_target(T229* C,T0* a1);
T0* r229run_feature_for(T229* C,T0* a1,T0* a2);
T2 r229to_integer_or_error(T229* C);
T0* r229add_comment(T229* C,T0* a1);
T0* r229to_runnable(T229* C,T0* a1);
void r229collect_c_tmp(T229* C);
void r229finalize(T229* C);
T0* r229static_result_base_class(T229* C);
T0* r140try_to_undefine_aux(T140* C,T0* a1,T0* a2);
void r140implicit(T140* C,T0* a1,T0* a2,T2 a3);
void r140error(T104 a1,T0* a2);
T6 r140can_hide(T140* C,T0* a1,T0* a2);
void r140merge_header_comments(T140* C,T0* a1);
void r140add_into(T140* C,T0* a1);
T0* r140try_to_undefine(T140* C,T0* a1,T0* a2);
void r140make(T140* C,T0* a1,T0* a2,T0* a3);
void r140check_obsolete(T140* C,T104 a1);
T0* r140to_run_feature(T140* C,T0* a1,T0* a2);
T6 r140is_not_mergeable_with(T140* C,T0* a1);
T104 r140start_position(T140* C);
void r60efnf(T60* C,T0* a1,T0* a2);
T6 r60need_gc_mark(T60* C);
extern T0*oBC60c_print_function_buffer;
T0* r60get_rf_with(T60* C,T0* a1);
void r60sort_wam(T0* a1);
void r60definitions_for_tuple(T60* C,T0* a1,T0* a2);
void r60gc_mark_fixed_size(T60* C,T6 a1,T0* a2);
T0* r60at(T60* C,T0* a1);
T2 r60c_sizeof(T60* C);
T6 r60is_wa_cycle(T60* C,T0* a1);
void r60gc_set_fsoh_marked_in(T60* C,T0* a1);
void r60error(T104 a1,T0* a2);
void r60demangling(T60* C);
T0* r60class_general(void);
void r60mark_attribute(T60* C,T0* a1,T0* a2);
void r60just_before_gc_mark_in(T60* C,T0* a1);
T0* r60get_result_type(T60* C,T0* a1);
extern T0*oBC60wa_cyclic_buf;
T6 r60gt(T0* a1,T0* a2);
T0* r60get_memory_dispose(T60* C);
void r60deep_twin_in(T60* C,T0* a1);
void r60add_run_feature(T60* C,T0* a1,T0* a2);
T0* r60get_copy(T60* C);
extern T0*oBC60tmp_string;
void r60add_client(T60* C,T0* a1);
void r60compile_to_c(T60* C,T2 a1);
void r60really_compile_to_c(T60* C);
T0* r60get_feature(T60* C,T0* a1);
void r60falling_down(T60* C);
T0* r60dynamic(T60* C,T0* a1);
void r60make(T60* C,T0* a1,T0* a2);
void r60c_object_model_in(T60* C,T0* a1);
T0* r60get_default_rescue(T60* C,T0* a1);
void r60fatal_error(T0* a1);
extern T0*oBC60demangling_buffer;
void r60afd_check(T60* C);
T2 r60offset_of(T60* C,T0* a1);
void r60gc_info_in(T60* C,T0* a1);
void r60set_at_run_time(T60* C);
T0* r60string_aliaser(void);
void r60runnable_class_invariant(T60* C);
void r60is_deep_equal_in(T60* C,T0* a1);
extern T0*oBC60wa_cycle;
T6 r60is_running_of(T60* C,T0* a1);
void r60gc_define1(T60* C);
void r60gc_define2(T60* C);
extern T0*oBC60wa_buf;
void r60gc_align_mark_fixed_size(T60* C,T0* a1);
void r60add_running(T60* C,T0* a1);
T0* r60writable_attributes(T60* C);
T6 r60gc_mark_to_follow(T60* C);
T0* r60id_provider(void);
void r60id_extra_information(T60* C,T0* a1);
void r60shared_attributes(T60* C,T0* a1);
T0* r60get_or_fatal_error(T60* C,T0* a1);
void r60tuple_field(T0* a1,T0* a2,T0* a3);
void r60c_header_pass1(T60* C);
T6 r60is_tagged(T60* C);
void r60c_header_pass2(T60* C);
void r60c_header_pass3(T60* C);
void r60c_header_pass4(T60* C);
T0* r60get_feature_with(T60* C,T0* a1);
void r60c_print_function(T60* C);
void r444just_before_mark(T0* a1);
void r444c_dicho(T444* C,T0* a1,T2 a2,T2 a3);
extern T0*oBC444body;
T0* r444system_tools(void);
void r444memory_dispose(T0* a1,T0* a2,T0* a3);
void r444switch_for(T444* C,T0* a1);
void r444new_native9_in(T444* C,T0* a1,T6 a2);
void r444new_manifest_string_in(T444* C,T0* a1,T6 a2);
void r444falling_down(T444* C,T0* a1);
T0* r444type_string(void);
extern T0*oBC19once_routine_pool;
void r444set_info_flag(T444* C);
void r444basic_allocation(T444* C,T0* a1,T0* a2,T0* a3);
void r444sort_running(T0* a1);
void r444define_gc_start(T444* C,T0* a1,T0* a2);
void r444initialize_runtime(T444* C);
void r444allocation_of(T444* C,T0* a1,T0* a2);
void r444no_gc(T444* C);
void r444define2(T444* C);
void r444allocation(T444* C,T0* a1);
void r444gc_info_before_exit(T444* C);
extern T0*oBC444switch_list;
void r444mark_for(T0* a1,T0* a2,T0* a3);
void r444define_gc_info(T0* a1);
extern T0*oBC444header;
void r371c_initialize_in(T371* C,T0* a1);
void r371c_type_for_external_in(T371* C,T0* a1);
T0* r371generic_list(T371* C);
T6 r371is_bit(T371* C);
T6 r371has_creation(T371* C,T0* a1);
T2 r371c_sizeof(T371* C);
void r371c_type_for_result_in(T371* C,T0* a1);
T6 r371is_native_array(T371* C);
void r371gc_mark_in(T371* C,T0* a1);
void r371standard_gc_define2_for_expanded(T371* C);
T6 r371is_pointer(T371* C);
T2 r371id(T371* C);
void r371mapping_cast(T371* C);
void r371from_other(T371* C,T0* a1,T0* a2);
T6 r371is_real(T371* C);
void r371c_initialize(T371* C);
void r371standard_c_typedef(T371* C);
T6 r371need_gc_mark_function(T371* C);
void r371c_type_for_argument_in(T371* C,T0* a1);
T6 r371stupid_switch(T371* C,T0* a1);
T6 r371is_integer(T371* C);
void r371c_frame_descriptor(T371* C);
void r371make(T371* C,T104 a1,T0* a2);
T0* r371base_class_name(T371* C);
void r371fatal_error(T0* a1);
T6 r371is_character(T371* C);
T0* r371string_aliaser(void);
T0* r371base_class(T371* C);
T6 r371is_dummy_expanded(T371* C);
void r371standard_c_print_function(T371* C);
T6 r371need_c_struct(T371* C);
void r371c_type_for_target_in(T371* C,T0* a1);
T0* r371expanded_initializer(T371* C);
T0* r371actual_reference(T371* C,T0* a1);
T0* r371compute_mark(T0* a1);
T6 r371is_a_in(T371* C,T0* a1,T0* a2);
void r371demangling_in(T371* C,T0* a1);
void r371c_initialize_expanded(T371* C);
void r371standard_c_struct(T371* C);
T6 r371is_generic(T371* C);
T6 r371is_double(T371* C);
void r371id_extra_information(T0* a1);
T6 r371is_user_expanded(T371* C);
T6 r371is_a(T371* C,T0* a1);
T6 r371is_boolean(T371* C);
T0* r371to_runnable(T371* C,T0* a1);
void r371standard_c_object_model(T371* C);
T0* r371run_class(T371* C);
void r371c_header_pass3(T371* C);
T0* r371smallest_ancestor(T371* C,T0* a1);
T6 r371is_basic_eiffel_expanded(T371* C);
void r371gc_call_new_in(T371* C,T0* a1);
void r188make(T188* C,T0* a1);
void r188fatal_error(T0* a1);
T0* r188name_in_child(T188* C,T0* a1);
T0* r188name_in_parent(T188* C,T0* a1);
void r188get_started(T188* C,T0* a1);
T0* r300try_to_undefine_aux(T300* C,T0* a1,T0* a2);
void r300error(T104 a1,T0* a2);
T6 r300can_hide(T300* C,T0* a1,T0* a2);
void r300merge_header_comments(T300* C,T0* a1);
void r300add_into(T300* C,T0* a1);
T0* r300try_to_undefine(T300* C,T0* a1,T0* a2);
void r300make(T300* C,T0* a1,T0* a2,T0* a3);
void r300check_obsolete(T300* C,T104 a1);
T0* r300to_run_feature(T300* C,T0* a1,T0* a2);
T6 r300is_not_mergeable_with(T300* C,T0* a1);
T104 r300start_position(T300* C);
void r195add_into(T195* C,T0* a1);
void r195make(T195* C,T0* a1,T0* a2,T0* a3);
T6 r411affect(T411* C,T0* a1);
void r411make_all(T411* C,T0* a1);
void r411make(T411* C,T0* a1,T0* a2);
T0* r213type_any(void);
void r213error(T104 a1,T0* a2);
void r213compile_to_c(T213* C);
T6 r213stupid_switch(T213* C,T0* a1);
void r213make(T213* C,T104 a1,T0* a2);
void r213to_integer_error(T213* C);
void r213assertion_check(T213* C,T3 a1);
void r213afd_check(T213* C);
T6 r213use_current(T213* C);
void r213c_declare_for_old(T213* C);
void r213compile_to_c_old(T213* C);
void r213mapping_c_target(T213* C,T0* a1);
T2 r213to_integer_or_error(T213* C);
T6 r213is_pre_computable(T213* C);
T0* r213add_comment(T213* C,T0* a1);
T0* r213to_runnable(T213* C,T0* a1);
void r213collect_c_tmp(T213* C);
T0* r213static_result_base_class(void);
void r48append_token(T0* a1,T0* a2);
void r48set_c_compiler(T48* C,T0* a1);
T6 r48is_linking_mandatory(void);
extern T0*oBC48system_list;
void r48add_directory(T48* C,T0* a1,T0* a2);
extern T6 oBC48Scoptions_exists;
extern int fBC48Scoptions_exists;
T6 r48Scoptions_exists(void);
void r48no_split_mode_command(T48* C,T0* a1,T0* a2);
void r48add_x_suffix(T48* C,T0* a1);
T0* r48path_h(T48* C);
void r48external_c_files_for_lcc_win32(T48* C,T0* a1);
T2 r48extra_arg(T48* C,T0* a1,T2 a2,T0* a3);
extern T0*oBC48id_file_path;
extern int fBC48id_file_path;
T0* r48id_file_path(T48* C);
void r48loading_path_add(T48* C,T0* a1,T0* a2,T2 a3);
T6 r48strip_executable(T48* C,T0* a1);
void r48append_lp_in(T48* C,T0* a1,T0* a2);
void r48environment_variable_substitution(T48* C,T0* a1,T0* a2);
void r48read_loading_path_in(T48* C,T0* a1);
void r48split_mode_c_compiler_command(T48* C,T0* a1,T0* a2);
extern T0*oBC48make_suffix;
extern int fBC48make_suffix;
T0* r48make_suffix(T48* C);
extern T0*oBC48object_suffix;
extern int fBC48object_suffix;
T0* r48object_suffix(T48* C);
void r48make(T48* C);
void r48parent_directory(T48* C,T0* a1);
void r48show_compiler_list_then_exit(T48* C);
void r48add_output_name(T48* C,T0* a1);
T0* r48get_environment_variable(T48* C,T0* a1);
void r48put_mark_stack_and_registers(T48* C);
T6 r48slash_separator(T48* C);
void r48add_external_lib(T0* a1);
T6 r48is_c_plus_plus_file_path(T0* a1);
extern T86 oBC1file_tools;
extern T0*oBC48x_suffix;
extern int fBC48x_suffix;
T0* r48x_suffix(T48* C);
extern T0*oBC48compiler_list;
extern int fBC48add_lib_math;
void r48add_lib_math(T48* C);
void r48put_c_main_function_type(T48* C,T0* a1);
void r48add_external_lib_path(T0* a1);
void r48bad_use_exit(T48* C,T0* a1);
void r48add_objects(T48* C,T0* a1,T0* a2,T2 a3);
void r48put_c_main_function_exit(T48* C,T0* a1);
T6 r48backslash_separator(T48* C);
void r48sys_runtime(T48* C,T0* a1,T3 a2);
T0* r48sas_c_compiler_options(T6 a1);
void r48split_mode_linker_command(T48* C,T0* a1,T0* a2,T2 a3);
extern int fBC48add_lib_basic_gui;
void r48add_lib_basic_gui(void);
T0* r205check_assertion_mode(void);
void r205make_runnable(T205* C,T104 a1,T0* a2,T0* a3,T0* a4);
extern T0*oBC205c_code;
void r205compile_to_c(T205* C);
void r205add_into(T205* C,T0* a1);
void r205make(T205* C,T104 a1,T0* a2,T0* a3);
void r205afd_check(T205* C);
T6 r205is_always_true(T205* C);
void r205c_define(T205* C);
T0* r73up_to_original(T73* C,T0* a1,T0* a2);
T0* r73consider_export(T73* C,T0* a1);
T0* r73going_up(T73* C,T0* a1,T0* a2,T0* a3);
T0* r73get_new_name(T73* C,T0* a1);
extern T0*oBC73forbidden_parent_list;
T0* r73runnable_type(T73* C,T0* a1);
T0* r73look_up_for(T73* C,T0* a1,T0* a2);
T6 r73has_redefine(T73* C,T0* a1);
T0* r73has_undefine(T73* C,T0* a1);
T0* r73going_down(T73* C,T0* a1,T0* a2);
T0* r73clients_for(T73* C,T0* a1);
void r73add_rename(T73* C,T0* a1);
void r73select_conflict(T0* a1,T0* a2);
T6 r73is_a_vncg(T73* C,T0* a1,T0* a2);
void r73make(T73* C,T0* a1);
void r73fatal_error(T0* a1);
T0* r73original_name(T73* C,T0* a1,T0* a2);
T0* r73do_rename(T73* C,T0* a1);
void r73multiple_check(T73* C,T0* a1);
T0* r73e_feature(T73* C,T0* a1);
T0* r73precursor_for(T73* C,T0* a1,T0* a2);
T0* r73name_in_parent(T73* C,T0* a1);
T0* r73apply_undefine(T73* C,T0* a1,T0* a2);
T6 r73has_select_for(T73* C,T0* a1);
T0* r73get_old_name(T73* C,T0* a1);
void r73missing_select(T0* a1,T0* a2);
void r73get_started(T73* C,T0* a1);
T104 r73start_position(T73* C);
void r317print_else(T6 a1);
void r317error(T104 a1,T0* a2);
T2 r317compile_to_c(T317* C,T6 a1);
T6 r317stupid_switch(T317* C,T0* a1);
void r317make(T317* C,T0* a1,T0* a2);
void r317afd_check(T317* C);
T6 r317use_current(T317* C);
T0* r317to_runnable(T317* C,T0* a1);
void r317collect_c_tmp(T317* C);
T6 r57loop_check(T57* C);
T6 r57boost(T57* C);
T6 r57ensure_check(T57* C);
T6 r57debug_check(T57* C);
void r57compute_root_class(T57* C,T0* a1);
T6 r57require_check(T57* C);
void r57set_is_deep_equal_used(T57* C);
T0* r57string_aliaser(void);
T6 r57invariant_check(T57* C);
T0* r57root_procedure(T57* C);
T6 r57no_check(T57* C);
T6 r57all_check(T57* C);
void r367c_initialize_in(T0* a1);
void r367c_type_for_external_in(T0* a1);
T0* r367generic_list(T367* C);
extern T0*oBC367type_real_ref;
extern int fBC367type_real_ref;
T0* r367type_real_ref(void);
T0* r367written_mark(void);
T6 r367has_creation(T367* C,T0* a1);
T0* r367run_time_mark(void);
T2 r367c_sizeof(void);
void r367error(T104 a1,T0* a2);
T6 r367is_native_array(T367* C);
void r367gc_mark_in(T0* a1);
void r367fatal_error_generic_list(T367* C);
void r367c_type_for_argument_in(T0* a1);
void r367make(T367* C,T104 a1);
T0* r367base_class(T367* C);
extern int fBC367check_type;
void r367check_type(T367* C);
T0* r367actual_reference(T0* a1);
T6 r367is_a_in(T367* C,T0* a1,T0* a2);
void r367demangling_in(T0* a1);
void r367id_extra_information(T0* a1);
T6 r367is_a(T367* C,T0* a1);
void r367load_ref(T0* a1);
T0* r367to_runnable(T367* C,T0* a1);
T0* r367run_class(T367* C);
T0* r367smallest_ancestor(T367* C,T0* a1);
void r367gc_call_new_in(T0* a1);
void r203error(T104 a1,T0* a2);
void r203compile_to_c(T203* C);
void r203make(T203* C,T0* a1,T0* a2,T0* a3);
void r203afd_check(T203* C);
T6 r203is_always_true(T203* C);
T6 r203use_current(T203* C);
void r203c_declare_for_old(T203* C);
void r203compile_to_c_old(T203* C);
T6 r203is_pre_computable(T203* C);
T0* r203to_runnable(T203* C,T0* a1,T3 a2);
void r203collect_c_tmp(T203* C);
T104 r203start_position(T203* C);
void r245from_model(T245* C,T0* a1);
T2 r245count(T245* C);
T6 r245can_be_dropped(T245* C);
void r245error(T104 a1,T0* a2);
void r245put(T245* C,T0* a1,T2 a2);
void r245compile_to_c_ith(T245* C,T0* a1,T2 a2);
T6 r245is_static(T245* C);
void r245dca_inline_ith(T245* C,T0* a1,T2 a2);
void r245match_with(T245* C,T0* a1,T0* a2);
void r245compile_to_c(T245* C,T0* a1);
T6 r245stupid_switch(T245* C,T0* a1);
void r245make_n(T245* C,T0* a1,T0* a2);
T6 r245isa_dca_inline(T245* C,T0* a1,T0* a2);
void r245dca_inline(T245* C,T0* a1);
void r245assertion_check(T245* C,T3 a1);
void r245afd_check(T245* C);
T6 r245use_current(T245* C);
extern T0*oBC245isa_dca_inline_memory;
T0* r245expression(T245* C,T2 a1);
void r245c_declare_for_old(T245* C);
void r245compile_to_c_old(T245* C);
T6 r245is_pre_computable(T245* C);
T6 r245is_like_argument(T245* C,T0* a1,T0* a2,T0* a3);
T0* r245to_runnable(T245* C,T0* a1);
void r245collect_c_tmp(T245* C);
T104 r245start_position(T245* C);
T0* r393try_to_undefine_aux(T393* C,T0* a1,T0* a2);
void r393error(T104 a1,T0* a2);
T6 r393can_hide(T393* C,T0* a1,T0* a2);
void r393merge_header_comments(T393* C,T0* a1);
void r393add_into(T393* C,T0* a1);
void r393make_effective_routine(T393* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r393make_routine(T393* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r393try_to_undefine(T393* C,T0* a1,T0* a2);
void r393make(T393* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r393check_obsolete(T393* C,T104 a1);
T0* r393to_run_feature(T393* C,T0* a1,T0* a2);
void r393set_header_comment(T393* C,T0* a1);
T6 r393is_not_mergeable_with(T393* C,T0* a1);
T104 r393start_position(T393* C);
void r207make(T207* C,T0* a1,T104 a2);
void r231run_feature_match(T231* C,T0* a1);
T0* r231runnable_expression(T0* a1,T0* a2);
T6 r231call_proc_call_stupid_switch(T231* C,T0* a1);
T6 r231is_static(T231* C);
T0* r231operator(void);
void r231with(T231* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r231run_feature_has_result(T231* C);
T6 r231stupid_switch(T231* C,T0* a1);
void r231make(T231* C,T0* a1,T104 a2,T0* a3);
void r231fatal_error(T0* a1);
void r231to_integer_error(T231* C);
T0* r231arg1(T231* C);
void r231assertion_check(T231* C,T3 a1);
T0* r231result_type(T231* C);
void r231afd_check(T231* C);
T6 r231use_current(T231* C);
void r231c_declare_for_old(T231* C);
void r231compile_to_c_old(T231* C);
T0* r231runnable_args(T0* a1,T0* a2);
void r231mapping_c_target(T231* C,T0* a1);
T0* r231run_feature_for(T231* C,T0* a1,T0* a2);
T2 r231to_integer_or_error(T231* C);
T0* r231add_comment(T231* C,T0* a1);
T0* r231to_runnable(T231* C,T0* a1);
void r231collect_c_tmp(T231* C);
void r231finalize(T231* C);
T0* r231static_result_base_class(T231* C);
void r368gc_store_in(T0* a1);
void r368c_type_for_external_in(T0* a1);
T0* r368generic_list(T368* C);
T0* r368type_any(void);
T0* r368written_mark(void);
T6 r368has_creation(T368* C,T0* a1);
T0* r368run_time_mark(void);
void r368gc_store_chunk_in(T0* a1);
void r368standard_gc_define2(T368* C);
void r368standard_gc_define1(T368* C);
T6 r368is_native_array(T368* C);
void r368gc_mark_in(T0* a1);
T2 r368c_sizeof_pointer(void);
void r368standard_gc_info_in(T0* a1);
void r368fatal_error_generic_list(T368* C);
T0* r368type_string(void);
void r368make(T368* C,T104 a1);
extern int fBC368set_at_run_time;
void r368set_at_run_time(void);
T0* r368base_class(T368* C);
void r368gc_free_in(T0* a1);
T6 r368is_a_in(T368* C,T0* a1,T0* a2);
void r368demangling_in(T0* a1);
void r368gc_align_mark_in(T0* a1);
void r368standard_c_struct(T368* C);
void r368gc_initialize_chunk(T2 a1,T0* a2);
void r368id_extra_information(T0* a1);
T6 r368is_a(T368* C,T0* a1);
void r368standard_c_object_model(T368* C);
void r368gc_store_left_in(T0* a1);
T0* r368run_class(T368* C);
void r368c_header_pass4(T368* C);
void r368standard_just_before_gc_mark_in(T0* a1);
T0* r368smallest_ancestor(T368* C,T0* a1);
void r368gc_info_nb_in(T0* a1);
void r368gc_call_new_in(T0* a1);
void r77make(T77* C,T0* a1,T104 a2);
T6 r77is_subclass_of(T77* C,T0* a1);
T0* r77base_class(T77* C);
void r369c_initialize_in(T369* C,T0* a1);
void r369gc_store_in(T369* C,T0* a1);
void r369c_type_for_external_in(T369* C,T0* a1);
T0* r369generic_list(T369* C);
T6 r369has_creation(T369* C,T0* a1);
T2 r369c_sizeof(T369* C);
void r369gc_store_chunk_in(T369* C,T0* a1);
void r369c_type_for_result_in(T369* C,T0* a1);
void r369standard_gc_define2(T369* C);
void r369standard_gc_define1(T369* C);
T6 r369is_native_array(T369* C);
void r369gc_mark_in(T369* C,T0* a1);
void r369standard_gc_define2_for_expanded(T369* C);
void r369just_before_gc_mark_in(T369* C,T0* a1);
T2 r369id(T369* C);
T2 r369c_sizeof_pointer(void);
void r369mapping_cast(T369* C);
void r369standard_gc_info_in(T369* C,T0* a1);
void r369c_initialize(T369* C);
void r369standard_c_typedef(T369* C);
T6 r369need_gc_mark_function(T369* C);
void r369fatal_error_generic_list(T369* C);
void r369c_type_for_argument_in(T369* C,T0* a1);
void r369c_frame_descriptor(T369* C);
T6 r369is_expanded(T369* C);
void r369gc_info_in(T369* C,T0* a1);
T0* r369base_class(T369* C);
T6 r369is_dummy_expanded(T369* C);
void r369standard_c_print_function(T369* C);
T6 r369is_reference(T369* C);
T6 r369need_c_struct(T369* C);
void r369gc_define1(T369* C);
void r369gc_define2(T369* C);
void r369c_type_for_target_in(T369* C,T0* a1);
T0* r369expanded_initializer(T369* C);
T0* r369actual_reference(T369* C,T0* a1);
void r369gc_free_in(T369* C,T0* a1);
T6 r369is_a_in(T369* C,T0* a1,T0* a2);
void r369demangling_in(T369* C,T0* a1);
void r369gc_align_mark_in(T369* C,T0* a1);
void r369c_initialize_expanded(T369* C);
void r369standard_c_struct(T369* C);
extern T0*oBC369check_memory;
void r369gc_initialize_chunk(T369* C,T2 a1,T0* a2);
void r369id_extra_information(T369* C,T0* a1);
T6 r369is_a(T369* C,T0* a1);
T0* r369to_runnable(T369* C,T0* a1);
void r369standard_c_object_model(T369* C);
void r369gc_store_left_in(T369* C,T0* a1);
T0* r369run_class(T369* C);
void r369c_header_pass3(T369* C);
void r369c_header_pass4(T369* C);
void r369standard_just_before_gc_mark_in(T369* C,T0* a1);
T0* r369smallest_ancestor(T369* C,T0* a1);
void r369gc_info_nb_in(T369* C,T0* a1);
void r369gc_call_new_in(T369* C,T0* a1);
void r256run_feature_match(T256* C,T0* a1);
T0* r256runnable_expression(T0* a1,T0* a2);
T6 r256call_proc_call_stupid_switch(T256* C,T0* a1);
T0* r256make_runnable(T256* C,T0* a1,T0* a2,T0* a3);
void r256with(T256* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r256run_feature_has_no_result(T256* C);
void r256compile_to_c(T256* C);
T6 r256stupid_switch(T256* C,T0* a1);
void r256make(T256* C,T0* a1,T0* a2,T0* a3);
void r256fatal_error(T0* a1);
void r256afd_check(T256* C);
T6 r256use_current(T256* C);
T0* r256runnable_args(T0* a1,T0* a2);
T0* r256run_feature_for(T256* C,T0* a1,T0* a2);
T0* r256add_comment(T256* C,T0* a1);
T2 r256arg_count(T256* C);
T0* r256to_runnable(T256* C,T0* a1);
void r256collect_c_tmp(T256* C);
void r256finalize(T256* C);
T104 r256start_position(T256* C);
void r255run_feature_match(T255* C,T0* a1);
T0* r255runnable_expression(T0* a1,T0* a2);
T6 r255call_proc_call_stupid_switch(T255* C,T0* a1);
T0* r255make_runnable(T255* C,T0* a1,T0* a2,T0* a3);
void r255with(T255* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r255run_feature_has_no_result(T255* C);
void r255compile_to_c(T255* C);
T6 r255stupid_switch(T255* C,T0* a1);
void r255make(T255* C,T0* a1,T0* a2,T0* a3);
void r255fatal_error(T0* a1);
T0* r255arg1(T255* C);
void r255afd_check(T255* C);
T6 r255use_current(T255* C);
T6 r255standard_use_current(T255* C);
T0* r255runnable_args(T0* a1,T0* a2);
T0* r255run_feature_for(T255* C,T0* a1,T0* a2);
T0* r255add_comment(T255* C,T0* a1);
T0* r255to_runnable(T255* C,T0* a1);
void r255collect_c_tmp(T255* C);
void r255finalize(T255* C);
T104 r255start_position(T255* C);
void r166run_feature_match(T166* C);
T0* r166runnable_expression(T0* a1,T0* a2);
T6 r166call_proc_call_stupid_switch(T166* C,T0* a1);
T0* r166make_runnable(T166* C,T0* a1,T0* a2,T0* a3);
void r166run_feature_has_no_result(T166* C);
void r166compile_to_c(T166* C);
T6 r166stupid_switch(T166* C,T0* a1);
void r166make(T166* C,T0* a1,T0* a2);
void r166fatal_error(T0* a1);
void r166afd_check(T166* C);
T6 r166use_current(T166* C);
T0* r166run_feature_for(T166* C,T0* a1,T0* a2);
T0* r166add_comment(T166* C,T0* a1);
T0* r166to_runnable(T166* C,T0* a1);
void r166collect_c_tmp(T166* C);
void r166finalize(T166* C);
T104 r166start_position(T166* C);
void r159from_compound(T159* C,T0* a1);
T2 r159count(T159* C);
void r159put(T159* C,T0* a1,T2 a2);
T0* r159item(T159* C,T2 a1);
void r159compile_to_c(T159* C);
T6 r159stupid_switch(T159* C,T0* a1);
void r159make(T159* C,T0* a1,T0* a2,T0* a3);
void r159fatal_error(T0* a1);
void r159afd_check(T159* C);
T6 r159use_current(T159* C);
T6 r159is_pre_computable(T159* C);
T0* r159to_runnable(T159* C,T0* a1);
T104 r159start_position(T159* C);
extern T0*oBC365unique_base_class_memory;
extern int fBC365unique_base_class_memory;
T0* r365unique_base_class_memory(void);
void r365c_type_for_external_in(T0* a1);
T0* r365generic_list(T365* C);
T0* r365written_mark(void);
T6 r365has_creation(T365* C,T0* a1);
T0* r365run_time_mark(void);
void r365error(T104 a1,T0* a2);
T6 r365is_native_array(T365* C);
void r365gc_mark_in(T0* a1);
T2 r365c_sizeof_pointer(void);
void r365fatal_error_generic_list(T365* C);
void r365make(T365* C,T104 a1);
T0* r365base_class(T365* C);
T6 r365is_a_in(T365* C,T0* a1,T0* a2);
void r365demangling_in(T0* a1);
void r365id_extra_information(T0* a1);
T0* r365run_class(T365* C);
T0* r365smallest_ancestor(T0* a1);
void r365gc_call_new_in(T0* a1);
void r43disconnect(T43* C);
void r43read_character(T43* C);
void r43skip_separators(T43* C);
void r43read_line_in(T43* C,T0* a1);
T6 r43end_of_input(T43* C);
T6 r43same_as(T43* C,T0* a1);
void r43connect_to(T43* C,T0* a1);
void r43read_word(T43* C);
void r43read_line(T43* C);
extern T0*oBC44last_string;
void r235error(T104 a1,T0* a2);
void r235make(T235* C,T0* a1,T104 a2);
void r235undefine_in(T235* C,T0* a1);
T0* r235string_aliaser(void);
void r235declaration_in(T235* C,T0* a1);
T0* r235origin_base_class(T235* C);
void r362c_initialize_in(T0* a1);
void r362c_type_for_external_in(T0* a1);
T0* r362generic_list(T362* C);
T0* r362written_mark(void);
T6 r362has_creation(T362* C,T0* a1);
T0* r362run_time_mark(void);
void r362error(T104 a1,T0* a2);
T6 r362is_native_array(T362* C);
void r362gc_mark_in(T0* a1);
void r362fatal_error_generic_list(T362* C);
void r362c_type_for_argument_in(T0* a1);
void r362make(T362* C,T104 a1);
T0* r362base_class(T362* C);
extern int fBC362check_type;
void r362check_type(T362* C);
T0* r362actual_reference(T0* a1);
T6 r362is_a_in(T362* C,T0* a1,T0* a2);
void r362demangling_in(T0* a1);
extern T0*oBC362type_character_ref;
extern int fBC362type_character_ref;
T0* r362type_character_ref(void);
void r362id_extra_information(T0* a1);
T6 r362is_a(T362* C,T0* a1);
void r362load_ref(T0* a1);
T0* r362to_runnable(T362* C,T0* a1);
T0* r362run_class(T362* C);
T0* r362smallest_ancestor(T362* C,T0* a1);
void r362gc_call_new_in(T0* a1);
void r357gc_store_in(T357* C,T0* a1);
void r357c_type_for_external_in(T0* a1);
T6 r357has_creation(T357* C,T0* a1);
T0* r357run_time_mark(T357* C);
void r357gc_store_chunk_in(T357* C,T0* a1);
void r357set_generic_list_with(T357* C,T0* a1);
void r357standard_gc_define2(T357* C);
void r357standard_gc_define1(T357* C);
T6 r357is_native_array(T357* C);
void r357gc_mark_in(T357* C,T0* a1);
void r357with(T357* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r357load_basic_features(T357* C);
T2 r357id(T357* C);
T2 r357c_sizeof_pointer(void);
void r357mapping_cast(T357* C);
void r357standard_gc_info_in(T357* C,T0* a1);
void r357standard_c_typedef(T357* C);
T6 r357stupid_switch(T357* C,T0* a1);
void r357c_frame_descriptor(T357* C);
void r357make(T357* C,T104 a1,T0* a2);
T0* r357run_type(T357* C);
void r357fatal_error(T0* a1);
extern T0*oBC357tmp_written_mark;
T0* r357string_aliaser(void);
T0* r357base_class(T357* C);
void r357standard_c_print_function(T357* C);
void r357final(T357* C,T0* a1,T0* a2,T0* a3);
void r357c_type_for_target_in(T357* C,T0* a1);
void r357gc_free_in(T357* C,T0* a1);
T6 r357is_a_in(T357* C,T0* a1,T0* a2);
void r357demangling_in(T357* C,T0* a1);
void r357gc_align_mark_in(T357* C,T0* a1);
void r357standard_c_struct(T357* C);
void r357gc_initialize_chunk(T357* C,T2 a1,T0* a2);
void r357id_extra_information(T0* a1);
T6 r357is_a(T357* C,T0* a1);
T0* r357to_runnable(T357* C,T0* a1);
void r357standard_c_object_model(T357* C);
void r357gc_store_left_in(T357* C,T0* a1);
T0* r357run_class(T357* C);
T6 r357is_run_type(T357* C);
void r357c_header_pass4(T357* C);
void r357standard_just_before_gc_mark_in(T357* C,T0* a1);
T0* r357smallest_ancestor(T357* C,T0* a1);
void r357gc_info_nb_in(T357* C,T0* a1);
void r357gc_call_new_in(T357* C,T0* a1);
void r420add_last(T420* C,T0* a1);
void r242run_feature_match(T242* C);
T6 r242can_be_dropped(T242* C);
T0* r242runnable_expression(T0* a1,T0* a2);
T6 r242call_proc_call_stupid_switch(T242* C,T0* a1);
T6 r242is_static(T242* C);
T0* r242operator(void);
void r242with(T242* C,T0* a1,T0* a2,T0* a3);
void r242run_feature_has_result(T242* C);
void r242compile_to_c(T242* C);
T6 r242stupid_switch(T242* C,T0* a1);
void r242make(T242* C,T104 a1,T0* a2);
void r242fatal_error(T0* a1);
void r242to_integer_error(T242* C);
T2 r242isa_dca_inline_argument(T242* C);
void r242dca_inline_argument(T242* C,T0* a1);
void r242assertion_check(T242* C,T3 a1);
T0* r242result_type(T242* C);
void r242afd_check(T242* C);
T6 r242use_current(T242* C);
T2 r242static_value(T242* C);
void r242c_declare_for_old(T242* C);
void r242compile_to_c_old(T242* C);
void r242mapping_c_target(T242* C,T0* a1);
T0* r242run_feature_for(T242* C,T0* a1,T0* a2);
T2 r242to_integer_or_error(T242* C);
T0* r242add_comment(T242* C,T0* a1);
T0* r242to_runnable(T242* C,T0* a1);
void r242collect_c_tmp(T242* C);
void r242finalize(T242* C);
T0* r242static_result_base_class(T242* C);
T0* r396try_to_undefine_aux(T396* C,T0* a1,T0* a2);
void r396error(T104 a1,T0* a2);
T6 r396can_hide(T396* C,T0* a1,T0* a2);
void r396merge_header_comments(T396* C,T0* a1);
void r396add_into(T396* C,T0* a1);
void r396make_effective_routine(T396* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r396make_routine(T396* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r396try_to_undefine(T396* C,T0* a1,T0* a2);
void r396make(T396* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r396check_obsolete(T396* C,T104 a1);
T0* r396to_run_feature(T396* C,T0* a1,T0* a2);
void r396set_header_comment(T396* C,T0* a1);
T6 r396is_not_mergeable_with(T396* C,T0* a1);
T104 r396start_position(T396* C);
T0* r519run_ensure(T519* C);
void r519define_prototype(T519* C);
void r519fe_vffd7(T519* C);
T0* r519run_require(T519* C);
T6 r519is_exported_in(T519* C,T0* a1);
extern T0*oBC96c_code;
T2 r519id(T519* C);
void r519mapping_c(T519* C);
void r519c_frame_descriptor_name_in(T519* C,T0* a1);
void r519mapping_name(T519* C);
T6 r519is_once_function(T519* C);
void r519put_c_name_tag(T519* C);
T0* r519stupid_switch(T519* C,T0* a1);
void r519std_compute_use_current(T519* C);
void r519c_frame_descriptor(T519* C);
void r519make(T519* C,T0* a1,T0* a2,T0* a3);
void r519fatal_error(T0* a1);
void r519routine_afd_check(T519* C);
T6 r519use_current(T519* C);
void r519std_compute_stupid_switch(T519* C,T0* a1);
void r519c_define_opening(T519* C);
void r519c_initialize_ds_one_by_one(T519* C);
void r519c_assertion_flag(T519* C);
void r519c_define(T519* C);
T6 r519is_pre_computable(T519* C);
void r519initialize(T519* C);
T0* r519clients(T519* C);
void r519collect_c_tmp(T519* C);
T104 r519start_position(T519* C);
void r519c_define_closing(T519* C);
void r519default_mapping_function(T519* C);
T0* r526run_ensure(T526* C);
void r526define_prototype(T526* C);
void r526default_mapping_procedure(T526* C);
T0* r526run_require(T526* C);
T6 r526is_exported_in(T526* C,T0* a1);
T2 r526id(T526* C);
T6 r526is_once_procedure(T526* C);
void r526c_frame_descriptor_name_in(T526* C,T0* a1);
void r526mapping_name(T526* C);
void r526put_c_name_tag(T526* C);
T0* r526stupid_switch(T526* C,T0* a1);
void r526std_compute_use_current(T526* C);
void r526c_frame_descriptor(T526* C);
void r526make(T526* C,T0* a1,T0* a2,T0* a3);
void r526fatal_error(T0* a1);
void r526routine_afd_check(T526* C);
T6 r526use_current(T526* C);
void r526std_compute_stupid_switch(T526* C,T0* a1);
void r526c_define_opening(T526* C);
void r526c_initialize_ds_one_by_one(T526* C);
void r526c_assertion_flag(T526* C);
void r526c_define(T526* C);
void r526initialize(T526* C);
T0* r526clients(T526* C);
T104 r526start_position(T526* C);
void r526c_define_closing(T526* C);
void r526default_mapping_function(T526* C);
T0* r119try_to_undefine_aux(T119* C,T0* a1,T0* a2);
void r119error(T104 a1,T0* a2);
T6 r119can_hide(T119* C,T0* a1,T0* a2);
void r119make_external_routine(T119* C,T0* a1,T0* a2);
void r119merge_header_comments(T119* C,T0* a1);
void r119add_into(T119* C,T0* a1);
void r119make_routine(T119* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r119try_to_undefine(T119* C,T0* a1,T0* a2);
void r119make(T119* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r119check_obsolete(T119* C,T104 a1);
T6 r119use_current(T119* C);
T0* r119external_name(T119* C);
T0* r119to_run_feature(T119* C,T0* a1,T0* a2);
void r119set_header_comment(T119* C,T0* a1);
T6 r119is_not_mergeable_with(T119* C,T0* a1);
T104 r119start_position(T119* C);
void r119set_rescue_compound(T119* C,T0* a1);
T0* r119c_plus_plus_name(T119* C);
void r232run_feature_match(T232* C,T0* a1);
T0* r232runnable_expression(T0* a1,T0* a2);
T6 r232call_proc_call_stupid_switch(T232* C,T0* a1);
T6 r232is_static(T232* C);
T0* r232operator(void);
void r232with(T232* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r232run_feature_has_result(T232* C);
T6 r232stupid_switch(T232* C,T0* a1);
void r232make(T232* C,T0* a1,T104 a2,T0* a3);
void r232fatal_error(T0* a1);
void r232to_integer_error(T232* C);
T0* r232arg1(T232* C);
void r232assertion_check(T232* C,T3 a1);
T0* r232result_type(T232* C);
void r232afd_check(T232* C);
T6 r232use_current(T232* C);
void r232c_declare_for_old(T232* C);
void r232compile_to_c_old(T232* C);
T0* r232runnable_args(T0* a1,T0* a2);
void r232mapping_c_target(T232* C,T0* a1);
T0* r232run_feature_for(T232* C,T0* a1,T0* a2);
T2 r232to_integer_or_error(T232* C);
T0* r232add_comment(T232* C,T0* a1);
T0* r232to_runnable(T232* C,T0* a1);
void r232collect_c_tmp(T232* C);
void r232finalize(T232* C);
T0* r232static_result_base_class(T232* C);
T6 r390stupid_switch_function(T0* a1,T0* a2);
void r390fatal_error(T0* a1);
T6 r390stupid_switch_procedure(T0* a1,T0* a2);
void r390fe_c2c(T0* a1);
void r139gc_store_in(T139* C,T0* a1);
extern T0*oBC139unique_base_class_memory;
extern int fBC139unique_base_class_memory;
T0* r139unique_base_class_memory(void);
void r139c_type_for_external_in(T0* a1);
T2 r139count(T139* C);
void r139gc_store_chunk_in(T139* C,T0* a1);
void r139standard_gc_define2(T139* C);
void r139standard_gc_define1(T139* C);
T6 r139is_native_array(T139* C);
void r139gc_mark_in(T139* C,T0* a1);
void r139load_basic_features(T139* C);
T2 r139id(T139* C);
void r139fatal_not_yet_implemented(T139* C,T0* a1);
T2 r139c_sizeof_pointer(void);
void r139mapping_cast(T139* C);
void r139standard_gc_info_in(T139* C,T0* a1);
void r139standard_c_typedef(T139* C);
T6 r139stupid_switch(T139* C,T0* a1);
void r139c_frame_descriptor(T139* C);
void r139make(T139* C,T104 a1,T0* a2);
T0* r139string_aliaser(void);
T0* r139base_class(T139* C);
void r139standard_c_print_function(T139* C);
T6 r139need_c_struct(T139* C);
extern T0*oBC139compute_mark_buffer;
void r139c_type_for_target_in(T139* C,T0* a1);
T0* r139compute_mark(T0* a1);
void r139gc_free_in(T139* C,T0* a1);
T6 r139is_a_in(T139* C,T0* a1,T0* a2);
void r139demangling_in(T139* C,T0* a1);
void r139gc_align_mark_in(T139* C,T0* a1);
void r139standard_c_struct(T139* C);
void r139gc_initialize_chunk(T139* C,T2 a1,T0* a2);
void r139id_extra_information(T0* a1);
T6 r139is_a(T139* C,T0* a1);
T0* r139to_runnable(T139* C,T0* a1);
void r139standard_c_object_model(T139* C);
void r139gc_store_left_in(T139* C,T0* a1);
T0* r139run_class(T139* C);
void r139c_header_pass4(T139* C);
void r139standard_just_before_gc_mark_in(T139* C,T0* a1);
T0* r139smallest_ancestor(T139* C,T0* a1);
void r139gc_info_nb_in(T139* C,T0* a1);
void r139gc_call_new_in(T139* C,T0* a1);
void r366c_initialize_in(T0* a1);
void r366c_type_for_external_in(T0* a1);
T0* r366generic_list(T366* C);
T0* r366written_mark(void);
T6 r366has_creation(T366* C,T0* a1);
T0* r366run_time_mark(void);
void r366error(T104 a1,T0* a2);
T6 r366is_native_array(T366* C);
void r366gc_mark_in(T0* a1);
T2 r366c_sizeof_pointer(void);
void r366fatal_error_generic_list(T366* C);
void r366c_type_for_argument_in(T0* a1);
void r366make(T366* C,T104 a1);
T0* r366base_class(T366* C);
extern T0*oBC366type_pointer_ref;
extern int fBC366type_pointer_ref;
T0* r366type_pointer_ref(void);
extern int fBC366check_type;
void r366check_type(T366* C);
T0* r366actual_reference(T0* a1);
T6 r366is_a_in(T366* C,T0* a1,T0* a2);
void r366demangling_in(T0* a1);
void r366id_extra_information(T0* a1);
T6 r366is_a(T366* C,T0* a1);
void r366load_ref(T0* a1);
T0* r366to_runnable(T366* C,T0* a1);
T0* r366run_class(T366* C);
T0* r366smallest_ancestor(T366* C,T0* a1);
void r366gc_call_new_in(T0* a1);
void r437fe_vffd7(T437* C);
T6 r437is_exported_in(T437* C,T0* a1);
T6 r437is_static(T437* C);
T2 r437id(T437* C);
void r437mapping_c(T437* C);
void r437c_frame_descriptor_name_in(T437* C,T0* a1);
T2 r437static_value_mem(T437* C);
T0* r437stupid_switch(T437* C,T0* a1);
void r437make(T437* C,T0* a1,T0* a2,T0* a3);
void r437fatal_error(T0* a1);
T6 r437use_current(T437* C);
void r437compute_stupid_switch(T437* C,T0* a1);
void r437c_assertion_flag(T437* C);
void r437address_of_c_define(T437* C,T0* a1);
void r437fall_down(T437* C);
void r437initialize(T437* C);
T0* r437clients(T437* C);
T104 r437start_position(T437* C);
void r152fe_vffd7(T152* C);
T6 r152is_exported_in(T152* C,T0* a1);
T2 r152id(T152* C);
void r152mapping_c(T152* C);
void r152c_frame_descriptor_name_in(T152* C,T0* a1);
T0* r152stupid_switch(T152* C,T0* a1);
void r152make(T152* C,T0* a1,T0* a2,T0* a3);
void r152fatal_error(T0* a1);
void r152afd_check(T152* C);
T6 r152use_current(T152* C);
void r152compute_stupid_switch(T152* C,T0* a1);
void r152c_assertion_flag(T152* C);
void r152address_of_c_mapping(T152* C);
void r152fall_down(T152* C);
void r152initialize(T152* C);
T0* r152clients(T152* C);
void r152collect_c_tmp(T152* C);
T6 r154dca(T154* C);
T6 r154isa_in_line(T154* C);
T6 r154direct_call(T154* C);
T0* r154run_ensure(T154* C);
T0* r154body_one_dpca(T154* C);
T6 r154do_not_use_current(T154* C);
void r154define_prototype(T154* C);
void r154default_mapping_procedure(T154* C);
T0* r154run_require(T154* C);
T6 r154is_exported_in(T154* C,T0* a1);
T0* r154memory_dispose(T154* C);
T2 r154id(T154* C);
void r154in_line(T154* C);
void r154address_of_wrapper_name_in(T154* C,T0* a1);
void r154mapping_c(T154* C);
void r154c_frame_descriptor_name_in(T154* C,T0* a1);
extern T0*oBC154tmp_string;
void r154mapping_name(T154* C);
T6 r154is_empty_or_null_body(T154* C);
void r154put_c_name_tag(T154* C);
T0* r154stupid_switch(T154* C,T0* a1);
void r154std_compute_use_current(T154* C);
void r154address_of_c_mapping_wrapper(T154* C);
void r154c_frame_descriptor(T154* C);
void r154make(T154* C,T0* a1,T0* a2,T0* a3);
T6 r154empty_or_null_body(T154* C);
void r154fatal_error(T0* a1);
void r154routine_afd_check(T154* C);
T6 r154use_current(T154* C);
void r154compute_use_current(T154* C);
void r154std_compute_stupid_switch(T154* C,T0* a1);
T6 r154one_pc(T154* C);
void r154c_define_opening(T154* C);
T6 r154need_local_vars(T154* C);
void r154c_initialize_ds_one_by_one(T154* C);
void r154c_assertion_flag(T154* C);
T6 r154attribute_writer(T154* C);
void r154address_of_c_mapping(T154* C);
void r154c_define(T154* C);
void r154address_of_c_define(T154* C,T0* a1);
T6 r154is_pre_computable(T154* C);
void r154fall_down(T154* C);
void r154initialize(T154* C);
T0* r154clients(T154* C);
void r154address_of_c_define_wrapper(T154* C,T0* a1);
T0* r154default_rescue_compound(T154* C);
void r154default_mapping_function(T154* C);
void r154c_define_closing(T154* C);
T6 r523dca(T523* C);
T6 r523isa_in_line(T523* C);
T6 r523direct_call(T523* C);
T0* r523run_ensure(T523* C);
T6 r523can_be_dropped(T523* C);
void r523define_prototype(T523* C);
void r523fe_vffd7(T523* C);
T0* r523run_require(T523* C);
T6 r523is_exported_in(T523* C,T0* a1);
T6 r523direct_cse_call(T523* C);
T6 r523is_static(T523* C);
T6 r523a_eq_neq(T523* C);
T2 r523id(T523* C);
T0* r523body_one_dc_pco(T523* C);
T0* r523body_one_result(T523* C);
void r523in_line(T523* C);
T6 r523result_is_current(T523* C);
void r523address_of_wrapper_name_in(T523* C,T0* a1);
void r523mapping_c(T523* C);
void r523c_frame_descriptor_name_in(T523* C,T0* a1);
extern T0*oBC523tmp_string;
void r523mapping_name(T523* C);
T6 r523attribute_reader(T523* C);
void r523put_c_name_tag(T523* C);
T0* r523stupid_switch(T523* C,T0* a1);
void r523std_compute_use_current(T523* C);
void r523address_of_c_mapping_wrapper(T523* C);
void r523c_frame_descriptor(T523* C);
void r523make(T523* C,T0* a1,T0* a2,T0* a3);
T6 r523empty_or_null_body(T523* C);
void r523fatal_error(T0* a1);
void r523routine_afd_check(T523* C);
T6 r523use_current(T523* C);
void r523compute_use_current(T523* C);
void r523std_compute_stupid_switch(T523* C,T0* a1);
void r523c_define_opening(T523* C);
void r523c_initialize_ds_one_by_one(T523* C);
void r523c_assertion_flag(T523* C);
void r523address_of_c_mapping(T523* C);
T0* r523body_one_result_dca(T523* C);
void r523c_define(T523* C);
T6 r523value_reader(T523* C);
void r523address_of_c_define(T523* C,T0* a1);
void r523fall_down(T523* C);
void r523initialize(T523* C);
T0* r523clients(T523* C);
void r523address_of_c_define_wrapper(T523* C,T0* a1);
void r523collect_c_tmp(T523* C);
T0* r523default_rescue_compound(T523* C);
T6 r523dc_pco1(T523* C);
T6 r523dc_pco2(T523* C);
void r523c_define_closing(T523* C);
void r523default_mapping_function(T523* C);
T0* r524run_ensure(T524* C);
void r524define_prototype(T524* C);
void r524default_mapping_procedure(T524* C);
T0* r524run_require(T524* C);
T6 r524is_exported_in(T524* C,T0* a1);
T2 r524id(T524* C);
void r524address_of_wrapper_name_in(T524* C,T0* a1);
void r524c_frame_descriptor_name_in(T524* C,T0* a1);
void r524mapping_name(T524* C);
void r524put_c_name_tag(T524* C);
T0* r524stupid_switch(T524* C,T0* a1);
void r524std_compute_use_current(T524* C);
void r524address_of_c_mapping_wrapper(T524* C);
void r524c_frame_descriptor(T524* C);
void r524make(T524* C,T0* a1,T0* a2,T0* a3);
void r524fatal_error(T0* a1);
void r524routine_afd_check(T524* C);
T6 r524use_current(T524* C);
void r524std_compute_stupid_switch(T524* C,T0* a1);
void r524c_define_opening(T524* C);
void r524c_initialize_ds_one_by_one(T524* C);
void r524c_assertion_flag(T524* C);
void r524address_of_c_mapping(T524* C);
void r524c_define(T524* C);
void r524address_of_c_define(T524* C,T0* a1);
void r524fall_down(T524* C);
void r524initialize(T524* C);
T0* r524clients(T524* C);
void r524address_of_c_define_wrapper(T524* C,T0* a1);
T0* r524default_rescue_compound(T524* C);
void r524c_define_closing(T524* C);
void r524default_mapping_function(T524* C);
T0* r525run_ensure(T525* C);
void r525define_prototype(T525* C);
void r525fe_vffd7(T525* C);
T0* r525run_require(T525* C);
T6 r525is_exported_in(T525* C,T0* a1);
T2 r525id(T525* C);
void r525address_of_wrapper_name_in(T525* C,T0* a1);
void r525mapping_c(T525* C);
void r525c_frame_descriptor_name_in(T525* C,T0* a1);
void r525mapping_name(T525* C);
void r525put_c_name_tag(T525* C);
T0* r525stupid_switch(T525* C,T0* a1);
void r525std_compute_use_current(T525* C);
void r525address_of_c_mapping_wrapper(T525* C);
void r525c_frame_descriptor(T525* C);
void r525make(T525* C,T0* a1,T0* a2,T0* a3);
void r525fatal_error(T0* a1);
void r525routine_afd_check(T525* C);
T6 r525use_current(T525* C);
void r525std_compute_stupid_switch(T525* C,T0* a1);
void r525c_define_opening(T525* C);
void r525c_initialize_ds_one_by_one(T525* C);
void r525c_assertion_flag(T525* C);
void r525address_of_c_mapping(T525* C);
void r525c_define(T525* C);
void r525address_of_c_define(T525* C,T0* a1);
void r525fall_down(T525* C);
T6 r525is_pre_computable(T525* C);
void r525initialize(T525* C);
T0* r525clients(T525* C);
void r525address_of_c_define_wrapper(T525* C,T0* a1);
void r525collect_c_tmp(T525* C);
T0* r525default_rescue_compound(T525* C);
void r525c_define_closing(T525* C);
void r525default_mapping_function(T525* C);
T0* r115run_ensure(T115* C);
void r115define_prototype(T115* C);
void r115default_mapping_procedure(T115* C);
T0* r115run_require(T115* C);
void r115c_plus_plus_prototype(T115* C,T0* a1);
T6 r115is_exported_in(T115* C,T0* a1);
T2 r115id(T115* C);
void r115mapping_c(T115* C);
void r115c_frame_descriptor_name_in(T115* C,T0* a1);
void r115external_prototype(T115* C,T0* a1);
void r115mapping_name(T115* C);
void r115put_c_name_tag(T115* C);
void r115std_compute_use_current(T115* C);
T0* r115stupid_switch(T115* C,T0* a1);
void r115c_frame_descriptor(T115* C);
void r115make(T115* C,T0* a1,T0* a2,T0* a3);
void r115fatal_error(T0* a1);
extern T0*oBC96c_plus_plus_prototype_buffer;
void r115routine_afd_check(T115* C);
T6 r115use_current(T115* C);
void r115compute_use_current(T115* C);
void r115c_define_opening(T115* C);
void r115compute_stupid_switch(T115* C,T0* a1);
void r115c_initialize_ds_one_by_one(T115* C);
void r115c_define_with_body(T115* C,T0* a1);
void r115c_assertion_flag(T115* C);
void r115external_prototype_for(T115* C,T0* a1,T0* a2);
void r115c_define(T115* C);
void r115fall_down(T115* C);
void r115initialize(T115* C);
T2 r115arg_count(T115* C);
T0* r115clients(T115* C);
void r115c_define_closing(T115* C);
void r115default_mapping_function(T115* C);
T0* r95run_ensure(T95* C);
T0* r95type_any(void);
void r95define_prototype(T95* C);
void r95fe_vffd7(T95* C);
T0* r95run_require(T95* C);
void r95c_plus_plus_prototype(T95* C,T0* a1);
T6 r95is_exported_in(T95* C,T0* a1);
T6 r95is_static(T95* C);
T2 r95id(T95* C);
void r95c_closing(T95* C);
void r95mapping_c(T95* C);
void r95c_frame_descriptor_name_in(T95* C,T0* a1);
void r95external_prototype(T95* C,T0* a1);
void r95mapping_name(T95* C);
void r95put_c_name_tag(T95* C);
void r95std_compute_use_current(T95* C);
T0* r95stupid_switch(T95* C,T0* a1);
void r95c_frame_descriptor(T95* C);
T0* r95type_string(void);
void r95make(T95* C,T0* a1,T0* a2,T0* a3);
void r95fatal_error(T0* a1);
void r95routine_afd_check(T95* C);
T2 r95integer_value(T95* C,T104 a1);
T6 r95use_current(T95* C);
void r95compute_use_current(T95* C);
void r95c_define_opening(T95* C);
void r95compute_stupid_switch(T95* C,T0* a1);
void r95c_initialize_ds_one_by_one(T95* C);
void r95c_define_with_body(T95* C,T0* a1);
void r95c_assertion_flag(T95* C);
void r95external_prototype_for(T95* C,T0* a1,T0* a2);
void r95c_define(T95* C);
void r95fall_down(T95* C);
void r95initialize(T95* C);
T2 r95arg_count(T95* C);
void r95c_opening(T95* C);
T0* r95clients(T95* C);
void r95default_mapping_function(T95* C);
void r95c_define_closing(T95* C);
void r384error(T104 a1,T0* a2);
void r384from_effective(T384* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T6 r384can_hide(T384* C,T0* a1,T0* a2);
void r384merge_header_comments(T384* C,T0* a1);
void r384add_into(T384* C,T0* a1);
void r384make_routine(T384* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
T0* r384try_to_undefine(T384* C,T0* a1,T0* a2);
void r384make(T384* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r384check_obsolete(T384* C,T104 a1);
T0* r384to_run_feature(T384* C,T0* a1,T0* a2);
void r384set_header_comment(T384* C,T0* a1);
T6 r384is_not_mergeable_with(T384* C,T0* a1);
T104 r384start_position(T384* C);
void r384set_rescue_compound(T384* C,T0* a1);
void r385body_long_bit_put01(T0* a1,T3 a2,T3 a3,T3 a4);
void r385c_define_standard_twin(T0* a1,T0* a2);
void r385mapping_small_bit_put01(T0* a1,T3 a2,T3 a3,T2 a4);
T6 r385stupid_switch_function(T0* a1,T0* a2);
T0* r385system_tools(void);
void r385c_define_function(T0* a1,T0* a2,T0* a3);
void r385c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r385c_mapping_integer_function(T0* a1,T0* a2);
void r385c_define_procedure(T0* a1,T0* a2,T0* a3);
extern T0*oBC385tmp_string;
void r385c_define_procedure_bit(T0* a1,T0* a2);
void r385c_mapping_bit_function(T0* a1,T0* a2);
T6 r385stupid_switch_procedure(T0* a1,T0* a2);
T6 r385use_current(T0* a1);
void r385c_define_function_bit(T0* a1,T0* a2);
void r385c_mapping_real_function(T0* a1,T0* a2);
void r385c_mapping_bit_procedure(T0* a1,T0* a2);
void r385c_mapping_double_function(T0* a1,T0* a2);
void r385c_mapping_function(T0* a1,T0* a2,T0* a3);
void r385c_mapping_native_array_procedure(T0* a1,T0* a2);
void r385c_mapping_native_array_function(T0* a1,T0* a2);
void r385c_mapping_standard_twin(T0* a1,T0* a2);
void r385fe_long_bit(T0* a1);
void r385c_define_twin(T0* a1,T0* a2,T0* a3,T0* a4);
void r421make(T421* C,T0* a1);
void r342error(T104 a1,T0* a2);
void r342make(T342* C,T0* a1,T0* a2,T0* a3);
void r342afd_check(T342* C);
T6 r342use_current(T342* C);
T0* r342twin(T342* C);
T0* r342to_runnable(T342* C,T0* a1);
T104 r342start_position(T342* C);
void r343error(T104 a1,T0* a2);
void r343make(T343* C,T0* a1,T0* a2);
void r343afd_check(T343* C);
T6 r343use_current(T343* C);
T0* r343twin(T343* C);
T0* r343to_runnable(T343* C,T0* a1);
T104 r343start_position(T343* C);
void r251compile_to_c(T251* C);
T6 r251stupid_switch(T251* C,T0* a1);
void r251mapping_c_arg(T251* C,T0* a1);
void r251to_integer_error(T251* C);
T0* r251result_type(T251* C);
void r251mapping_c_target(T251* C,T0* a1);
T2 r251to_integer_or_error(T251* C);
T0* r251add_comment(T251* C,T0* a1);
T0* r251to_runnable(T251* C,T0* a1);
T0* r251static_result_base_class(void);
void r374make(T374* C,T0* a1,T0* a2);
void r374constraint_substitution(T374* C,T0* a1,T2 a2);
void r374check_generic_formal_arguments(T374* C);
void r374fatal_error(T0* a1);
void r374substitute(T374* C,T0* a1,T0* a2,T2 a3,T0* a4);
void r359gc_mark(T359* C,T6 a1);
void r359gc_na_env_in(T359* C,T0* a1);
void r359c_type_for_external_in(T359* C,T0* a1);
T0* r359type_any(void);
T0* r359run_time_mark(T359* C);
void r359set(T359* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T6 r359is_native_array(T359* C);
void r359gc_mark_in(T359* C,T0* a1);
void r359make_runnable(T359* C,T104 a1,T0* a2,T0* a3);
void r359just_before_gc_mark_in(T359* C,T0* a1);
void r359load_basic_features(T359* C);
T2 r359id(T359* C);
T2 r359c_sizeof_pointer(void);
void r359mapping_cast(T359* C);
void r359c_type_for_argument_in(T359* C,T0* a1);
T6 r359stupid_switch(T359* C,T0* a1);
void r359c_frame_descriptor(T359* C);
void r359make(T359* C,T104 a1,T0* a2);
void r359fatal_error(T0* a1);
void r359gc_info_in(T359* C,T0* a1);
T0* r359string_aliaser(void);
T0* r359base_class(T359* C);
void r359standard_c_print_function(T359* C);
void r359gc_define1(T359* C);
void r359gc_define2(T359* C);
T0* r359actual_reference(T0* a1);
T6 r359is_a_in(T359* C,T0* a1,T0* a2);
void r359demangling_in(T359* C,T0* a1);
void r359c_type_in(T359* C,T0* a1);
void r359id_extra_information(T0* a1);
T6 r359is_a(T359* C,T0* a1);
T0* r359to_runnable(T359* C,T0* a1);
T0* r359run_class(T359* C);
void r359c_header_pass2(T359* C);
T6 r359is_run_type(T359* C);
T0* r359smallest_ancestor(T359* C,T0* a1);
void r359gc_info_nb_in(T359* C,T0* a1);
void r359gc_call_new_in(T359* C,T0* a1);
void r268error(T104 a1,T0* a2);
void r268compile_to_c(T268* C);
void r268make(T268* C,T104 a1,T0* a2,T0* a3);
void r268fatal_error(T0* a1);
T0* r268super_feature(T268* C,T0* a1);
void r268afd_check(T268* C);
void r268prepare_arguments(T268* C,T0* a1);
T0* r268precursor_name(T0* a1,T0* a2);
T0* r268add_comment(T268* C,T0* a1);
T0* r268to_runnable(T268* C,T0* a1);
void r268collect_c_tmp(T268* C);
void r360c_initialize_in(T0* a1);
void r360c_type_for_external_in(T0* a1);
T0* r360generic_list(T360* C);
T0* r360written_mark(void);
T6 r360has_creation(T360* C,T0* a1);
T0* r360run_time_mark(void);
T2 r360c_sizeof(void);
void r360error(T104 a1,T0* a2);
T6 r360is_native_array(T360* C);
void r360gc_mark_in(T0* a1);
extern T0*oBC360type_boolean_ref;
extern int fBC360type_boolean_ref;
T0* r360type_boolean_ref(void);
void r360fatal_error_generic_list(T360* C);
void r360c_type_for_argument_in(T0* a1);
void r360make(T360* C,T104 a1);
T0* r360base_class(T360* C);
extern int fBC360check_type;
void r360check_type(T360* C);
T0* r360actual_reference(T0* a1);
T6 r360is_a_in(T360* C,T0* a1,T0* a2);
void r360demangling_in(T0* a1);
void r360id_extra_information(T0* a1);
T6 r360is_a(T360* C,T0* a1);
void r360load_ref(T0* a1);
T0* r360to_runnable(T360* C,T0* a1);
T0* r360run_class(T360* C);
T0* r360smallest_ancestor(T360* C,T0* a1);
void r360gc_call_new_in(T0* a1);
void r253compile_to_c(T253* C);
void r253mapping_c_arg(T253* C,T0* a1);
void r253to_integer_error(T253* C);
void r253mapping_c_target(T0* a1);
T2 r253to_integer_or_error(T253* C);
T0* r253add_comment(T253* C,T0* a1);
T0* r253to_runnable(T253* C,T0* a1);
T0* r253static_result_base_class(T253* C);
T0* r293try_to_undefine_aux(T293* C,T0* a1,T0* a2);
void r293error(T104 a1,T0* a2);
T6 r293can_hide(T293* C,T0* a1,T0* a2);
void r293merge_header_comments(T293* C,T0* a1);
void r293add_into(T293* C,T0* a1);
T0* r293try_to_undefine(T293* C,T0* a1,T0* a2);
void r293make(T293* C,T0* a1,T0* a2);
void r293check_obsolete(T293* C,T104 a1);
extern T0*oBC293counter;
T0* r293to_run_feature(T293* C,T0* a1,T0* a2);
T6 r293is_not_mergeable_with(T293* C,T0* a1);
T104 r293start_position(T293* C);
void r316error(T104 a1,T0* a2);
void r316compile_to_c(T316* C);
T6 r316stupid_switch(T316* C,T0* a1);
void r316make(T316* C,T0* a1,T0* a2);
void r316afd_check(T316* C);
T6 r316use_current(T316* C);
T6 r316is_pre_computable(T316* C);
T0* r316add_comment(T316* C,T0* a1);
T0* r316to_runnable(T316* C,T0* a1);
void r316collect_c_tmp(T316* C);
T104 r316start_position(T316* C);
void r355c_initialize_in(T355* C,T0* a1);
void r355c_type_for_external_in(T355* C,T0* a1);
T0* r355generic_list(T355* C);
T6 r355is_bit(T355* C);
T6 r355has_creation(T355* C,T0* a1);
T0* r355run_time_mark(T355* C);
T6 r355is_any(T355* C);
T2 r355c_sizeof(T355* C);
void r355c_type_for_result_in(T355* C,T0* a1);
T6 r355is_native_array(T355* C);
void r355gc_mark_in(T355* C,T0* a1);
void r355just_before_gc_mark_in(T355* C,T0* a1);
void r355with(T355* C,T0* a1,T0* a2);
T6 r355is_pointer(T355* C);
T2 r355id(T355* C);
void r355mapping_cast(T355* C);
T0* r355static_base_class_name(T355* C);
T6 r355is_real(T355* C);
T6 r355is_none(T355* C);
void r355c_initialize(T355* C);
T6 r355need_gc_mark_function(T355* C);
void r355fatal_error_generic_list(T355* C);
void r355c_type_for_argument_in(T355* C,T0* a1);
void r355anchor_cycle_end(T355* C);
T6 r355is_integer(T355* C);
void r355c_frame_descriptor(T355* C);
void r355make(T355* C,T104 a1,T0* a2);
T0* r355base_class_name(T355* C);
T0* r355run_type(T355* C);
void r355fatal_error(T0* a1);
T6 r355is_character(T355* C);
T6 r355is_expanded(T355* C);
T6 r355is_array(T355* C);
void r355gc_info_in(T355* C,T0* a1);
T0* r355string_aliaser(void);
T0* r355base_class(T355* C);
T6 r355is_dummy_expanded(T355* C);
T6 r355need_c_struct(T355* C);
T6 r355is_reference(T355* C);
void r355gc_define1(T355* C);
void r355gc_define2(T355* C);
void r355c_type_for_target_in(T355* C,T0* a1);
T0* r355expanded_initializer(T355* C);
T0* r355actual_reference(T355* C,T0* a1);
T6 r355is_a_in(T355* C,T0* a1,T0* a2);
void r355demangling_in(T355* C,T0* a1);
T6 r355is_generic(T355* C);
T6 r355is_double(T355* C);
void r355id_extra_information(T355* C,T0* a1);
T6 r355is_user_expanded(T355* C);
T6 r355is_a(T355* C,T0* a1);
T6 r355is_boolean(T355* C);
void r355anchor_cycle_start(T355* C);
T0* r355to_runnable(T355* C,T0* a1);
T6 r355is_string(T355* C);
T0* r355run_class(T355* C);
void r355c_header_pass1(T355* C);
void r355c_header_pass2(T355* C);
void r355c_header_pass3(T355* C);
T6 r355is_run_type(T355* C);
void r355c_header_pass4(T355* C);
T6 r355is_basic_eiffel_expanded(T355* C);
T0* r355smallest_ancestor(T355* C,T0* a1);
void r355gc_call_new_in(T355* C,T0* a1);
void r376c_initialize_in(T376* C,T0* a1);
void r376c_type_for_external_in(T376* C,T0* a1);
T0* r376generic_list(T376* C);
void r376warning(T104 a1,T0* a2);
void r376set_run_type(T376* C,T0* a1,T0* a2);
T6 r376is_bit(T376* C);
T6 r376has_creation(T376* C,T0* a1);
T6 r376is_any(T376* C);
void r376set(T376* C,T0* a1,T0* a2,T0* a3,T0* a4,T2 a5,T0* a6,T0* a7);
T2 r376c_sizeof(T376* C);
void r376error(T104 a1,T0* a2);
void r376c_type_for_result_in(T376* C,T0* a1);
T6 r376is_native_array(T376* C);
void r376gc_mark_in(T376* C,T0* a1);
T0* r376make_runnable(T376* C,T0* a1,T0* a2);
void r376just_before_gc_mark_in(T376* C,T0* a1);
T6 r376is_pointer(T376* C);
T2 r376id(T376* C);
void r376mapping_cast(T376* C);
T0* r376static_base_class_name(T376* C);
T6 r376is_real(T376* C);
T6 r376is_none(T376* C);
void r376c_initialize(T376* C);
T6 r376need_gc_mark_function(T376* C);
void r376fatal_error_generic_list(T376* C);
void r376c_type_for_argument_in(T376* C,T0* a1);
T6 r376stupid_switch(T376* C,T0* a1);
T6 r376is_integer(T376* C);
void r376c_frame_descriptor(T376* C);
void r376make(T376* C,T0* a1,T0* a2,T2 a3);
T0* r376base_class_name(T376* C);
void r376fatal_error(T0* a1);
T6 r376is_character(T376* C);
T6 r376is_expanded(T376* C);
T6 r376is_array(T376* C);
void r376gc_info_in(T376* C,T0* a1);
T0* r376base_class(T376* C);
T6 r376is_dummy_expanded(T376* C);
T6 r376need_c_struct(T376* C);
T6 r376is_reference(T376* C);
void r376gc_define1(T376* C);
void r376gc_define2(T376* C);
void r376c_type_for_target_in(T376* C,T0* a1);
T0* r376expanded_initializer(T376* C);
T0* r376actual_reference(T376* C,T0* a1);
T6 r376is_a_in(T376* C,T0* a1,T0* a2);
void r376demangling_in(T376* C,T0* a1);
T6 r376is_generic(T376* C);
T6 r376is_double(T376* C);
void r376id_extra_information(T376* C,T0* a1);
T6 r376is_user_expanded(T376* C);
T6 r376is_a(T376* C,T0* a1);
T6 r376is_boolean(T376* C);
T0* r376to_runnable(T376* C,T0* a1);
T6 r376standard_stupid_switch(T376* C,T0* a1);
T6 r376is_string(T376* C);
T0* r376run_class(T376* C);
void r376c_header_pass1(T376* C);
void r376c_header_pass2(T376* C);
void r376c_header_pass3(T376* C);
void r376c_header_pass4(T376* C);
T6 r376is_basic_eiffel_expanded(T376* C);
T0* r376smallest_ancestor(T376* C,T0* a1);
void r376gc_call_new_in(T376* C,T0* a1);
void r495compile_to_c(T495* C);
T0* r495result_type(T495* C);
void r495mapping_c_target(T0* a1);
T2 r495to_integer_or_error(void);
T0* r495add_comment(T495* C,T0* a1);
T0* r495static_result_base_class(T495* C);
T2 r118count(T118* C);
T0* r118item(T118* C,T2 a1);
T2 r118index_of(T118* C,T0* a1);
void r118make_n(T118* C,T0* a1);
void r118fatal_error(T0* a1);
void r118fe_multiple(T0* a1,T0* a2);
T6 r118has(T118* C,T0* a1);
void r118add_last(T118* C,T0* a1);
T0* r118feature_name(T118* C,T0* a1);
T0* r118root_procedure_name(T118* C,T0* a1);
T0* r178item(T2 a1);
T0* r178empty_line_at(T2 a1);
T0* r178string_aliaser(void);
void r178load_file(T178* C,T0* a1);
extern T0*oBC178text;
void r169compile_to_c(T169* C);
void r169mapping_c_arg(T169* C,T0* a1);
void r169to_integer_error(T169* C);
void r169mapping_c_target(T0* a1);
T2 r169to_integer_or_error(T169* C);
T0* r169add_comment(T169* C,T0* a1);
T0* r169to_runnable(T169* C,T0* a1);
T0* r169static_result_base_class(T169* C);
void r373c_initialize_in(T373* C,T0* a1);
void r373c_type_for_external_in(T373* C,T0* a1);
T0* r373generic_list(T373* C);
T0* r373type_any(void);
T2 r373c_sizeof(T373* C);
T6 r373is_native_array(T373* C);
void r373gc_mark_in(T373* C,T0* a1);
T2 r373id(T373* C);
void r373mapping_cast(T373* C);
T6 r373is_c_unsigned_ptr(T373* C);
void r373c_initialize(T373* C);
T2 r373nb_unsigned(T373* C);
void r373fatal_error_generic_list(T373* C);
void r373c_type_for_argument_in(T373* C,T0* a1);
void r373c_frame_descriptor(T373* C);
void r373make(T373* C,T104 a1,T0* a2);
extern T0*oBC136base_class_name;
extern int fBC136base_class_name;
T0* r373base_class_name(void);
void r373fatal_error(T0* a1);
T0* r373string_aliaser(void);
T0* r373base_class(T373* C);
void r373standard_c_print_function(T373* C);
T6 r373need_c_struct(T373* C);
void r373c_type_for_target_in(T373* C,T0* a1);
T6 r373is_c_char(T373* C);
T0* r373actual_reference(T373* C,T0* a1);
T6 r373is_a_in(T373* C,T0* a1,T0* a2);
void r373demangling_in(T373* C,T0* a1);
void r373id_extra_information(T0* a1);
T6 r373is_a(T373* C,T0* a1);
T2 r373unsigned_padding(T373* C);
T0* r373to_runnable(T373* C,T0* a1);
T2 r373mapping_code(T373* C);
void r373to_runnable_1_2(T373* C);
T0* r373run_class(T373* C);
void r373c_header_pass1(T373* C);
T0* r373smallest_ancestor(T373* C,T0* a1);
void r373gc_call_new_in(T373* C,T0* a1);
void r372c_initialize_in(T372* C,T0* a1);
void r372c_type_for_external_in(T372* C,T0* a1);
T0* r372generic_list(T372* C);
T0* r372type_any(void);
T2 r372c_sizeof(T372* C);
T6 r372is_native_array(T372* C);
void r372gc_mark_in(T372* C,T0* a1);
T2 r372id(T372* C);
void r372mapping_cast(T372* C);
T6 r372is_c_unsigned_ptr(T372* C);
void r372c_initialize(T372* C);
T2 r372nb_unsigned(T372* C);
void r372fatal_error_generic_list(T372* C);
void r372c_type_for_argument_in(T372* C,T0* a1);
void r372c_frame_descriptor(T372* C);
void r372make(T372* C,T104 a1,T0* a2);
T0* r372base_class_name(void);
T0* r372string_aliaser(void);
T0* r372base_class(T372* C);
void r372standard_c_print_function(T372* C);
T6 r372need_c_struct(T372* C);
void r372c_type_for_target_in(T372* C,T0* a1);
T6 r372is_c_char(T372* C);
T0* r372actual_reference(T372* C,T0* a1);
T6 r372is_a_in(T372* C,T0* a1,T0* a2);
void r372demangling_in(T372* C,T0* a1);
void r372id_extra_information(T0* a1);
T6 r372is_a(T372* C,T0* a1);
T2 r372unsigned_padding(T372* C);
T0* r372to_runnable(T372* C,T0* a1);
T2 r372mapping_code(T372* C);
void r372to_runnable_1_2(T372* C);
T0* r372run_class(T372* C);
void r372c_header_pass1(T372* C);
T0* r372smallest_ancestor(T372* C,T0* a1);
void r372gc_call_new_in(T372* C,T0* a1);
T0* r153try_to_undefine_aux(T153* C,T0* a1,T0* a2);
void r153implicit(T153* C,T0* a1,T0* a2,T0* a3);
void r153error(T104 a1,T0* a2);
T6 r153can_hide(T153* C,T0* a1,T0* a2);
void r153merge_header_comments(T153* C,T0* a1);
void r153add_into(T153* C,T0* a1);
T0* r153try_to_undefine(T153* C,T0* a1,T0* a2);
void r153make(T153* C,T0* a1,T0* a2);
void r153check_obsolete(T153* C,T104 a1);
T0* r153to_run_feature(T153* C,T0* a1,T0* a2);
T6 r153is_not_mergeable_with(T153* C,T0* a1);
T104 r153start_position(T153* C);
void r363c_initialize_in(T0* a1);
void r363c_type_for_external_in(T0* a1);
T0* r363generic_list(T363* C);
T0* r363written_mark(void);
T6 r363has_creation(T363* C,T0* a1);
T0* r363run_time_mark(void);
T2 r363c_sizeof(void);
void r363error(T104 a1,T0* a2);
T6 r363is_native_array(T363* C);
void r363gc_mark_in(T0* a1);
extern T0*oBC363type_double_ref;
extern int fBC363type_double_ref;
T0* r363type_double_ref(void);
void r363fatal_error_generic_list(T363* C);
void r363c_type_for_argument_in(T0* a1);
void r363make(T363* C,T104 a1);
T0* r363base_class(T363* C);
extern int fBC363check_type;
void r363check_type(T363* C);
T0* r363actual_reference(T0* a1);
T6 r363is_a_in(T363* C,T0* a1,T0* a2);
void r363demangling_in(T0* a1);
void r363id_extra_information(T0* a1);
T6 r363is_a(T363* C,T0* a1);
void r363load_ref(T0* a1);
T0* r363to_runnable(T363* C,T0* a1);
T0* r363run_class(T363* C);
T0* r363smallest_ancestor(T363* C,T0* a1);
void r363gc_call_new_in(T0* a1);
T2 r260isa_dca_inline_argument(void);
T0* r260type_boolean(void);
T0* r260add_comment(T260* C,T0* a1);
T0* r260to_runnable(T260* C,T0* a1);
T0* r260static_result_base_class(void);
void r341error(T104 a1,T0* a2);
void r341compile_to_c(T341* C);
T6 r341stupid_switch(T341* C,T0* a1);
void r341make(T341* C,T104 a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r341afd_check(T341* C);
T6 r341use_current(T341* C);
T0* r341add_comment(T341* C,T0* a1);
T0* r341to_runnable(T341* C,T0* a1);
void r226run_feature_match(T226* C,T0* a1);
T0* r226runnable_expression(T0* a1,T0* a2);
T6 r226call_proc_call_stupid_switch(T226* C,T0* a1);
T6 r226is_static(T226* C);
T0* r226operator(void);
void r226with(T226* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r226run_feature_has_result(T226* C);
T6 r226stupid_switch(T226* C,T0* a1);
void r226make(T226* C,T0* a1,T104 a2,T0* a3);
void r226fatal_error(T0* a1);
void r226to_integer_error(T226* C);
T0* r226arg1(T226* C);
void r226assertion_check(T226* C,T3 a1);
T0* r226result_type(T226* C);
void r226afd_check(T226* C);
T6 r226use_current(T226* C);
void r226c_declare_for_old(T226* C);
void r226compile_to_c_old(T226* C);
T0* r226runnable_args(T0* a1,T0* a2);
void r226mapping_c_target(T226* C,T0* a1);
T0* r226run_feature_for(T226* C,T0* a1,T0* a2);
T2 r226to_integer_or_error(T226* C);
T0* r226add_comment(T226* C,T0* a1);
T0* r226to_runnable(T226* C,T0* a1);
void r226collect_c_tmp(T226* C);
void r226finalize(T226* C);
T0* r226static_result_base_class(T226* C);
T6 r517c_simple(T517* C);
T6 r517can_be_dropped(T517* C);
T6 r517is_static(T517* C);
T6 r517is_void(T517* C);
void r517compile_to_c(T517* C);
T6 r517is_result(T517* C);
T6 r517stupid_switch(T517* C,T0* a1);
void r517mapping_c_arg(T517* C,T0* a1);
void r517make(T517* C,T0* a1,T0* a2);
void r517to_integer_error(T517* C);
T2 r517isa_dca_inline_argument(T517* C);
void r517dca_inline_argument(T517* C,T0* a1);
void r517assertion_check(T517* C,T3 a1);
void r517afd_check(T517* C);
T6 r517use_current(T517* C);
T2 r517static_value(T517* C);
void r517c_declare_for_old(T517* C);
void r517compile_to_c_old(T517* C);
void r517mapping_c_target(T517* C,T0* a1);
T2 r517to_integer_or_error(T517* C);
T6 r517is_pre_computable(T517* C);
T0* r517add_comment(T517* C,T0* a1);
T0* r517to_runnable(T517* C,T0* a1);
void r517collect_c_tmp(T517* C);
T6 r517is_current(T517* C);
T104 r517start_position(T517* C);
T0* r517static_result_base_class(T517* C);
void r230run_feature_match(T230* C,T0* a1);
T0* r230runnable_expression(T0* a1,T0* a2);
T6 r230call_proc_call_stupid_switch(T230* C,T0* a1);
T0* r230operator(void);
void r230with(T230* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r230run_feature_has_result(T230* C);
T6 r230stupid_switch(T230* C,T0* a1);
void r230make(T230* C,T0* a1,T104 a2,T0* a3);
void r230fatal_error(T0* a1);
void r230to_integer_error(T230* C);
T0* r230arg1(T230* C);
void r230assertion_check(T230* C,T3 a1);
T0* r230result_type(T230* C);
void r230afd_check(T230* C);
T6 r230use_current(T230* C);
void r230c_declare_for_old(T230* C);
void r230compile_to_c_old(T230* C);
T0* r230runnable_args(T0* a1,T0* a2);
void r230mapping_c_target(T230* C,T0* a1);
T0* r230run_feature_for(T230* C,T0* a1,T0* a2);
T2 r230to_integer_or_error(T230* C);
T0* r230add_comment(T230* C,T0* a1);
T0* r230to_runnable(T230* C,T0* a1);
void r230collect_c_tmp(T230* C);
void r230finalize(T230* C);
T0* r230static_result_base_class(T230* C);
T6 r392stupid_switch_function(T0* a1,T0* a2);
void r392fatal_error(T0* a1);
T6 r392stupid_switch_procedure(T0* a1,T0* a2);
void r392fe_c2c(T0* a1);
void r389c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r389standard_c_define_function(T0* a1,T0* a2,T0* a3);
void r389standard_c_define_procedure(T0* a1,T0* a2,T0* a3);
void r389c_mapping_external(T0* a1,T2 a2);
void r389wrapped_external_call(T0* a1,T2 a2);
void r389c_mapping_function(T0* a1,T0* a2,T0* a3);
void r521gc_store_in(T521* C,T0* a1);
void r521c_type_for_external_in(T0* a1);
T0* r521generic_list(T521* C);
void r521gc_store_chunk_in(T521* C,T0* a1);
void r521standard_gc_define2(T521* C);
void r521standard_gc_define1(T521* C);
T6 r521is_native_array(T521* C);
void r521gc_mark_in(T521* C,T0* a1);
void r521from_expanded(T521* C,T104 a1,T0* a2);
T2 r521id(T521* C);
T2 r521c_sizeof_pointer(void);
void r521mapping_cast(T521* C);
void r521standard_gc_info_in(T521* C,T0* a1);
T0* r521static_base_class_name(T521* C);
void r521standard_c_typedef(T521* C);
T6 r521stupid_switch(T521* C,T0* a1);
void r521c_frame_descriptor(T521* C);
T0* r521base_class_name(T521* C);
void r521fatal_error(T0* a1);
T0* r521string_aliaser(void);
T0* r521base_class(T521* C);
void r521standard_c_print_function(T521* C);
void r521c_type_for_target_in(T521* C,T0* a1);
void r521gc_free_in(T521* C,T0* a1);
T6 r521is_a_in(T521* C,T0* a1,T0* a2);
void r521demangling_in(T521* C,T0* a1);
void r521gc_align_mark_in(T521* C,T0* a1);
void r521standard_c_struct(T521* C);
void r521gc_initialize_chunk(T521* C,T2 a1,T0* a2);
T6 r521is_generic(T521* C);
void r521id_extra_information(T0* a1);
T6 r521is_a(T521* C,T0* a1);
void r521standard_c_object_model(T521* C);
void r521gc_store_left_in(T521* C,T0* a1);
T0* r521run_class(T521* C);
void r521c_header_pass4(T521* C);
void r521standard_just_before_gc_mark_in(T521* C,T0* a1);
void r521gc_info_nb_in(T521* C,T0* a1);
T0* r521smallest_ancestor(T0* a1);
void r521gc_call_new_in(T521* C,T0* a1);
T0* r383check_assertion_mode(void);
void r383make_runnable(T383* C,T104 a1,T0* a2,T0* a3,T0* a4);
void r383compile_to_c(T383* C);
void r383add_into(T383* C,T0* a1);
void r383make(T383* C,T104 a1,T0* a2,T0* a3);
void r383afd_check(T383* C);
T6 r383is_always_true(T383* C);
T6 r383use_current(T383* C);
T0* r379left_type(T379* C);
T0* r379implicit_conversion(T379* C);
void r379compile_to_c(T379* C);
T6 r379stupid_switch(T379* C,T0* a1);
void r379make(T379* C,T0* a1,T0* a2);
void r379fatal_error(T0* a1);
void r379afd_check(T379* C);
T6 r379use_current(T379* C);
T6 r379is_pre_computable(T379* C);
T0* r379add_comment(T379* C,T0* a1);
T0* r379to_runnable(T379* C,T0* a1);
void r379collect_c_tmp(T379* C);
T0* r379right_type(T379* C);
T104 r379start_position(T379* C);
T0* r340check_assertion_mode(void);
void r340compile_to_c(T340* C);
void r340make(T340* C,T104 a1,T0* a2,T0* a3);
void r340afd_check(T340* C);
T6 r340is_always_true(T340* C);
T6 r340use_current(T340* C);
T0* r340twin(T340* C);
T0* r340to_runnable(T340* C,T0* a1);
void r370c_initialize_in(T370* C,T0* a1);
void r370gc_store_in(T370* C,T0* a1);
void r370c_type_for_external_in(T370* C,T0* a1);
T0* r370type_any(void);
T6 r370has_creation(T370* C,T0* a1);
T0* r370run_time_mark(T370* C);
void r370set(T370* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T2 r370c_sizeof(T370* C);
void r370gc_store_chunk_in(T370* C,T0* a1);
void r370c_type_for_result_in(T370* C,T0* a1);
void r370standard_gc_define2(T370* C);
void r370standard_gc_define1(T370* C);
T6 r370is_native_array(T370* C);
void r370gc_mark_in(T370* C,T0* a1);
void r370make_runnable(T370* C,T0* a1,T0* a2,T0* a3);
void r370standard_gc_define2_for_expanded(T370* C);
void r370just_before_gc_mark_in(T370* C,T0* a1);
extern T0*oBC370tmp_mark;
T2 r370id(T370* C);
T2 r370c_sizeof_pointer(void);
void r370mapping_cast(T370* C);
void r370standard_gc_info_in(T370* C,T0* a1);
void r370c_initialize(T370* C);
void r370standard_c_typedef(T370* C);
T6 r370need_gc_mark_function(T370* C);
void r370c_type_for_argument_in(T370* C,T0* a1);
T6 r370stupid_switch(T370* C,T0* a1);
void r370basic_checks(T370* C);
void r370c_frame_descriptor(T370* C);
void r370make(T370* C,T0* a1,T0* a2);
T0* r370run_type(T370* C);
void r370fatal_error(T0* a1);
T6 r370is_expanded(T370* C);
void r370gc_info_in(T370* C,T0* a1);
T0* r370string_aliaser(void);
T0* r370base_class(T370* C);
T6 r370is_dummy_expanded(T370* C);
void r370standard_c_print_function(T370* C);
T6 r370is_reference(T370* C);
T6 r370need_c_struct(T370* C);
void r370gc_define1(T370* C);
void r370gc_define2(T370* C);
void r370c_type_for_target_in(T370* C,T0* a1);
T0* r370expanded_initializer(T370* C);
T0* r370actual_reference(T370* C,T0* a1);
void r370gc_free_in(T370* C,T0* a1);
T6 r370is_a_in(T370* C,T0* a1,T0* a2);
void r370demangling_in(T370* C,T0* a1);
void r370gc_align_mark_in(T370* C,T0* a1);
void r370c_initialize_expanded(T370* C);
void r370standard_c_struct(T370* C);
void r370gc_initialize_chunk(T370* C,T2 a1,T0* a2);
void r370id_extra_information(T370* C,T0* a1);
T6 r370is_user_expanded(T370* C);
T6 r370is_a(T370* C,T0* a1);
T6 r370is_written_runnable(T370* C);
T0* r370to_runnable(T370* C,T0* a1);
void r370standard_c_object_model(T370* C);
void r370gc_store_left_in(T370* C,T0* a1);
T0* r370run_class(T370* C);
void r370c_header_pass3(T370* C);
T6 r370is_run_type(T370* C);
void r370c_header_pass4(T370* C);
void r370standard_just_before_gc_mark_in(T370* C,T0* a1);
T0* r370smallest_ancestor(T370* C,T0* a1);
void r370gc_info_nb_in(T370* C,T0* a1);
void r370gc_call_new_in(T370* C,T0* a1);
T0* r306try_to_undefine_aux(T306* C,T0* a1,T0* a2);
void r306error(T104 a1,T0* a2);
T6 r306can_hide(T306* C,T0* a1,T0* a2);
void r306merge_header_comments(T306* C,T0* a1);
void r306add_into(T306* C,T0* a1);
T0* r306try_to_undefine(T306* C,T0* a1,T0* a2);
void r306make(T306* C,T0* a1,T0* a2,T0* a3);
void r306check_obsolete(T306* C,T104 a1);
T0* r306to_run_feature(T306* C,T0* a1,T0* a2);
T6 r306is_not_mergeable_with(T306* C,T0* a1);
T104 r306start_position(T306* C);
void r241run_feature_match(T241* C);
T6 r241can_be_dropped(T241* C);
T0* r241runnable_expression(T0* a1,T0* a2);
T6 r241call_proc_call_stupid_switch(T241* C,T0* a1);
T6 r241is_static(T241* C);
T0* r241operator(void);
void r241with(T241* C,T0* a1,T0* a2,T0* a3);
void r241run_feature_has_result(T241* C);
T6 r241stupid_switch(T241* C,T0* a1);
void r241make(T241* C,T104 a1,T0* a2);
void r241fatal_error(T0* a1);
void r241to_integer_error(T241* C);
T2 r241isa_dca_inline_argument(T241* C);
void r241dca_inline_argument(T241* C,T0* a1);
void r241assertion_check(T241* C,T3 a1);
T0* r241result_type(T241* C);
void r241afd_check(T241* C);
T6 r241use_current(T241* C);
T2 r241static_value(T241* C);
void r241c_declare_for_old(T241* C);
void r241compile_to_c_old(T241* C);
void r241mapping_c_target(T241* C,T0* a1);
T0* r241run_feature_for(T241* C,T0* a1,T0* a2);
T2 r241to_integer_or_error(T241* C);
T0* r241add_comment(T241* C,T0* a1);
T0* r241to_runnable(T241* C,T0* a1);
void r241collect_c_tmp(T241* C);
void r241finalize(T241* C);
T0* r241static_result_base_class(T241* C);
void r264make(T264* C,T104 a1,T0* a2);
void r264to_integer_error(T264* C);
T2 r264isa_dca_inline_argument(void);
extern T0*oBC264result_type;
extern int fBC264result_type;
T0* r264result_type(void);
T2 r264to_integer_or_error(T264* C);
T0* r264add_comment(T264* C,T0* a1);
T0* r264to_runnable(T264* C,T0* a1);
T0* r264static_result_base_class(void);
void r388c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r388standard_c_define_function(T0* a1,T0* a2,T0* a3);
void r388standard_c_define_procedure(T0* a1,T0* a2,T0* a3);
void r388c_mapping_external(T0* a1,T2 a2);
void r388wrapped_external_call(T0* a1,T2 a2);
void r388c_mapping_function(T0* a1,T0* a2,T0* a3);
void r280cmp_bit(T280* C,T6 a1,T0* a2);
T0* r280runnable_expression(T0* a1,T0* a2);
T6 r280is_static_neq_void(T0* a1);
T6 r280call_proc_call_stupid_switch(T280* C,T0* a1);
T6 r280is_static(T280* C);
T0* r280operator(void);
void r280with(T280* C,T0* a1,T0* a2,T0* a3);
void r280compile_to_c(T280* C);
void r280check_comparison(T280* C,T0* a1);
T6 r280stupid_switch(T280* C,T0* a1);
T2 r280static_neq_void(T0* a1);
void r280make(T280* C,T0* a1,T104 a2,T0* a3);
void r280error_comparison(T280* C,T0* a1,T0* a2);
void r280fatal_error(T0* a1);
void r280dca_inline(T280* C,T0* a1);
void r280to_integer_error(T280* C);
T0* r280arg1(T280* C);
void r280assertion_check(T280* C,T3 a1);
void r280afd_check(T280* C);
T6 r280use_current(T280* C);
T0* r280type_boolean(void);
T2 r280static_value(T280* C);
void r280cmp_basic_ref(T280* C,T6 a1);
void r280c_declare_for_old(T280* C);
void r280cmp_user_expanded(T280* C,T6 a1,T0* a2);
void r280compile_to_c_old(T280* C);
T0* r280runnable_args(T0* a1,T0* a2);
void r280mapping_c_target(T280* C,T0* a1);
void r280c2c_exp_ref(T0* a1,T0* a2,T0* a3,T0* a4);
T2 r280to_integer_or_error(T280* C);
void r280bit_limitation(T280* C,T0* a1,T0* a2);
T0* r280add_comment(T280* C,T0* a1);
T0* r280to_runnable(T280* C,T0* a1);
void r280collect_c_tmp(T280* C);
T0* r280static_result_base_class(void);
void r280cmp_basic_eiffel_expanded(T280* C,T6 a1,T0* a2,T0* a3);
extern T0*oBC27buffer;
T0* r27item(T0* a1);
void r27special_add(T0* a1);
T0* r27for_prefix(T0* a1);
extern T0*oBC27memory;
T0* r27for_infix(T0* a1);
T0* r27key_for_prefix_infix(T0* a1,T0* a2);
void r248run_feature_match(T248* C,T0* a1);
T0* r248runnable_expression(T0* a1,T0* a2);
T6 r248call_proc_call_stupid_switch(T248* C,T0* a1);
T6 r248is_static(T248* C);
void r248with(T248* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r248run_feature_has_result(T248* C);
T6 r248stupid_switch(T248* C,T0* a1);
void r248make(T248* C,T0* a1,T0* a2,T0* a3);
void r248fatal_error(T0* a1);
void r248to_integer_error(T248* C);
void r248assertion_check(T248* C,T3 a1);
T0* r248result_type(T248* C);
void r248afd_check(T248* C);
T6 r248use_current(T248* C);
T2 r248static_value(T248* C);
void r248c_declare_for_old(T248* C);
void r248compile_to_c_old(T248* C);
T0* r248runnable_args(T0* a1,T0* a2);
void r248mapping_c_target(T248* C,T0* a1);
T0* r248run_feature_for(T248* C,T0* a1,T0* a2);
T2 r248to_integer_or_error(T248* C);
T0* r248add_comment(T248* C,T0* a1);
T2 r248arg_count(T248* C);
T0* r248to_runnable(T248* C,T0* a1);
void r248collect_c_tmp(T248* C);
void r248finalize(T248* C);
T0* r248static_result_base_class(T248* C);
T104 r248start_position(T248* C);
void r277run_feature_match(T277* C,T0* a1);
T0* r277runnable_expression(T0* a1,T0* a2);
T6 r277call_proc_call_stupid_switch(T277* C,T0* a1);
T6 r277is_static(T277* C);
T0* r277operator(void);
void r277with(T277* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r277run_feature_has_result(T277* C);
T6 r277stupid_switch(T277* C,T0* a1);
void r277make(T277* C,T0* a1,T104 a2,T0* a3);
void r277fatal_error(T0* a1);
void r277to_integer_error(T277* C);
T0* r277arg1(T277* C);
void r277assertion_check(T277* C,T3 a1);
T0* r277result_type(T277* C);
void r277afd_check(T277* C);
T6 r277use_current(T277* C);
void r277c_declare_for_old(T277* C);
void r277compile_to_c_old(T277* C);
T0* r277runnable_args(T0* a1,T0* a2);
void r277mapping_c_target(T277* C,T0* a1);
T0* r277run_feature_for(T277* C,T0* a1,T0* a2);
T2 r277to_integer_or_error(T277* C);
T0* r277add_comment(T277* C,T0* a1);
T0* r277to_runnable(T277* C,T0* a1);
void r277collect_c_tmp(T277* C);
void r277finalize(T277* C);
T0* r277static_result_base_class(T277* C);
void r522gc_store_in(T522* C,T0* a1);
void r522c_type_for_external_in(T0* a1);
T0* r522generic_list(T522* C);
T0* r522type_any(void);
void r522gc_store_chunk_in(T522* C,T0* a1);
void r522standard_gc_define2(T522* C);
void r522standard_gc_define1(T522* C);
T6 r522is_native_array(T522* C);
void r522gc_mark_in(T522* C,T0* a1);
T2 r522id(T522* C);
void r522from_type_bit(T522* C,T104 a1,T0* a2);
T2 r522c_sizeof_pointer(void);
void r522mapping_cast(T522* C);
void r522standard_gc_info_in(T522* C,T0* a1);
void r522standard_c_typedef(T522* C);
void r522fatal_error_generic_list(T522* C);
void r522c_frame_descriptor(T522* C);
extern T0*oBC522base_class_name;
extern int fBC522base_class_name;
T0* r522base_class_name(void);
T0* r522string_aliaser(void);
T0* r522base_class(T522* C);
void r522standard_c_print_function(T522* C);
void r522c_type_for_target_in(T522* C,T0* a1);
void r522gc_free_in(T522* C,T0* a1);
T6 r522is_a_in(T522* C,T0* a1,T0* a2);
void r522demangling_in(T522* C,T0* a1);
void r522gc_align_mark_in(T522* C,T0* a1);
void r522gc_initialize_chunk(T522* C,T2 a1,T0* a2);
void r522id_extra_information(T0* a1);
T6 r522is_a(T522* C,T0* a1);
void r522gc_store_left_in(T522* C,T0* a1);
T0* r522run_class(T522* C);
void r522c_header_pass2(T522* C);
void r522c_header_pass4(T522* C);
void r522standard_just_before_gc_mark_in(T522* C,T0* a1);
void r522gc_info_nb_in(T522* C,T0* a1);
T0* r522smallest_ancestor(T522* C,T0* a1);
void r522gc_call_new_in(T522* C,T0* a1);
void r225run_feature_match(T225* C,T0* a1);
T0* r225runnable_expression(T0* a1,T0* a2);
T6 r225call_proc_call_stupid_switch(T225* C,T0* a1);
T6 r225is_static(T225* C);
T0* r225operator(void);
void r225with(T225* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r225run_feature_has_result(T225* C);
T6 r225stupid_switch(T225* C,T0* a1);
void r225make(T225* C,T0* a1,T104 a2,T0* a3);
void r225fatal_error(T0* a1);
void r225to_integer_error(T225* C);
T0* r225arg1(T225* C);
void r225assertion_check(T225* C,T3 a1);
T0* r225result_type(T225* C);
void r225afd_check(T225* C);
T6 r225use_current(T225* C);
void r225c_declare_for_old(T225* C);
void r225compile_to_c_old(T225* C);
T0* r225runnable_args(T0* a1,T0* a2);
void r225mapping_c_target(T225* C,T0* a1);
T0* r225run_feature_for(T225* C,T0* a1,T0* a2);
T2 r225to_integer_or_error(T225* C);
T0* r225add_comment(T225* C,T0* a1);
T0* r225to_runnable(T225* C,T0* a1);
void r225collect_c_tmp(T225* C);
void r225finalize(T225* C);
T0* r225static_result_base_class(T225* C);
void r194make(T194* C,T0* a1);
void r194get_started(T194* C,T0* a1);
void r137compile_to_c(T137* C);
void r137make(T137* C,T104 a1,T0* a2);
void r137to_integer_error(T137* C);
void r137c_define(T137* C);
T2 r137to_integer_or_error(T137* C);
T0* r137add_comment(T137* C,T0* a1);
T0* r137to_runnable(T137* C,T0* a1);
T0* r137static_result_base_class(void);
T6 r518is_frozen(T518* C);
void r518error(T104 a1,T0* a2);
T0* r518to_string(T518* C);
void r518undefine_in(T518* C,T0* a1);
void r518refer_to(T518* C,T2 a1,T0* a2);
T0* r518string_aliaser(void);
T0* r518origin_base_class(T518* C);
T104 r518start_position(T518* C);
T6 r250stupid_switch(T250* C,T0* a1);
T0* r250c_variable_name(T250* C);
void r250mapping_c_arg(T250* C,T0* a1);
void r250to_integer_error(T250* C);
T0* r250result_type(T250* C);
void r250mapping_c_target(T250* C,T0* a1);
T2 r250to_integer_or_error(T250* C);
T0* r250add_comment(T250* C,T0* a1);
T0* r250to_runnable(T250* C,T0* a1);
T0* r250static_result_base_class(void);
void r494from_model(T494* C,T0* a1);
T2 r494count(T494* C);
T6 r494can_be_dropped(T494* C);
void r494error(T104 a1,T0* a2);
void r494put(T494* C,T0* a1,T2 a2);
void r494compile_to_c_ith(T494* C,T0* a1,T2 a2);
T6 r494is_static(T494* C);
void r494dca_inline_ith(T494* C,T0* a1,T2 a2);
void r494match_with(T494* C,T0* a1,T0* a2);
void r494compile_to_c(T494* C,T0* a1);
T6 r494stupid_switch(T494* C,T0* a1);
void r494make_n(T494* C,T0* a1,T0* a2);
T6 r494isa_dca_inline(T494* C,T0* a1,T0* a2);
void r494dca_inline(T494* C,T0* a1);
void r494assertion_check(T494* C,T3 a1);
void r494afd_check(T494* C);
T6 r494use_current(T494* C);
T0* r494expression(T494* C,T2 a1);
void r494c_declare_for_old(T494* C);
void r494compile_to_c_old(T494* C);
void r494run_feature(T494* C,T0* a1);
T6 r494is_pre_computable(T494* C);
T6 r494is_like_argument(T494* C,T0* a1,T0* a2,T0* a3);
T0* r494to_runnable(T494* C,T0* a1);
void r494collect_c_tmp(T494* C);
T104 r494start_position(T494* C);
void r262add_percent(T262* C,T3 a1);
void r262break_line(T262* C);
void r262compile_to_c(T262* C);
T0* r262type_string(void);
void r262make(T262* C,T104 a1);
void r262to_integer_error(T262* C);
void r262add_ascii(T262* C,T3 a1);
T0* r262twin(T262* C);
T2 r262to_integer_or_error(T262* C);
T0* r262add_comment(T262* C,T0* a1);
T0* r262to_runnable(T262* C,T0* a1);
T0* r262static_result_base_class(void);
void r39put_integer(T39* C,T2 a1);
void r39put_double_format(T39* C,T5 a1,T2 a2);
void r39put_string(T39* C,T0* a1);
void r54put_integer(T54* C,T2 a1);
void r54put_string(T54* C,T0* a1);
T0* r72up_to_original(T72* C,T0* a1,T0* a2);
T0* r72going_up(T72* C,T0* a1,T0* a2,T0* a3);
void r72inherit_cycle_check(T72* C);
T0* r72look_up_for(T72* C,T0* a1,T0* a2);
T6 r72has_redefine(T72* C,T0* a1);
T0* r72first_parent_for(T72* C,T0* a1);
T0* r72clients_for(T72* C,T0* a1);
T0* r72next_parent_for(T72* C,T0* a1,T0* a2);
T6 r72is_a_vncg(T72* C,T0* a1,T0* a2);
void r72make(T72* C,T0* a1,T104 a2,T0* a3,T0* a4);
void r72fatal_error(T0* a1);
T0* r72original_name(T72* C,T0* a1,T0* a2);
T0* r72repeated_inheritance(T72* C,T0* a1,T0* a2,T0* a3);
void r72collect_invariant(T72* C,T0* a1);
T0* r72e_feature(T72* C,T0* a1);
T0* r72precursor_for(T72* C,T0* a1,T0* a2);
T6 r72has_parent(T72* C,T0* a1);
void r72id_extra_information(T72* C,T0* a1);
void r72collect_assertion(T72* C,T0* a1);
void r72get_started(T72* C);
T0* r72smallest_ancestor(T72* C,T0* a1,T0* a2);
void r351c2c_opening(T351* C,T0* a1);
void r351warning(T104 a1,T0* a2);
T0* r351run_args(T351* C);
void r351error(T104 a1,T0* a2);
void r351compile_to_c(T351* C);
void r351c2c_closing(T351* C,T0* a1);
T6 r351stupid_switch(T351* C,T0* a1);
void r351make(T351* C,T104 a1,T0* a2,T0* a3,T0* a4);
void r351fatal_error(T0* a1);
void r351afd_check(T351* C);
T6 r351use_current(T351* C);
void r351c2c_expanded_initializer(T351* C,T0* a1);
void r351check_created_type(T351* C,T0* a1);
void r351check_writable(T351* C,T0* a1);
void r351c2c_clear_expanded(T351* C,T2 a1);
T6 r351is_pre_computable(T351* C);
T0* r351add_comment(T351* C,T0* a1);
T2 r351arg_count(T351* C);
T0* r351to_runnable(T351* C,T0* a1);
void r351check_creation_clause(T351* C,T0* a1);
void r351collect_c_tmp(T351* C);
void r351cp_not_found(T351* C,T0* a1);
void r351check_explicit_type(T351* C);
void r349c2c_opening(T349* C,T0* a1);
void r349warning(T104 a1,T0* a2);
T0* r349run_args(T349* C);
void r349error(T104 a1,T0* a2);
void r349compile_to_c(T349* C);
void r349c2c_closing(T349* C,T0* a1);
T6 r349stupid_switch(T349* C,T0* a1);
void r349make(T349* C,T104 a1,T0* a2,T0* a3);
void r349fatal_error(T0* a1);
void r349afd_check(T349* C);
T6 r349use_current(T349* C);
void r349c2c_expanded_initializer(T349* C,T0* a1);
void r349check_created_type(T349* C,T0* a1);
void r349check_writable(T349* C,T0* a1);
void r349c2c_clear_expanded(T349* C,T2 a1);
T6 r349is_pre_computable(T349* C);
T0* r349add_comment(T349* C,T0* a1);
T2 r349arg_count(T349* C);
T0* r349to_runnable(T349* C,T0* a1);
void r349check_creation_clause(T349* C,T0* a1);
void r349collect_c_tmp(T349* C);
void r349cp_not_found(T349* C,T0* a1);
void r193make(T193* C,T104 a1);
void r193check_generic_formal_arguments(T193* C);
void r193fatal_error(T0* a1);
void r193add_last(T193* C,T0* a1);
void r347c2c_opening(T347* C,T0* a1);
void r347warning(T104 a1,T0* a2);
void r347error(T104 a1,T0* a2);
void r347compile_to_c(T347* C);
void r347c2c_closing(T347* C,T0* a1);
T6 r347stupid_switch(T347* C,T0* a1);
void r347make(T347* C,T104 a1,T0* a2,T0* a3);
void r347fatal_error(T0* a1);
T6 r347use_current(T347* C);
void r347check_created_type(T347* C,T0* a1);
void r347check_writable(T347* C,T0* a1);
void r347c2c_clear_expanded(T347* C,T2 a1);
T6 r347is_pre_computable(T347* C);
T0* r347add_comment(T347* C,T0* a1);
T0* r347to_runnable(T347* C,T0* a1);
void r347check_creation_clause(T347* C,T0* a1);
void r347check_explicit_type(T347* C);
void r344c2c_opening(T344* C,T0* a1);
void r344warning(T104 a1,T0* a2);
void r344error(T104 a1,T0* a2);
void r344compile_to_c(T344* C);
void r344c2c_closing(T344* C,T0* a1);
T6 r344stupid_switch(T344* C,T0* a1);
void r344make(T344* C,T104 a1,T0* a2);
void r344fatal_error(T0* a1);
T6 r344use_current(T344* C);
void r344check_created_type(T344* C,T0* a1);
void r344check_writable(T344* C,T0* a1);
void r344c2c_clear_expanded(T344* C,T2 a1);
T6 r344is_pre_computable(T344* C);
T0* r344add_comment(T344* C,T0* a1);
T0* r344to_runnable(T344* C,T0* a1);
void r344check_creation_clause(T344* C,T0* a1);
T0* r311check_assertion_mode(void);
void r311compile_to_c(T311* C);
void r311make(T311* C,T104 a1,T0* a2,T0* a3);
void r311afd_check(T311* C);
T6 r311is_always_true(T311* C);
T6 r311use_current(T311* C);
T0* r311twin(T311* C);
T6 r311is_pre_computable(T311* C);
T0* r311to_runnable(T311* C,T0* a1);
T0* r309check_assertion_mode(void);
void r309make_runnable(T309* C,T104 a1,T0* a2,T0* a3,T0* a4);
void r309compile_to_c(T309* C);
void r309add_into(T309* C,T0* a1);
void r309make(T309* C,T104 a1,T0* a2,T0* a3);
void r309afd_check(T309* C);
T6 r309is_always_true(T309* C);
T6 r309use_current(T309* C);
void r309c_declare_for_old(T309* C);
void r309compile_to_c_old(T309* C);
extern T0*oBC42temporary_type_name;
extern T0*oBC42id_memory;
T0* r42system_tools(void);
T2 r42item(T42* C,T0* a1);
void r42make(T42* C);
void r42disk_restore(T42* C);
T0* r42string_aliaser(void);
T0* r42alias_of(T2 a1);
void r275with(T275* C,T0* a1,T0* a2);
T0* r275to_string(T275* C);
T6 r275stupid_switch(T275* C,T0* a1);
void r275to_integer_error(T275* C);
T0* r275result_type(T275* C);
void r275refer_to(T275* C,T104 a1,T0* a2,T2 a3);
void r275mapping_c_target(T275* C,T0* a1);
T2 r275to_integer_or_error(T275* C);
T0* r275add_comment(T275* C,T0* a1);
T0* r275to_runnable(T275* C,T0* a1);
T0* r275static_result_base_class(T275* C);
void r364c_initialize_in(T0* a1);
void r364c_type_for_external_in(T0* a1);
T0* r364generic_list(T364* C);
T0* r364written_mark(void);
T6 r364has_creation(T364* C,T0* a1);
T0* r364run_time_mark(void);
T2 r364c_sizeof(void);
extern T0*oBC364type_integer_ref;
extern int fBC364type_integer_ref;
T0* r364type_integer_ref(void);
void r364error(T104 a1,T0* a2);
T6 r364is_native_array(T364* C);
void r364gc_mark_in(T0* a1);
void r364fatal_error_generic_list(T364* C);
void r364c_type_for_argument_in(T0* a1);
void r364make(T364* C,T104 a1);
T0* r364base_class(T364* C);
extern int fBC364check_type;
void r364check_type(T364* C);
T0* r364actual_reference(T0* a1);
T6 r364is_a_in(T364* C,T0* a1,T0* a2);
void r364demangling_in(T0* a1);
void r364id_extra_information(T0* a1);
T6 r364is_a(T364* C,T0* a1);
void r364load_ref(T0* a1);
T0* r364to_runnable(T364* C,T0* a1);
T0* r364run_class(T364* C);
T0* r364smallest_ancestor(T364* C,T0* a1);
void r364gc_call_new_in(T0* a1);
void r38sfw_connect(T38* C,T0* a1,T0* a2);
void r38file_removing(T38* C,T0* a1);
T6 r38file_exists(T0* a1);
void r38file_renaming(T38* C,T0* a1,T0* a2);
void r38sfr_connect(T38* C,T0* a1,T0* a2);
void r38w_put_character(T3 a1);
void r38sfr_connect_or_exit(T38* C,T0* a1,T0* a2);
T0* r38read_word_in(T38* C,T0* a1);
void r38print_count(T38* C,T0* a1,T2 a2);
void r38put_integer(T38* C,T2 a1);
extern T0*oBC1std_output;
void r38put_double_format(T38* C,T5 a1,T2 a2);
void r38w_put_string(T0* a1);
void r38w_put_integer(T2 a1);
void r38put_character(T38* C,T3 a1);
void r38put_string(T38* C,T0* a1);
extern T0*oBC1std_error;
T0* r501run_ensure(T501* C);
void r501define_prototype(T501* C);
void r501default_mapping_procedure(T501* C);
void r501fe_vffd7(T501* C);
T0* r501run_require(T501* C);
T6 r501is_exported_in(T501* C,T0* a1);
T2 r501id(T501* C);
void r501mapping_c(T501* C);
void r501c_frame_descriptor_name_in(T501* C,T0* a1);
void r501mapping_name(T501* C);
void r501put_c_name_tag(T501* C);
T0* r501stupid_switch(T501* C,T0* a1);
void r501c_frame_descriptor(T501* C);
void r501make(T501* C,T0* a1,T0* a2,T0* a3);
void r501fatal_error(T0* a1);
void r501routine_afd_check(T501* C);
void r501afd_check(T501* C);
T6 r501use_current(T501* C);
void r501c_define_opening(T501* C);
void r501compute_stupid_switch(T501* C,T0* a1);
void r501c_initialize_ds_one_by_one(T501* C);
void r501c_assertion_flag(T501* C);
void r501c_define(T501* C);
void r501address_of_c_define(T501* C,T0* a1);
void r501fall_down(T501* C);
void r501initialize(T501* C);
T0* r501clients(T501* C);
void r501collect_c_tmp(T501* C);
T104 r501start_position(T501* C);
void r501c_define_closing(T501* C);
void r501default_mapping_function(T501* C);
void r104set(T104* C,T2 a1,T2 a2,T2 a3,T0* a4);
T6 r104is_unknown(T104* C);
T2 r104id(T104* C);
T0* r104get_line(T0* a1,T2 a2);
void r104show(T104* C);
T0* r104base_class_name(T104* C);
T0* r104path(T104* C);
T6 r104before(T104* C,T104 a1);
T0* r104id_provider(void);
T2 r104line(T104* C);
T2 r104column(T104* C);
T6 r86file_exists(T0* a1);
void r86rename_to(int C,T0* a1,T0* a2);
extern T0*oBC86std_fr1;
extern T0*oBC86std_fr2;
T6 r86same_files(T0* a1,T0* a2);
void r86delete(int C,T0* a1);
T6 r86is_readable(T0* a1);
T0* r465o_flag(T0* a1);
T0* r465o_result(T0* a1);
extern T0*oBC465function_list;
extern T0*oBC465o_flag_buffer;
extern T0*oBC465c_define_o_result_buffer;
extern T0*oBC465buffer;
void r465gc_mark_in(T0* a1);
void r465c_pre_compute_of(T0* a1,T0* a2);
void r465c_define_o_result(T0* a1);
T0* r465string_aliaser(void);
void r465c_test_o_flag(T0* a1);
extern T0*oBC465o_result_buffer;
void r465c_return_o_result(T0* a1);
extern T0*oBC465procedure_list;
void r465register_function(T0* a1);
void r465c_define_o_flag(T0* a1);
void r465register_procedure(T0* a1);
T6 r465is_pre_computable(T0* a1);
extern T0*oBC465frozen_general;
void r449put_ith_argument(T0* a1,T0* a2,T2 a3);
void r449c_dicho(int C,T0* a1,T2 a2,T2 a3);
void r449put_arguments(T0* a1,T0* a2);
void r449c_switch(T0* a1);
extern T0*oBC449running;
T0* r449name(T0* a1);
extern T0*oBC449c_code;
void r449sort_running(T0* a1);
void r449afd(T0* a1);
void r449c_define(int C,T0* a1);
void r474register_for(T0* a1);
extern T0*oBC474caller_memory;
extern T0*oBC474registered;
void r83put_recompilation_comment(T2 a1);
void r83put_banner(T0* a1);
void r83incr_real_function_count(T83* C);
void r83se_evobt(T83* C,T0* a1,T0* a2);
extern T0*oBC83path_c;
extern int fBC83path_c;
T0* r83path_c(T83* C);
void r83incr_elt_c_count(T83* C,T2 a1);
extern T0*oBC83path_h;
extern int fBC83path_h;
T0* r83path_h(void);
T6 r83arguments_cannot_be_dropped(T83* C);
void r83put_position_in_ds(T104 a1);
void r83put_c_heading(T83* C,T0* a1);
void r83incr_direct_call_count(T83* C);
void r83one_more_instruction_generated(T83* C);
void r83incr_switch_count(T83* C);
void r83define_main(T83* C,T0* a1);
extern T0*oBC83se_tmp_list;
void r83fatal_error(T0* a1);
void r83inside_switch_call(T83* C,T0* a1,T0* a2);
void r83use_switch(T83* C,T0* a1,T0* a2,T0* a3,T0* a4);
T6 r83attribute_read_removal(T0* a1,T0* a2);
void r83push_check(T83* C,T0* a1,T0* a2,T0* a3);
void r83cecil_define(T83* C);
void r83current_class_invariant(T0* a1);
void r83push_new(T83* C,T0* a1,T0* a2);
void r83se_tmp_close_declaration(T83* C);
void r83push_same_target(T83* C,T0* a1,T0* a2);
extern T0*oBC83path_make;
extern int fBC83path_make;
T0* r83path_make(void);
T6 r83call_invariant_start(T0* a1);
void r83inline_level_incr(T83* C);
void r83put_c_inline_c(T83* C);
void r83push_direct(T83* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC84stack_cpc;
void r83put_c_inline_h(T83* C);
T6 r83target_cannot_be_dropped(T83* C);
T2 r83se_tmp_open(T0* a1);
void r83really_define_c_main(T83* C,T0* a1);
void r83put_ith_argument(T83* C,T2 a1);
extern T0*oBC83c_inline_h_mem;
void r83stack_overflow(T83* C);
void r83padding_here(T83* C);
void r83put_to_pointer(T83* C);
T6 r83stupid_switch_n(T83* C,T0* a1,T0* a2);
void r83put_inspect(T83* C);
void r83register_bit_constant(T83* C,T0* a1);
extern T0*oBC84stack_target;
void r83define_initialize_eiffel_runtime(T83* C,T0* a1);
void r83put_trace_switch(T83* C);
void r83customize_runtime(T83* C,T0* a1);
void r83push_inline_dca(T83* C,T0* a1,T0* a2);
extern T0*oBC84stack_args;
void r83common_put_target(T83* C);
void r83incr_static_expression_count(T83* C);
T0* r83system_tools(void);
void r83c_plus_plus_definitions(T83* C);
void r83sys_runtime_h_and_c(T83* C,T0* a1);
void r83inline_level_decr(T83* C);
void r83inspect_incr(T83* C);
void r83se_trace_ins(T83* C,T104 a1);
T6 r83cannot_drop_all(T83* C);
void r83incr_procedure_count(T83* C);
void r83incr_real_procedure_count(T83* C);
void r83print_argument(T83* C,T2 a1);
void r83se_tmp_add(T0* a1);
void r83expanded_attributes(T83* C,T0* a1);
void r83trace_boolean_expression(T83* C,T0* a1);
void r83inside_twin(T83* C,T0* a1);
void r83incr_function_count(T83* C);
void r83put_cpc(T83* C,T0* a1);
void r83macro_def(T83* C,T0* a1,T2 a2);
void r83put_object_size(T83* C,T0* a1);
T0* r83get_inline_ms(T83* C);
void r83print_current(T83* C);
void r83stack_push(T83* C,T2 a1);
void r83check_id(T83* C,T0* a1,T2 a2);
void r83add_first_include(T0* a1);
void r83swap_on_h(T83* C);
void r83add_include_on(T0* a1,T0* a2);
void r83push_cpc(T83* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r83se_trace_exp(T83* C,T104 a1);
extern T0*oBC84stack_static_rf;
extern T0*oBC83out_make;
void r83inspect_decr(T83* C);
void r83incr_inlined_function_count(T83* C);
extern T0*oBC84stack_string;
T6 r83stupid_switch(T83* C,T0* a1);
T6 r83se_tmp_open_declaration(T83* C);
void r83write_make_file_no_split(T83* C);
void r83sys_runtime_c(T0* a1);
void r83sys_runtime_h(T83* C,T0* a1);
void r83put_error0(T83* C,T0* a1);
void r83connect_cecil_out_h(T83* C,T0* a1);
T0* r83need_invariant(T0* a1);
void r83put_string_c(T0* a1);
void r83incr_precursor_routine_count(T83* C);
void r83put_file(T0* a1,T0* a2);
extern T0*oBC83tmp_string2;
void r83put_array1(T83* C,T3 a1,T2 a2);
void r83put_c_function(T83* C,T0* a1,T0* a2);
void r83put_generating_type(T83* C,T0* a1);
T6 r83no_args_to_eval(T83* C);
void r83get_started(T83* C);
void r83finished_switch(T83* C,T2 a1);
extern T0*oBC84stack_code;
void r83backup_sfw_connect(T0* a1,T0* a2);
void r83put_proc_call_0(T83* C,T0* a1,T0* a2,T0* a3);
void r83put_target_as_value(T83* C);
void r83check_assertion(T83* C,T0* a1,T0* a2);
extern T0*oBC83out_c;
void r83define_used_basics(T83* C);
void r83c_plus_plus_register(T83* C,T0* a1);
void r83write_make_file(T83* C);
void r83write_make_file_split(T83* C);
void r83variant_check(T83* C,T0* a1);
void r83put_generator(T83* C,T0* a1);
void r83increment_static_expression_count(T83* C,T2 a1);
void r83pop(T83* C);
void r83put_se_string(T83* C,T0* a1);
void r83print_local(T83* C,T0* a1);
extern T0*oBC83tmp_string;
T6 r83file_exists(T0* a1);
void r83push_precursor(T83* C,T0* a1,T0* a2);
void r83bit_constant_definition(T83* C);
void r83put_target_as_target(T83* C);
void r83path_c_in(T0* a1,T2 a2);
void r83put_extern1(T83* C,T0* a1);
void r83se_tmp_close(T2 a1);
void r83put_extern2(T83* C,T0* a1,T3 a2);
void r83put_extern4(T83* C,T0* a1,T0* a2,T2 a3);
void r83put_extern5(T83* C,T0* a1,T0* a2);
void r83put_extern6(T83* C,T0* a1,T2 a2);
void r83put_extern7(T83* C,T0* a1);
void r83put_comment(T83* C,T0* a1);
void r83incr_inlined_procedure_count(T83* C);
extern T0*oBC84stack_rf;
void r83put_comment_line(T83* C,T0* a1);
void r83put_arguments(T83* C);
void r432update_with(T0* a1);
void r432remove(T0* a1);
extern T0*oBC432dictionary;
void r432update(T0* a1,T0* a2);
void r82print_as_fatal_error(T82* C);
void r82do_print(T0* a1);
T6 r82is_empty(void);
extern T0*oBC82explanation;
void r82print_as_error(T82* C);
void r82add_feature_name(T0* a1);
extern T0*oBC82positions;
void r82add_type(T0* a1,T0* a2);
void r82add_position(T104 a1);
void r82feature_not_found(T0* a1);
void r82print_as_warning(T82* C);
extern T0*oBC470body;
void r470character_to_c_code(T3 a1,T0* a2);
void r470c_define1(T6 a1);
void r470c_define2(T6 a1);
T0* r470type_string(void);
void r470common_body_for_se_string_and_se_ms(T6 a1);
void r470define_manifest_string_mark_header(T2 a1);
T0* r470register(T0* a1);
extern T0*oBC470mangling_dictionary;
void r470used_for_c_inline(T0* a1);
void r470string_to_c_code(T0* a1,T0* a2);
void r470define_se_ms(T6 a1);
extern T0*oBC470header;
void r440computes_for(T440* C,T0* a1,T0* a2);
extern T0*oBC440expressions;
extern T0*oBC440buffer;
void r440generic_cast(T440* C,T0* a1);
void r440c_definitions(T440* C);
void r440c_function_call(T440* C,T0* a1,T0* a2);
extern T0*oBC440source_types;
void r440finish_falling_down(T440* C);
T0* r440implicit_cast(T440* C,T0* a1,T0* a2);
void r440notify(T440* C,T0* a1,T0* a2,T0* a3);
void r440c_function_definition(T440* C);
T0* r440string_aliaser(void);
extern T0*oBC440destination_types;
void r440passing(T440* C,T0* a1,T0* a2);
extern T0*oBC461manifest_array_types;
extern T0*oBC461body;
void r461c_define_for(T0* a1);
void r461c_call(T0* a1);
void r461register(T0* a1);
extern T0*oBC461header;
T0* r211to_prefix_name(T211* C);
T0* r211to_argument_name1(T211* C);
T0* r211to_argument_name2(T211* C,T0* a1,T2 a2);
T0* r211to_infix_name_use(T211* C);
T6 r211is_void(void);
T6 r211is_result(void);
T0* r211aliased_string(T211* C);
T6 r211isa_keyword(T211* C);
T0* r211to_local_name2(T211* C,T0* a1,T2 a2);
T0* r211to_local_name1(T211* C);
T0* r211string_aliaser(void);
T0* r211to_simple_feature_name(T211* C);
void r211reset(T211* C,T104 a1);
T0* r211to_class_name(T211* C);
T0* r211to_tag_name(T211* C);
T0* r211to_infix_name(T211* C,T104 a1);
T0* r211to_e_void(T211* C);
T6 r211is_current(void);
void r297increment(T297* C);
T6 r17is_flag_case_insensitive(T0* a1);
T6 r17is_flag_all_check(T17* C,T0* a1);
T6 r17is_flag_no_style_warning(T0* a1);
void r17check_for_root_class(T17* C);
T0* r17system_tools(void);
extern T0*oBC1command_arguments;
extern int fBC1command_arguments;
T0* r17command_arguments(void);
T6 r17is_flag_loop_check(T17* C,T0* a1);
T6 r17is_flag_version(T17* C,T0* a1);
T6 r17is_flag_invariant_check(T17* C,T0* a1);
void r17make(T17* C);
T6 r17is_flag_verbose(T0* a1);
T6 r17is_flag_boost(T17* C,T0* a1);
T0* r17command_name(void);
T0* r17string_aliaser(void);
T6 r17is_flag_cecil(T17* C,T0* a1,T2 a2,T2 a3);
T6 r17is_flag_debug_check(T0* a1);
void r17search_for_cc_flag(T2 a1);
T0* r17id_provider(void);
T6 r17is_flag_ensure_check(T17* C,T0* a1);
T6 r17is_flag_o(T17* C,T0* a1,T2 a2,T2 a3,T0* a4);
void r17check_for_level(T17* C,T0* a1);
T0* r17argument(T2 a1);
T6 r17is_flag_require_check(T17* C,T0* a1);
T6 r17is_flag_no_check(T17* C,T0* a1);
T6 r17is_flag_no_warning(T0* a1);
extern T0*oBC131buffer;
void r131fill_up(T131* C);
void r131c_define_for(T0* a1,T0* a2);
void r131add_file(T131* C,T0* a1);
void r131afd_check(T131* C);
void r131echo_for(T0* a1);
void r131define_body_of(T0* a1);
void r131c_define_users(T131* C);
T0* r292to_deferred_routine(T292* C);
void r292add_synonym(T0* a1);
T0* r292to_external_routine(T292* C,T0* a1,T0* a2);
T0* r292to_cst_att_unique(T292* C);
void r292error(T104 a1,T0* a2);
T0* r292to_writable_attribute(T292* C);
extern T0*oBC292names;
void r292fatal_error(T0* a1);
T0* r292to_cst_att_character(T292* C,T0* a1);
T0* r292to_cst_att_boolean(T292* C,T0* a1);
T0* r292n(void);
T0* r292to_cst_att_bit(T292* C,T0* a1);
void r292to_cst_att_check_result_type(T292* C);
T0* r292to_procedure_or_function(T292* C);
T0* r292to_cst_att_string(T292* C,T0* a1);
T0* r292to_once_routine(T292* C);
void r292initialize(T292* C);
void r292set_require_else(T292* C,T104 a1,T0* a2,T0* a3);
void r292set_require(T292* C,T104 a1,T0* a2,T0* a3);
T0* r292to_cst_att_integer(T292* C,T0* a1);
T0* r292to_cst_att_real(T292* C,T0* a1);
T0* r37a_routine(T37* C);
void r37a_after_a_dot(T37* C,T6 a1,T0* a2);
T6 r37a_current(T37* C);
void r37a_assignment_aux(T37* C,T6 a1);
T6 r37a_then_part(T37* C,T0* a1);
void r37show_nb(T2 a1,T0* a2);
T104 r37current_position(T37* C);
void r37warning(T104 a1,T0* a2);
T0* r37a_compound1(T37* C);
T0* r37a_compound2(T37* C,T0* a1,T0* a2);
void r37a_formal_arg_list(T37* C);
T6 r37a_real_constant(T37* C);
T6 r37a_tag_mark(T37* C);
T6 r37a_instruction(T37* C);
void r37fcp(T37* C,T0* a1);
void r37go_back_at(T37* C,T2 a1,T2 a2);
void r37fatal_error(T0* a1);
void r37a_function_call(T37* C);
T0* r37a_routine_body(T37* C);
T6 r37a_result(T37* C);
T0* r37a_assertion(T37* C);
extern T0*oBC37buffer;
void r37a_feature_clause(T37* C);
T6 r37a_index_clause(T37* C);
void r37a_rename_list(T37* C);
void r37a_creation_clause(T37* C,T104 a1);
T0* r37a_alias(T37* C);
T6 r37a_manifest_string(T37* C);
T6 r37a_retry(T37* C);
T6 r37a_binary(T37* C,T104 a1);
void r37a_new_export_list(T37* C);
void r37a_ascii_code(T37* C);
T6 r37a_identifier(T37* C);
T6 r37a_character_constant(T37* C);
T0* r37to_proc_call(T37* C,T0* a1,T0* a2,T0* a3);
T6 r37a_keyword(T37* C,T0* a1);
T6 r37a_feature_name_list(T37* C);
void r37skip_comments(T37* C);
T6 r37a_parent(T37* C);
T6 r37a_index_value(T37* C);
T0* r37last_result(T37* C);
T6 r37a_class_type(T37* C);
T6 r37a_strip(T37* C);
T6 r37a_precursor(T37* C,T6 a1);
T6 r37a_loop(T37* C);
T6 r37a_conditional(T37* C);
T0* r37to_call(T0* a1,T0* a2,T0* a3);
T6 r37a_feature_name(T37* C);
void r37a_r10(T37* C,T6 a1,T0* a2,T0* a3,T0* a4);
T6 r37skip1(T37* C,T3 a1);
T6 r37skip2(T37* C,T3 a1,T3 a2);
T6 r37a_create_instruction(T37* C);
T6 r37a_prefix(T37* C);
T6 r37a_feature_declaration(T37* C);
void r37next_char(T37* C);
T0* r37connect_to_cecil(T37* C,T0* a1);
T6 r37a_bit_constant(T37* C);
extern T0*oBC37lcs;
T6 r37a_real(T37* C);
T6 r37a_void(T37* C);
T6 r37a_actual(T37* C);
T0* r37analyse_class(T37* C,T0* a1);
T6 r37a_when_part(T37* C,T0* a1);
void r37a_then_part_list(T37* C,T0* a1);
T6 r37a_debug(T37* C);
void r37a_indexing(T37* C);
T6 r37a_rename_pair(T37* C);
T6 r37a_manifest_constant(T37* C);
T6 r37a_creation(T37* C);
T6 r37a_identifier2(T37* C);
T6 r37a_identifier1(T37* C);
T6 r37a_inspect(T37* C);
T6 r37a_e10(T37* C);
T6 r37a_base_class_name(T37* C);
T6 r37a_argument(T37* C);
T0* r37parse_run_type(T37* C);
T6 r37a_type(T37* C);
T6 r37skip1unless2(T37* C,T3 a1,T3 a2);
T6 r37a_infix(T37* C);
void r37a_procedure_call(T37* C);
T6 r37a_type_formal_generic(T37* C);
T0* r37parse_c_name(T37* C);
T0* r37a_external(T37* C);
T6 r37end_of_input(T37* C);
void r37err_exp(T104 a1,T0* a2);
T6 r37a_e0(T37* C);
T6 r37a_e1(T37* C);
extern T0*oBC37faof;
T6 r37a_e2(T37* C);
T6 r37a_e3(T37* C);
T6 r37a_e4(T37* C);
T6 r37a_boolean_constant(T37* C);
T6 r37a_e5(T37* C);
T6 r37a_e6(T37* C);
T6 r37a_e7(T37* C);
T6 r37a_e8(T37* C);
T6 r37a_e9(T37* C);
T6 r37a_unary(T37* C);
T6 r37a_assignment_or_call(T37* C);
T0* r37a_clients(T37* C);
T0* r37mandatory_writable(T37* C);
void r37a_local_var_list(T37* C);
void r37to_frozen_feature_name(T37* C);
void r37disconnect(T37* C);
T6 r37a_integer_constant(T37* C);
T6 r37a_base_type(T37* C);
T6 r37a_free_operator(T37* C);
T6 r37a_constant(T37* C);
void r37a_formal_generic_list(T37* C);
T6 r37a_local_variable(T37* C);
void r37wcpefnc(T37* C,T0* a1,T0* a2);
T0* r37id_provider(void);
T6 r37a_integer(T37* C);
void r37a_r1(T37* C,T0* a1);
void r37a_r2(T37* C,T0* a1);
void r37a_r3(T37* C,T0* a1);
void r37a_r4(T37* C,T0* a1);
void r37a_r5(T37* C,T0* a1);
void r37a_r6(T37* C,T0* a1);
T0* r37get_comment(T37* C);
T0* r37parse_feature_name(T37* C);
void r37a_r7(T37* C,T0* a1);
void r37a_r8(T37* C,T0* a1);
T6 r37a_check(T37* C);
extern T0*oBC37a_assertion_buffer;
T104 r37pos(T37* C,T2 a1,T2 a2);
void r37a_parent_list(T37* C,T104 a1,T0* a2);
void r37error(T104 a1,T0* a2);
void r37a_class_declaration(T37* C);
T0* r37a_actuals(T37* C);
T6 r37a_expression(T37* C);
void r37a_base_class_name1(T37* C);
extern T17*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 528
extern T7* g[];
extern T7* t[];
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms143_1761546765;
extern T7*ms359_2082029949;
extern T7*ms461_25374580;
extern T7*ms470_437780;
extern T7*ms37_1563835599;
extern T7*ms62_81437;
extern T7*ms350_527115622;
extern T7*ms276_1311763296;
extern T7*ms376_1158502989;
extern T7*ms385_32406;
extern T7*ms21_2023685073;
extern T7*ms37_2159a;
extern T7*ms61_15142174;
extern T7*ms60_4559801;
extern T7*ms359_26635163;
extern T7*ms385_1992693595;
extern T7*ms83_545118879;
extern T7*ms96_1555607831;
extern T7*ms501_1894299446;
extern T7*ms385_31986;
extern T7*ms20_2041682;
extern T7*ms444_41125176;
extern T7*ms99_1087076085;
extern T7*ms21_50778415;
extern T7*ms380_811579327;
extern T7*ms339_297138751;
extern T7*ms20_216;
extern T7*ms60_577202205;
extern T7*ms20_226;
extern T7*ms21_1949019648;
extern T7*ms20_240;
extern T7*ms20_241;
extern T7*ms279_35407;
extern T7*ms461_1704115456;
extern T7*ms20_245;
extern T7*ms20_246;
extern T7*ms37_1296817101;
extern T7*ms20_305;
extern T7*ms20_257;
extern T7*ms449_593760881;
extern T7*ms59_297303074;
extern T7*ms83_928596125;
extern T7*ms279_1808090188;
extern T7*ms20_277;
extern T7*ms48_860169684;
extern T7*ms20_286;
extern T7*ms21_279523519;
extern T7*ms60_50032655;
extern T7*ms522_14340;
extern T7*ms20_360;
extern T7*ms18_93490068;
extern T7*ms37_188494264;
extern T7*ms21_337331;
extern T7*ms60_4017030;
extern T7*ms20_366;
extern T7*ms18_1042405932;
extern T7*ms20_377;
extern T7*ms20_1854346358;
extern T7*ms341_31625;
extern T7*ms18_1009954795;
extern T7*ms21_286922;
extern T7*ms361_849282034;
extern T7*ms470_1916291223;
extern T7*ms20_2185421;
extern T7*ms83_1214735849;
extern T7*ms96_1367040625;
extern T7*ms37_1978896036;
extern T7*ms20_600;
extern T7*ms59_1507705367;
extern T7*ms61_142319;
extern T7*ms20_611;
extern T7*ms365_1517781844;
extern T7*ms440_1907711138;
extern T7*ms20_614;
extern T7*ms96_1660308094;
extern T7*ms20_10315778;
extern T7*ms470_669461518;
extern T7*ms20_625;
extern T7*ms385_1541156706a;
extern T7*ms20_627;
extern T7*ms385_106066795;
extern T7*ms20_635;
extern T7*ms20_640;
extern T7*ms96_7317;
extern T7*ms60_352009409;
extern T7*ms139_827568154;
extern T7*ms89_8260;
extern T7*ms326_1650;
extern T7*ms21_15751;
extern T7*ms385_108351709a;
extern T7*ms48_52773091;
extern T7*ms60_1726920051;
extern T7*ms21_15831;
extern T7*ms21_267647687;
extern T7*ms444_15915;
extern T7*ms62_171955;
extern T7*ms89_1961687;
extern T7*ms83_514187710;
extern T7*ms60_1253917267;
extern T7*ms60_596564007;
extern T7*ms385_188402364;
extern T7*ms367_686319392;
extern T7*ms21_15932;
extern T7*ms37_67;
extern T7*ms385_34510;
extern T7*ms37_1098559967;
extern T7*ms37_176469602;
extern T7*ms440_5156340;
extern T7*ms21_591414963;
extern T7*ms21_1384826;
extern T7*ms20_2234341;
extern T7*ms385_1541156706;
extern T7*ms60_284;
extern T7*ms461_789033551;
extern T7*ms20_664531444;
extern T7*ms21_16616;
extern T7*ms60_287;
extern T7*ms83_1206795525;
extern T7*ms21_16639;
extern T7*ms61_292482;
extern T7*ms60_419;
extern T7*ms522_110019555;
extern T7*ms60_379;
extern T7*ms341_1670731538;
extern T7*ms359_1396798042;
extern T7*ms60_605650769;
extern T7*ms62_1815688614;
extern T7*ms21_16686;
extern T7*ms121_172193497;
extern T7*ms385_34811;
extern T7*ms139_1140322163;
extern T7*ms37_881601516a;
extern T7*ms21_287359706;
extern T7*ms37_988145286;
extern T7*ms59_1318242324;
extern T7*ms96_2111741;
extern T7*ms18_935144013;
extern T7*ms37_116346440;
extern T7*ms60_635;
extern T7*ms346_696937580a;
extern T7*ms18_5763915;
extern T7*ms385_34936;
extern T7*ms37_52979396;
extern T7*ms20_2233396;
extern T7*ms83_375072661;
extern T7*ms21_275488632;
extern T7*ms21_33156840;
extern T7*ms83_78906490;
extern T7*ms385_427767795;
extern T7*ms205_447148204;
extern T7*ms48_270309168;
extern T7*ms385_933501;
extern T7*ms21_18110;
extern T7*ms96_334284767;
extern T7*ms96_143305;
extern T7*ms373_2101008371;
extern T7*ms20_1090;
extern T7*ms385_1628970485;
extern T7*ms385_1072545723;
extern T7*ms83_19969182;
extern T7*ms385_340514;
extern T7*ms20_462691396;
extern T7*ms83_1628002544;
extern T7*ms60_423280aa;
extern T7*ms17_230396;
extern T7*ms21_591417242;
extern T7*ms20_1330;
extern T7*ms62_169510;
extern T7*ms83_585944489;
extern T7*ms20_1284;
extern T7*ms350_1742784741;
extern T7*ms20_1285;
extern T7*ms326_361a;
extern T7*ms48_1125006;
extern T7*ms470_2078648440;
extern T7*ms61_3563044;
extern T7*ms385_35991;
extern T7*ms449_342169763;
extern T7*ms385_2122389958;
extern T7*ms326_4425;
extern T7*ms59_981892978;
extern T7*ms17_226239;
extern T7*ms449_43899248;
extern T7*ms380_1016822887;
extern T7*ms96_1660308094a;
extern T7*ms165_51895507;
extern T7*ms37_505423465;
extern T7*ms17_230766;
extern T7*ms59_2140009595;
extern T7*ms83_4049151;
extern T7*ms167_1742784741;
extern T7*ms279_162070;
extern T7*ms340_3343;
extern T7*ms279_162045;
extern T7*ms62_1419822228a;
extern T7*ms21_7749340;
extern T7*ms292_1952642401;
extern T7*ms37_277917932;
extern T7*ms82_1831619428;
extern T7*ms104_200;
extern T7*ms385_1102979933;
extern T7*ms21_2126626;
extern T7*ms18_5761951;
extern T7*ms385_1105475957;
extern T7*ms61_1701059270;
extern T7*ms37_958560710;
extern T7*ms37_1284361566;
extern T7*ms385_1008067448;
extern T7*ms385_1102979958;
extern T7*ms83_1435285930;
extern T7*ms21_954385774;
extern T7*ms37_924385084;
extern T7*ms21_295849;
extern T7*ms62_1519036636;
extern T7*ms62_938298091;
extern T7*ms20_2417;
extern T7*ms437_1608699;
extern T7*ms20_2382;
extern T7*ms96_1775507635;
extern T7*ms83_1587531149;
extern T7*ms62_1748680500;
extern T7*ms20_240a;
extern T7*ms20_1079001;
extern T7*ms20_3073;
extern T7*ms61_660585882;
extern T7*ms206_862271166;
extern T7*ms20_3085;
extern T7*ms104_480;
extern T7*ms17_1976311991;
extern T7*ms168_608361995;
extern T7*ms59_77912;
extern T7*ms20_3175;
extern T7*ms21_54749764;
extern T7*ms440_209458617;
extern T7*ms83_89771;
extern T7*ms37_1353966724;
extern T7*ms48_11253;
extern T7*ms21_282;
extern T7*ms21_296;
extern T7*ms139_410482645;
extern T7*ms143_1345559174;
extern T7*ms21_361;
extern T7*ms17_5657310;
extern T7*ms20_3291;
extern T7*ms37_442256615;
extern T7*ms292_1845353597;
extern T7*ms21_371;
extern T7*ms326_6305;
extern T7*ms136_86320376;
extern T7*ms20_3415;
extern T7*ms20_3374;
extern T7*ms83_1186179343;
extern T7*ms385_1220661594;
extern T7*ms37_1724356412a;
extern T7*ms139_109;
extern T7*ms21_552;
extern T7*ms62_84678371;
extern T7*ms20_77350;
extern T7*ms48_1090a;
extern T7*ms20_3539;
extern T7*ms37_1825917546;
extern T7*ms48_1832417772;
extern T7*ms21_636;
extern T7*ms37_1436398529;
extern T7*ms501_1611457;
extern T7*ms20_78002;
extern T7*ms48_98806116;
extern T7*ms20_3595;
extern T7*ms21_669;
extern T7*ms83_1316373138;
extern T7*ms21_1680885744;
extern T7*ms139_265;
extern T7*ms359_129735471;
extern T7*ms38_3556890;
extern T7*ms449_2746980;
extern T7*ms20_82570;
extern T7*ms139_410;
extern T7*ms18_556698697;
extern T7*ms62_176986;
extern T7*ms62_2051940780;
extern T7*ms61_216;
extern T7*ms21_1937220099;
extern T7*ms278_6506;
extern T7*ms20_78263;
extern T7*ms139_47833290;
extern T7*ms62_1648235130;
extern T7*ms60_23313965;
extern T7*ms20_10648581;
extern T7*ms385_10513515;
extern T7*ms61_252;
extern T7*ms60_9980719;
extern T7*ms48_13028;
extern T7*ms83_522679873;
extern T7*ms380_28032126;
extern T7*ms59_54734511;
extern T7*ms61_272;
extern T7*ms385_834771837;
extern T7*ms83_627908885;
extern T7*ms159_251;
extern T7*ms21_10945665;
extern T7*ms385_452095250;
extern T7*ms20_17723839;
extern T7*ms21_42134669;
extern T7*ms83_1790869799;
extern T7*ms60_814642458;
extern T7*ms37_833080669;
extern T7*ms440_1971499416;
extern T7*ms20_78490;
extern T7*ms37_1208507031;
extern T7*ms61_1786429697;
extern T7*ms83_1290234339;
extern T7*ms461_211356;
extern T7*ms48_1570aa;
extern T7*ms59_2096892436;
extern T7*ms385_1769843235;
extern T7*ms48_12782;
extern T7*ms60_1671053848;
extern T7*ms324_9155;
extern T7*ms60_1809213019;
extern T7*ms21_2067995;
extern T7*ms271_134876560;
extern T7*ms21_1778079380;
extern T7*ms59_1180143814;
extern T7*ms89_1810101146;
extern T7*ms313_916170;
extern T7*ms20_79251;
extern T7*ms37_1961320002;
extern T7*ms48_0a;
extern T7*ms115_1612080;
extern T7*ms59_1332826858;
extern T7*ms385_1887064762;
extern T7*ms48_1462565417;
extern T7*ms154_160405;
extern T7*ms359_1396;
extern T7*ms37_101794766;
extern T7*ms165_1568216255;
extern T7*ms37_2122388361;
extern T7*ms60_9905a;
extern T7*ms20_84443;
extern T7*ms60_1317154036;
extern T7*ms62_54686284;
extern T7*ms48_721564652;
extern T7*ms62_89821;
extern T7*ms48_0aaaaa;
extern T7*ms440_1229875290;
extern T7*ms42_1265;
extern T7*ms37_562075114;
extern T7*ms48_1367153110;
extern T7*ms380_181317;
extern T7*ms325_403041978;
extern T7*ms17_5510246;
extern T7*ms279_544289339;
extern T7*ms60_252669317;
extern T7*ms37_844703215;
extern T7*ms20_6330;
extern T7*ms21_836969340;
extern T7*ms89_54686040;
extern T7*ms345_1993444075;
extern T7*ms104_63912;
extern T7*ms200_790556736;
extern T7*ms292_2108232434;
extern T7*ms359_5839580;
extern T7*ms60_7440512;
extern T7*ms200_354325983;
extern T7*ms470_1518071231;
extern T7*ms20_6455;
extern T7*ms346_739187517;
extern T7*ms243_880386718;
extern T7*ms326_281822138;
extern T7*ms96_526;
extern T7*ms385_12705715;
extern T7*ms60_5394280;
extern T7*ms20_90408;
extern T7*ms37_2159;
extern T7*ms345_813171837;
extern T7*ms37_2177;
extern T7*ms59_517131637;
extern T7*ms21_1744612358;
extern T7*ms48_415107;
extern T7*ms82_60894;
extern T7*ms385_398250205;
extern T7*ms143_1966754928;
extern T7*ms48_19761224;
extern T7*ms73_875060418;
extern T7*ms37_1933;
extern T7*ms37_816849367;
extern T7*ms21_406284;
extern T7*ms359_3175;
extern T7*ms62_1710309;
extern T7*ms83_1605087047;
extern T7*ms37_1382075996;
extern T7*ms292_900887704;
extern T7*ms20_9790205;
extern T7*ms524_19385;
extern T7*ms385_1595618529a;
extern T7*ms325_244699380;
extern T7*ms83_42279221;
extern T7*ms152_1350;
extern T7*ms83_1377391529;
extern T7*ms60_1809359305;
extern T7*ms444_10511077;
extern T7*ms165_584218374;
extern T7*ms326_1936418471;
extern T7*ms37_50040236;
extern T7*ms37_732932648;
extern T7*ms261_162019;
extern T7*ms37_331100035;
extern T7*ms380_1312;
extern T7*ms325_1470642763;
extern T7*ms38_44975894;
extern T7*ms152_1530;
extern T7*ms370_366170003;
extern T7*ms37_345260582;
extern T7*ms37_248250267;
extern T7*ms48_15721;
extern T7*ms245_172033369;
extern T7*ms48_1090;
extern T7*ms200_1530892681;
extern T7*ms37_155929078;
extern T7*ms385_929281864;
extern T7*ms37_116346440a;
extern T7*ms20_7800;
extern T7*ms48_1215;
extern T7*ms346_94944730;
extern T7*ms154_1240;
extern T7*ms139_46;
extern T7*ms37_545306000;
extern T7*ms368_2417;
extern T7*ms461_1206929268;
extern T7*ms48_1570a;
extern T7*ms359_101;
extern T7*ms154_1330;
extern T7*ms62_236525;
extern T7*ms37_1093012317;
extern T7*ms48_0aaaa;
extern T7*ms20_75797981;
extern T7*ms154_1370;
extern T7*ms131_1368666474;
extern T7*ms61_1717725716;
extern T7*ms48_1438;
extern T7*ms37_2060176323;
extern T7*ms60_44462444;
extern T7*ms374_161773610;
extern T7*ms62_432936020;
extern T7*ms48_1182185621;
extern T7*ms59_54526326;
extern T7*ms359_284;
extern T7*ms444_829920879;
extern T7*ms380_1701574474;
extern T7*ms444_1348996210;
extern T7*ms48_1570;
extern T7*ms20_87466;
extern T7*ms83_48061390;
extern T7*ms37_469646655;
extern T7*ms60_687744958;
extern T7*ms60_915251302;
extern T7*ms37_432;
extern T7*ms60_1330;
extern T7*ms48_2178;
extern T7*ms60_526175446;
extern T7*ms89_2237652;
extern T7*ms48_1744;
extern T7*ms38_27561173;
extern T7*ms37_1081135889;
extern T7*ms73_887869768;
extern T7*ms37_432a;
extern T7*ms48_218174;
extern T7*ms48_1774;
extern T7*ms48_1775;
extern T7*ms21_9529116;
extern T7*ms38_1680762272;
extern T7*ms60_1330a;
extern T7*ms440_484876960;
extern T7*ms385_134878499;
extern T7*ms379_246;
extern T7*ms62_175;
extern T7*ms449_2000361;
extern T7*ms48_2440;
extern T7*ms62_129037214;
extern T7*ms37_319995947;
extern T7*ms364_1179852269;
extern T7*ms48_1721407046;
extern T7*ms62_284;
extern T7*ms205_1112610025;
extern T7*ms359_1419822228;
extern T7*ms206_1650;
extern T7*ms60_1646;
extern T7*ms48_18144;
extern T7*ms27_15195;
extern T7*ms48_2618;
extern T7*ms48_3069;
extern T7*ms48_3094;
extern T7*ms48_301a;
extern T7*ms48_3169;
extern T7*ms21_2067759348;
extern T7*ms48_304a;
extern T7*ms83_246893097;
extern T7*ms20_2125481451;
extern T7*ms27_15370;
extern T7*ms62_604;
extern T7*ms62_605;
extern T7*ms385_60405;
extern T7*ms62_614;
extern T7*ms37_199494346;
extern T7*ms59_1112;
extern T7*ms385_194670249;
extern T7*ms48_17794;
extern T7*ms48_3320;
extern T7*ms449_257;
extern T7*ms21_880412606;
extern T7*ms240_205;
extern T7*ms444_98267602;
extern T7*ms48_2833;
extern T7*ms21_111802057;
extern T7*ms60_244793715;
extern T7*ms48_3294;
extern T7*ms385_304601115;
extern T7*ms62_479982486;
extern T7*ms180_314294460;
extern T7*ms21_2038667775;
extern T7*ms62_699;
extern T7*ms62_1646;
extern T7*ms62_1651;
extern T7*ms83_756717624;
extern T7*ms470_1742714978;
extern T7*ms62_54875475;
extern T7*ms59_1330;
extern T7*ms20_1865695338;
extern T7*ms83_1284a;
extern T7*ms48_1106932385;
extern T7*ms48_340a;
extern T7*ms48_223953;
extern T7*ms59_375871741;
extern T7*ms205_1365491496;
extern T7*ms20_9980517;
extern T7*ms206_3175;
extern T7*ms19_9366;
extern T7*ms48_679150617;
extern T7*ms62_1704089558;
extern T7*ms19_8897;
extern T7*ms20_10990481;
extern T7*ms21_9676326;
extern T7*ms96_1111279623;
extern T7*ms60_3337;
extern T7*ms385_60855;
extern T7*ms48_54687110;
extern T7*ms465_46350;
extern T7*ms60_15405;
extern T7*ms20_1459599374;
extern T7*ms60_3374;
extern T7*ms359_6755;
extern T7*ms48_5578901;
extern T7*ms60_257216509;
extern T7*ms385_1105475957a;
extern T7*ms96_560761477;
extern T7*ms37_45224899;
extern T7*ms449_209097161;
extern T7*ms61_1838187926;
extern T7*ms444_54714979;
extern T7*ms83_1187263559;
extern T7*ms313_4605420;
extern T7*ms60_1112927266;
extern T7*ms267_1197649626;
extern T7*ms62_1994331;
extern T7*ms20_89862;
extern T7*ms62_3175;
extern T7*ms83_7720290;
extern T7*ms37_1358473075;
extern T7*ms83_4980205;
extern T7*ms21_35868574;
extern T7*ms60_456870507;
extern T7*ms470_1390840;
extern T7*ms48_354654986;
extern T7*ms21_94407393;
extern T7*ms62_3337;
extern T7*ms82_70962;
extern T7*ms444_1231257120;
extern T7*ms37_1967846638;
extern T7*ms96_430519127;
extern T7*ms385_842325609;
extern T7*ms465_295937432;
extern T7*ms62_1985327250;
extern T7*ms20_10193105;
extern T7*ms62_1562678200;
extern T7*ms21_573080478;
extern T7*ms465_47278;
extern T7*ms61_1229059519;
extern T7*ms48_968120;
extern T7*ms37_1604340919;
extern T7*ms83_15280;
extern T7*ms59_2630;
extern T7*ms62_284a;
extern T7*ms444_1824264277;
extern T7*ms60_419a;
extern T7*ms139_139180801;
extern T7*ms83_10940631;
extern T7*ms83_15351;
extern T7*ms522_166323715;
extern T7*ms60_16510;
extern T7*ms444_1290936337;
extern T7*ms89_852437;
extern T7*ms21_1507243919;
extern T7*ms99_1060258809;
extern T7*ms366_1872190535;
extern T7*ms61_439490016;
extern T7*ms59_313299890;
extern T7*ms359_2097247;
extern T7*ms37_273016233;
extern T7*ms62_1126647264;
extern T7*ms325_635;
extern T7*ms21_1692780980;
extern T7*ms345_262;
extern T7*ms117_1217321133;
extern T7*ms359_958639438;
extern T7*ms359_28263330;
extern T7*ms37_210743979;
extern T7*ms18_336;
extern T7*ms60_111269879;
extern T7*ms18_28281127;
extern T7*ms59_887102279;
extern T7*ms48_0aaaaaa;
extern T7*ms152_6655;
extern T7*ms200_1369337435;
extern T7*ms37_314182975;
extern T7*ms37_2047202317;
extern T7*ms37_105701016;
extern T7*ms82_1122;
extern T7*ms37_347705622;
extern T7*ms21_698215697;
extern T7*ms59_601041072;
extern T7*ms20_1261705;
extern T7*ms339_2043440078;
extern T7*ms37_2047201942;
extern T7*ms449_993641482;
extern T7*ms37_543076045;
extern T7*ms385_511943145;
extern T7*ms60_5580;
extern T7*ms37_2053250287;
extern T7*ms60_17575;
extern T7*ms21_1554777;
extern T7*ms21_35866627;
extern T7*ms48_1514967669;
extern T7*ms449_1552636066;
extern T7*ms327_180037;
extern T7*ms38_322;
extern T7*ms60_476433922;
extern T7*ms356_964142543;
extern T7*ms48_382130;
extern T7*ms61_1840207317;
extern T7*ms279_1673400454;
extern T7*ms48_467476687;
extern T7*ms245_172193497;
extern T7*ms449_1650;
extern T7*ms89_1629123832;
extern T7*ms60_18257;
extern T7*ms37_1176245553;
extern T7*ms48_53640765;
extern T7*ms48_427244;
extern T7*ms48_6687;
extern T7*ms317_96445217;
extern T7*ms440_200;
extern T7*ms59_1628100917;
extern T7*ms385_6534aa;
extern T7*ms440_215;
extern T7*ms96_1334667838;
extern T7*ms83_923503323;
extern T7*ms60_1667215692;
extern T7*ms523_1026466011;
extern T7*ms60_6455;
extern T7*ms385_246;
extern T7*ms385_247;
extern T7*ms189_439056951;
extern T7*ms385_312;
extern T7*ms440_264;
extern T7*ms37_1662133290;
extern T7*ms385_265;
extern T7*ms385_306706;
extern T7*ms154_4670426;
extern T7*ms385_345;
extern T7*ms385_130409330;
extern T7*ms385_296;
extern T7*ms60_6614;
extern T7*ms60_880879251;
extern T7*ms60_1990989;
extern T7*ms37_400716256;
extern T7*ms37_1898638542;
extern T7*ms21_54733341;
extern T7*ms385_471;
extern T7*ms37_256295585;
extern T7*ms385_21064105;
extern T7*ms21_349117293;
extern T7*ms73_104720455;
extern T7*ms444_49917876;
extern T7*ms37_2006579501;
extern T7*ms48_7809;
extern T7*ms21_11026665;
extern T7*ms60_2030510390;
extern T7*ms180_1742784741;
extern T7*ms380_908608149;
extern T7*ms385_7025a;
extern T7*ms21_54733071;
extern T7*ms444_1542088104;
extern T7*ms60_1120232626;
extern T7*ms449_77412;
extern T7*ms62_7066;
extern T7*ms83_277;
extern T7*ms385_6534a;
extern T7*ms48_0aaaaaaa;
extern T7*ms48_7878;
extern T7*ms21_53028;
extern T7*ms279_10512915;
extern T7*ms96_803430551;
extern T7*ms470_992208171;
extern T7*ms48_7897;
extern T7*ms60_55816647;
extern T7*ms48_0aaaaaaaa;
extern T7*ms62_6755;
extern T7*ms60_1744666427;
extern T7*ms62_6773;
extern T7*ms48_9121;
extern T7*ms48_9073;
extern T7*ms61_1751640606;
extern T7*ms48_9220;
extern T7*ms48_9222;
extern T7*ms18_1889925553;
extern T7*ms83_490869799;
extern T7*ms461_284291114;
extern T7*ms21_53339;
extern T7*ms48_8801;
extern T7*ms326_1329248467;
extern T7*ms261_236;
extern T7*ms37_493481611;
extern T7*ms21_1202672333;
extern T7*ms369_1618317100;
extern T7*ms60_7869;
extern T7*ms60_9954400;
extern T7*ms83_699;
extern T7*ms59_651a;
extern T7*ms488_1175718195;
extern T7*ms83_20558205;
extern T7*ms61_891552598;
extern T7*ms20_2042907574;
extern T7*ms20_400652;
extern T7*ms21_936296820;
extern T7*ms206_9130;
extern T7*ms48_143937264;
extern T7*ms59_1490742422;
extern T7*ms61_772983982;
extern T7*ms48_8976;
extern T7*ms385_1561552493;
extern T7*ms83_901897617;
extern T7*ms62_1646a;
extern T7*ms62_8305;
extern T7*ms62_8260;
extern T7*ms59_1490742447;
extern T7*ms37_1021024803;
extern T7*ms526_1618543;
extern T7*ms96_208313786;
extern T7*ms59_1490742472;
extern T7*ms37_938675437;
extern T7*ms20_1994852;
extern T7*ms59_1490742497;
extern T7*ms326_300;
extern T7*ms38_141444;
extern T7*ms440_273430240;
extern T7*ms359_419443;
extern T7*ms444_49680837;
extern T7*ms37_181806522;
extern T7*ms60_744114;
extern T7*ms271_1919392481;
extern T7*ms276_26975293;
extern T7*ms96_826425832;
extern T7*ms96_1484470448;
extern T7*ms326_361;
extern T7*ms97_2014931627;
extern T7*ms37_1950357785;
extern T7*ms326_366;
extern T7*ms211_1362370015;
extern T7*ms279_1973901270;
extern T7*ms519_1618544;
extern T7*ms62_9130;
extern T7*ms205_1728089446;
extern T7*ms20_1994621;
extern T7*ms287_2094878563;
extern T7*ms21_2246041;
extern T7*ms465_3172;
extern T7*ms61_473790304;
extern T7*ms292_1141945772;
extern T7*ms18_136281127;
extern T7*ms465_3175;
extern T7*ms341_746725232;
extern T7*ms37_1724356412;
extern T7*ms61_1225686025;
extern T7*ms62_365929075;
extern T7*ms21_1856946950;
extern T7*ms18_142550;
extern T7*ms325_2251910;
extern T7*ms60_32080;
extern T7*ms21_240810604;
extern T7*ms20_12331;
extern T7*ms21_619776399;
extern T7*ms60_1824713404;
extern T7*ms346_251;
extern T7*ms524_1618328;
extern T7*ms61_74133124;
extern T7*ms21_240810599;
extern T7*ms48_1236979201;
extern T7*ms59_13801;
extern T7*ms72_1731115754;
extern T7*ms20_402346;
extern T7*ms62_18257;
extern T7*ms465_2947;
extern T7*ms326_744;
extern T7*ms19_331;
extern T7*ms37_204656687;
extern T7*ms19_329;
extern T7*ms19_334;
extern T7*ms83_1898670837;
extern T7*ms385_108351709;
extern T7*ms83_738771309;
extern T7*ms37_629850238;
extern T7*ms48_0;
extern T7*ms385_900720;
extern T7*ms60_9905;
extern T7*ms83_23988287;
extern T7*ms37_11302a;
extern T7*ms37_1910692676;
extern T7*ms21_49076823;
extern T7*ms37_2018314726;
extern T7*ms444_986930951;
extern T7*ms83_225699312;
extern T7*ms20_79815491;
extern T7*ms42_563444330;
extern T7*ms83_143624248;
extern T7*ms62_672427151;
extern T7*ms42_1539722017;
extern T7*ms48_0aaa;
extern T7*ms48_1102814319;
extern T7*ms60_653639191;
extern T7*ms152_230;
extern T7*ms470_422849931;
extern T7*ms20_1010242914;
extern T7*ms37_2016523575;
extern T7*ms188_1395974104;
extern T7*ms73_309360400;
extern T7*ms37_867131816;
extern T7*ms379_809795;
extern T7*ms59_103;
extern T7*ms20_298390;
extern T7*ms59_112;
extern T7*ms432_1556476521;
extern T7*ms20_877484516;
extern T7*ms59_116;
extern T7*ms385_1400582480;
extern T7*ms385_1895969346;
extern T7*ms20_2054139374;
extern T7*ms59_1289877087;
extern T7*ms48_1984046136;
extern T7*ms324_1888091524;
extern T7*ms59_438660461;
extern T7*ms20_1988096;
extern T7*ms341_56655830;
extern T7*ms59_1378261354;
extern T7*ms470_20974295;
extern T7*ms193_1379248421;
extern T7*ms59_240;
extern T7*ms444_118716790;
extern T7*ms97_3147;
extern T7*ms21_54325331;
extern T7*ms385_188188376;
extern T7*ms83_1253959973;
extern T7*ms83_1728206941;
extern T7*ms48_1631212670;
extern T7*ms440_1880471656;
extern T7*ms326_1190106281;
extern T7*ms37_849606800;
extern T7*ms385_245384155;
extern T7*ms370_1151218857;
extern T7*ms292_324521195;
extern T7*ms279_1826154197a;
extern T7*ms83_1627956294;
extern T7*ms62_1419822228;
extern T7*ms60_153655;
extern T7*ms60_7869aaaa;
extern T7*ms59_526;
extern T7*ms20_1138570986;
extern T7*ms21_2090604340;
extern T7*ms346_2144688644;
extern T7*ms21_279416444;
extern T7*ms59_1950430678;
extern T7*ms440_23463394;
extern T7*ms20_1754150081;
extern T7*ms37_1380562254;
extern T7*ms83_60;
extern T7*ms59_651;
extern T7*ms84_252;
extern T7*ms60_33885;
extern T7*ms37_2141291014;
extern T7*ms83_32869;
extern T7*ms444_1897580075;
extern T7*ms37_825716016;
extern T7*ms21_2187483;
extern T7*ms21_2187464;
extern T7*ms37_445504446a;
extern T7*ms376_322102056;
extern T7*ms122_2009288523;
extern T7*ms276_1879799154;
extern T7*ms348_960364148;
extern T7*ms48_44119;
extern T7*ms381_1166590709;
extern T7*ms48_876917780;
extern T7*ms84_6926;
extern T7*ms59_125792922;
extern T7*ms206_229510;
extern T7*ms37_762747069;
extern T7*ms21_1339128;
extern T7*ms60_24669254;
extern T7*ms37_595780742;
extern T7*ms20_16001;
extern T7*ms60_525205114;
extern T7*ms152_1621200;
extern T7*ms48_1461099594;
extern T7*ms444_1637595774;
extern T7*ms21_867350214;
extern T7*ms385_81370;
extern T7*ms83_20552830;
extern T7*ms444_444775459;
extern T7*ms154_323701;
extern T7*ms20_15574;
extern T7*ms61_164956856;
extern T7*ms83_1348520454;
extern T7*ms83_34415;
extern T7*ms18_1506066634;
extern T7*ms59_203051301;
extern T7*ms62_1085305030;
extern T7*ms20_16264;
extern T7*ms385_475574404;
extern T7*ms83_2022630;
extern T7*ms60_9980719a;
extern T7*ms48_1866433364;
extern T7*ms359_484169497;
extern T7*ms327_244699380;
extern T7*ms21_1326673961;
extern T7*ms309_3190;
extern T7*ms526_750;
extern T7*ms21_1286698901;
extern T7*ms37_441048635;
extern T7*ms61_1125596082;
extern T7*ms18_704546752;
extern T7*ms385_188394864;
extern T7*ms21_2236118;
extern T7*ms341_1966571694;
extern T7*ms48_45436;
extern T7*ms168_1263631766;
extern T7*ms21_1377517899;
extern T7*ms104_1100;
extern T7*ms21_33120277;
extern T7*ms20_17221;
extern T7*ms21_247239028;
extern T7*ms21_1297876698;
extern T7*ms20_56612951;
extern T7*ms62_32605;
extern T7*ms123_2015374870;
extern T7*ms465_8260;
extern T7*ms20_16761;
extern T7*ms37_1697171302;
extern T7*ms341_1013542117;
extern T7*ms20_752996481;
extern T7*ms21_1223936132;
extern T7*ms59_22915015;
extern T7*ms37_1138390195;
extern T7*ms61_1700107276;
extern T7*ms20_1839765037;
extern T7*ms131_241077355;
extern T7*ms279_1826154197;
extern T7*ms20_37202594;
extern T7*ms37_538692491;
extern T7*ms444_257498083;
extern T7*ms20_16942;
extern T7*ms20_17480;
extern T7*ms59_839960169;
extern T7*ms20_18036;
extern T7*ms325_1650;
extern T7*ms359_291421585;
extern T7*ms266_167445550;
extern T7*ms21_386854;
extern T7*ms83_937932;
extern T7*ms20_407540;
extern T7*ms20_18090;
extern T7*ms20_18150;
extern T7*ms165_899910547;
extern T7*ms385_5654700;
extern T7*ms20_17715;
extern T7*ms61_358119448;
extern T7*ms20_408086;
extern T7*ms21_65574;
extern T7*ms62_212314278;
extern T7*ms37_1538234998;
extern T7*ms60_7869aaa;
extern T7*ms38_210310269;
extern T7*ms292_789877170;
extern T7*ms385_1816589238;
extern T7*ms17_478359440;
extern T7*ms21_438300;
extern T7*ms380_830099621;
extern T7*ms359_576790349;
extern T7*ms48_1291097955;
extern T7*ms20_867907918;
extern T7*ms96_1905406134;
extern T7*ms48_2075119688;
extern T7*ms48_179868158;
extern T7*ms21_1236707441;
extern T7*ms363_1764244777;
extern T7*ms21_733277224;
extern T7*ms62_5161461;
extern T7*ms83_36951;
extern T7*ms21_1574640467;
extern T7*ms444_1197879602;
extern T7*ms461_87517;
extern T7*ms89_1809088081;
extern T7*ms385_1359655098;
extern T7*ms21_904828090;
extern T7*ms62_249330648;
extern T7*ms21_1622700141;
extern T7*ms444_149759763;
extern T7*ms21_48958735;
extern T7*ms48_447734;
extern T7*ms427_1873512573;
extern T7*ms72_2007192211;
extern T7*ms461_1295480311;
extern T7*ms279_108351709;
extern T7*ms62_720252832;
extern T7*ms62_35404;
extern T7*ms73_1492005482;
extern T7*ms37_1330069409;
extern T7*ms449_11319686;
extern T7*ms95_1612081;
extern T7*ms142_1389744524;
extern T7*ms525_322003652;
extern T7*ms269_1324933885;
extern T7*ms21_9647090;
extern T7*ms359_998144220;
extern T7*ms62_284aa;
extern T7*ms37_2047202317a;
extern T7*ms20_10208843;
extern T7*ms243_287;
extern T7*ms83_203646;
extern T7*ms37_1460213717;
extern T7*ms21_1597390874;
extern T7*ms62_1800342110;
extern T7*ms83_1725307161;
extern T7*ms48_1772235;
extern T7*ms37_1545228536;
extern T7*ms139_1246443131;
extern T7*ms427_858747666;
extern T7*ms38_349372;
extern T7*ms385_2088896243;
extern T7*ms48_1319327951;
extern T7*ms62_1665297219;
extern T7*ms20_14538933;
extern T7*ms371_1694564278;
extern T7*ms440_471247814;
extern T7*ms61_753046307;
extern T7*ms18_546820847;
extern T7*ms61_1409824798;
extern T7*ms37_586311386;
extern T7*ms152_4052132;
extern T7*ms48_581585530;
extern T7*ms20_215791;
extern T7*ms89_16902;
extern T7*ms73_225645047;
extern T7*ms48_449342;
extern T7*ms83_4204001;
extern T7*ms60_834589410;
extern T7*ms48_448859;
extern T7*ms437_1084568520;
extern T7*ms83_1276355212;
extern T7*ms37_332623945;
extern T7*ms21_11011040;
extern T7*ms83_273731430;
extern T7*ms164_1240817101;
extern T7*ms359_943358957;
extern T7*ms206_179423058;
extern T7*ms19_1445869078;
extern T7*ms21_2104;
extern T7*ms21_971749965;
extern T7*ms385_87090;
extern T7*ms59_797060818;
extern T7*ms341_440473309;
extern T7*ms350_1837585965;
extern T7*ms37_372047073;
extern T7*ms61_1781104140;
extern T7*ms21_2099;
extern T7*ms21_7704337;
extern T7*ms444_189437896;
extern T7*ms83_455756746;
extern T7*ms385_1715920859a;
extern T7*ms62_41861;
extern T7*ms359_1288623074;
extern T7*ms245_1263631766;
extern T7*ms385_475042348;
extern T7*ms37_431394186a;
extern T7*ms211_32103795;
extern T7*ms60_113001857;
extern T7*ms60_1124779458;
extern T7*ms21_1960;
extern T7*ms20_384451081;
extern T7*ms37_375534514;
extern T7*ms20_820292;
extern T7*ms21_1972;
extern T7*ms205_143305;
extern T7*ms385_88060;
extern T7*ms523_322452;
extern T7*ms326_811199186;
extern T7*ms27_1590873191;
extern T7*ms21_80109;
extern T7*ms131_1271;
extern T7*ms427_1873512573a;
extern T7*ms18_1719;
extern T7*ms21_3075;
extern T7*ms139_1397880841;
extern T7*ms280_6511;
extern T7*ms83_173632912;
extern T7*ms62_69947558;
extern T7*ms37_1685006358;
extern T7*ms18_874467418;
extern T7*ms427_473393039;
extern T7*ms96_10;
extern T7*ms62_1196941282;
extern T7*ms37_348041349;
extern T7*ms313_4668170;
extern T7*ms37_78263;
extern T7*ms21_446841;
extern T7*ms21_80416;
extern T7*ms37_494839979;
extern T7*ms21_3421;
extern T7*ms37_2053867462;
extern T7*ms96_82;
extern T7*ms356_555435463;
extern T7*ms21_3501;
extern T7*ms348_1864419121;
extern T7*ms83_34603044;
extern T7*ms359_1069766146a;
extern T7*ms37_630883461;
extern T7*ms104_7207;
extern T7*ms37_937061724;
extern T7*ms21_397576;
extern T7*ms21_2174354;
extern T7*ms21_447584;
extern T7*ms279_1373128003;
extern T7*ms385_932183207;
extern T7*ms292_1573210512;
extern T7*ms379_46;
extern T7*ms83_1087530433;
extern T7*ms21_3669;
extern T7*ms21_80694;
extern T7*ms136_1082443815;
extern T7*ms360_2000662912;
extern T7*ms37_1962710217;
extern T7*ms37_390809736;
extern T7*ms385_114321512;
extern T7*ms21_447851;
extern T7*ms62_1403828457;
extern T7*ms60_103522334;
extern T7*ms59_1024938238;
extern T7*ms96_759184012;
extern T7*ms48_57487;
extern T7*ms59_1876627592;
extern T7*ms21_774649014;
extern T7*ms48_39617954;
extern T7*ms38_1711985232;
extern T7*ms21_168164374;
extern T7*ms61_2026211842;
extern T7*ms325_93134055;
extern T7*ms21_112335826;
extern T7*ms37_1861857328;
extern T7*ms59_205254600;
extern T7*ms123_462691396;
extern T7*ms59_1994596535;
extern T7*ms62_44739;
extern T7*ms385_1735971161;
extern T7*ms60_2118444283;
extern T7*ms37_377533302;
extern T7*ms37_1071750288;
extern T7*ms60_423280;
extern T7*ms60_457054882;
extern T7*ms96_293181954;
extern T7*ms48_3498891;
extern T7*ms376_2104240264;
extern T7*ms379_607690624;
extern T7*ms84_1753572602;
extern T7*ms20_2073386;
extern T7*ms385_1942608409;
extern T7*ms83_1777292479;
extern T7*ms59_1941861967;
extern T7*ms59_1200304419;
extern T7*ms267_155280342;
extern T7*ms385_202745083;
extern T7*ms37_1550836304;
extern T7*ms20_328704871;
extern T7*ms444_35343969;
extern T7*ms385_1693063785;
extern T7*ms18_1076788795;
extern T7*ms385_1574146891;
extern T7*ms385_59397236;
extern T7*ms444_1869700848;
extern T7*ms61_439169454;
extern T7*ms48_1826831355;
extern T7*ms83_1765316316;
extern T7*ms21_77832;
extern T7*ms245_1841665413;
extern T7*ms461_526331452;
extern T7*ms37_1559455194;
extern T7*ms61_510352234;
extern T7*ms60_60405;
extern T7*ms385_1997940;
extern T7*ms37_1250095432;
extern T7*ms37_432335312;
extern T7*ms17_28292987;
extern T7*ms20_40700;
extern T7*ms83_10703002;
extern T7*ms83_2121209581;
extern T7*ms62_46525;
extern T7*ms73_773063953;
extern T7*ms317_1214068530;
extern T7*ms488_22997809;
extern T7*ms440_1334327885;
extern T7*ms37_2001790502;
extern T7*ms59_401124480;
extern T7*ms62_411775958;
extern T7*ms178_138929174;
extern T7*ms350_794211032;
extern T7*ms20_11300605;
extern T7*ms72_1240319482;
extern T7*ms20_1981509924;
extern T7*ms89_9808515;
extern T7*ms73_867907918;
extern T7*ms444_49806180;
extern T7*ms60_21409905;
extern T7*ms20_11251026;
extern T7*ms385_101405226;
extern T7*ms48_698995372;
extern T7*ms385_1998060;
extern T7*ms48_59731;
extern T7*ms37_89092044;
extern T7*ms279_246;
extern T7*ms118_914877497;
extern T7*ms48_836475934;
extern T7*ms59_1230839011;
extern T7*ms21_79341;
extern T7*ms359_775406525;
extern T7*ms62_842464717;
extern T7*ms37_445504446;
extern T7*ms60_5394280a;
extern T7*ms359_1069766146;
extern T7*ms37_175744316;
extern T7*ms21_1740332382;
extern T7*ms38_2537;
extern T7*ms62_1831440704;
extern T7*ms82_1750778;
extern T7*ms444_249328889;
extern T7*ms326_1965730;
extern T7*ms37_1956416552;
extern T7*ms131_1172474923;
extern T7*ms440_1062034894;
extern T7*ms37_1532919189;
extern T7*ms17_28292341;
extern T7*ms89_34086;
extern T7*ms37_2102385657;
extern T7*ms341_1557109223;
extern T7*ms385_168532;
extern T7*ms96_2072064738;
extern T7*ms60_2092663259;
extern T7*ms166_1369876739;
extern T7*ms73_404453571;
extern T7*ms20_36951;
extern T7*ms18_218233;
extern T7*ms48_51699930;
extern T7*ms37_1181926797;
extern T7*ms359_1314337673;
extern T7*ms60_9980719aa;
extern T7*ms20_2065491;
extern T7*ms96_26975293;
extern T7*ms48_242975417;
extern T7*ms37_175744691;
extern T7*ms366_337310553;
extern T7*ms60_1007239;
extern T7*ms89_33885;
extern T7*ms449_1156329759;
extern T7*ms205_1426;
extern T7*ms59_604558099;
extern T7*ms21_84969;
extern T7*ms359_1295032451;
extern T7*ms83_705425016;
extern T7*ms21_90544;
extern T7*ms37_1062019645;
extern T7*ms37_431394186;
extern T7*ms21_1053896806;
extern T7*ms444_2006740748;
extern T7*ms292_1369508129;
extern T7*ms21_1498845794;
extern T7*ms362_1681910507;
extern T7*ms254_1096645863;
extern T7*ms60_775396;
extern T7*ms82_878860;
extern T7*ms121_134876562;
extern T7*ms18_219216;
extern T7*ms444_110;
extern T7*ms385_1205;
extern T7*ms59_1680944214;
extern T7*ms385_1280;
extern T7*ms83_958608135;
extern T7*ms385_1284;
extern T7*ms60_680177517;
extern T7*ms82_927785894;
extern T7*ms385_1295;
extern T7*ms385_1413;
extern T7*ms20_1308256781;
extern T7*ms470_1160736641;
extern T7*ms245_673325704;
extern T7*ms121_671015455;
extern T7*ms359_598811726;
extern T7*ms444_382;
extern T7*ms385_1715920859;
extern T7*ms37_922212712;
extern T7*ms83_1779522914;
extern T7*ms20_1071750288;
extern T7*ms385_1609;
extern T7*ms465_4631170;
extern T7*ms217_53106191;
extern T7*ms385_1650;
extern T7*ms61_712276;
extern T7*ms317_183257;
extern T7*ms61_216a;
extern T7*ms59_7918258;
extern T7*ms20_384465;
extern T7*ms444_125892905;
extern T7*ms205_3293;
extern T7*ms37_973007162;
extern T7*ms91_1031515224;
extern T7*ms59_1025105601;
extern T7*ms385_2403;
extern T7*ms59_2129633545;
extern T7*ms385_165715;
extern T7*ms385_10895;
extern T7*ms21_87541;
extern T7*ms444_1215177661;
extern T7*ms99_1393094289;
extern T7*ms21_88048;
extern T7*ms21_88049;
extern T7*ms385_2395;
extern T7*ms18_1740192162;
extern T7*ms222_793028699;
extern T7*ms38_136264778;
extern T7*ms165_253892190;
extern T7*ms385_813409;
extern T7*ms385_245913414;
extern T7*ms385_12079;
extern T7*ms501_1896420902;
extern T7*ms48_1023953763;
extern T7*ms60_6455a;
extern T7*ms383_3468;
extern T7*ms139_853752579;
extern T7*ms444_1284;
extern T7*ms440_4734146;
extern T7*ms83_1240218271;
extern T7*ms61_23301310;
extern T7*ms385_53329675;
extern T7*ms122_1318898854;
extern T7*ms385_2670;
extern T7*ms385_3175;
extern T7*ms359_1242450095;
extern T7*ms279_1379665550;
extern T7*ms59_3541509;
extern T7*ms385_265a;
extern T7*ms96_1888555933;
extern T7*ms20_46;
extern T7*ms37_824653683;
extern T7*ms48_69601;
extern T7*ms83_218198560;
extern T7*ms37_804145850;
extern T7*ms20_436196;
extern T7*ms180_580671671;
extern T7*ms523_35907;
extern T7*ms380_77412;
extern T7*ms325_485184123;
extern T7*ms48_228399374;
extern T7*ms83_1102979933;
extern T7*ms83_1371497790;
extern T7*ms385_345a;
extern T7*ms385_296a;
extern T7*ms83_64800;
extern T7*ms205_427957207;
extern T7*ms21_88795;
extern T7*ms60_966152571;
extern T7*ms444_2382;
extern T7*ms461_614559914;
extern T7*ms48_69851;
extern T7*ms96_1200006371;
extern T7*ms359_77562923;
extern T7*ms21_244781926;
extern T7*ms21_89510;
extern T7*ms21_35;
extern T7*ms21_42;
extern T7*ms20_437070;
extern T7*ms21_43;
extern T7*ms21_45;
extern T7*ms21_47;
extern T7*ms385_1449951397;
extern T7*ms18_199827552;
extern T7*ms488_1413407004;
extern T7*ms21_60;
extern T7*ms21_61;
extern T7*ms21_62;
extern T7*ms21_64;
extern T7*ms20_391651;
extern T7*ms21_94;
extern T7*ms238_1369876739;
extern T7*ms385_1295a;
extern T7*ms37_881601516;
extern T7*ms245_367486352;
extern T7*ms20_436911;
extern T7*ms346_696937580;
extern T7*ms89_397949195;
extern T7*ms83_11086084;
extern T7*ms37_928941315;
extern T7*ms21_55926626;
extern T7*ms83_5367889;
extern T7*ms21_849712179;
extern T7*ms37_800364721;
extern T7*ms60_269139657;
extern T7*ms37_955638361;
extern T7*ms48_76405;
extern T7*ms379_1627269957;
extern T7*ms316_1917891272;
extern T7*ms359_2095490029;
extern T7*ms385_471a;
extern T7*ms48_793284570;
extern T7*ms37_1331837650;
extern T7*ms83_1426575877;
extern T7*ms326_77412;
extern T7*ms350_1952587812;
extern T7*ms37_1351360066;
extern T7*ms317_180037;
extern T7*ms104_4479182;
extern T7*ms522_58367254;
extern T7*ms48_194;
extern T7*ms48_301;
extern T7*ms48_304;
extern T7*ms21_175767198;
extern T7*ms48_324;
extern T7*ms470_879665703;
extern T7*ms48_326;
extern T7*ms48_327;
extern T7*ms48_333;
extern T7*ms83_1284;
extern T7*ms48_340;
extern T7*ms99_2129004198;
extern T7*ms48_341;
extern T7*ms48_336;
extern T7*ms131_1754150081;
extern T7*ms48_293;
extern T7*ms48_297;
extern T7*ms21_378799862;
extern T7*ms385_4680700;
extern T7*ms60_423280aaa;
extern T7*ms359_585110409;
extern T7*ms18_1812938425;
extern T7*ms59_2071069951;
extern T7*ms20_443432;
extern T7*ms60_548441155;
extern T7*ms444_689812670;
extern T7*ms359_1682659883;
extern T7*ms60_641475824a;
extern T7*ms48_1494914262;
extern T7*ms359_1265395998;
extern T7*ms83_4469182;
extern T7*ms385_1772971310;
extern T7*ms131_377819028;
extern T7*ms385_6305;
extern T7*ms21_520438282;
extern T7*ms48_603;
extern T7*ms21_10377643;
extern T7*ms21_244783893;
extern T7*ms72_116011447;
extern T7*ms205_1103861333;
extern T7*ms154_186045;
extern T7*ms38_210141519;
extern T7*ms48_594;
extern T7*ms20_11381817;
extern T7*ms37_1301660112;
extern T7*ms21_324411;
extern T7*ms20_439136;
extern T7*ms42_188525860;
extern T7*ms96_674382779;
extern T7*ms380_1140065898;
extern T7*ms48_674;
extern T7*ms48_39204698;
extern T7*ms385_6396;
extern T7*ms385_6455;
extern T7*ms521_272092387;
extern T7*ms48_689;
extern T7*ms385_162070;
extern T7*ms380_79775;
extern T7*ms60_423280a;
extern T7*ms380_157716425;
extern T7*ms359_233907729;
extern T7*ms20_2248337;
extern T7*ms205_828911582;
extern T7*ms37_2060540980;
extern T7*ms385_7025;
extern T7*ms385_162045;
extern T7*ms385_6534;
extern T7*ms470_115;
extern T7*ms48_115188994;
extern T7*ms385_162020;
extern T7*ms37_941240074;
extern T7*ms48_1972658421;
extern T7*ms60_658615564;
extern T7*ms444_1208251348;
extern T7*ms180_753568822;
extern T7*ms21_55924644;
extern T7*ms83_2395;
extern T7*ms21_274599;
extern T7*ms83_3015;
extern T7*ms385_281556707;
extern T7*ms83_443764493;
extern T7*ms37_11302;
extern T7*ms83_2630;
extern T7*ms37_1744209811;
extern T7*ms325_1492662176;
extern T7*ms327_1942949944;
extern T7*ms385_1449951397a;
extern T7*ms48_0aa;
extern T7*ms21_1607595572;
extern T7*ms188_766872687;
extern T7*ms341_1952787551;
extern T7*ms48_137550186;
extern T7*ms60_1096165867;
extern T7*ms380_897982986;
extern T7*ms37_1731250773;
extern T7*ms317_2105482;
extern T7*ms48_50246554;
extern T7*ms385_1595618529;
extern T7*ms385_6965;
extern T7*ms20_51843716;
extern T7*ms62_1527651872;
extern T7*ms20_300594;
extern T7*ms61_1518885935;
extern T7*ms440_7487;
extern T7*ms37_168971224;
extern T7*ms21_1447702;
extern T7*ms470_660;
extern T7*ms20_1883968684;
extern T7*ms48_128214728;
extern T7*ms20_10876026;
extern T7*ms444_6427;
extern T7*ms385_37173080;
extern T7*ms20_451011;
extern T7*ms18_1115094588;
extern T7*ms245_1141347885;
extern T7*ms159_757353095;
extern T7*ms268_1223700793;
extern T7*ms21_50246319;
extern T7*ms20_9909665;
extern T7*ms444_6550;
extern T7*ms73_846328008;
extern T7*ms385_160205;
extern T7*ms385_7869;
extern T7*ms62_2045816469;
extern T7*ms37_16572000;
extern T7*ms21_279656751;
extern T7*ms461_1466201847;
extern T7*ms48_152027832;
extern T7*ms21_55868341;
extern T7*ms139_327916;
extern T7*ms385_160111;
extern T7*ms83_389665003;
extern T7*ms61_1754027858;
extern T7*ms37_47798174;
extern T7*ms359_1411018665;
extern T7*ms271_1814961148;
extern T7*ms37_2127445170;
extern T7*ms444_53329675;
extern T7*ms37_565334390;
extern T7*ms21_171638715;
extern T7*ms376_319078760;
extern T7*ms96_1271;
extern T7*ms20_396356;
extern T7*ms139_854711854;
extern T7*ms205_706329;
extern T7*ms276_85643;
extern T7*ms525_1618329;
extern T7*ms62_160930;
extern T7*ms271_529996976;
extern T7*ms73_430276609;
extern T7*ms61_8895;
extern T7*ms444_38305571;
extern T7*ms99_1854646737;
extern T7*ms461_156691852;
extern T7*ms48_1091987;
extern T7*ms61_1801741785;
extern T7*ms48_550783544;
extern T7*ms96_1565;
extern T7*ms37_2037548;
extern T7*ms213_535614889;
extern T7*ms385_8885;
extern T7*ms37_1078639380;
extern T7*ms62_503314970;
extern T7*ms21_41849945;
extern T7*ms341_635;
extern T7*ms21_1501191;
extern T7*ms444_2007398957;
extern T7*ms48_91157;
extern T7*ms20_671063316;
extern T7*ms385_2138778683;
extern T7*ms139_39130851;
extern T7*ms62_433411101;
extern T7*ms461_1474035421;
extern T7*ms60_7869aa;
extern T7*ms60_884381655;
extern T7*ms470_905827712;
extern T7*ms444_7869;
extern T7*ms21_840111968;
extern T7*ms60_1636835183;
extern T7*ms292_2044092858;
extern T7*ms18_809623138;
extern T7*ms178_300594;
extern T7*ms62_1313445026;
extern T7*ms37_1341733285;
extern T7*ms292_539917548;
extern T7*ms96_1677173506;
extern T7*ms96_943110089;
extern T7*ms73_1493757059;
extern T7*ms325_244699380a;
extern T7*ms62_407207;
extern T7*ms59_1469467630;
extern T7*ms21_280482649;
extern T7*ms60_78082;
extern T7*ms21_7173699;
extern T7*ms444_167317;
extern T7*ms60_1927425;
extern T7*ms73_214953505;
extern T7*ms60_78271;
extern T7*ms21_12184;
extern T7*ms60_83290;
extern T7*ms217_2033272607;
extern T7*ms37_446380143;
extern T7*ms18_707328903;
extern T7*ms59_177229903;
extern T7*ms180_1144475034;
extern T7*ms48_1429938878;
extern T7*ms444_1240206596;
extern T7*ms385_11879796;
extern T7*ms21_10018876;
extern T7*ms62_2124916149;
extern T7*ms21_1419919903;
extern T7*ms59_1341494671;
extern T7*ms37_469031018;
extern T7*ms21_12376;
extern T7*ms83_6651;
extern T7*ms62_280766651;
extern T7*ms21_179371455;
extern T7*ms72_628135516;
extern T7*ms136_319972504;
extern T7*ms21_1742738754;
extern T7*ms38_1520107011;
extern T7*ms60_1514442508;
extern T7*ms523_4511056;
extern T7*ms292_1775768883;
extern T7*ms21_756809447;
extern T7*ms385_941993080;
extern T7*ms21_705019679;
extern T7*ms449_36977;
extern T7*ms385_928754688;
extern T7*ms359_22760;
extern T7*ms48_678217330;
extern T7*ms62_1360462097;
extern T7*ms62_976559263;
extern T7*ms37_732257893;
extern T7*ms380_1066862250;
extern T7*ms61_847092098;
extern T7*ms62_1029549485;
extern T7*ms311_3118;
extern T7*ms20_398948;
extern T7*ms20_2187619;
extern T7*ms359_223052221;
extern T7*ms461_292134801;
extern T7*ms99_895448585;
extern T7*ms89_240;
extern T7*ms444_969559328;
extern T7*ms139_1141224284;
extern T7*ms521_1935128719;
extern T7*ms60_7869a;
extern T7*ms385_191602377;
extern T7*ms449_10322525;
extern T7*ms346_875697492;
extern T7*ms89_348;
extern T7*ms48_530877013;
extern T7*ms444_1284a;
extern T7*ms37_1636436113;
extern T7*ms385_1903915589;
extern T7*ms60_1425117810;
extern T7*ms60_1223919505;
extern T7*ms37_1275558331;
extern T7*ms165_1797674551;
extern T7*ms385_215689314;
extern T7*ms465_16487;
extern T7*ms60_641475824;
extern T7*ms385_32080;
extern T7*ms83_78591;
extern T7*ms89_16902a;
extern T7*ms61_32926;
extern T7*ms83_78646;
extern T7*ms21_14150;
extern T7*ms60_692075493;
extern T7*ms20_1495656936;
extern T7*ms83_7869;
extern T7*ms21_1979951;
extern T7*ms444_40031469;
T7*se_ms(int c,char*e);
T7*se_string(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void se_msi10(void);
void se_msi11(void);
void se_msi12(void);
void se_msi13(void);
void se_msi14(void);
void se_msi15(void);
void se_msi16(void);
void se_msi17(void);
void se_msi18(void);
void se_msi19(void);
void se_msi20(void);
void se_msi21(void);
void se_msi22(void);
void se_msi23(void);
void se_msi24(void);
void se_msi25(void);
void se_msi26(void);
void se_msi27(void);
void se_msi28(void);
void se_msi29(void);
void se_msi30(void);
void se_msi31(void);
void se_msi32(void);
void se_msi33(void);
void se_msi34(void);
void se_msi35(void);
void*se_ma433(int argc,...);
void*se_ma52(int argc,...);
T0* X151result_type(T0*C);
T104 X151start_position(T0*C);
void X98set_ensure_assertion(T0*C,T0* a1);
void X98set_rescue_compound(T0*C,T0* a1);
T0* X332to_runnable_character(T0*C,T0* a1);
T0* X332to_runnable_integer(T0*C,T0* a1);
T0* X332twin(T0*C);
T6 X117is_frozen(T0*C);
T0* X117to_key(T0*C);
T0* X117to_string(T0*C);
void X117undefine_in(T0*C,T0* a1);
void X117declaration_in(T0*C,T0* a1);
void X117mapping_c_in(T0*C,T0* a1);
T0* X117origin_base_class(T0*C);
T104 X117start_position(T0*C);
void X117put_cpp_tag(T0*C);
void X404put(T0*C,T0* a1,T2 a2);
T0* X404item(T0*C,T2 a1);
void X212put(T0*C,T0* a1,T2 a2);
T0* X212item(T0*C,T2 a1);
void X212add_last(T0*C,T0* a1);
void X212resize(T0*C,T2 a1);
T0* X212twin(T0*C);
void X499set_item(T0*C,T0* a1);
void X499set_next(T0*C,T0* a1);
void X245match_with(T0*C,T0* a1,T0* a2);
T6 X245isa_dca_inline(T0*C,T0* a1,T0* a2);
T0* X245to_runnable(T0*C,T0* a1);
T104 X245start_position(T0*C);
void X88add_last(T0*C,T0* a1);
void X127set_result_type(T0*C,T0* a1);
T0* X127to_string(T0*C);
void X127set_rank(T0*C,T2 a1);
T104 X127start_position(T0*C);
void X136c_initialize_in(T0*C,T0* a1);
T0* X136run_time_mark(T0*C);
T2 X136id(T0*C);
void X136mapping_cast(T0*C);
T6 X136is_c_unsigned_ptr(T0*C);
T2 X136nb(T0*C);
void X136c_type_for_argument_in(T0*C,T0* a1);
T6 X136is_c_char(T0*C);
T2 X136unsigned_padding(T0*C);
void X160compile_to_c(T0*C);
T6 X160stupid_switch(T0*C,T0* a1);
void X160afd_check(T0*C);
T6 X160use_current(T0*C);
T6 X160is_pre_computable(T0*C);
T0* X160add_comment(T0*C,T0* a1);
T0* X160to_runnable(T0*C,T0* a1);
void X160collect_c_tmp(T0*C);
T104 X160start_position(T0*C);
T6 X97use_current(T0*C);
T0* X99ensure_assertion(T0*C);
T0* X99arguments(T0*C);
T6 X99can_hide(T0*C,T0* a1,T0* a2);
void X99add_into(T0*C,T0* a1);
void X99set_clients(T0*C,T0* a1);
T0* X99require_assertion(T0*C);
T0* X99try_to_undefine(T0*C,T0* a1,T0* a2);
void X99check_obsolete(T0*C,T104 a1);
T0* X99result_type(T0*C);
T0* X99to_run_feature(T0*C,T0* a1,T0* a2);
void X99set_header_comment(T0*C,T0* a1);
T6 X99is_not_mergeable_with(T0*C,T0* a1);
T6 X99is_deferred(T0*C);
T104 X99start_position(T0*C);
void X122add_last(T0*C,T0* a1);
T6 X96can_be_dropped(T0*C);
T0* X96ensure_assertion(T0*C);
void X96fe_vffd7(T0*C);
T6 X96is_exported_in(T0*C,T0* a1);
T6 X96is_static(T0*C);
void X96vape_check_from(T0*C,T104 a1);
T0* X96arguments(T0*C);
T0* X96routine_body(T0*C);
void X96mapping_c(T0*C);
T6 X96is_once_function(T0*C);
T2 X96static_value_mem(T0*C);
T0* X96stupid_switch(T0*C,T0* a1);
T0* X96require_assertion(T0*C);
T0* X96result_type(T0*C);
void X96afd_check(T0*C);
T6 X96use_current(T0*C);
void X96address_of_c_mapping(T0*C);
T0* X96local_vars(T0*C);
void X96c_define(T0*C);
void X96address_of_c_define(T0*C,T0* a1);
void X96fall_down(T0*C);
T6 X96is_pre_computable(T0*C);
T0* X96clients(T0*C);
void X96collect_c_tmp(T0*C);
T6 X96is_deferred(T0*C);
T104 X96start_position(T0*C);
T0* X398item(T0*C,T2 a1);
void X398add_last(T0*C,T0* a1);
T0* X167make_runnable(T0*C,T0* a1,T0* a2,T0* a3);
T0* X167arguments(T0*C);
T6 X167stupid_switch(T0*C,T0* a1);
T2 X167arg_count(T0*C);
T6 X126c_simple(T0*C);
T6 X126can_be_dropped(T0*C);
T6 X126is_manifest_string(T0*C);
T6 X126is_static(T0*C);
T6 X126is_void(T0*C);
void X126compile_to_c(T0*C);
T6 X126is_result(T0*C);
T6 X126stupid_switch(T0*C,T0* a1);
void X126mapping_c_arg(T0*C,T0* a1);
T6 X126is_manifest_array(T0*C);
void X126dca_inline_argument(T0*C,T0* a1);
T2 X126isa_dca_inline_argument(T0*C);
void X126assertion_check(T0*C,T3 a1);
T0* X126result_type(T0*C);
void X126afd_check(T0*C);
T6 X126use_current(T0*C);
T2 X126static_value(T0*C);
void X126c_declare_for_old(T0*C);
void X126compile_to_c_old(T0*C);
void X126mapping_c_target(T0*C,T0* a1);
T2 X126to_integer_or_error(T0*C);
T6 X126is_pre_computable(T0*C);
T0* X126add_comment(T0*C,T0* a1);
T0* X126to_runnable(T0*C,T0* a1);
void X126collect_c_tmp(T0*C);
T6 X126is_current(T0*C);
T0* X126static_result_base_class(T0*C);
T104 X126start_position(T0*C);
void X62c_initialize_in(T0*C,T0* a1);
void X62c_type_for_external_in(T0*C,T0* a1);
T0* X62generic_list(T0*C);
T0* X62written_mark(T0*C);
T6 X62is_bit(T0*C);
T6 X62has_creation(T0*C,T0* a1);
T0* X62run_time_mark(T0*C);
T6 X62is_any(T0*C);
T2 X62c_sizeof(T0*C);
void X62c_type_for_result_in(T0*C,T0* a1);
T6 X62is_formal_generic(T0*C);
void X62gc_mark_in(T0*C,T0* a1);
T6 X62is_native_array(T0*C);
void X62just_before_gc_mark_in(T0*C,T0* a1);
T6 X62is_pointer(T0*C);
T2 X62id(T0*C);
void X62mapping_cast(T0*C);
T0* X62static_base_class_name(T0*C);
T6 X62is_real(T0*C);
T6 X62is_none(T0*C);
void X62c_initialize(T0*C);
T6 X62is_anchored(T0*C);
T6 X62need_gc_mark_function(T0*C);
void X62c_type_for_argument_in(T0*C,T0* a1);
T6 X62stupid_switch(T0*C,T0* a1);
void X62c_frame_descriptor(T0*C);
T6 X62is_integer(T0*C);
T0* X62base_class_name(T0*C);
T0* X62run_type(T0*C);
T6 X62is_character(T0*C);
T6 X62is_expanded(T0*C);
T6 X62is_array(T0*C);
void X62gc_info_in(T0*C,T0* a1);
T0* X62base_class(T0*C);
T6 X62is_dummy_expanded(T0*C);
T6 X62need_c_struct(T0*C);
T6 X62is_reference(T0*C);
void X62gc_define1(T0*C);
T6 X62is_like_feature(T0*C);
void X62c_type_for_target_in(T0*C,T0* a1);
void X62gc_define2(T0*C);
T0* X62expanded_initializer(T0*C);
T0* X62actual_reference(T0*C,T0* a1);
void X62demangling_in(T0*C,T0* a1);
T6 X62is_a_in(T0*C,T0* a1,T0* a2);
T6 X62is_generic(T0*C);
T6 X62is_double(T0*C);
void X62id_extra_information(T0*C,T0* a1);
T6 X62is_user_expanded(T0*C);
T6 X62is_like_current(T0*C);
T6 X62is_a(T0*C,T0* a1);
T6 X62is_boolean(T0*C);
T6 X62is_like_argument(T0*C);
T0* X62to_runnable(T0*C,T0* a1);
T6 X62is_string(T0*C);
T0* X62run_class(T0*C);
void X62c_header_pass1(T0*C);
void X62c_header_pass2(T0*C);
T6 X62is_run_type(T0*C);
void X62c_header_pass3(T0*C);
void X62c_header_pass4(T0*C);
T104 X62start_position(T0*C);
T0* X62smallest_ancestor(T0*C,T0* a1);
T6 X62is_basic_eiffel_expanded(T0*C);
void X62gc_call_new_in(T0*C,T0* a1);
T6 X91stupid_switch_function(T0*C,T0* a1,T0* a2);
void X91c_define_function(T0*C,T0* a1,T0* a2,T0* a3);
void X91c_mapping_procedure(T0*C,T0* a1,T0* a2,T0* a3);
void X91c_define_procedure(T0*C,T0* a1,T0* a2,T0* a3);
T6 X91stupid_switch_procedure(T0*C,T0* a1,T0* a2);
T6 X91use_current(T0*C,T0* a1);
void X91c_mapping_function(T0*C,T0* a1,T0* a2,T0* a3);
void X279dca_inline(T0*C,T0* a1);
T0* X168arguments(T0*C);
T0* X168run_feature(T0*C);
T2 X397count(T0*C);
void X397append_in(T0*C,T0* a1);
T0* X141value(T0*C,T2 a1);
T104 X141start_position(T0*C);
T0* X238run_feature(T0*C);
T0* X222arguments(T0*C);
T0* X222run_feature(T0*C);
T2 X222arg_count(T0*C);
void X222finalize(T0*C);
void X498put(T0*C,T0* a1,T0* a2);
T0* X155last(T0*C);
void X155put(T0*C,T0* a1,T2 a2);
T0* X155item(T0*C,T2 a1);
T6 X155fast_has(T0*C,T0* a1);
void X155add_last(T0*C,T0* a1);
void X155resize(T0*C,T2 a1);
void X68add_last(T0*C,T0* a1);
void X339set_current_type(T0*C,T0* a1);
T0* X339to_runnable(T0*C,T0* a1);
T0* X199item(T0*C,T2 a1);
T6 X199fast_has(T0*C,T0* a1);
void X199add_last(T0*C,T0* a1);
T0* X199twin(T0*C);
void X381set_clients(T0*C,T0* a1);
T0* X381result_type(T0*C);
T104 X381start_position(T0*C);
#define T114toT111(x) (x)
#define T112toT111(x) (x)
#define T113toT111(x) (x)

#ifdef __cplusplus
}
#endif
