#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmallEiffel The GNU Eiffel Compiler
Release -0.76 (Friday 10th november 2000)
Copyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE
Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
http://SmallEiffel.loria.fr
*/
#ifdef __cplusplus
}
#endif
#include "install.h"
#ifdef __cplusplus
extern "C" {
#endif
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/base.c) is included for _all_ modes of 
  compilation (-boost, -no_check, ... -all_check, -debug_check).
*/

/*
  The wrapper for `malloc' (generated C code is supposed to use 
  only `se_malloc' instead of direct `malloc').
*/
void* se_malloc(size_t size) {
  void *result = malloc(size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_NO_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}

/*
  The wrapper for `calloc' (generated C code is supposed to use 
  only `se_calloc' instead of direct `calloc').
*/
void* se_calloc(size_t nmemb, size_t size) {
  void *result = calloc(nmemb,size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_NO_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}


int se_cmpT36(T36 o1,T36 o2){
return memcmp(&o1,&o2,sizeof(o1));}
T38 M38=0;
T51 M51={NULL,NULL};
T31 M31={0,0};
T17 M17={0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,{NULL,NULL},NULL};
T54 M54={54,NULL,0,0};
T37 M37={0};
T39 M39={NULL,NULL,NULL,NULL,0};
T46 M46={NULL,NULL};
T7 M7={NULL,0,0};
T40 M40={0,NULL,NULL,0};
T36 M36={NULL,NULL};
T44 M44={44,NULL,0,0,0};
T52 M52=NULL;
T34 M34=NULL;
T49 M49=NULL;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/

/*
  This file (SmallEiffel/sys/runtime/boost.c) is automatically included when
  `run_control.boost' is true (ie. only for mode -boost).
*/

void se_print_run_time_stack (void) {
  fprintf(SE_ERR,"Eiffel program crash at run time.\n");
  fprintf(SE_ERR,"No trace when using option \"-boost\"\n");
}

void sigrsp(int sig) {
  printf("Received signal %d (man signal).\n",sig);
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
}
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/basic_getenv.c) is automatically 
  included when the GENERAL.basic_getenv feature is used (ie. in live code).
*/

EIF_POINTER basic_getenv(EIF_POINTER name) {

  return ((EIF_POINTER)(getenv((char*)name)));
}
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://SmallEiffel.loria.fr
--
*/
/*
  This file (SmallEiffel/sys/runtime/basic_directory.c) is automatically 
  included when some external "SmallEiffel" feature of class BASIC_DIRECTORY
  is live.
*/

#ifdef WIN32
#define SIMULATED_MODE
/* The simulated mode for WIN32.
*/
typedef struct _SIMULATED_DIR {
  HANDLE handle;
  WIN32_FIND_DATA data;
  int entry_used;
} SIMULATED_DIR;

static SIMULATED_DIR* simulated_opendir(char* path) {
  int len = strlen((char*)path);
  char* pattern = se_malloc(len + 5); 
  SIMULATED_DIR* result = se_malloc(sizeof(SIMULATED_DIR));
  
  pattern = strcpy(pattern,(char*)path);
  if (pattern[len - 1] != '\\') pattern[len++] = '\\';
  pattern[len++] = '*';
  pattern[len++] = '.';
  pattern[len++] = '*';
  pattern[len++] = 0;
  result->handle = FindFirstFile(pattern,&(result->data));
  if (result->handle == INVALID_HANDLE_VALUE) {
    free(pattern);
    free(result);
    return NULL;
  }
  result->entry_used = 0;
  return result;
}

static void* simulated_readdir(SIMULATED_DIR* dirstream) {
  if (dirstream->entry_used) {
    if (FindNextFile(dirstream->handle,&(dirstream->data))) {
      dirstream->entry_used = 1;
      return dirstream;
    }
    else { 
      return NULL;
    }
  }
  else {
    dirstream->entry_used = 1;
    return dirstream;
  }
}

#define simulated_get_entry_name(x) ((x)->data.cFileName)

static int simulated_closedir(SIMULATED_DIR* dirstream) {
  FindClose(dirstream->handle);
  free(dirstream);
  return 0;
}


/* GCC(MingW32) doesn't need these prototypes; whereas, LCC needs them. */
char * getcwd(char* buffer, int maxlen);
int chdir(const char* buffer);
int mkdir(const char* directory_path);
int rmdir(const char* directory_path);


#define simulated_getcwd(x, y) getcwd(x, y)
#define simulated_chdir(x) chdir(x)
#define simulated_rmdir(x) rmdir(x)

int simulated_mkdir(const char* directory_path, int perm) {
   
  mkdir(directory_path);
  return 0;
}

#endif  /* WIN32 */

#ifdef AMIGA
#define SIMULATED_MODE
/* The simulated mode for AmigaOS 2.04+ 
   Author: Thomas Aglassinger <agi@rieska.oulu.fi>

   Normally this shouldn't be necessary as all compilers include a
   simulation of the Un*x directory API. However, they differ in
   certain details, often resulting into compiler errors. Thus a
   implementation using native AmigaDOS calls seems preferable.
 
   Note that many of the happenings below have to deal with the
   various idiosyncracies of the "dos.library", which are not all
   documented clearly in the Autodocs. The biggest surprises should
   be reflected in comments. But consider reading chapter 17 of
   Ralph Babel's "Amiga Guru Book" before changing anything.
*/
#include <exec/types.h>
#include <dos/dos.h>
#include <dos/dostags.h>

#include <proto/exec.h>
#include <proto/dos.h>

typedef struct _SIMULATED_DIR {
  struct FileInfoBlock *info;
  BPTR lock;
} SIMULATED_DIR;


/* Release all resources allocated during `simulated_opendir'; also
   works correctly if structure was only partially initialized.
*/
static void free_simulated_dir(SIMULATED_DIR * dir) {
  if (dir != NULL) {
    if (dir->lock != NULL) {
      UnLock(dir->lock);
    }
    if (dir->info != NULL) {
      FreeDosObject(DOS_FIB, dir->info);
    }
    free(dir);
  }
}

static SIMULATED_DIR * simulated_opendir(char *path) {
  BOOL ok = FALSE;
  SIMULATED_DIR *result = se_malloc(sizeof(SIMULATED_DIR));
  
  if (result != NULL) {
    result->lock = NULL;
    result->info = (struct FileInfoBlock *) AllocDosObject(DOS_FIB, NULL);
    if (result->info != NULL) {
      result->lock = Lock(path, ACCESS_READ);
      if (result->lock != NULL) {
	ok = (Examine(result->lock, result->info) != DOSFALSE);
	if (ok) {
	  /* Ensure we are scanning a directory, not a file */
	  ok = (result->info->fib_DirEntryType >= 0)
	    && (result->info->fib_DirEntryType != ST_SOFTLINK);
	}
      }
    }
  }
  if (!ok) {
    free_simulated_dir(result);
    result = NULL;
  }
  return result;
}

static void * simulated_readdir(SIMULATED_DIR * dirstream) {
  BOOL ok;
  SIMULATED_DIR *result = NULL;
  
  ok = (ExNext(dirstream->lock, dirstream->info) != DOSFALSE);
  
  if (ok) {
    result = dirstream;
  }
  return (void *) result;
}

#define simulated_get_entry_name(entry) ((entry)->info->fib_FileName)

static int simulated_closedir(SIMULATED_DIR * dirstream) {
  free_simulated_dir(dirstream);
  return 0;
}


static EIF_POINTER simulated_getcwd(char *buffer, size_t maximum_length) {
     EIF_POINTER result = NULL;
     BPTR lock = Lock("", ACCESS_READ);
     if (lock != NULL) {
       if (NameFromLock(lock, buffer, maximum_length) != DOSFALSE) {
         result = (EIF_POINTER) buffer;
       }
       UnLock(lock);
     }
     return result;
   }

static int simulated_chdir(char *name) {
  int result = -1;
  BPTR lock = Lock(name, ACCESS_READ);
  if (lock != NULL) {
    /* Change the current working directory (CWD) of the task 
     */
    BPTR old_lock = CurrentDir(lock);
    
    /* Attempt to update internal buffer of the process.
       If we are not running in a process, but a plain task, this
       call does not cause any harm.
    */
    /* FIXME: What's the result of SetCurrentDirName() in a plain
       task? If it is FALSE, the below code won't work. 
    */
    if (SetCurrentDirName(name)) {
      /* If this was successful, unlock `old_lock' because we
	 are not going to restore it later; this routine is one
	 of the few cases where such behavior is appropriate.
      */
      UnLock(old_lock);
      result = 0;
    } 
    else {
      /* If it fails, restore the previous CWD and make the
	 whole routine fail.
      */
      CurrentDir(old_lock);
    }
  }
  return result;
}

static void strip_trailing_slash(char *path, size_t *length, 
				 BOOL * stripped) {
  /* Used in `simulated_mkdir' and `simulated_rmdir' to temporarily
     blank out a possible traling slash (/) in the directory path.
     `restore_trailing_slash' puts it back in place afterwards.
  */
  *length = strlen(path);
  if ((*length > 0) && (path[*length - 1] == '/')) {
    *stripped = TRUE;
    path[*length - 1] = '\0';
  } else {
    *stripped = FALSE;
  }
}

static void restore_trailing_slash(char *path, size_t *length, 
				   BOOL * stripped) {
  if (*stripped) {
    path[*length - 1] = '/';
  }
}

static int simulated_mkdir(char *directory_path, int permission) {
  BPTR lock;
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;
  
  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  lock = CreateDir(directory_path);
  if (lock != NULL) {
    UnLock(lock);
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}

static int simulated_rmdir(char *directory_path) {
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;
  
  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  if (DeleteFile(directory_path)) {
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}
#endif /* AMIGA */

/*--------------------------------------------------------------------
  At his point, either this is a Linux/POSIX platform or some
  SIMULATED_MODE is defined. Unsupported platform should add their own
  SIMULATED_MODE before.
*/

EIF_POINTER basic_directory_open(EIF_POINTER path) {
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_open' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
#ifndef SIMULATED_MODE
  return (opendir(((char*) path)));
#else
  return (simulated_opendir(((char*) path)));
#endif
}

EIF_POINTER basic_directory_read_entry(EIF_POINTER dirstream) {
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_read_entry' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
#ifndef SIMULATED_MODE
  return readdir((DIR*)dirstream);
#else
  return simulated_readdir((SIMULATED_DIR*)dirstream);
#endif
}

EIF_POINTER basic_directory_get_entry_name(EIF_POINTER entry) {
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_get_entry_name' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
#ifndef SIMULATED_MODE
  return (((struct dirent*)entry)->d_name);
#else
  return simulated_get_entry_name((SIMULATED_DIR*)entry);
#endif
}

EIF_BOOLEAN basic_directory_close(EIF_POINTER dirstream) {
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_close' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = (closedir((DIR*)dirstream) == 0);
#else
  status = (simulated_closedir((SIMULATED_DIR*)dirstream) == 0);
#endif
  return ((EIF_BOOLEAN)(status ? 1 : 0));
}

EIF_POINTER basic_directory_current_working_directory(void) {
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_current_working_directory' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  static char* buf = NULL;
#ifdef WIN32
  /* MS Windows requires size to be an int; whereas in non-windows systems,
     it needs to be size_t
  */
  static int size = 0;
#else
  static size_t size = 0;
#endif
  int status;
  if (buf == NULL) {
    size = 256;
    buf = (char*)se_malloc(size);
  }
  

#ifndef SIMULATED_MODE
  status = (getcwd(buf,size) != NULL);
#else
  status = (simulated_getcwd(buf,size) != NULL);
#endif


  if (status) {
    return buf;
  }
  else {
    free(buf);
    size = size * 2;
    buf = (char*)se_malloc(size);
    return basic_directory_current_working_directory();
  }
}

EIF_BOOLEAN basic_directory_chdir(EIF_POINTER destination) {
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_chdir' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = (chdir((char*)destination));
#else
  status = simulated_chdir((char*)destination);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN basic_directory_mkdir(EIF_POINTER directory_path){
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_mkdir' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = (mkdir((char*)directory_path,0777));
#else
  status = simulated_mkdir((char*)directory_path,0777);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN basic_directory_rmdir(EIF_POINTER directory_path){
  /* 
     This is the implementation of the Eiffel external feature 
     `basic_directory_rmdir' from class BASIC_DIRECTORY.
     See Eiffel source file for additional information.
  */
  int status;
#ifndef SIMULATED_MODE
  status = rmdir((char*)directory_path);
#else
  status = simulated_rmdir((char*)directory_path);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}



T6 r8is_null(T8 C){
T6 R=0;
R=!((NULL!=C));
return R;
}


T6 r6_ix_not(T6 C){
T6 R=0;
/*[IF*/
if(C){
}
else{
R=1;
}
/*FI]*/
return R;
}


T6 r6_px_and(T6 C,T6 a1){
T6 R=0;
R=(C)&&(a1);
return R;
}


T6 r3is_separator(T3 C){
T6 R=0;
/*[INSPECT*/
{int z1=C;
switch(z1){
case 0:
case 9:
case 10:
case 12:
case 13:
case 32:
R=1;
break;
}
}/*INSPECT]*/
return R;
}


T3 r3to_upper(T3 C){
T3 R=0;
/*[IF*/
if((T3code(C))<(97)){
R=C;
}
 else if((T3code(C))>(122)){
R=C;
}
else{
R=((T3)((T3code(C))-(32)));
}
/*FI]*/
return R;
}


T3 r3to_lower(T3 C){
T3 R=0;
/*[IF*/
if((T3code(C))<(65)){
R=C;
}
 else if((T3code(C))>(90)){
R=C;
}
else{
R=((T3)((T3code(C))+(32)));
}
/*FI]*/
return R;
}


T3 r2digit(T2 C){
T3 R=0;
R=((T3)((C)+(T3code(((T3)'0')))));
return R;
}


void r2append_in(T2 C,T0* a1){
T2 _i=0;
T2 _val=0;
/*[IF*/
if((C)==(0)){
r7extend(((T7*)a1),((T3)'0'));
}
else{
/*[IF*/
if((C)>(0)){
_i=((/*RF2*/(((T7*)a1))->_count/*4*/))+(1);
_val=C;
while (!((_val)==(0)))
{
r7extend(((T7*)a1),r2digit((_val)%(10)));
_val=(_val)/(10);
}
}
else{
r7extend(((T7*)a1),((T3)'\55'));
_i=((/*RF2*/(((T7*)a1))->_count/*4*/))+(1);
_val=C;
while (!((_val)==(0)))
{
r7extend(((T7*)a1),r2digit(-((_val)%(10))));
_val=(_val)/(10);
}
}
/*FI]*/
_val=(/*RF2*/(((T7*)a1))->_count/*4*/);
while (!((_i)>=(_val)))
{
r7swap(((T7*)a1),_i,_val);
_val=(_val)-(1);
_i=(_i)+(1);
}
}
/*FI]*/
}


T6 r45safe_equal(T0* a1,T0* a2){
T6 R=0;
/*[IF*/
/*AF*//*AF*/if((a1)==((void*)(a2))){
R=1;
}
 else if(((a1)==((void*)(NULL)))||((a2)==((void*)(NULL)))){
}
 else if(((T0*)(t[7]))==((void*)((T0*)(t[7])))){
R=r7is_equal(((T7*)a1),a2);
}
/*FI]*/
return R;
}


T45 r45realloc(T45 C,T2 a1,T2 a2){
T45 R=NULL;
R=((T45)(se_calloc(a2,sizeof(T0*))));
r45copy_from(R,C,(a1)-(1));
return R;
}


T2 r45index_of(T45 C,T0* a1,T2 a2){
T2 R=0;
while (!(((R)>(a2))||(r45safe_equal(a1,(C)[R]))))
{
R=(R)+(1);
}
return R;
}


void r45clear(T45 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
_i=a1;
while (!((_i)>(a2)))
{
(C)[_i]=(_v);
_i=(_i)+(1);
}
}


void r45copy_from(T45 C,T45 a1,T2 a2){
T2 _i=0;
_i=a2;
while (!((_i)<(0)))
{
(C)[_i]=((a1)[_i]);
_i=(_i)-(1);
}
}


void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4){
T2 _i2=0;
T2 _i1=0;
_i1=a1;
_i2=a3;
while (!((_i2)>(a4)))
{
(C)[_i1]=((a2)[_i2]);
_i2=(_i2)+(1);
_i1=(_i1)+(1);
}
}


T9 r9realloc(T9 C,T2 a1,T2 a2){
T9 R=NULL;
R=((T9)(se_calloc(a2,sizeof(T3))));
r9copy_from(R,C,(a1)-(1));
return R;
}


T6 r9fast_memcmp(T9 C,T9 a1,T2 a2){
T6 R=0;
T2 _i=0;
_i=(a2)-(1);
while (!(((_i)<(0))||(((C)[_i])!=((a1)[_i]))))
{
_i=(_i)-(1);
}
R=(_i)<(0);
return R;
}


T6 r9fast_has(T9 C,T3 a1,T2 a2){
T6 R=0;
T2 _i=0;
_i=a2;
while (!(((_i)<(0))||((a1)==((C)[_i]))))
{
_i=(_i)-(1);
}
R=(_i)>=(0);
return R;
}


void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3){
T2 _i2=0;
T2 _i1=0;
_i1=a1;
while (!((_i2)==(a3)))
{
(C)[_i1]=((a2)[_i2]);
_i2=(_i2)+(1);
_i1=(_i1)+(1);
}
}


T2 r9fast_index_of(T9 C,T3 a1,T2 a2){
T2 R=0;
while (!(((R)>(a2))||((a1)==((C)[R]))))
{
R=(R)+(1);
}
return R;
}


void r9copy_from(T9 C,T9 a1,T2 a2){
T2 _i=0;
_i=a2;
while (!((_i)<(0)))
{
(C)[_i]=((a1)[_i]);
_i=(_i)-(1);
}
}


void r7copy(T7* C,T0* a1){
(/*SFN*/C->_count)=(/*RF2*/(((T7*)a1))->_count/*4*/);
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))>(0)){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<((/*RF2*/(C)->_count/*4*/))){
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_count/*4*/),sizeof(T3))));
(/*SFN*/C->_capacity)=(/*RF2*/(C)->_count/*4*/);
}
/*FI]*/
r9copy_from((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),((/*RF2*/(C)->_count/*4*/))-(1));
}
/*FI]*/
}


T0* r7substring(T7* C,T2 a1,T2 a2){
T0* R=NULL;
T2 _c=0;
_c=((a2)-(a1))+(1);
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7make(n,_c);
R=((T0*)n);
}
/*[IRF3.3set_count*/((((T7*)(((T7*)R))))->_count)=(_c);
/*]*/
r9copy_slice((/*RF2*/(((T7*)R))->_storage/*0*/),0,(/*RF2*/(C)->_storage/*0*/),(a1)-(1),(a2)-(1));
return R;
}


void r7remove_first(T7* C,T2 a1){
/*[IF*/
if((a1)>(0)){
r7remove_between(C,1,a1);
}
/*FI]*/
}


T3 r7last(T7* C){
T3 R=0;
R=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)]/*)*/;
return R;
}


void r7remove_between(T7* C,T2 a1,T2 a2){
T2 _i=0;
_i=a2;
while (!((_i)>=((/*RF2*/(C)->_count/*4*/))))
{
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(((a1)+(_i))-(a2))-(1)]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((_i)+(1))-(1)]/*)*/);
/*]*/
_i=(_i)+(1);
}
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*4*/))-(((a2)-(a1))+(1));
}


T6 r7is_equal(T7* C,T0* a1){
T6 R=0;
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))==((/*RF2*/(((T7*)a1))->_count/*4*/))){
R=r9fast_memcmp((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),(/*RF2*/(C)->_count/*4*/));
}
/*FI]*/
return R;
}
T0*oBC7split_buffer=NULL;


T0* r7split(T7* C){
T0* R=NULL;
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))>(0)){
r44clear((T44*)(oBC7split_buffer));
r7split_in(C,oBC7split_buffer);
/*[IF*/
if(!(r44is_empty((T44*)(oBC7split_buffer)))){
R=r44twin((T44*)(oBC7split_buffer));
}
/*FI]*/
}
/*FI]*/
return R;
}


void r7append(T7* C,T0* a1){
T2 _needed_capacity=0;
T2 _other_count=0;
_other_count=(/*RF2*/(((T7*)a1))->_count/*4*/);
_needed_capacity=((/*RF2*/(C)->_count/*4*/))+(_other_count);
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(_needed_capacity)){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_capacity)=_needed_capacity;
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T3))));
}
else{
(/*SFN*/C->_storage)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_needed_capacity);
(/*SFN*/C->_capacity)=_needed_capacity;
}
/*FI]*/
}
/*FI]*/
r9copy_at((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_count/*4*/),(/*RF2*/(((T7*)a1))->_storage/*0*/),_other_count);
(/*SFN*/C->_count)=_needed_capacity;
}


T2 r7index_of(T7* C,T3 a1){
T2 R=0;
R=(1)+(r9fast_index_of((/*RF2*/(C)->_storage/*0*/),a1,((/*RF2*/(C)->_count/*4*/))-(1)));
return R;
}


T6 r7has_string(T7* C,T0* a1){
T6 R=0;
R=(r7index_of_string(C,a1))!=(((/*RF2*/(C)->_count/*4*/))+(1));
return R;
}
T0*oBC7tmp_string=NULL;


T6 r7has_suffix(T7* C,T0* a1){
T6 R=0;
T2 _i2=0;
T2 _i1=0;
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))<=((/*RF2*/(C)->_count/*4*/))){
_i1=(((/*RF2*/(C)->_count/*4*/))-((/*RF2*/(((T7*)a1))->_count/*4*/)))+(1);
_i2=1;
while (!((((_i1)>((/*RF2*/(C)->_count/*4*/)))||((_i2)>((/*RF2*/(((T7*)a1))->_count/*4*/))))||((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i1)-(1)]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i2)-(1)]/*)*/))))
{
_i1=(_i1)+(1);
_i2=(_i2)+(1);
}
R=(_i1)>((/*RF2*/(C)->_count/*4*/));
}
/*FI]*/
return R;
}


void r7make(T7* C,T2 a1){
/*[IF*/
if((a1)>(0)){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(a1)){
(/*SFN*/C->_storage)=((T9)(se_calloc(a1,sizeof(T3))));
(/*SFN*/C->_capacity)=a1;
}
/*FI]*/
}
/*FI]*/
(/*SFN*/C->_count)=0;
}


T6 r7has_prefix(T7* C,T0* a1){
T6 R=0;
T2 _i=0;
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))<=((/*RF2*/(C)->_count/*4*/))){
_i=(/*RF2*/(((T7*)a1))->_count/*4*/);
while (!(((_i)==(0))||((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/))))
{
_i=(_i)-(1);
}
R=(_i)==(0);
}
/*FI]*/
return R;
}


void r7extend(T7* C,T3 a1){
T2 _new_capacity=0;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_capacity)=32;
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T3))));
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity)=_new_capacity;
}
/*FI]*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*4*/))+(1);
}


void r7remove_last(T7* C,T2 a1){
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*4*/))-(a1);
}


T6 r7has(T7* C,T3 a1){
T6 R=0;
R=r9fast_has((/*RF2*/(C)->_storage/*0*/),a1,((/*RF2*/(C)->_count/*4*/))-(1));
return R;
}


void r7extend_unless(T7* C,T3 a1){
/*[IF*/
if((((/*RF2*/(C)->_count/*4*/))==(0))||((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)]/*)*/)!=(a1))){
r7extend(C,a1);
}
/*FI]*/
}


void r7add_last(T7* C,T3 a1){
T2 _new_capacity=0;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/))){
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_capacity)=32;
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T3))));
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage)=r9realloc((/*RF2*/(C)->_storage/*0*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity)=_new_capacity;
}
/*FI]*/
((/*RF2*/(C)->_storage/*0*/))[(/*RF2*/(C)->_count/*4*/)]=(a1);
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*4*/))+(1);
}


void r7to_upper(T7* C){
T2 _i=0;
_i=(/*RF2*/(C)->_count/*4*/);
while (!((_i)==(0)))
{
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]=(r3to_upper(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/));
/*]*/
_i=(_i)-(1);
}
}


T2 r7index_of_string(T7* C,T0* a1){
T2 R=0;
T2 _i3=0;
T2 _i2=0;
T2 _i1=0;
T6 _stop=0;
_i1=1;
_i2=(/*RF2*/(((T7*)a1))->_count/*4*/);
_i3=_i2;
while (!((R)!=(0)))
{
/*[IF*/
if((_i2)>((/*RF2*/(C)->_count/*4*/))){
R=((/*RF2*/(C)->_count/*4*/))+(1);
}
else{
_stop=0;
while (!(_stop))
{
/*[IF*/
if((_i3)==(0)){
_stop=1;
R=_i1;
}
 else if((/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i3)-(1)]/*)*/)!=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i2)-(1)]/*)*/)){
_stop=1;
}
/*FI]*/
_i3=(_i3)-(1);
_i2=(_i2)-(1);
}
}
/*FI]*/
_i1=(_i1)+(1);
_i3=(/*RF2*/(((T7*)a1))->_count/*4*/);
_i2=((_i1)+(_i3))-(1);
}
return R;
}


void r7from_external_copy(T7* C,T8 a1){
T2 _i=0;
T9 _s=NULL;
_s=a1;
(/*SFN*/C->_count)=0;
while (!(((_s)[_i])==(((T3)'\0'))))
{
r7extend(C,(_s)[_i]);
_i=(_i)+(1);
}
}


T8 r7to_external(T7* C){
T8 R=NULL;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))>((/*RF2*/(C)->_count/*4*/))){
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*4*/))+(1);
/*[IF*/
if((/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)]/*)*/)!=(((T3)'\0'))){
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[((/*RF2*/(C)->_count/*4*/))-(1)]=(((T3)'\0'));
/*]*/
}
/*FI]*/
}
else{
r7extend(C,((T3)'\0'));
}
/*FI]*/
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*4*/))-(1);
R=((void*)(/*RF2*/(C)->_storage/*0*/));
return R;
}


void r7to_lower(T7* C){
T2 _i=0;
_i=(/*RF2*/(C)->_count/*4*/);
while (!((_i)==(0)))
{
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]=(r3to_lower(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/));
/*]*/
_i=(_i)-(1);
}
}


T0* r7twin(T7* C){
T0* R=NULL;
R=se_malloc(sizeof(*C));
*((T7*)R)=M7;
r7copy(((T7*)R),((T0*)C));
return R;
}


void r7split_in(T7* C,T0* a1){
T3 _c=0;
T2 _i=0;
T2 _state=0;
/*[IF*/
if(((/*RF2*/(C)->_count/*4*/))>(0)){
_i=1;
while (!((_i)>((/*RF2*/(C)->_count/*4*/))))
{
_c=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(_i)-(1)]/*)*/;
/*[IF*/
if((_state)==(0)){
/*[IF*/
if(!(r3is_separator(_c))){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC7tmp_string))))->_count)=(0);
/*]*/
r7extend((T7*)(oBC7tmp_string),_c);
_state=1;
}
/*FI]*/
}
else{
/*[IF*/
if(!(r3is_separator(_c))){
r7extend((T7*)(oBC7tmp_string),_c);
}
else{
X47add_last(a1,r7twin((T7*)(oBC7tmp_string)));
_state=0;
}
/*FI]*/
}
/*FI]*/
_i=(_i)+(1);
}
/*[IF*/
if((_state)==(1)){
X47add_last(a1,r7twin((T7*)(oBC7tmp_string)));
}
/*FI]*/
}
/*FI]*/
}


void r7swap(T7* C,T2 a1,T2 a2){
T3 _tmp=0;
_tmp=/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(a1)-(1)]/*)*/;
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(a1)-(1)]=(/*(IRF4.6item*/((/*RF2*/(C)->_storage/*0*/))[(a2)-(1)]/*)*/);
/*]*/
/*[IRF3.5put*/((/*RF2*/(C)->_storage/*0*/))[(a2)-(1)]=(_tmp);
/*]*/
}


void r54make(T54* C,T2 a1){
/*[IF*/
if((a1)==(0)){
/*[IF*/
if((((/*RF2*/(C)->_capacity/*8*/))>(0))&&(((/*RF2*/(C)->_upper/*12*/))>=(0))){
r45clear((/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
/*FI]*/
(/*SFN*/C->_upper)=-(1);
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_storage)=((T45)(se_calloc(a1,sizeof(T0*))));
(/*SFN*/C->_capacity)=a1;
(/*SFN*/C->_upper)=(a1)-(1);
}
 else if(((/*RF2*/(C)->_capacity/*8*/))<(a1)){
(/*SFN*/C->_storage)=((T45)(se_calloc(a1,sizeof(T0*))));
(/*SFN*/C->_capacity)=a1;
(/*SFN*/C->_upper)=(a1)-(1);
}
else{
r45clear((/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
(/*SFN*/C->_upper)=(a1)-(1);
}
/*FI]*/
}


void r54add_last(T54* C,T0* a1){
T2 _new_capacity=0;
/*[IF*/
if((((/*RF2*/(C)->_upper/*12*/))+(1))<=(((/*RF2*/(C)->_capacity/*8*/))-(1))){
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
}
 else if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_storage)=((T45)(se_calloc(2,sizeof(T0*))));
(/*SFN*/C->_capacity)=2;
(/*SFN*/C->_upper)=0;
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage)=r45realloc((/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity)=_new_capacity;
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
}
/*FI]*/
((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_upper/*12*/)]=(a1);
}


void r44copy(T44* C,T0* a1){
T2 _needed_capacity=0;
(/*SFN*/C->_lower)=(/*RF2*/(((T44*)a1))->_lower/*16*/);
(/*SFN*/C->_upper)=(/*RF2*/(((T44*)a1))->_upper/*12*/);
_needed_capacity=(((/*RF2*/(C)->_upper/*12*/))-((/*RF2*/(C)->_lower/*16*/)))+(1);
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(_needed_capacity)){
(/*SFN*/C->_capacity)=_needed_capacity;
(/*SFN*/C->_storage)=((T45)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T0*))));
}
/*FI]*/
/*[IF*/
if((_needed_capacity)>(0)){
r45copy_from((/*RF2*/(C)->_storage/*4*/),(/*RF2*/(((T44*)a1))->_storage/*4*/),(_needed_capacity)-(1));
}
/*FI]*/
}


T2 r44count(T44* C){
T2 R=0;
R=(((/*RF2*/(C)->_upper/*12*/))-((/*RF2*/(C)->_lower/*16*/)))+(1);
return R;
}


T0* r44item(T44* C,T2 a1){
T0* R=NULL;
R=((/*RF2*/(C)->_storage/*4*/))[(a1)-((/*RF2*/(C)->_lower/*16*/))];
return R;
}


T2 r44index_of(T44* C,T0* a1){
T2 R=0;
R=((/*RF2*/(C)->_lower/*16*/))+(r45index_of((/*RF2*/(C)->_storage/*4*/),a1,((/*RF2*/(C)->_upper/*12*/))-((/*RF2*/(C)->_lower/*16*/))));
return R;
}


T6 r44is_empty(T44* C){
T6 R=0;
R=((/*RF2*/(C)->_upper/*12*/))<((/*RF2*/(C)->_lower/*16*/));
return R;
}


void r44add_last(T44* C,T0* a1){
T2 _new_capacity=0;
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<((r44count(C))+(1))){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))==(0)){
(/*SFN*/C->_capacity)=16;
(/*SFN*/C->_storage)=((T45)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T0*))));
}
else{
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*8*/));
(/*SFN*/C->_storage)=r45realloc((/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(/*SFN*/C->_capacity)=_new_capacity;
}
/*FI]*/
}
/*FI]*/
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
/*[IRF3.6put*/{T44* C1=C;
T0* b1=a1;
T2 b2=(/*RF2*/(C)->_upper/*12*/);
((/*RF2*/(C1)->_storage/*4*/))[(b2)-((/*RF2*/(C1)->_lower/*16*/))]=(b1);
}/*]*/
}


void r44clear(T44* C){
(/*SFN*/C->_upper)=((/*RF2*/(C)->_lower/*16*/))-(1);
}


T0* r44twin(T44* C){
T0* R=NULL;
R=se_malloc(sizeof(*C));
*((T44*)R)=M44;
r44copy(((T44*)R),((T0*)C));
return R;
}


void r44with_capacity(T44* C,T2 a1,T2 a2){
/*[IF*/
if(((/*RF2*/(C)->_capacity/*8*/))<(a1)){
(/*SFN*/C->_storage)=((T45)(se_calloc(a1,sizeof(T0*))));
(/*SFN*/C->_capacity)=a1;
}
/*FI]*/
(/*SFN*/C->_lower)=a2;
(/*SFN*/C->_upper)=(a2)-(1);
}


void r51disconnect(T51* C){
fclose((/*RF2*/(C)->_output_stream/*4*/));
(/*SFN*/C->_path)=NULL;
}


void r51connect_to(T51* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
(/*SFN*/C->_output_stream)=fopen((char*)_p,"w");
/*[IF*/
if((NULL!=(/*RF2*/(C)->_output_stream/*4*/))){
(/*SFN*/C->_path)=a1;
}
/*FI]*/
}


void r51put_string(T51* C,T0* a1){
T2 _i=0;
_i=1;
while (!((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))))
{
/*[IRF3.6put_character*/{T51* C1=C;
T3 b1=/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/;
putc(b1,((FILE*)((/*RF2*/(C1)->_output_stream/*4*/))));
}/*]*/
_i=(_i)+(1);
}
}


void r31read_character(T31* C){
/*[IF*/
if((/*RF2*/(C)->_push_back_flag/*0*/)){
(/*SFN*/C->_push_back_flag)=0;
}
else{
(/*SFN*/C->_memory)=getc((FILE*)(stdin));
}
/*FI]*/
}


void r31skip_separators(T31* C){
while (!((r31end_of_input(C))||(!(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/)))))
{
r31read_character(C);
}
/*[IF*/
if((!(r31end_of_input(C)))&&(!((/*RF2*/(C)->_push_back_flag/*0*/)))){
/*[IRF3.3unread_character*/((((T31*)(C)))->_push_back_flag)=(1);
/*]*/
}
/*FI]*/
}


void r31read_line_in(T31* C,T0* a1){
T2 _mem=0;
r31read_character(C);
/*[IF*/
if(((/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/)!=(((T3)'\n')))&&(((/*RF2*/(C)->_memory/*1*/))!=((EOF)))){
r7extend(((T7*)a1),((T3)((/*RF2*/(C)->_memory/*1*/))));
_mem=getc((FILE*)(stdin));
while (!(((_mem)==((EOF)))||((_mem)==(T3code(((T3)'\n'))))))
{
r7extend(((T7*)a1),((T3)(_mem)));
_mem=getc((FILE*)(stdin));
}
(/*SFN*/C->_memory)=_mem;
}
/*FI]*/
}


T6 r31end_of_input(T31* C){
T6 R=0;
/*[IF*/
if(!((/*RF2*/(C)->_push_back_flag/*0*/))){
R=((/*RF2*/(C)->_memory/*1*/))==((EOF));
}
/*FI]*/
return R;
}


void r31read_word(T31* C){
r31skip_separators(C);
/*[IF*/
if(!(r31end_of_input(C))){
r31read_character(C);
}
/*FI]*/
/*[IRF3.3clear*/((((T7*)((T7*)(oBC32last_string))))->_count)=(0);
/*]*/
while (!((r31end_of_input(C))||(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/))))
{
r7extend((T7*)(oBC32last_string),/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*1*/)))/*)*/);
r31read_character(C);
}
}


void r31read_line(T31* C){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC32last_string))))->_count)=(0);
/*]*/
r31read_line_in(C,oBC32last_string);
}
T0*oBC32last_string=NULL;


void r37sfw_connect(T37* C,T0* a1,T0* a2){
r51connect_to(((T51*)a1),a2);
/*[IF*/
if(/*(IRF4.7is_connected*/((/*RF2*/(((T51*)a1))->_path/*0*/))!=(NULL)/*)*/){
r37put_string(C,((T0*)ms37_44975894));
r37put_string(C,a2);
r37put_string(C,((T0*)ms37_3556890));
}
else{
r37w_put_string(((T0*)ms37_1711985232));
r37w_put_string(a2);
r37w_put_string(((T0*)ms20_1090));
exit(1);
}
/*FI]*/
}


void r37file_removing(T37* C,T0* a1){
/*[IF*/
if(r37file_exists(a1)){
r37put_string(C,((T0*)ms37_210310269));
r37put_string(C,a1);
r37put_string(C,((T0*)ms20_1090));
/*[IRF3.6remove_file*/{T0* b1=a1;
r38delete(oBC1file_tools,b1);
}/*]*/
}
/*FI]*/
}


T6 r37file_exists(T0* a1){
T6 R=0;
R=r38is_readable(a1);
return R;
}


void r37file_renaming(T37* C,T0* a1,T0* a2){
r37put_string(C,((T0*)ms37_210141519));
r37put_string(C,a1);
r37put_string(C,((T0*)ms37_141444));
r37put_string(C,a2);
r37put_string(C,((T0*)ms20_1090));
/*[IRF3.6rename_file*/{T0* b1=a1;
T0* b2=a2;
r38rename_to(oBC1file_tools,b1,b2);
}/*]*/
}


void r37sfr_connect(T37* C,T0* a1,T0* a2){
r37put_string(C,((T0*)ms37_27561173));
r37put_string(C,a2);
r37put_string(C,((T0*)ms20_1090));
r40connect_to(((T40*)a1),a2);
}


void r37w_put_character(T3 a1){
/*[IRF3.6put_character*/{T49* C1=(T49*)(oBC1std_error);
T3 b1=a1;
putc(b1,((FILE*)(stderr)));
}/*]*/
/*[IRF3.6flush*/{T49* C1=(T49*)(oBC1std_error);
fflush(stderr);
}/*]*/
}


void r37sfr_connect_or_exit(T37* C,T0* a1,T0* a2){
r37sfr_connect(C,a1,a2);
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/(((T40*)a1))->_path/*1*/))!=(NULL)/*)*/)){
r37w_put_string(((T0*)ms20_300594));
r37w_put_string(a2);
r37w_put_string(((T0*)ms37_1680762272));
exit(1);
}
/*FI]*/
}


T0* r37read_word_in(T37* C,T0* a1){
T0* R=NULL;
r37put_string(C,((T0*)ms37_136264778));
r37put_string(C,(/*RF2*/(((T40*)a1))->_path/*1*/));
r37put_string(C,((T0*)ms20_1090));
/*[IF*/
if(r40end_of_input(((T40*)a1))){
r37w_put_string(((T0*)ms37_1520107011));
r37w_put_string((/*RF2*/(((T40*)a1))->_path/*1*/));
r37w_put_string(((T0*)ms20_1090));
exit(1);
}
else{
r40read_word(((T40*)a1));
R=r7twin((T7*)(oBC32last_string));
}
/*FI]*/
return R;
}


void r37system(T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
system(((char*)_p));
}
T38 oBC1file_tools=0;
T0*oBC1std_output=NULL;


void r37w_put_string(T0* a1){
r49put_string((T49*)(oBC1std_error),a1);
/*[IRF3.6flush*/{T49* C1=(T49*)(oBC1std_error);
fflush(stderr);
}/*]*/
}


void r37put_string(T37* C,T0* a1){
/*[IF*/
if((/*RF2*/(C)->_verbose/*0*/)){
r34put_string((T34*)(oBC1std_output),a1);
/*[IRF3.6flush*/{T34* C1=(T34*)(oBC1std_output);
fflush(stdout);
}/*]*/
}
/*FI]*/
}


void r37call_system(T37* C,T0* a1){
T0* _cmd2=NULL;
T2 _i=0;
/*[IF*/
if((r7last(((T7*)a1)))==(((T3)'\n'))){
r7remove_last(((T7*)a1),1);
r37call_system(C,a1);
}
 else if(r7has(((T7*)a1),((T3)'\n'))){
_i=r7index_of(((T7*)a1),((T3)'\n'));
_cmd2=r7substring(((T7*)a1),(_i)+(1),(/*RF2*/(((T7*)a1))->_count/*4*/));
r7remove_last(((T7*)a1),(((/*RF2*/(((T7*)a1))->_count/*4*/))-(_i))+(1));
r37call_system(C,a1);
r37call_system(C,_cmd2);
}
else{
r37put_string(C,((T0*)ms37_1800535743));
r37put_string(C,a1);
r37put_string(C,((T0*)ms20_1090));
r37system(a1);
}
/*FI]*/
}
T0*oBC1std_error=NULL;


void r39append_token(T0* a1,T0* a2){
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a2))->_count/*4*/))==(0)/*)*/)){
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)!=(((T3)'\40'))){
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a1))->_count/*4*/))==(0)/*)*/)){
r7extend_unless(((T7*)a1),((T3)'\40'));
}
/*FI]*/
}
/*FI]*/
r7append(((T7*)a1),a2);
}
/*FI]*/
}


void r39set_c_compiler(T39* C,T0* a1){
T3 _c=0;
T0* _sd=NULL;
T2 _i=0;
/*[IF*/
if((a1)!=((void*)(NULL))){
_i=r44index_of((T44*)(oBC39compiler_list),a1);
/*[IF*/
if((_i)>((/*RF2*/((T44*)(oBC39compiler_list))->_upper/*12*/))){
r37w_put_string(((T0*)ms39_3498891));
r37w_put_string(a1);
r37w_put_string(((T0*)ms39_228399374));
r39show_compiler_list_then_exit(C);
}
/*FI]*/
(/*SFN*/C->_c_compiler)=r44item((T44*)(oBC39compiler_list),_i);
}
else{
_sd=(/*RF2*/(C)->_sys_directory/*4*/);
r7copy((T7*)(oBC19tmp_path),_sd);
r7append((T7*)(oBC19tmp_path),((T0*)ms39_1236979201));
r37sfr_connect_or_exit((T37*)(oBC19echo),oBC19tmp_file_read,oBC19tmp_path);
(/*SFN*/C->_c_compiler)=r37read_word_in((T37*)(oBC19echo),oBC19tmp_file_read);
_i=r44index_of((T44*)(oBC39compiler_list),(/*RF2*/(C)->_c_compiler/*12*/));
/*[IF*/
if((_i)>((/*RF2*/((T44*)(oBC39compiler_list))->_upper/*12*/))){
r37w_put_string(((T0*)ms39_876917780));
r37w_put_string((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/));
r37w_put_string(((T0*)ms39_1090));
r39show_compiler_list_then_exit(C);
}
/*FI]*/
(/*SFN*/C->_c_compiler)=r44item((T44*)(oBC39compiler_list),_i);
/*[IF*/
if(!(r40end_of_input((T40*)(oBC19tmp_file_read)))){
_c=/*(IRF4.6last_character*/((T3)((/*RF2*/((T40*)(oBC19tmp_file_read))->_memory/*9*/)))/*)*/;
while (!(((_c)==(((T3)'\n')))||((_c)==(((T3)'\15')))))
{
r7extend((T7*)(((T0*)ms39_0aaaaaaa)),_c);
r40read_character((T40*)(oBC19tmp_file_read));
/*[IF*/
if(!(r40end_of_input((T40*)(oBC19tmp_file_read)))){
_c=/*(IRF4.6last_character*/((T3)((/*RF2*/((T40*)(oBC19tmp_file_read))->_memory/*9*/)))/*)*/;
}
/*FI]*/
}
}
/*FI]*/
r40disconnect((T40*)(oBC19tmp_file_read));
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms39_0aaaaaaa)))->_count/*4*/))==(0)/*)*/)||(!(r3is_separator(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms39_0aaaaaaa)))->_storage/*0*/))[0]/*)*/)))))
{
r7remove_first((T7*)(((T0*)ms39_0aaaaaaa)),1);
}
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms39_0aaaaaaa)))->_count/*4*/))==(0)/*)*/){
/*[IF*/
if((((T0*)ms39_3169))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_1570aaa));
}
 else if((((T0*)ms39_51699930))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_304a));
}
 else if((((T0*)ms39_594))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_304aa));
}
 else if((((T0*)ms39_448859))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
}
 else if((((T0*)ms39_76405))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_836475934));
}
 else if((((T0*)ms39_382130))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_1826831355));
}
 else if((((T0*)ms39_603))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_137550186));
}
 else if((((T0*)ms39_674))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
/*[IRF3.3clear*/((((T7*)((T7*)(((T0*)ms39_0aaaaaaa)))))->_count)=(0);
/*]*/
r7copy((T7*)(((T0*)ms39_0aaaaaa)),((T0*)ms39_12782));
/*[IF*/
if(!(r39Scoptions_exists())){
r39append_token(((T0*)ms39_0aaaaaa),((T0*)ms39_698995372));
}
/*FI]*/
}
 else if((((T0*)ms39_15721))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_1091987));
}
 else if((((T0*)ms39_17794))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
/*[IF*/
if((((T0*)ms39_57487))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_968120));
}
/*FI]*/
}
 else if((((T0*)ms39_3069))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_1570aaaa));
}
 else if((((T0*)ms39_18144))==((void*)((/*RF2*/(C)->_c_compiler/*12*/)))){
r7copy((T7*)(((T0*)ms39_0aaaaaaa)),((T0*)ms39_1570aaaaa));
}
else{
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
}


void r39install_extra_options(T39* C){
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3169)))){
/*[IF*/
if(!(r7has((T7*)(((T0*)ms39_0aaaaaaa)),((T3)'O')))){
r39append_token(((T0*)ms39_0aaaaaaa),((T0*)ms39_1570));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_51699930)))){
/*[IF*/
if(!(r7has((T7*)(((T0*)ms39_0aaaaaaa)),((T3)'O')))){
r39append_token(((T0*)ms39_0aaaaaaa),((T0*)ms39_304));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
/*[IF*/
if(!(r39Scoptions_exists())){
r39append_token(((T0*)ms39_0aaaaaaa),((T0*)ms39_426884100));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3069)))){
/*[IF*/
if(!(r7has((T7*)(((T0*)ms39_0aaaaaaa)),((T3)'O')))){
r39append_token(((T0*)ms39_0aaaaaaa),((T0*)ms39_1570a));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
/*[IF*/
if(!(r7has((T7*)(((T0*)ms39_0aaaaaaa)),((T3)'O')))){
r39append_token(((T0*)ms39_0aaaaaaa),((T0*)ms39_1570aa));
}
/*FI]*/
}
/*FI]*/
}
T0*oBC39system_list=NULL;
T0*oBC19tmp_file_read=NULL;


void r39add_directory(T39* C,T0* a1,T0* a2){
T3 _last=0;
/*[IF*/
if(r39slash_separator(C)){
r7extend_unless(((T7*)a1),((T3)'\57'));
r7append(((T7*)a1),a2);
r7extend_unless(((T7*)a1),((T3)'\57'));
}
 else if(r39backslash_separator(C)){
r7extend_unless(((T7*)a1),((T3)'\134'));
r7append(((T7*)a1),a2);
r7extend_unless(((T7*)a1),((T3)'\134'));
}
 else if((((T0*)ms39_39617954))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r7extend_unless(((T7*)a1),((T3)'\72'));
r7append(((T7*)a1),a2);
r7extend_unless(((T7*)a1),((T3)'\72'));
}
 else if((((T0*)ms39_57487))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
_last=r7last(((T7*)a1));
/*[IF*/
if(((_last)!=(((T3)'\57')))&&((_last)!=(((T3)'\72')))){
r7extend_unless(((T7*)a1),((T3)'\57'));
}
/*FI]*/
r7append(((T7*)a1),a2);
r7extend_unless(((T7*)a1),((T3)'\57'));
}
 else if((((T0*)ms39_2618))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r7extend_unless(((T7*)a1),((T3)'\135'));
r7remove_last(((T7*)a1),1);
r7extend_unless(((T7*)a1),((T3)'\56'));
r7append(((T7*)a1),a2);
r7extend_unless(((T7*)a1),((T3)'\135'));
}
else{
}
/*FI]*/
}
T6 oBC39Scoptions_exists=0;
int fBC39Scoptions_exists=0;


T6 r39Scoptions_exists(void){
if(fBC39Scoptions_exists==0){fBC39Scoptions_exists=1;{
oBC39Scoptions_exists=r38is_readable(((T0*)ms39_39204698));
}}
return oBC39Scoptions_exists;
}


void r39no_split_mode_command(T39* C,T0* a1,T0* a2){
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count)=(0);
/*]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3169)))){
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms39_0aaa)))->_count/*4*/))==(0)/*)*/){
r7append(((T7*)a1),((T0*)ms39_3169));
}
else{
r7append(((T7*)a1),((T0*)ms39_2833));
}
/*FI]*/
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_51699930)))){
r7append(((T7*)a1),((T0*)ms39_3294));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,a2);
r7extend(((T7*)a1),((T3)'\n'));
r39external_c_files_for_lcc_win32(C,a1);
r7append(((T7*)a1),((T0*)ms39_415107));
/*[IF*/
if(!((/*RF2*/(C)->_no_strip/*16*/))){
r39append_token(a1,((T0*)ms39_340));
}
/*FI]*/
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39add_output_name(C,a1);
/*[IRF3.6remove_suffix*/{T7* C1=((T7*)a2);
T0* b1=((T0*)ms19_329);
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r7append(((T7*)a2),r39object_suffix(C));
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_594)))){
r7append(((T7*)a1),((T0*)ms39_594));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_448859)))){
r7append(((T7*)a1),((T0*)ms39_448859));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_76405)))){
r7append(((T7*)a1),((T0*)ms39_76405));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_382130)))){
r7append(((T7*)a1),((T0*)ms39_382130));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_603)))){
r7append(((T7*)a1),((T0*)ms39_603));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
r7append(((T7*)a1),((T0*)ms39_674));
r39append_token(a1,r39sas_c_compiler_options(0));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
r39add_output_name(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
r7append(((T7*)a1),((T0*)ms39_3094));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
/*[IF*/
if((/*RF2*/(C)->_no_strip/*16*/)){
r39append_token(a1,((T0*)ms39_340a));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
r7append(((T7*)a1),((T0*)ms39_689));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_lib_math(C);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3069)))){
r7append(((T7*)a1),((T0*)ms39_3069));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
r7append(((T7*)a1),((T0*)ms39_18144));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39append_token(a1,a2);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
/*FI]*/
}


void r39add_x_suffix(T39* C,T0* a1){
T0* _suffix=NULL;
_suffix=r39x_suffix(C);
/*[IF*/
if(!(r7has_suffix(((T7*)a1),_suffix))){
r7append(((T7*)a1),_suffix);
}
/*FI]*/
}
T0*oBC19tmp_path=NULL;


void r39external_c_files_for_lcc_win32(T39* C,T0* a1){
T2 _i=0;
T0* _c_file=NULL;
T0* _c_files=NULL;
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms39_0aaaa)))->_count/*4*/))==(0)/*)*/)){
_c_files=r7split((T7*)(((T0*)ms39_0aaaa)));
/*[IRF3.3clear*/((((T7*)((T7*)(((T0*)ms39_0aaaa)))))->_count)=(0);
/*]*/
/*[IF*/
if((_c_files)!=((void*)(NULL))){
_i=(/*RF2*/(((T44*)_c_files))->_lower/*16*/);
while (!((_i)>((/*RF2*/(((T44*)_c_files))->_upper/*12*/))))
{
_c_file=r44item(((T44*)_c_files),_i);
r7append(((T7*)a1),((T0*)ms39_3294));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,_c_file);
r7extend(((T7*)a1),((T3)'\n'));
/*[IRF3.6remove_suffix*/{T7* C1=((T7*)_c_file);
T0* b1=((T0*)ms19_329);
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r7append(((T7*)_c_file),r39object_suffix(C));
r39append_token(((T0*)ms39_0aa),_c_file);
_i=(_i)+(1);
}
}
/*FI]*/
}
/*FI]*/
}


void r39split_mode_c_compiler_command(T39* C,T0* a1,T0* a2){
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count)=(0);
/*]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3169)))){
/*[IF*/
if(r39is_c_plus_plus_file_path(a2)){
r7append(((T7*)a1),((T0*)ms39_2833));
}
else{
r7append(((T7*)a1),((T0*)ms39_3169));
}
/*FI]*/
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_51699930)))){
r7append(((T7*)a1),((T0*)ms39_3294));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_594)))){
r7append(((T7*)a1),((T0*)ms39_594));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_448859)))){
r7append(((T7*)a1),((T0*)ms39_447734));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_76405)))){
r7append(((T7*)a1),((T0*)ms39_76405));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_382130)))){
r7append(((T7*)a1),((T0*)ms39_382130));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_603)))){
r7append(((T7*)a1),((T0*)ms39_603));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
r7append(((T7*)a1),((T0*)ms39_674));
r39append_token(a1,r39sas_c_compiler_options(1));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
r7append(((T7*)a1),((T0*)ms39_3094));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
r7append(((T7*)a1),((T0*)ms39_689));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3069)))){
r7append(((T7*)a1),((T0*)ms39_3069));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
r7append(((T7*)a1),((T0*)ms39_18144));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_324));
r39append_token(a1,a2);
}
/*FI]*/
}
T0*oBC39object_suffix=NULL;
int fBC39object_suffix=0;


T0* r39object_suffix(T39* C){
if(fBC39object_suffix==0){fBC39object_suffix=1;{
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3169)))){
oBC39object_suffix=((T0*)ms39_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_51699930)))){
oBC39object_suffix=((T0*)ms39_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_594)))){
/*[IF*/
if(((/*RF2*/(C)->_system_name/*0*/))==((void*)(((T0*)ms39_2618)))){
oBC39object_suffix=((T0*)ms39_9121);
r7to_upper(((T7*)oBC39object_suffix));
}
else{
oBC39object_suffix=((T0*)ms39_341);
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_448859)))){
oBC39object_suffix=((T0*)ms39_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_76405)))){
oBC39object_suffix=((T0*)ms39_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_382130)))){
oBC39object_suffix=((T0*)ms39_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_603)))){
oBC39object_suffix=((T0*)ms39_9121);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
oBC39object_suffix=((T0*)ms39_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
oBC39object_suffix=((T0*)ms39_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
oBC39object_suffix=((T0*)ms39_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3069)))){
oBC39object_suffix=((T0*)ms39_341);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
oBC39object_suffix=((T0*)ms39_341);
}
/*FI]*/
}}
return oBC39object_suffix;
}


void r39make(T39* C){
T2 _i=0;
T0* _system_se_path=NULL;
_system_se_path=r39get_environment_variable(C,((T0*)ms20_1071750288));
/*[IF*/
if((_system_se_path)==((void*)(NULL))){
_system_se_path=r7twin((T7*)(((T0*)ms20_1071750288)));
r7to_upper(((T7*)_system_se_path));
_system_se_path=r39get_environment_variable(C,_system_se_path);
/*[IF*/
if((_system_se_path)==((void*)(NULL))){
r37put_string((T37*)(oBC19echo),((T0*)ms39_860169684));
_system_se_path=((T0*)ms39_115188994);
r37put_string((T37*)(oBC19echo),_system_se_path);
r37put_string((T37*)(oBC19echo),((T0*)ms20_216));
}
/*FI]*/
}
else{
r37put_string((T37*)(oBC19echo),((T0*)ms39_1023953763));
r37put_string((T37*)(oBC19echo),_system_se_path);
r37put_string((T37*)(oBC19echo),((T0*)ms20_1090));
}
/*FI]*/
/*[IF*/
if(r7has_suffix(((T7*)_system_se_path),((T0*)ms20_56612951))){
r37sfr_connect((T37*)(oBC19echo),oBC19tmp_file_read,_system_se_path);
}
else{
r37put_string((T37*)(oBC19echo),((T0*)ms39_679150617));
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\57'))){
r37put_string((T37*)(oBC19echo),((T0*)ms39_467476687));
r7copy((T7*)(oBC19tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC19tmp_path),((T3)'\57'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_3595));
r7extend((T7*)(oBC19tmp_path),((T3)'\57'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_56612951));
r37sfr_connect((T37*)(oBC19echo),oBC19tmp_file_read,oBC19tmp_path);
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\134'))){
r37put_string((T37*)(oBC19echo),((T0*)ms39_581585530));
r7copy((T7*)(oBC19tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC19tmp_path),((T3)'\134'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_3595));
r7extend((T7*)(oBC19tmp_path),((T3)'\134'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_56612951));
r37sfr_connect((T37*)(oBC19echo),oBC19tmp_file_read,oBC19tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\72'))){
r37put_string((T37*)(oBC19echo),((T0*)ms39_1631212670));
r7copy((T7*)(oBC19tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC19tmp_path),((T3)'\72'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_3595));
r7extend((T7*)(oBC19tmp_path),((T3)'\72'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_56612951));
r37sfr_connect((T37*)(oBC19echo),oBC19tmp_file_read,oBC19tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
/*[IF*/
if(r7has(((T7*)_system_se_path),((T3)'\135'))){
r37put_string((T37*)(oBC19echo),((T0*)ms39_128214728));
r7copy((T7*)(oBC19tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC19tmp_path),((T3)'\135'));
r7remove_last((T7*)(oBC19tmp_path),1);
r7extend((T7*)(oBC19tmp_path),((T3)'\56'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_3595));
r7extend((T7*)(oBC19tmp_path),((T3)'\135'));
r7append((T7*)(oBC19tmp_path),((T0*)ms20_56612951));
r37sfr_connect((T37*)(oBC19echo),oBC19tmp_file_read,oBC19tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
r37put_string((T37*)(oBC19echo),((T0*)ms39_1106932385));
r7copy((T7*)(oBC19tmp_path),_system_se_path);
r7append((T7*)(oBC19tmp_path),((T0*)ms20_56612951));
r37sfr_connect((T37*)(oBC19echo),oBC19tmp_file_read,oBC19tmp_path);
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/))!=(NULL)/*)*/)){
r37w_put_string(((T0*)ms39_1429938878));
exit(1);
}
/*FI]*/
r40read_line((T40*)(oBC19tmp_file_read));
(/*SFN*/C->_system_name)=oBC32last_string;
_i=r44index_of((T44*)(oBC39system_list),(/*RF2*/(C)->_system_name/*0*/));
/*[IF*/
if((_i)>((/*RF2*/((T44*)(oBC39system_list))->_upper/*12*/))){
r37w_put_string(((T0*)ms39_179868158));
r37w_put_string((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/));
r37w_put_string(((T0*)ms39_1866433364));
_i=1;
while (!((_i)>((/*RF2*/((T44*)(oBC39system_list))->_upper/*12*/))))
{
r37w_put_string(r44item((T44*)(oBC39system_list),_i));
r37w_put_character(((T3)'\n'));
_i=(_i)+(1);
}
exit(1);
}
else{
(/*SFN*/C->_system_name)=r44item((T44*)(oBC39system_list),_i);
r37put_string((T37*)(oBC19echo),((T0*)ms39_1102814319));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_name/*0*/));
r37put_string((T37*)(oBC19echo),((T0*)ms20_1090));
}
/*FI]*/
(/*SFN*/C->_sys_directory)=r7twin((T7*)((/*RF2*/((T40*)(oBC19tmp_file_read))->_path/*1*/)));
/*[IRF3.6remove_suffix*/{T7* C1=(T7*)((/*RF2*/(C)->_sys_directory/*4*/));
T0* b1=((T0*)ms20_56612951);
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r40disconnect((T40*)(oBC19tmp_file_read));
(/*SFN*/C->_bin_directory)=r7twin((T7*)((/*RF2*/(C)->_sys_directory/*4*/)));
r39parent_directory(C,(/*RF2*/(C)->_bin_directory/*8*/));
r39add_directory(C,(/*RF2*/(C)->_bin_directory/*8*/),((T0*)ms20_3085));
}
T0*oBC19run_control=NULL;


void r39parent_directory(T39* C,T0* a1){
/*[IF*/
if(r39slash_separator(C)){
r7remove_last(((T7*)a1),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a1))->_count/*4*/))==(0)/*)*/)||((r7last(((T7*)a1)))==(((T3)'\57')))))
{
r7remove_last(((T7*)a1),1);
}
}
 else if(r39backslash_separator(C)){
r7remove_last(((T7*)a1),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a1))->_count/*4*/))==(0)/*)*/)||((r7last(((T7*)a1)))==(((T3)'\134')))))
{
r7remove_last(((T7*)a1),1);
}
}
 else if((((T0*)ms39_39617954))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r7remove_last(((T7*)a1),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a1))->_count/*4*/))==(0)/*)*/)||((r7last(((T7*)a1)))==(((T3)'\72')))))
{
r7remove_last(((T7*)a1),1);
}
}
 else if((((T0*)ms39_57487))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r7remove_last(((T7*)a1),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a1))->_count/*4*/))==(0)/*)*/)||(r7has(ms39_293,r7last(((T7*)a1))))))
{
r7remove_last(((T7*)a1),1);
}
}
 else if((((T0*)ms39_2618))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r7remove_last(((T7*)a1),1);
while (!((/*(IRF4.7is_empty*/((/*RF2*/(((T7*)a1))->_count/*4*/))==(0)/*)*/)||((r7last(((T7*)a1)))==(((T3)'\56')))))
{
r7remove_last(((T7*)a1),1);
}
r7remove_last(((T7*)a1),1);
r7extend(((T7*)a1),((T3)'\135'));
}
else{
}
/*FI]*/
}


void r39show_compiler_list_then_exit(T39* C){
T2 _i=0;
r37w_put_string(((T0*)ms39_270309168));
_i=1;
while (!((_i)>((/*RF2*/((T44*)(oBC39compiler_list))->_upper/*12*/))))
{
r37w_put_string(r44item((T44*)(oBC39compiler_list),_i));
r37w_put_character(((T3)'\n'));
_i=(_i)+(1);
}
exit(1);
}


void r39add_output_name(T39* C,T0* a1){
T0* _output_name=NULL;
_output_name=(/*RF2*/((T46*)(oBC19run_control))->_output_name/*4*/);
/*[IF*/
if((_output_name)==((void*)(NULL))){
_output_name=r7twin((T7*)((/*RF2*/((T46*)(oBC19run_control))->_root_class/*0*/)));
r7to_lower(((T7*)_output_name));
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_51699930)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_76405)))){
r39append_token(a1,((T0*)ms39_326));
r7append(((T7*)a1),_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_382130)))){
r39append_token(a1,((T0*)ms39_326));
r7append(((T7*)a1),_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_448859)))){
r39append_token(a1,((T0*)ms39_336));
r7append(((T7*)a1),_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
_output_name=r7twin((T7*)((/*RF2*/((T46*)(oBC19run_control))->_root_class/*0*/)));
r7to_lower(((T7*)_output_name));
r7append(((T7*)a1),((T0*)ms39_6687));
r7append(((T7*)a1),_output_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
r39append_token(a1,((T0*)ms39_336));
r7append(((T7*)a1),_output_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
r39append_token(a1,((T0*)ms39_336));
r7append(((T7*)a1),_output_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
r39append_token(a1,((T0*)ms39_336));
r7append(((T7*)a1),_output_name);
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3169)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_51699930)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_594)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_448859)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_76405)))){
r39append_token(a1,((T0*)ms39_326));
r7append(((T7*)a1),_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_382130)))){
r39append_token(a1,((T0*)ms39_326));
r7append(((T7*)a1),_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_603)))){
r39append_token(a1,((T0*)ms39_336));
r7append(((T7*)a1),_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
r7append(((T7*)a1),((T0*)ms39_6687));
r39append_token(a1,_output_name);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3069)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
r39append_token(a1,((T0*)ms39_336));
r39append_token(a1,_output_name);
r39add_x_suffix(C,a1);
}
/*FI]*/
}


T0* r39get_environment_variable(T39* C,T0* a1){
T0* R=NULL;
T8 _null=NULL;
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
_p=basic_getenv(_p);
/*[IF*/
if((_p)!=(_null)){
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7from_external_copy(n,_p);
R=((T0*)n);
}
}
/*FI]*/
return R;
}
T0*oBC19echo=NULL;


T6 r39slash_separator(T39* C){
T6 R=0;
/*[IF*/
if((((T0*)ms39_13028))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
R=1;
}
 else if((((T0*)ms39_11253))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
R=1;
}
 else if((((T0*)ms39_59731))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
R=1;
}
/*FI]*/
return R;
}


void r39add_external_lib(T0* a1){
/*[IF*/
if(!(r7has_string((T7*)(((T0*)ms39_0a)),a1))){
r39append_token(((T0*)ms39_0a),a1);
}
/*FI]*/
}


T6 r39is_c_plus_plus_file_path(T0* a1){
T6 R=0;
/*[IF*/
if(r7has_suffix(((T7*)a1),((T0*)ms19_8897))){
R=1;
}
 else if(r7has_suffix(((T7*)a1),((T0*)ms39_1744))){
R=1;
}
 else if(r7has_suffix(((T7*)a1),((T0*)ms39_297))){
R=1;
}
/*FI]*/
return R;
}
T0*oBC39x_suffix=NULL;
int fBC39x_suffix=0;


T0* r39x_suffix(T39* C){
if(fBC39x_suffix==0){fBC39x_suffix=1;{
/*[IF*/
if((((T0*)ms39_2178))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC39x_suffix=((T0*)ms39_8976);
r7to_upper(((T7*)oBC39x_suffix));
}
 else if((((T0*)ms39_2618))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC39x_suffix=((T0*)ms39_8976);
r7to_upper(((T7*)oBC39x_suffix));
}
 else if((((T0*)ms39_2440))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC39x_suffix=((T0*)ms39_8976);
}
 else if((((T0*)ms39_1772235))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC39x_suffix=((T0*)ms39_8976);
}
 else if((((T0*)ms39_59731))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
oBC39x_suffix=((T0*)ms39_1438);
}
else{
oBC39x_suffix=((T0*)ms39_0);
}
/*FI]*/
}}
return oBC39x_suffix;
}
T0*oBC39compiler_list=NULL;
int fBC39add_lib_math=0;


void r39add_lib_math(T39* C){
if(fBC39add_lib_math==0){fBC39add_lib_math=1;{
/*[IF*/
if((((T0*)ms39_11253))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3169)))){
r39add_external_lib(((T0*)ms39_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_76405)))){
r39add_external_lib(((T0*)ms39_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_382130)))){
r39add_external_lib(((T0*)ms39_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_603)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
r39add_external_lib(((T0*)ms39_1774));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
/*[IF*/
if((((T0*)ms39_57487))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
r39add_external_lib(((T0*)ms39_1125006));
}
else{
r39add_external_lib(((T0*)ms39_1774));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3069)))){
r39add_external_lib(((T0*)ms39_223953));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
}
/*FI]*/
}}}


void r39add_objects(T39* C,T0* a1,T0* a2,T2 a3){
T2 _i=0;
_i=1;
while (!((_i)>(a3)))
{
r39append_token(a1,a2);
r2append_in(_i,a1);
r7append(((T7*)a1),r39object_suffix(C));
_i=(_i)+(1);
}
}


T6 r39backslash_separator(T39* C){
T6 R=0;
/*[IF*/
if((((T0*)ms39_1772235))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
R=1;
}
 else if((((T0*)ms39_2178))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
R=1;
}
 else if((((T0*)ms39_2440))==((void*)((/*RF2*/(C)->_system_name/*0*/)))){
R=1;
}
/*FI]*/
return R;
}


T0* r39sas_c_compiler_options(T6 a1){
T0* R=NULL;
/*[IF*/
if(r39Scoptions_exists()){
R=((T0*)ms39_0aaaaaaaa);
}
else{
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7make(n,0);
R=((T0*)n);
}
r7append(((T7*)R),((T0*)ms39_1721407046));
/*[IF*/
if(a1){
r7append(((T7*)R),((T0*)ms39_19761224));
}
else{
r7append(((T7*)R),((T0*)ms39_98806116));
}
/*FI]*/
r7append(((T7*)R),((T0*)ms39_1494914262));
r7append(((T7*)R),((T0*)ms39_721564652));
}
/*FI]*/
return R;
}


void r39split_mode_linker_command(T39* C,T0* a1,T0* a2,T2 a3){
/*[IRF3.3clear*/((((T7*)(((T7*)a1))))->_count)=(0);
/*]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3169)))){
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms39_0aaa)))->_count/*4*/))==(0)/*)*/){
r7append(((T7*)a1),((T0*)ms39_3169));
}
else{
r7append(((T7*)a1),((T0*)ms39_2833));
}
/*FI]*/
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_51699930)))){
r39external_c_files_for_lcc_win32(C,a1);
r7append(((T7*)a1),((T0*)ms39_415107));
/*[IF*/
if(!((/*RF2*/(C)->_no_strip/*16*/))){
r39append_token(a1,((T0*)ms39_340));
}
/*FI]*/
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_594)))){
r7append(((T7*)a1),((T0*)ms39_594));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_448859)))){
r7append(((T7*)a1),((T0*)ms39_91157));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_76405)))){
r7append(((T7*)a1),((T0*)ms39_76405));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_382130)))){
r7append(((T7*)a1),((T0*)ms39_382130));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_603)))){
r7append(((T7*)a1),((T0*)ms39_603));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_674)))){
r7append(((T7*)a1),((T0*)ms39_674));
r39append_token(a1,r39sas_c_compiler_options(1));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,a2);
r7append(((T7*)a1),((T0*)ms39_2075119688));
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
r39add_output_name(C,a1);
/*[IF*/
if(!((/*RF2*/(C)->_no_strip/*16*/))){
r7append(((T7*)a1),((T0*)ms39_530877013));
}
/*FI]*/
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_15721)))){
r7append(((T7*)a1),((T0*)ms39_3094));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
/*[IF*/
if((/*RF2*/(C)->_no_strip/*16*/)){
r39append_token(a1,((T0*)ms39_218174));
}
/*FI]*/
r39add_lib_math(C);
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_17794)))){
r7append(((T7*)a1),((T0*)ms39_689));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_lib_math(C);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_3069)))){
r7append(((T7*)a1),((T0*)ms39_3069));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
 else if(((/*RF2*/(C)->_c_compiler/*12*/))==((void*)(((T0*)ms39_18144)))){
r7append(((T7*)a1),((T0*)ms39_18144));
r39append_token(a1,((T0*)ms39_0aaaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaaa));
r39append_token(a1,((T0*)ms39_0aaaaa));
r39add_output_name(C,a1);
r39add_objects(C,a1,a2,a3);
r39append_token(a1,((T0*)ms39_0aaaa));
r39append_token(a1,((T0*)ms39_0aaa));
r39append_token(a1,((T0*)ms39_0aa));
r39append_token(a1,((T0*)ms39_0a));
}
/*FI]*/
}


void r40disconnect(T40* C){
fclose((/*RF2*/(C)->_input_stream/*5*/));
(/*SFN*/C->_path)=NULL;
}


void r40read_character(T40* C){
/*[IF*/
if((/*RF2*/(C)->_push_back_flag/*0*/)){
(/*SFN*/C->_push_back_flag)=0;
}
else{
(/*SFN*/C->_memory)=getc((FILE*)((/*RF2*/(C)->_input_stream/*5*/)));
}
/*FI]*/
}


void r40skip_separators(T40* C){
while (!((r40end_of_input(C))||(!(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*9*/)))/*)*/)))))
{
r40read_character(C);
}
/*[IF*/
if((!(r40end_of_input(C)))&&(!((/*RF2*/(C)->_push_back_flag/*0*/)))){
/*[IRF3.3unread_character*/((((T40*)(C)))->_push_back_flag)=(1);
/*]*/
}
/*FI]*/
}


void r40read_line_in(T40* C,T0* a1){
r40read_character(C);
while (!(((((/*RF2*/(C)->_memory/*9*/))==((EOF)))||(((/*RF2*/(C)->_memory/*9*/))==(T3code(((T3)'\n')))))||(((/*RF2*/(C)->_memory/*9*/))==(T3code(((T3)'\15'))))))
{
r7extend(((T7*)a1),((T3)((/*RF2*/(C)->_memory/*9*/))));
r40read_character(C);
}
/*[IF*/
if(((/*RF2*/(C)->_memory/*9*/))==(T3code(((T3)'\15')))){
r40read_character(C);
/*[IF*/
if(((/*RF2*/(C)->_memory/*9*/))!=(T3code(((T3)'\n')))){
(/*SFN*/C->_push_back_flag)=1;
}
/*FI]*/
}
/*FI]*/
}


T6 r40end_of_input(T40* C){
T6 R=0;
/*[IF*/
if(!((/*RF2*/(C)->_push_back_flag/*0*/))){
R=((/*RF2*/(C)->_memory/*9*/))==((EOF));
}
/*FI]*/
return R;
}


void r40connect_to(T40* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
(/*SFN*/C->_input_stream)=fopen((char*)_p,"r");
/*[IF*/
if((NULL!=(/*RF2*/(C)->_input_stream/*5*/))){
(/*SFN*/C->_push_back_flag)=0;
(/*SFN*/C->_memory)=T3code(((T3)'\40'));
(/*SFN*/C->_path)=a1;
}
/*FI]*/
}


void r40read_line(T40* C){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC32last_string))))->_count)=(0);
/*]*/
r40read_line_in(C,oBC32last_string);
}


void r40read_word(T40* C){
r40skip_separators(C);
/*[IF*/
if(!(r40end_of_input(C))){
r40read_character(C);
}
/*FI]*/
/*[IRF3.3clear*/((((T7*)((T7*)(oBC32last_string))))->_count)=(0);
/*]*/
while (!((r40end_of_input(C))||(r3is_separator(/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*9*/)))/*)*/))))
{
r7extend((T7*)(oBC32last_string),/*(IRF4.6last_character*/((T3)((/*RF2*/(C)->_memory/*9*/)))/*)*/);
r40read_character(C);
}
}


void r34put_string(T34* C,T0* a1){
T2 _i=0;
_i=1;
while (!((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))))
{
/*[IRF3.6put_character*/{T34* C1=C;
T3 b1=/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/;
putc(b1,((FILE*)(stdout)));
}/*]*/
_i=(_i)+(1);
}
}


void r49put_string(T49* C,T0* a1){
T2 _i=0;
_i=1;
while (!((_i)>((/*RF2*/(((T7*)a1))->_count/*4*/))))
{
/*[IRF3.6put_character*/{T49* C1=C;
T3 b1=/*(IRF4.6item*/((/*RF2*/(((T7*)a1))->_storage/*0*/))[(_i)-(1)]/*)*/;
putc(b1,((FILE*)(stderr)));
}/*]*/
_i=(_i)+(1);
}
}


T6 r38file_exists(T0* a1){
T6 R=0;
R=r38is_readable(a1);
return R;
}


void r38rename_to(int C,T0* a1,T0* a2){
T8 _p2=NULL;
T8 _p1=NULL;
/*[IF*/
if(r38file_exists(a2)){
r38delete(C,a2);
}
/*FI]*/
_p1=r7to_external(((T7*)a1));
_p2=r7to_external(((T7*)a2));
rename(((char*)_p1),((char*)_p2));
}
T0*oBC38std_fr1=NULL;


void r38delete(int C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
remove(((char*)_p));
}


T6 r38is_readable(T0* a1){
T6 R=0;
r40connect_to((T40*)(oBC38std_fr1),a1);
R=/*(IRF4.7is_connected*/((/*RF2*/((T40*)(oBC38std_fr1))->_path/*1*/))!=(NULL)/*)*/;
/*[IF*/
if(R){
r40disconnect((T40*)(oBC38std_fr1));
}
/*FI]*/
return R;
}


void r17clean_bin_c_path(T17* C){
T0* _item=NULL;
T2 _i=0;
_i=1;
while (!((_i)>(r44count((T44*)(oBC17no_split_command_list)))))
{
_item=r44item((T44*)(oBC17no_split_command_list),_i);
r17call_clean(C,_item);
_i=(_i)+(1);
}
_i=1;
while (!((_i)>(r44count((T44*)(oBC17splitted_command_list)))))
{
_item=r44item((T44*)(oBC17splitted_command_list),_i);
/*[IF*/
if(!(r7is_equal(((T7*)_item),((T0*)ms17_1889925553aaaaaa)))){
r17call_clean(C,_item);
}
/*FI]*/
_i=(_i)+(1);
}
{T36 se_tmp0;
r36connect_to_current_working_directory(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*39*/))._directory_stream/*0*/))/*)*/){
{T36 se_tmp0;
{T36 se_tmp1;
T36 se_tmp0;
r36read_entry(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
while (!(/*(IRF4.6end_of_input*/r8is_null(((T8)((/*RF2*/((/*RF2*/(C)->_basic_directory/*39*/))._current_entry/*4*/))))/*)*/))
{
{T36 se_tmp3;
T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
_item=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp3;
T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
/*[IF*/
if(r7has_prefix(((T7*)_item),((T0*)ms17_1889925553aaaa))){
{T36 se_tmp3;
T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
/*[INSPECT*/
{int z1=r7last(((T7*)_item));
switch(z1){
case 67:
case 72:
case 99:
case 104:
break;
default:;
{T36 se_tmp3;
T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37file_removing((T37*)(oBC19echo),_item);
}
}
}/*INSPECT]*/
}
}
else{
{T36 se_tmp3;
T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37file_removing((T37*)(oBC19echo),_item);
}
}
/*FI]*/
}
{T36 se_tmp4;
T36 se_tmp3;
T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r36read_entry(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
}
}
}
{T36 se_tmp5;
T36 se_tmp4;
T36 se_tmp3;
T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r36disconnect(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
}
/*FI]*/
}
/*[IF*/
if(r7is_equal(ms17_51699930,(/*RF2*/(C)->_c_compiler_name/*26*/))){
r37put_string((T37*)(oBC19echo),((T0*)ms17_47441125));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_bin_c_path/*34*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090));
r17call_clean(C,((T0*)ms17_1889925553aaa));
r17call_compile_to_c(C,((T0*)ms17_52892944),((T0*)ms17_1889925553));
/*[IRF3.6remove_file*/{T0* b1=((T0*)ms17_87473026);
r38delete(oBC1file_tools,b1);
}/*]*/
}
/*FI]*/
}


void r17prepare_bin_c_directory(T17* C){
T0* _item=NULL;
T0* _args=NULL;
T2 _i=0;
_i=1;
while (!((_i)>(r44count((T44*)(oBC17no_split_command_list)))))
{
_item=r44item((T44*)(oBC17no_split_command_list),_i);
/*[IF*/
if(r7is_equal(ms17_51699930aa,(/*RF2*/(C)->_c_compiler_name/*26*/))){
_args=((T0*)ms17_1978328933);
}
else{
_args=((T0*)ms17_1744496991);
}
/*FI]*/
r17call_compile_to_c(C,_args,_item);
_i=(_i)+(1);
}
_i=1;
while (!((_i)>(r44count((T44*)(oBC17splitted_command_list)))))
{
_item=r44item((T44*)(oBC17splitted_command_list),_i);
/*[IF*/
if(r7is_equal(ms17_51699930a,(/*RF2*/(C)->_c_compiler_name/*26*/))){
_args=((T0*)ms17_219216);
}
else{
_args=((T0*)ms17_52892944a);
}
/*FI]*/
r17call_compile_to_c(C,_args,_item);
_i=(_i)+(1);
}
}
T0*oBC17sfr=NULL;


void r17gathered_information_summary(T17* C){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1565343603));
r34put_string((T34*)(oBC1std_output),(/*RF2*/(C)->_installation_path/*6*/));
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1457509747));
r34put_string((T34*)(oBC1std_output),(/*RF2*/(C)->_system_name/*10*/));
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1460571212));
r34put_string((T34*)(oBC1std_output),(/*RF2*/(C)->_c_compiler_name/*26*/));
r34put_string((T34*)(oBC1std_output),((T0*)ms17_180aa));
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms17_0)))->_count/*4*/))==(0)/*)*/)){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1661597104));
r34put_string((T34*)(oBC1std_output),((T0*)ms17_0));
r34put_string((T34*)(oBC1std_output),((T0*)ms17_180a));
}
/*FI]*/
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1550993158));
r34put_string((T34*)(oBC1std_output),(/*RF2*/(C)->_garbage_collector/*22*/));
r34put_string((T34*)(oBC1std_output),((T0*)ms17_180));
/*[IF*/
if((/*RF2*/(C)->_interactive/*0*/)){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_273256990));
/*[IRF3.6flush*/{T34* C1=(T34*)(oBC1std_output);
fflush(stdout);
}/*]*/
r31read_character((T31*)(oBC1std_input));
}
/*FI]*/
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1324228360));
}


T6 r17file_exists(T0* a1){
T6 R=0;
R=r38is_readable(a1);
return R;
}
T0*oBC17sfw=NULL;
T0*oBC17system_tools=NULL;


void r17compute_bin_path_in_system_env_path(T17* C){
T0* _content=NULL;
T0* _se_bin=NULL;
_se_bin=r7twin((T7*)((/*RF2*/(C)->_bin_path/*30*/)));
/*[IF*/
if(r7is_equal(ms17_13028,(/*RF2*/(C)->_system_name/*10*/))){
_content=r17get_environment_variable(C,((T0*)ms17_12117));
/*[IF*/
if((_content)!=((void*)(NULL))){
/*[IF*/
if((r7last(((T7*)_se_bin)))==(((T3)'\57'))){
r7remove_last(((T7*)_se_bin),1);
}
/*FI]*/
_content=r7twin(((T7*)_content));
while (!(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)))
{
/*[IF*/
if(r7has_prefix(((T7*)_content),_se_bin)){
r7remove_first(((T7*)_content),(/*RF2*/(((T7*)_se_bin))->_count/*4*/));
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count)=(0);
/*]*/
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_first(((T7*)_content),1);
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count)=(0);
/*]*/
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
/*FI]*/
}
/*FI]*/
}
else{
r7remove_first(((T7*)_content),1);
}
/*FI]*/
}
}
/*FI]*/
}
 else if(r7is_equal(ms17_1772235a,(/*RF2*/(C)->_system_name/*10*/))){
_content=r17get_environment_variable(C,((T0*)ms17_12117a));
/*[IF*/
if((_content)!=((void*)(NULL))){
/*[IF*/
if((r7last(((T7*)_se_bin)))==(((T3)'\134'))){
r7remove_last(((T7*)_se_bin),1);
}
/*FI]*/
r7to_lower(((T7*)_se_bin));
_content=r7twin(((T7*)_content));
r7to_lower(((T7*)_content));
while (!(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)))
{
/*[IF*/
if(r7has_prefix(((T7*)_content),_se_bin)){
r7remove_first(((T7*)_content),(/*RF2*/(((T7*)_se_bin))->_count/*4*/));
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\73'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count)=(0);
/*]*/
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\134'))){
r7remove_first(((T7*)_content),1);
/*[IF*/
if(((/*RF2*/(((T7*)_content))->_count/*4*/))==(0)){
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
 else if((/*(IRF4.6first*/((/*RF2*/(((T7*)_content))->_storage/*0*/))[0]/*)*/)==(((T3)'\73'))){
/*[IRF3.3clear*/((((T7*)(((T7*)_content))))->_count)=(0);
/*]*/
(/*SFN*/C->_bin_path_in_system_env_path)=1;
}
/*FI]*/
}
/*FI]*/
}
else{
r7remove_first(((T7*)_content),1);
}
/*FI]*/
}
}
/*FI]*/
}
/*FI]*/
}


void r17call_compile_to_c(T17* C,T0* a1,T0* a2){
/*[IF*/
if((/*RF2*/(C)->_bin_path_in_system_env_path/*38*/)){
r7copy((T7*)(oBC17command),((T0*)ms17_1889925553a));
}
else{
{T36 se_tmp0;
r36compute_file_path_with(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_path/*30*/),((T0*)ms17_1889925553aa));
}
{T36 se_tmp0;
r7copy((T7*)(oBC17command),oBC36last_entry);
}
}
/*FI]*/
r39add_x_suffix((T39*)(oBC17system_tools),oBC17command);
r7extend((T7*)(oBC17command),((T3)'\40'));
r7append((T7*)(oBC17command),a1);
r7append((T7*)(oBC17command),((T0*)ms17_5712));
r7append((T7*)(oBC17command),a2);
r7extend((T7*)(oBC17command),((T3)'\40'));
r7append((T7*)(oBC17command),a2);
r34put_string((T34*)(oBC1std_output),oBC17command);
r34put_string((T34*)(oBC1std_output),((T0*)ms17_10));
r37call_system((T37*)(oBC19echo),oBC17command);
}
T0*oBC1command_arguments=NULL;
int fBC1command_arguments=0;


T0* r17command_arguments(void){
if(fBC1command_arguments==0){fBC1command_arguments=1;{
T0* _arg=NULL;
T2 _i=0;
_i=se_argc;
{T54*n=((T54*)se_malloc(sizeof(*n))/*16*/);
*n=M54;
oBC1command_arguments=((T0*)n);
r54make(n,_i);
}
while (!((_i)==(0)))
{
_i=(_i)-(1);
_arg=((T0*)se_string(se_argv[_i]));
/*[IRF3.5put*/((/*RF2*/(((T54*)oBC1command_arguments))->_storage/*4*/))[_i]=(_arg);
/*]*/
}
}}
return oBC1command_arguments;
}


void r17interactive_c_compiler_linker_options(T17* C){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1998835793));
/*[IF*/
if(r7is_equal(ms17_3169,(/*RF2*/(C)->_c_compiler_name/*26*/))){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_392246664));
}
/*FI]*/
r34put_string((T34*)(oBC1std_output),((T0*)ms17_762404314));
r31read_line((T31*)(oBC1std_input));
r7copy((T7*)(((T0*)ms17_0)),oBC32last_string);
}


void r17set_installation_path(T17* C){
T0* _string=NULL;
r37put_string((T37*)(oBC19echo),((T0*)ms17_156524099));
_string=r7twin((T7*)((/*RF2*/(C)->_system_se_path/*2*/)));
{T36 se_tmp0;
r36compute_parent_directory_of(&((/*RF2*/(C)->_basic_directory/*39*/)),_string);
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/){
{T36 se_tmp0;
/*[IRF3.2fatal_problem_description_start*/{T36 se_tmp0;
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
}
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_106668511a));
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_se_path/*2*/));
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaaaaaaaa));
}
{T36 se_tmp0;
r17fatal_problem_description_end(C);
}
}
/*FI]*/
}
{T36 se_tmp0;
_string=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp0;
r36compute_parent_directory_of(&((/*RF2*/(C)->_basic_directory/*39*/)),_string);
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/){
{T36 se_tmp0;
/*[IRF3.2fatal_problem_description_start*/{T36 se_tmp0;
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
}
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_106668511));
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),_string);
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaaaaaaa));
}
{T36 se_tmp0;
r17fatal_problem_description_end(C);
}
}
/*FI]*/
}
{T36 se_tmp0;
(/*SFN*/C->_installation_path)=r7twin((T7*)(oBC36last_entry));
}
r37put_string((T37*)(oBC19echo),((T0*)ms17_1264449352));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_installation_path/*6*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaaaaaa));
}


void r17c_compile_no_split_command_list(T17* C){
T2 _i=0;
T0* _item=NULL;
_i=1;
while (!((_i)>(r44count((T44*)(oBC17no_split_command_list)))))
{
_item=r44item((T44*)(oBC17no_split_command_list),_i);
r17no_split_mode_c_compile(C,_item);
_i=(_i)+(1);
}
}
T0*oBC1std_input=NULL;
T0*oBC19small_eiffel=NULL;


void r17set_garbage_collector_file_path(T17* C){
T0* _path=NULL;
r37put_string((T37*)(oBC19echo),((T0*)ms17_789957814));
_path=r7twin((T7*)((/*RF2*/(C)->_installation_path/*6*/)));
{T36 se_tmp0;
r36compute_subdirectory_with(&((/*RF2*/(C)->_basic_directory/*39*/)),_path,((T0*)ms17_3595));
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/){
{T36 se_tmp0;
/*[IRF3.2fatal_problem_description_start*/{T36 se_tmp0;
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
}
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1447048624));
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),_path);
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1816967047a));
}
{T36 se_tmp0;
r17fatal_problem_description_end(C);
}
}
/*FI]*/
}
{T36 se_tmp0;
_path=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp0;
r36compute_file_path_with(&((/*RF2*/(C)->_basic_directory/*39*/)),_path,((T0*)ms17_614));
}
{T36 se_tmp0;
_path=r7twin((T7*)(oBC36last_entry));
}
(/*SFN*/C->_garbage_collector_file_path)=_path;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1753448889));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_garbage_collector_file_path/*18*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1816967047));
}
T0*oBC17splitted_command_list=NULL;


void r17make(T17* C){
T0* _arg=NULL;
T2 _i=0;
_i=1;
while (!((_i)>(/*(IRF4.9argument_count*/(/*RF2*/((T54*)(r17command_arguments()))->_upper/*12*/)/*)*/)))
{
_arg=r17argument(_i);
/*[IF*/
if(r7is_equal(ms17_218888,_arg)){
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
}
 else if(r7is_equal(ms17_802100104,_arg)){
(/*SFN*/C->_interactive)=1;
}
 else if(r7is_equal(ms17_1014578011,_arg)){
(/*SFN*/C->_skip_c_compilation)=1;
}
 else if(r7is_equal(ms17_1719,_arg)){
/*[IF*/
if((_i)<(/*(IRF4.9argument_count*/(/*RF2*/((T54*)(r17command_arguments()))->_upper/*12*/)/*)*/)){
_i=(_i)+(1);
(/*SFN*/C->_c_compiler_name)=r17argument(_i);
}
else{
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1643948856));
r17echo_usage_exit(C);
}
/*FI]*/
}
else{
r17echo_usage_exit(C);
}
/*FI]*/
_i=(_i)+(1);
}
r34put_string((T34*)(oBC1std_output),((T0*)ms17_111984535));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1042405932));
r37put_string((T37*)(oBC19echo),((T0*)ms17_2073823));
r37put_string((T37*)(oBC19echo),((T0*)ms17_142550));
r37put_string((T37*)(oBC19echo),((T0*)ms52_2140009595));
r17set_system_se_path(C);
r17set_installation_path(C);
r17set_system_name(C);
r17write_default_loadpath_se_file(C);
r17set_compiler_se_path(C);
{T36 se_tmp0;
r36connect_to_current_working_directory(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
{T36 se_tmp0;
(/*SFN*/C->_cwd)=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*39*/))._directory_stream/*0*/))/*)*/){
{T36 se_tmp1;
T36 se_tmp0;
r36disconnect(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
}
/*FI]*/
}
r17set_garbage_collector_file_path(C);
r17garbage_collector_selection(C);
r17set_c_compiler_name(C);
r17set_bin_path(C);
r17set_bin_c_path(C);
{T36 se_tmp0;
r36change_current_working_directory(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_c_path/*34*/));
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/){
{T36 se_tmp0;
/*[IRF3.2fatal_problem_description_start*/{T36 se_tmp0;
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
}
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1396646724));
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_bin_c_path/*34*/));
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaa));
}
{T36 se_tmp0;
r17fatal_problem_description_end(C);
}
}
/*FI]*/
}
r17compute_bin_path_in_system_env_path(C);
r17gathered_information_summary(C);
/*[IF*/
if((/*RF2*/(C)->_skip_c_compilation/*1*/)){
}
else{
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1908435986));
{T36 se_tmp0;
r34put_string((T34*)(oBC1std_output),oBC36last_entry);
}
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1090aa));
r17split_mode_c_compile(C,((T0*)ms17_1889925553aaaaaaa));
r17prepare_bin_c_directory(C);
r17c_compile_no_split_command_list(C);
r17c_compile_splitted_command_list(C);
r17clean_bin_c_path(C);
}
/*FI]*/
r17restore_current_working_directory(C);
/*[IF*/
if(!((/*RF2*/(C)->_bin_path_in_system_env_path/*38*/))){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1613624149));
r34put_string((T34*)(oBC1std_output),(/*RF2*/(C)->_bin_path/*30*/));
r34put_string((T34*)(oBC1std_output),((T0*)ms17_596025978));
}
/*FI]*/
r34put_string((T34*)(oBC1std_output),((T0*)ms17_66309112));
/*[IF*/
if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_1772235))){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1472409390));
r31read_character((T31*)(oBC1std_input));
}
/*FI]*/
}


void r17set_c_compiler_name(T17* C){
r37put_string((T37*)(oBC19echo),((T0*)ms17_564929999));
/*[IF*/
if(r6_px_and(!((/*RF2*/(C)->_interactive/*0*/)),((/*RF2*/(C)->_c_compiler_name/*26*/))==((void*)(NULL)))){
/*[IF*/
if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_13028a))){
(/*SFN*/C->_c_compiler_name)=((T0*)ms17_3169a);
/*[IF*/
if(r7is_equal(ms17_2102329,(/*RF2*/(C)->_garbage_collector/*22*/))){
r7copy((T7*)(((T0*)ms17_0)),((T0*)ms17_45411));
}
/*FI]*/
}
/*FI]*/
}
/*FI]*/
/*[IF*/
if(((/*RF2*/(C)->_c_compiler_name/*26*/))==((void*)(NULL))){
(/*SFN*/C->_c_compiler_name)=r17choice_in(((T0*)ms17_22597211),oBC39compiler_list);
}
/*FI]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_1471850305));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_c_compiler_name/*26*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaa));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1432574655));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_compiler_se_path/*14*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaa));
r37sfw_connect((T37*)(oBC19echo),oBC17sfw,(/*RF2*/(C)->_compiler_se_path/*14*/));
r17sfw_check_is_connected(C,(/*RF2*/(C)->_compiler_se_path/*14*/));
r51put_string((T51*)(oBC17sfw),(/*RF2*/(C)->_c_compiler_name/*26*/));
/*[IF*/
if((/*RF2*/(C)->_interactive/*0*/)){
r17interactive_c_compiler_linker_options(C);
}
/*FI]*/
/*[IF*/
if(!(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(((T0*)ms17_0)))->_count/*4*/))==(0)/*)*/)){
/*[IRF3.6put_character*/{T51* C1=(T51*)(oBC17sfw);
T3 b1=((T3)'\40');
putc(b1,((FILE*)((/*RF2*/(C1)->_output_stream/*4*/))));
}/*]*/
r51put_string((T51*)(oBC17sfw),((T0*)ms17_0));
}
/*FI]*/
/*[IRF3.6put_character*/{T51* C1=(T51*)(oBC17sfw);
T3 b1=((T3)'\n');
putc(b1,((FILE*)((/*RF2*/(C1)->_output_stream/*4*/))));
}/*]*/
r51disconnect((T51*)(oBC17sfw));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1097633494));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_compiler_se_path/*14*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_3554640));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1188940911));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_compiler_se_path/*14*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1118238740));
r39set_c_compiler((T39*)(oBC17system_tools),NULL);
r39install_extra_options((T39*)(oBC17system_tools));
}


void r17sfw_check_is_connected(T17* C,T0* a1){
/*[IF*/
if(!(/*(IRF4.7is_connected*/((/*RF2*/((T51*)(oBC17sfw))->_path/*0*/))!=(NULL)/*)*/)){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_1711985232));
r37put_string((T37*)(oBC19echo),a1);
r37put_string((T37*)(oBC19echo),((T0*)ms17_2028227069));
r17fatal_problem_description_end(C);
}
/*FI]*/
}


void r17set_system_se_path(T17* C){
T0* _string=NULL;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1320038759));
(/*SFN*/C->_system_se_path)=r17get_environment_variable(C,((T0*)ms20_1071750288));
/*[IF*/
if((((/*RF2*/(C)->_system_se_path/*2*/))==((void*)(NULL)))||(((/*RF2*/((T7*)((/*RF2*/(C)->_system_se_path/*2*/)))->_count/*4*/))==(0))){
_string=r7twin((T7*)(((T0*)ms20_1071750288)));
r7to_upper(((T7*)_string));
(/*SFN*/C->_system_se_path)=r17get_environment_variable(C,_string);
}
/*FI]*/
/*[IF*/
if((((/*RF2*/(C)->_system_se_path/*2*/))==((void*)(NULL)))||(((/*RF2*/((T7*)((/*RF2*/(C)->_system_se_path/*2*/)))->_count/*4*/))==(0))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_1378771941));
r17fatal_problem_description_end(C);
}
/*FI]*/
/*[IF*/
if(!(r7has_suffix((T7*)((/*RF2*/(C)->_system_se_path/*2*/)),((T0*)ms17_56612951)))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_2030897129));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_se_path/*2*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaaaaaaaaa));
r37put_string((T37*)(oBC19echo),((T0*)ms17_424198040));
r17fatal_problem_description_end(C);
}
/*FI]*/
/*[IF*/
if(!(r17file_exists((/*RF2*/(C)->_system_se_path/*2*/)))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_1308497832));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_se_path/*2*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1392904185));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_se_path/*2*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1891780586));
r17fatal_problem_description_end(C);
}
/*FI]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_1789524802));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_se_path/*2*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_5515));
}


T0* r17get_environment_variable(T17* C,T0* a1){
T0* R=NULL;
T8 _null=NULL;
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
_p=basic_getenv(_p);
/*[IF*/
if((_p)!=(_null)){
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
r7from_external_copy(n,_p);
R=((T0*)n);
}
}
/*FI]*/
return R;
}


void r17system(T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
system(((char*)_p));
}


void r17call_clean(T17* C,T0* a1){
/*[IF*/
if((/*RF2*/(C)->_bin_path_in_system_env_path/*38*/)){
r7copy((T7*)(oBC17command),((T0*)ms17_78495));
}
else{
{T36 se_tmp0;
r36compute_file_path_with(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_path/*30*/),((T0*)ms17_78495a));
}
{T36 se_tmp0;
r7copy((T7*)(oBC17command),oBC36last_entry);
}
}
/*FI]*/
r39add_x_suffix((T39*)(oBC17system_tools),oBC17command);
r7extend((T7*)(oBC17command),((T3)'\40'));
r7append((T7*)(oBC17command),a1);
r34put_string((T34*)(oBC1std_output),oBC17command);
r34put_string((T34*)(oBC1std_output),((T0*)ms17_10a));
r37call_system((T37*)(oBC19echo),oBC17command);
}


void r17fatal_problem_description_end(T17* C){
r37put_string((T37*)(oBC19echo),((T0*)ms17_870813064));
r17restore_current_working_directory(C);
exit(1);
}


void r17restore_current_working_directory(T17* C){
/*[IF*/
if(((/*RF2*/(C)->_cwd/*47*/))!=((void*)(NULL))){
{T36 se_tmp0;
r36change_current_working_directory(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_cwd/*47*/));
}
}
/*FI]*/
}


void r17garbage_collector_selection(T17* C){
T0* _cmd=NULL;
r37put_string((T37*)(oBC19echo),((T0*)ms17_38415354));
/*[IF*/
if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_13028aa))){
_cmd=r7twin((T7*)((/*RF2*/(C)->_system_se_path/*2*/)));
/*[IRF3.6remove_suffix*/{T7* C1=((T7*)_cmd);
T0* b1=((T0*)ms17_896093333);
r7remove_last(C1,(/*RF2*/(((T7*)b1))->_count/*4*/));
}/*]*/
r7append(((T7*)_cmd),((T0*)ms17_264638762));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1529073275));
r37put_string((T37*)(oBC19echo),_cmd);
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaa));
r17system(_cmd);
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_57487))){
(/*SFN*/C->_garbage_collector)=((T0*)ms17_167987030);
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_1772235aa))){
(/*SFN*/C->_garbage_collector)=((T0*)ms17_56806204);
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_11253))){
(/*SFN*/C->_garbage_collector)=((T0*)ms17_176208679);
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_2178))){
(/*SFN*/C->_garbage_collector)=((T0*)ms17_56806204a);
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_39617954))){
(/*SFN*/C->_garbage_collector)=((T0*)ms17_747883329);
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_2440))){
(/*SFN*/C->_garbage_collector)=((T0*)ms17_56806204aa);
}
 else if(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),((T0*)ms17_2618))){
(/*SFN*/C->_garbage_collector)=((T0*)ms17_50246554);
}
/*FI]*/
/*[IF*/
if(((/*RF2*/(C)->_garbage_collector/*22*/))==((void*)(NULL))){
r37sfr_connect((T37*)(oBC19echo),oBC17sfr,(/*RF2*/(C)->_garbage_collector_file_path/*18*/));
(/*SFN*/C->_garbage_collector)=r37read_word_in((T37*)(oBC19echo),oBC17sfr);
r40disconnect((T40*)(oBC17sfr));
r37put_string((T37*)(oBC19echo),((T0*)ms17_817978331));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_garbage_collector/*22*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaa));
}
else{
r37put_string((T37*)(oBC19echo),((T0*)ms17_817978331a));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_garbage_collector/*22*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaa));
r37sfw_connect((T37*)(oBC19echo),oBC17sfw,(/*RF2*/(C)->_garbage_collector_file_path/*18*/));
r17sfw_check_is_connected(C,(/*RF2*/(C)->_garbage_collector_file_path/*18*/));
r51put_string((T51*)(oBC17sfw),(/*RF2*/(C)->_garbage_collector/*22*/));
/*[IRF3.6put_character*/{T51* C1=(T51*)(oBC17sfw);
T3 b1=((T3)'\n');
putc(b1,((FILE*)((/*RF2*/(C1)->_output_stream/*4*/))));
}/*]*/
r51disconnect((T51*)(oBC17sfw));
}
/*FI]*/
}
T0*oBC17command=NULL;


void r17set_bin_c_path(T17* C){
(/*SFN*/C->_bin_c_path)=r7twin((T7*)((/*RF2*/(C)->_installation_path/*6*/)));
{T36 se_tmp0;
r36compute_subdirectory_with(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_c_path/*34*/),((T0*)ms17_77699));
}
{T36 se_tmp0;
(/*SFN*/C->_bin_c_path)=r7twin((T7*)(oBC36last_entry));
}
}


void r17c_compile_splitted_command_list(T17* C){
T2 _i=0;
T0* _item=NULL;
_i=1;
while (!((_i)>(r44count((T44*)(oBC17splitted_command_list)))))
{
_item=r44item((T44*)(oBC17splitted_command_list),_i);
r17split_mode_c_compile(C,_item);
_i=(_i)+(1);
}
}


void r17set_system_name(T17* C){
r37put_string((T37*)(oBC19echo),((T0*)ms17_1926767382));
/*[IF*/
if((/*RF2*/(C)->_interactive/*0*/)){
(/*SFN*/C->_system_name)=r17choice_in(((T0*)ms17_414933715),oBC39system_list);
}
 else if(r17file_exists(((T0*)ms17_1457010570))){
r37put_string((T37*)(oBC19echo),((T0*)ms17_2093873910));
(/*SFN*/C->_system_name)=((T0*)ms17_57487aa);
}
 else if(r17file_exists(((T0*)ms17_404024442))){
r37put_string((T37*)(oBC19echo),((T0*)ms17_1927398937));
(/*SFN*/C->_system_name)=((T0*)ms17_11253aa);
}
 else if(r17file_exists(((T0*)ms17_1121830))){
r37put_string((T37*)(oBC19echo),((T0*)ms17_1927443312));
(/*SFN*/C->_system_name)=((T0*)ms17_13028aaaa);
}
else{
{T36 se_tmp0;
r36connect_to(&((/*RF2*/(C)->_basic_directory/*39*/)),((T0*)ms17_2057));
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*39*/))._directory_stream/*0*/))/*)*/){
{T36 se_tmp0;
(/*SFN*/C->_system_name)=((T0*)ms17_1772235aaaa);
}
{T36 se_tmp1;
T36 se_tmp0;
r36disconnect(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
}
else{
{T36 se_tmp1;
T36 se_tmp0;
(/*SFN*/C->_system_name)=r17choice_in(((T0*)ms17_414933715a),oBC39system_list);
}
}
/*FI]*/
}
}
/*FI]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_1102814319));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_name/*10*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1168848885));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_se_path/*2*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaaaaa));
r37sfw_connect((T37*)(oBC19echo),oBC17sfw,(/*RF2*/(C)->_system_se_path/*2*/));
r17sfw_check_is_connected(C,(/*RF2*/(C)->_system_se_path/*2*/));
r51put_string((T51*)(oBC17sfw),(/*RF2*/(C)->_system_name/*10*/));
/*[IRF3.6put_character*/{T51* C1=(T51*)(oBC17sfw);
T3 b1=((T3)'\n');
putc(b1,((FILE*)((/*RF2*/(C1)->_output_stream/*4*/))));
}/*]*/
r51disconnect((T51*)(oBC17sfw));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1097633494aa));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_se_path/*2*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_3554640a));
r39make((T39*)(oBC17system_tools));
/*[IF*/
if(!(r7is_equal((T7*)((/*RF2*/(C)->_system_name/*10*/)),(/*RF2*/((T39*)(oBC17system_tools))->_system_name/*0*/)))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_825023736));
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_system_name/*10*/));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaaaa));
r17fatal_problem_description_end(C);
}
/*FI]*/
}


void r17no_split_mode_c_compile(T17* C,T0* a1){
T0* _c_name=NULL;
_c_name=r7twin(((T7*)a1));
r7append(((T7*)_c_name),((T0*)ms17_329a));
/*[IRF3.3set_output_name*/((((T46*)((T46*)(oBC19run_control))))->_output_name)=(a1);
/*]*/
r39no_split_mode_command((T39*)(oBC17system_tools),oBC17command,_c_name);
r34put_string((T34*)(oBC1std_output),oBC17command);
/*[IRF3.6put_character*/{T34* C1=(T34*)(oBC1std_output);
T3 b1=((T3)'\n');
putc(b1,((FILE*)(stdout)));
}/*]*/
r37call_system((T37*)(oBC19echo),oBC17command);
r17move_executable_for(C,a1);
}


void r17set_bin_path(T17* C){
(/*SFN*/C->_bin_path)=r7twin((T7*)((/*RF2*/(C)->_installation_path/*6*/)));
{T36 se_tmp0;
r36compute_subdirectory_with(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_path/*30*/),((T0*)ms17_3085));
}
{T36 se_tmp0;
(/*SFN*/C->_bin_path)=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp0;
r36connect_to(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_path/*30*/));
}
{T36 se_tmp1;
T36 se_tmp0;
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*39*/))._directory_stream/*0*/))/*)*/){
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r36disconnect(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
}
 else if(r36create_new_directory(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_path/*30*/))){
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_923558719));
}
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_bin_path/*30*/));
}
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_444078490));
}
}
else{
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_923558719a));
}
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37put_string((T37*)(oBC19echo),(/*RF2*/(C)->_bin_path/*30*/));
}
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1680762272));
}
}
/*FI]*/
}
}
T0*oBC17no_split_command_list=NULL;


void r17set_compiler_se_path(T17* C){
T0* _path=NULL;
_path=r7twin((T7*)((/*RF2*/(C)->_installation_path/*6*/)));
{T36 se_tmp0;
r36compute_subdirectory_with(&((/*RF2*/(C)->_basic_directory/*39*/)),_path,((T0*)ms17_3595a));
}
{T36 se_tmp0;
_path=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp0;
r36compute_file_path_with(&((/*RF2*/(C)->_basic_directory/*39*/)),_path,((T0*)ms17_1236979201));
}
{T36 se_tmp0;
(/*SFN*/C->_compiler_se_path)=r7twin((T7*)(oBC36last_entry));
}
}


void r17split_mode_c_compile(T17* C,T0* a1){
T2 _max=0;
T0* _c_name=NULL;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1977034835));
r37put_string((T37*)(oBC19echo),a1);
r37put_string((T37*)(oBC19echo),((T0*)ms17_1583821555));
/*[IRF3.3set_output_name*/((((T46*)((T46*)(oBC19run_control))))->_output_name)=(a1);
/*]*/
{T36 se_tmp0;
r36connect_to_current_working_directory(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
{T36 se_tmp0;
/*[IF*/
if(!(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/((/*RF2*/(C)->_basic_directory/*39*/))._directory_stream/*0*/))/*)*/)){
{T36 se_tmp0;
/*[IRF3.2fatal_problem_description_start*/{T36 se_tmp0;
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
}
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_835722674));
}
{T36 se_tmp0;
r17fatal_problem_description_end(C);
}
}
/*FI]*/
}
{T36 se_tmp0;
r36read_entry(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
{T36 se_tmp0;
while (!(/*(IRF4.6end_of_input*/r8is_null(((T8)((/*RF2*/((/*RF2*/(C)->_basic_directory/*39*/))._current_entry/*4*/))))/*)*/))
{
{T36 se_tmp1;
T36 se_tmp0;
_c_name=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp1;
T36 se_tmp0;
/*[IF*/
if(!(r7has_prefix(((T7*)_c_name),a1))){
}
 else if(!(r7has_suffix(((T7*)_c_name),((T0*)ms17_329)))){
}
else{
{T36 se_tmp1;
T36 se_tmp0;
_max=(_max)+(1);
}
{T36 se_tmp1;
T36 se_tmp0;
r39split_mode_c_compiler_command((T39*)(oBC17system_tools),oBC17command,_c_name);
}
{T36 se_tmp1;
T36 se_tmp0;
r34put_string((T34*)(oBC1std_output),oBC17command);
}
{T36 se_tmp1;
T36 se_tmp0;
r34put_string((T34*)(oBC1std_output),((T0*)ms17_10aaa));
}
{T36 se_tmp1;
T36 se_tmp0;
r37call_system((T37*)(oBC19echo),oBC17command);
}
}
/*FI]*/
}
{T36 se_tmp2;
T36 se_tmp1;
T36 se_tmp0;
r36read_entry(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
}
}
{T36 se_tmp0;
r36disconnect(&((/*RF2*/(C)->_basic_directory/*39*/)));
}
r39split_mode_linker_command((T39*)(oBC17system_tools),oBC17command,a1,_max);
r34put_string((T34*)(oBC1std_output),oBC17command);
r34put_string((T34*)(oBC1std_output),((T0*)ms17_10aa));
r37call_system((T37*)(oBC19echo),oBC17command);
r17move_executable_for(C,a1);
}


void r17echo_usage_exit(T17* C){
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_11318747));
r37put_string((T37*)(oBC19echo),((T0*)ms17_2073823));
r37put_string((T37*)(oBC19echo),((T0*)ms17_936442223));
r17restore_current_working_directory(C);
exit(1);
}


void r17write_default_loadpath_se_file(T17* C){
T2 _i=0;
T0* _list=NULL;
T0* _directory=NULL;
T0* _path=NULL;
r37put_string((T37*)(oBC19echo),((T0*)ms17_922420739));
_path=r7twin((T7*)((/*RF2*/(C)->_installation_path/*6*/)));
{T36 se_tmp0;
r36compute_subdirectory_with(&((/*RF2*/(C)->_basic_directory/*39*/)),_path,((T0*)ms17_3595aa));
}
{T36 se_tmp0;
/*[IF*/
if(/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/){
{T36 se_tmp0;
/*[IRF3.2fatal_problem_description_start*/{T36 se_tmp0;
/*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
}
/*]*/
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_415268032));
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),_path);
}
{T36 se_tmp0;
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090aaaaaaaaa));
}
{T36 se_tmp0;
r17fatal_problem_description_end(C);
}
}
/*FI]*/
}
{T36 se_tmp0;
r7copy(((T7*)_path),oBC36last_entry);
}
{T36 se_tmp0;
r36compute_file_path_with(&((/*RF2*/(C)->_basic_directory/*39*/)),_path,((T0*)ms17_52773091));
}
{T36 se_tmp0;
r7copy(((T7*)_path),oBC36last_entry);
}
r7append(((T7*)_path),(/*RF2*/(C)->_system_name/*10*/));
r37sfw_connect((T37*)(oBC19echo),oBC17sfw,_path);
r17sfw_check_is_connected(C,_path);
r37put_string((T37*)(oBC19echo),((T0*)ms17_1366827671));
/*[IF*/
if(r7is_equal(ms17_13028aaa,(/*RF2*/(C)->_system_name/*10*/))){
_directory=((T0*)ms17_1395);
}
 else if(r7is_equal(ms17_2178a,(/*RF2*/(C)->_system_name/*10*/))){
_directory=((T0*)ms17_1620);
}
 else if(r7is_equal(ms17_1772235aaa,(/*RF2*/(C)->_system_name/*10*/))){
_directory=((T0*)ms17_1620a);
}
 else if(r7is_equal(ms17_11253a,(/*RF2*/(C)->_system_name/*10*/))){
_directory=((T0*)ms17_1395a);
}
 else if(r7is_equal(ms17_39617954a,(/*RF2*/(C)->_system_name/*10*/))){
_directory=((T0*)ms17_300);
}
 else if(r7is_equal(ms17_2618a,(/*RF2*/(C)->_system_name/*10*/))){
_directory=NULL;
}
 else if(r7is_equal(ms17_2440a,(/*RF2*/(C)->_system_name/*10*/))){
_directory=NULL;
}
 else if(r7is_equal(ms17_57487a,(/*RF2*/(C)->_system_name/*10*/))){
_directory=((T0*)ms17_10aaaaa);
}
/*FI]*/
/*[IF*/
if((_directory)!=((void*)(NULL))){
r37put_string((T37*)(oBC19echo),_directory);
r51put_string((T51*)(oBC17sfw),_directory);
}
/*FI]*/
_list=se_ma44(6,
((T0*)ms17_2092305),
((T0*)ms17_2052172647),
((T0*)ms17_261527539),
((T0*)ms17_261527319),
((T0*)ms17_10461399),
((T0*)ms17_418426));
_i=1;
while (!((_i)>((/*RF2*/(((T44*)_list))->_upper/*12*/))))
{
_directory=r7twin((T7*)((/*RF2*/(C)->_installation_path/*6*/)));
{T36 se_tmp0;
r36compute_subdirectory_with(&((/*RF2*/(C)->_basic_directory/*39*/)),_directory,r44item(((T44*)_list),_i));
}
{T36 se_tmp0;
r7copy(((T7*)_directory),oBC36last_entry);
}
/*[IF*/
if((_i)<((/*RF2*/(((T44*)_list))->_upper/*12*/))){
r7extend(((T7*)_directory),((T3)'\n'));
}
/*FI]*/
r37put_string((T37*)(oBC19echo),_directory);
r51put_string((T51*)(oBC17sfw),_directory);
_i=(_i)+(1);
}
r37put_string((T37*)(oBC19echo),((T0*)ms17_1472591913));
r51disconnect((T51*)(oBC17sfw));
r37put_string((T37*)(oBC19echo),((T0*)ms17_1097633494a));
r37put_string((T37*)(oBC19echo),_path);
r37put_string((T37*)(oBC19echo),((T0*)ms17_499966698));
}


T0* r17argument(T2 a1){
T0* R=NULL;
R=/*(IRF4.6item*/((/*RF2*/((T54*)(r17command_arguments()))->_storage/*4*/))[a1]/*)*/;
return R;
}


void r17move_executable_for(T17* C,T0* a1){
T0* _new_path=NULL;
T0* _old_path=NULL;
T0* _executable=NULL;
_executable=r7twin(((T7*)a1));
r39add_x_suffix((T39*)(oBC17system_tools),_executable);
{T36 se_tmp0;
r36compute_file_path_with(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_c_path/*34*/),_executable);
}
{T36 se_tmp0;
_old_path=r7twin((T7*)(oBC36last_entry));
}
{T36 se_tmp0;
r36compute_file_path_with(&((/*RF2*/(C)->_basic_directory/*39*/)),(/*RF2*/(C)->_bin_path/*30*/),_executable);
}
{T36 se_tmp0;
_new_path=r7twin((T7*)(oBC36last_entry));
}
/*[IF*/
if(!(r17file_exists(_old_path))){
/*[IRF3.2fatal_problem_description_start*//*[IRF3.3set_verbose*/((((T37*)((T37*)(oBC19echo))))->_verbose)=(1);
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_424217529));
/*]*/
r37put_string((T37*)(oBC19echo),((T0*)ms17_1784783943));
r37put_string((T37*)(oBC19echo),_old_path);
r37put_string((T37*)(oBC19echo),((T0*)ms17_1090a));
r17fatal_problem_description_end(C);
}
/*FI]*/
r37file_renaming((T37*)(oBC19echo),_old_path,_new_path);
}


T0* r17choice_in(T0* a1,T0* a2){
T0* R=NULL;
T0* _n=NULL;
T0* _w=NULL;
T2 _i=0;
while (!((R)!=((void*)(NULL))))
{
r34put_string((T34*)(oBC1std_output),a1);
r34put_string((T34*)(oBC1std_output),((T0*)ms17_7692));
_i=1;
while (!((_i)>((/*RF2*/(((T44*)a2))->_upper/*12*/))))
{
r34put_string((T34*)(oBC1std_output),r44item(((T44*)a2),_i));
_i=(_i)+(1);
/*[IF*/
if((_i)<=((/*RF2*/(((T44*)a2))->_upper/*12*/))){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_252));
}
/*FI]*/
}
r34put_string((T34*)(oBC1std_output),((T0*)ms17_597));
/*[IRF3.6flush*/{T34* C1=(T34*)(oBC1std_output);
fflush(stdout);
}/*]*/
r31read_word((T31*)(oBC1std_input));
_i=(/*RF2*/(((T44*)a2))->_lower/*16*/);
_w=r7twin((T7*)(oBC32last_string));
r7to_lower(((T7*)_w));
while (!((_i)>((/*RF2*/(((T44*)a2))->_upper/*12*/))))
{
_n=r7twin((T7*)(r44item(((T44*)a2),_i)));
r7to_lower(((T7*)_n));
/*[IF*/
if(r7is_equal(((T7*)_w),_n)){
R=r44item(((T44*)a2),_i);
_i=(/*RF2*/(((T44*)a2))->_upper/*12*/);
}
 else if(r7has_prefix(((T7*)_n),_w)){
/*[IF*/
if((R)!=((void*)(NULL))){
R=NULL;
}
else{
R=r44item(((T44*)a2),_i);
}
/*FI]*/
}
/*FI]*/
_i=(_i)+(1);
}
/*[IF*/
if((R)==((void*)(NULL))){
r34put_string((T34*)(oBC1std_output),((T0*)ms17_34));
r34put_string((T34*)(oBC1std_output),_w);
r34put_string((T34*)(oBC1std_output),((T0*)ms17_1887845192));
}
/*FI]*/
}
r34put_string((T34*)(oBC1std_output),((T0*)ms17_274475447));
r34put_string((T34*)(oBC1std_output),R);
r34put_string((T34*)(oBC1std_output),((T0*)ms17_10aaaa));
return R;
}


void r36connect_to_current_working_directory(T36* C){
T8 _path=NULL;
_path=basic_directory_current_working_directory();
/*[IF*/
if((NULL!=_path)){
r7from_external_copy((T7*)(oBC36last_entry),_path);
(/*SFN*/C->_directory_stream)=basic_directory_open(_path);
(/*SFN*/C->_current_entry)=(/*RF2*/(*C)._directory_stream/*0*/);
/*[IF*/
if(r8is_null((/*RF2*/(*C)._directory_stream/*0*/))){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}


void r36disconnect(T36* C){
T8 _null=NULL;
/*[IF*/
if(basic_directory_close((/*RF2*/(*C)._directory_stream/*0*/))){
(/*SFN*/C->_directory_stream)=_null;
(/*SFN*/C->_current_entry)=_null;
}
/*FI]*/
}


void r36compute_subdirectory_with(T36* C,T0* a1,T0* a2){
r7copy((T7*)(oBC36last_entry),a1);
/*[IF*/
if(r36unix_like_notation()){
/*[IF*/
if(r7is_equal(ms36_46,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
 else if(r7is_equal(ms36_276,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
else{
r7extend_unless((T7*)(oBC36last_entry),((T3)'\57'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC36last_entry),a2);
r7extend_unless((T7*)(oBC36last_entry),((T3)'\57'));
}
/*FI]*/
}
 else if(r36windows_like_notation()){
/*[IF*/
if(r7is_equal(ms36_46a,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
 else if(r7is_equal(ms36_276a,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
else{
r7extend_unless((T7*)(oBC36last_entry),((T3)'\134'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\134'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC36last_entry),a2);
r7extend_unless((T7*)(oBC36last_entry),((T3)'\134'));
}
/*FI]*/
}
 else if(r36amiga_like_notation()){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC36last_entry));
switch(z1){
case 47:
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
break;
case 58:
break;
default:;
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)!=(((T3)'\57'))){
r7add_last((T7*)(oBC36last_entry),((T3)'\57'));
}
/*FI]*/
}
}/*INSPECT]*/
r7append((T7*)(oBC36last_entry),a2);
r7extend_unless((T7*)(oBC36last_entry),((T3)'\57'));
}
 else if(r36macintosh_like_notation()){
r7extend_unless((T7*)(oBC36last_entry),((T3)'\72'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC36last_entry),a2);
r7extend_unless((T7*)(oBC36last_entry),((T3)'\72'));
}
 else if(r36vms_like_notation()){
/*[IF*/
if(r7is_equal(ms36_548,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
 else if(r7is_equal(ms36_2593,a2)){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
else{
/*[INSPECT*/
{int z1=r7last((T7*)(oBC36last_entry));
switch(z1){
case 93:
r7remove_last((T7*)(oBC36last_entry),1);
r7extend((T7*)(oBC36last_entry),((T3)'\56'));
break;
case 46:
break;
default:;
r7extend((T7*)(oBC36last_entry),((T3)'\56'));
}
}/*INSPECT]*/
r7append((T7*)(oBC36last_entry),a2);
/*[INSPECT*/
{int z1=r7last((T7*)(oBC36last_entry));
switch(z1){
case 93:
break;
case 46:
r7remove_last((T7*)(oBC36last_entry),1);
r7extend((T7*)(oBC36last_entry),((T3)'\135'));
break;
default:;
r7extend((T7*)(oBC36last_entry),((T3)'\135'));
}
}/*INSPECT]*/
}
/*FI]*/
}
 else if(r36system_notation_detected()){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
else{
r36try_to_compute_notation(a1);
/*[IF*/
if(r36system_notation_detected()){
r36compute_subdirectory_with(C,a1,a2);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}
/*FI]*/
}


T6 r36file_exists(T0* a1){
T6 R=0;
R=r38is_readable(a1);
return R;
}


T6 r36vms_like_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'V'));
return R;
}


T6 r36system_notation_detected(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[0]/*)*/)!=(((T3)'\77'));
return R;
}


T6 r36unix_like_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'U'));
return R;
}
T0*oBC36last_entry=NULL;


T6 r36macintosh_like_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'M'));
return R;
}


void r36compute_parent_directory_of(T36* C,T0* a1){
r7copy((T7*)(oBC36last_entry),a1);
/*[IF*/
if(r36unix_like_notation()){
/*[IF*/
if(((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))>(0)){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC36last_entry)))==(((T3)'\57')))))
{
r7remove_last((T7*)(oBC36last_entry),1);
}
}
 else if(r36windows_like_notation()){
/*[IF*/
if(((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))>(0)){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC36last_entry)))==(((T3)'\134')))))
{
r7remove_last((T7*)(oBC36last_entry),1);
}
}
 else if(r36amiga_like_notation()){
/*[IF*/
if((r7last((T7*)(oBC36last_entry)))!=(((T3)'\72'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
while (!(((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC36last_entry)))==(((T3)'\57'))))||((r7last((T7*)(oBC36last_entry)))==(((T3)'\72')))))
{
r7remove_last((T7*)(oBC36last_entry),1);
}
}
 else if(r36macintosh_like_notation()){
/*[IF*/
if((r7last((T7*)(oBC36last_entry)))==(((T3)'\72'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
while (!((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC36last_entry)))==(((T3)'\72')))))
{
r7remove_last((T7*)(oBC36last_entry),1);
}
}
 else if(r36vms_like_notation()){
/*[IF*/
if((r7last((T7*)(oBC36last_entry)))==(((T3)'\135'))){
r7remove_last((T7*)(oBC36last_entry),1);
while (!(((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC36last_entry)))==(((T3)'\56'))))||((r7last((T7*)(oBC36last_entry)))==(((T3)'\133')))))
{
r7remove_last((T7*)(oBC36last_entry),1);
}
/*[IF*/
if(((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))>(0)){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC36last_entry));
switch(z1){
case 46:
r7remove_last((T7*)(oBC36last_entry),1);
r7extend((T7*)(oBC36last_entry),((T3)'\135'));
break;
default:;
/*[IF*/
if(((/*RF2*/(((T7*)a1))->_count/*4*/))>(2)){
r7extend((T7*)(oBC36last_entry),((T3)'\135'));
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}
}/*INSPECT]*/
}
/*FI]*/
}
else{
r7remove_last((T7*)(oBC36last_entry),1);
while (!(((/*(IRF4.7is_empty*/((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))==(0)/*)*/)||((r7last((T7*)(oBC36last_entry)))==(((T3)'\56'))))||((r7last((T7*)(oBC36last_entry)))==(((T3)'\135')))))
{
r7remove_last((T7*)(oBC36last_entry),1);
}
/*[IF*/
if(((/*RF2*/((T7*)(oBC36last_entry))->_count/*4*/))>(0)){
r7remove_last((T7*)(oBC36last_entry),1);
r7extend((T7*)(oBC36last_entry),((T3)'\135'));
}
/*FI]*/
}
/*FI]*/
}
 else if(r36system_notation_detected()){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
else{
r36try_to_compute_notation(a1);
/*[IF*/
if(r36system_notation_detected()){
r36compute_parent_directory_of(C,a1);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}
/*FI]*/
}


void r36change_current_working_directory(T36* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
/*[IF*/
if(basic_directory_chdir(_p)){
r36connect_to_current_working_directory(C);
/*[IF*/
if(/*(IRF4.6is_connected*/(NULL!=(/*RF2*/(*C)._directory_stream/*0*/))/*)*/){
r36disconnect(C);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}


T6 r36windows_like_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'W'));
return R;
}


void r36read_entry(T36* C){
T8 _name=NULL;
(/*SFN*/C->_current_entry)=basic_directory_read_entry((/*RF2*/(*C)._directory_stream/*0*/));
/*[IF*/
if((NULL!=(/*RF2*/(*C)._current_entry/*4*/))){
_name=basic_directory_get_entry_name((/*RF2*/(*C)._current_entry/*4*/));
r7from_external_copy((T7*)(oBC36last_entry),_name);
}
/*FI]*/
}


void r36try_to_compute_notation(T0* a1){
/*[IF*/
if(r36file_exists(a1)){
/*[IF*/
if(r7has(((T7*)a1),((T3)'\57'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'U'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\134'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'W'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\72'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'M'));
/*]*/
}
 else if(r7has(((T7*)a1),((T3)'\133'))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'V'));
/*]*/
}
else{
/*[IRF3.2last_attempt_to_compute_notation*//*[IF*/
if(r36file_exists(((T0*)ms36_1457010570))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'A'));
/*]*/
}
 else if(r36file_exists(((T0*)ms36_1121830))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'U'));
/*]*/
}
 else if(r36file_exists(((T0*)ms36_403016243))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'W'));
/*]*/
}
/*FI]*/
/*]*/
}
/*FI]*/
}
else{
/*[IRF3.2last_attempt_to_compute_notation*//*[IF*/
if(r36file_exists(((T0*)ms36_1457010570))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'A'));
/*]*/
}
 else if(r36file_exists(((T0*)ms36_1121830))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'U'));
/*]*/
}
 else if(r36file_exists(((T0*)ms36_403016243))){
/*[IRF3.5put*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[(1)-(1)]=(((T3)'W'));
/*]*/
}
/*FI]*/
/*]*/
}
/*FI]*/
}


T6 r36amiga_like_notation(void){
T6 R=0;
R=(/*(IRF4.6first*/((/*RF2*/((T7*)(((T0*)ms36_63)))->_storage/*0*/))[0]/*)*/)==(((T3)'A'));
return R;
}


void r36connect_to(T36* C,T0* a1){
T8 _path_pointer=NULL;
_path_pointer=r7to_external(((T7*)a1));
(/*SFN*/C->_directory_stream)=basic_directory_open(_path_pointer);
(/*SFN*/C->_current_entry)=(/*RF2*/(*C)._directory_stream/*0*/);
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}


T6 r36create_new_directory(T36* C,T0* a1){
T6 R=0;
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
R=basic_directory_mkdir(_p);
return R;
}


void r36compute_file_path_with(T36* C,T0* a1,T0* a2){
r7copy((T7*)(oBC36last_entry),a1);
/*[IF*/
if(r36unix_like_notation()){
r7extend_unless((T7*)(oBC36last_entry),((T3)'\57'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC36last_entry),a2);
}
 else if(r36windows_like_notation()){
r7extend_unless((T7*)(oBC36last_entry),((T3)'\134'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\134'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC36last_entry),a2);
}
 else if(r36amiga_like_notation()){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC36last_entry));
switch(z1){
case 58:
break;
case 47:
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\57'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
break;
default:;
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)!=(((T3)'\57'))){
r7extend((T7*)(oBC36last_entry),((T3)'\57'));
}
/*FI]*/
}
}/*INSPECT]*/
r7append((T7*)(oBC36last_entry),a2);
}
 else if(r36macintosh_like_notation()){
r7extend_unless((T7*)(oBC36last_entry),((T3)'\72'));
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\72'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC36last_entry),a2);
}
 else if(r36vms_like_notation()){
/*[INSPECT*/
{int z1=r7last((T7*)(oBC36last_entry));
switch(z1){
case 93:
break;
case 46:
r7remove_last((T7*)(oBC36last_entry),1);
r7extend((T7*)(oBC36last_entry),((T3)'\135'));
break;
default:;
r7extend((T7*)(oBC36last_entry),((T3)'\135'));
}
}/*INSPECT]*/
/*[IF*/
if((/*(IRF4.6first*/((/*RF2*/(((T7*)a2))->_storage/*0*/))[0]/*)*/)==(((T3)'\135'))){
r7remove_last((T7*)(oBC36last_entry),1);
}
/*FI]*/
r7append((T7*)(oBC36last_entry),a2);
}
 else if(r36system_notation_detected()){
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
else{
r36try_to_compute_notation(a1);
/*[IF*/
if(r36system_notation_detected()){
r36compute_file_path_with(C,a1,a2);
}
else{
/*[IRF3.3clear*/((((T7*)((T7*)(oBC36last_entry))))->_count)=(0);
/*]*/
}
/*FI]*/
}
/*FI]*/
}
T17*eiffel_root_object=NULL;
int se_argc;
char**se_argv;
T7* g[55];
T7* t[55];


void initialize_eiffel_runtime(int argc,char*argv[]){
se_argc=argc;
se_argv=argv;
g[30]=se_string("SAFE_EQUAL");
g[35]=se_string("OUTPUT_STREAM");
g[22]=se_string("PLATFORM");
g[2]=se_string("INTEGER");
g[7]=se_string("STRING");
g[23]=se_string("COMPARABLE");
g[51]=se_string("STD_FILE_WRITE");
g[25]=se_string("INTEGER_REF");
g[10]=se_string("ANY");
g[53]=se_string("FIXED_ARRAY");
g[34]=se_string("STD_OUTPUT");
g[26]=se_string("NUMERIC");
g[36]=se_string("BASIC_DIRECTORY");
g[21]=se_string("ALIASED_STRING_LIST");
g[1]=se_string("GENERAL");
g[49]=se_string("STD_ERROR");
g[46]=se_string("RUN_CONTROL");
g[41]=se_string("ARRAY");
g[18]=se_string("COMMAND_FLAGS");
g[38]=se_string("FILE_TOOLS");
g[19]=se_string("GLOBALS");
g[24]=se_string("HASHABLE");
g[33]=se_string("POINTER_REF");
g[8]=se_string("POINTER");
g[39]=se_string("SYSTEM_TOOLS");
g[29]=se_string("NATIVE_ARRAY");
g[20]=se_string("FROZEN_STRING_LIST");
g[43]=se_string("COLLECTION");
g[31]=se_string("STD_INPUT");
g[28]=se_string("CHARACTER_REF");
g[3]=se_string("CHARACTER");
g[32]=se_string("INPUT_STREAM");
g[6]=se_string("BOOLEAN");
g[40]=se_string("STD_FILE_READ");
g[0]=se_string("NONE");
g[27]=se_string("BOOLEAN_REF");
g[37]=se_string("ECHO");
g[52]=se_string("SMALL_EIFFEL");
g[17]=se_string("INSTALL");
g[42]=se_string("ARRAYED_COLLECTION");
g[54]=g[53];
g[45]=g[29];
g[9]=g[29];
g[44]=g[41];
t[8]=g[8];
t[38]=g[38];
t[6]=g[6];
t[3]=g[3];
t[51]=g[51];
t[31]=g[31];
t[17]=g[17];
t[54]=se_string("FIXED_ARRAY[STRING]");
t[37]=g[37];
t[45]=se_string("NATIVE_ARRAY[STRING]");
t[39]=g[39];
t[46]=g[46];
t[7]=g[7];
t[40]=g[40];
t[9]=se_string("NATIVE_ARRAY[CHARACTER]");
t[36]=g[36];
t[2]=g[2];
t[44]=se_string("ARRAY[STRING]");
t[52]=g[52];
t[34]=g[34];
t[49]=g[49];
#ifdef SIGINT
signal(SIGINT,sigrsp);
#endif
#ifdef SIGQUIT
signal(SIGQUIT,sigrsp);
#endif
#ifdef SIGTERM
signal(SIGTERM,sigrsp);
#endif
#ifdef SIGBREAK
signal(SIGBREAK,sigrsp);
#endif
#ifdef SIGKILL
signal(SIGKILL,sigrsp);
#endif
se_msi1();
/*PCO*/
{T52*n=((T52*)se_malloc(1));
oBC19small_eiffel=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
oBC39system_list=se_ma44(9,
((T0*)ms39_13028),
((T0*)ms39_1772235),
((T0*)ms39_11253),
((T0*)ms39_39617954),
((T0*)ms39_57487),
((T0*)ms39_2178),
((T0*)ms39_2440),
((T0*)ms39_2618),
((T0*)ms39_59731));
/*PCO*/
{T40*n=((T40*)se_malloc(sizeof(*n))/*13*/);
*n=M40;
oBC17sfr=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC32last_string=((T0*)n);
r7make(n,1024);
}
/*PCO*/
{T51*n=((T51*)se_malloc(sizeof(*n))/*8*/);
*n=M51;
oBC17sfw=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC19tmp_path=((T0*)n);
r7make(n,512);
}
/*PCO*/
{T40*n=((T40*)se_malloc(sizeof(*n))/*13*/);
*n=M40;
oBC19tmp_file_read=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T49*n=((T49*)se_malloc(1));
oBC1std_error=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T37*n=((T37*)se_malloc(sizeof(*n))/*1*/);
*n=M37;
oBC19echo=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
oBC39compiler_list=se_ma44(12,
((T0*)ms39_3169),
((T0*)ms39_51699930),
((T0*)ms39_594),
((T0*)ms39_448859),
((T0*)ms39_76405),
((T0*)ms39_382130),
((T0*)ms39_603),
((T0*)ms39_674),
((T0*)ms39_15721),
((T0*)ms39_17794),
((T0*)ms39_3069),
((T0*)ms39_18144));
/*PCO*/
{T46*n=((T46*)se_malloc(sizeof(*n))/*8*/);
*n=M46;
oBC19run_control=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC7tmp_string=((T0*)n);
r7make(n,256);
}
/*PCO*/
{T44*n=((T44*)se_malloc(sizeof(*n))/*20*/);
*n=M44;
oBC7split_buffer=((T0*)n);
r44with_capacity(n,4,1);
}
/*PCO*/
oBC17no_split_command_list=se_ma44(4,
((T0*)ms17_78495aa),
((T0*)ms17_1979141),
((T0*)ms17_401244),
((T0*)ms17_432336586));
/*PCO*/
oBC17splitted_command_list=se_ma44(4,
((T0*)ms17_1889925553aaaaa),
((T0*)ms17_88336),
((T0*)ms17_437476),
((T0*)ms17_3499443));
/*PCO*/
{T40*n=((T40*)se_malloc(sizeof(*n))/*13*/);
*n=M40;
oBC38std_fr1=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T39*n=((T39*)se_malloc(sizeof(*n))/*17*/);
*n=M39;
oBC17system_tools=((T0*)n);
/*[IRF3.1install*//*]*/
}
/*PCO*/
{T34*n=((T34*)se_malloc(1));
oBC1std_output=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC17command=((T0*)n);
r7make(n,512);
}
/*PCO*/
{T7*n=((T7*)se_malloc(sizeof(*n))/*12*/);
*n=M7;
oBC36last_entry=((T0*)n);
r7make(n,256);
}
/*PCO*/
{T31*n=((T31*)se_malloc(sizeof(*n))/*5*/);
*n=M31;
oBC1std_input=((T0*)n);
/*[IRF3.1make*//*]*/
}
/*PCO*/
eiffel_root_object=((T17*)se_malloc(sizeof(*eiffel_root_object))/*51*/);
*eiffel_root_object=M17;
}
int main(int argc,char*argv[]){
initialize_eiffel_runtime(argc,argv);
{T17*n=eiffel_root_object;
r17make(n);
}
exit(0);
return 0;}
T7*ms39_581585530;
T7*ms17_1014578011;
T7*ms39_12782;
T7*ms17_1711985232;
T7*ms17_274475447;
T7*ms37_1680762272;
T7*ms17_51699930aa;
T7*ms20_216;
T7*ms17_762404314;
T7*ms17_57487;
T7*ms17_1891780586;
T7*ms17_3595aa;
T7*ms36_46;
T7*ms36_63;
T7*ms17_1753448889;
T7*ms17_78495aa;
T7*ms17_1816967047;
T7*ms17_219216;
T7*ms17_1889925553aaaaaaa;
T7*ms17_817978331;
T7*ms17_10461399;
T7*ms17_418426;
T7*ms17_218888;
T7*ms17_2093873910;
T7*ms39_15721;
T7*ms39_1570a;
T7*ms39_0aaaa;
T7*ms20_1090;
T7*ms17_1908435986;
T7*ms17_167987030;
T7*ms39_0a;
T7*ms17_1090;
T7*ms39_18144;
T7*ms17_1090aaaaaaaaa;
T7*ms17_1927398937;
T7*ms17_1395;
T7*ms39_17794;
T7*ms17_1661597104;
T7*ms17_2057;
T7*ms17_1620;
T7*ms39_1125006;
T7*ms17_1719;
T7*ms17_1816967047a;
T7*ms39_698995372;
T7*ms17_2178;
T7*ms20_3085;
T7*ms17_57487a;
T7*ms39_836475934;
T7*ms17_11253aa;
T7*ms17_2440;
T7*ms17_180a;
T7*ms17_2052172647;
T7*ms17_1772235a;
T7*ms17_1366827671;
T7*ms17_2618;
T7*ms17_10aa;
T7*ms17_3085;
T7*ms17_3169;
T7*ms37_136264778;
T7*ms17_39617954;
T7*ms20_3595;
T7*ms36_276;
T7*ms17_747883329;
T7*ms17_1889925553;
T7*ms17_1320038759;
T7*ms17_156524099;
T7*ms36_548;
T7*ms17_106668511a;
T7*ms17_329a;
T7*ms17_1090aaaaaa;
T7*ms36_46a;
T7*ms17_3595;
T7*ms17_817978331a;
T7*ms17_1457010570;
T7*ms37_1800535743;
T7*ms17_1097633494a;
T7*ms17_1188940911;
T7*ms17_1565343603;
T7*ms17_5515;
T7*ms39_1090;
T7*ms17_1090aaaaaaaaaaaaaaa;
T7*ms39_304aa;
T7*ms17_5712;
T7*ms39_1438;
T7*ms17_1324228360;
T7*ms17_51699930;
T7*ms17_1090aaaaaaaaaaaaaa;
T7*ms39_1570;
T7*ms39_2178;
T7*ms39_1744;
T7*ms37_210141519;
T7*ms39_1774;
T7*ms39_228399374;
T7*ms17_1097633494aa;
T7*ms17_180;
T7*ms17_10a;
T7*ms17_300;
T7*ms17_252;
T7*ms39_2440;
T7*ms17_51699930a;
T7*ms17_329;
T7*ms39_2618;
T7*ms39_3069;
T7*ms39_3094;
T7*ms17_77699;
T7*ms17_1121830;
T7*ms39_3169;
T7*ms39_304a;
T7*ms17_614;
T7*ms17_424198040;
T7*ms17_1460571212;
T7*ms39_2833;
T7*ms17_597;
T7*ms17_78495a;
T7*ms39_3294;
T7*ms17_87473026;
T7*ms17_7692;
T7*ms17_437476;
T7*ms17_78495;
T7*ms39_340a;
T7*ms17_432336586;
T7*ms17_1926767382;
T7*ms17_870813064;
T7*ms17_1472591913;
T7*ms17_1097633494;
T7*ms39_98806116;
T7*ms17_1090aaaaaaaaaaaaa;
T7*ms17_1889925553aaaa;
T7*ms17_66309112;
T7*ms39_115188994;
T7*ms17_415268032;
T7*ms19_8897;
T7*ms39_1721407046;
T7*ms17_273256990;
T7*ms39_137550186;
T7*ms17_923558719a;
T7*ms17_1432574655;
T7*ms17_111984535;
T7*ms17_1392904185;
T7*ms17_52892944a;
T7*ms39_128214728;
T7*ms17_1529073275;
T7*ms39_1106932385;
T7*ms39_6687;
T7*ms17_1550993158;
T7*ms39_19761224;
T7*ms17_789957814;
T7*ms17_88336;
T7*ms36_1457010570;
T7*ms17_1744496991;
T7*ms17_2028227069;
T7*ms17_22597211;
T7*ms39_9121;
T7*ms39_0aaaaaa;
T7*ms17_13028aa;
T7*ms39_1570aa;
T7*ms17_50246554;
T7*ms17_0;
T7*ms17_1643948856;
T7*ms17_922420739;
T7*ms39_8976;
T7*ms17_1090aaaaaaaaaa;
T7*ms17_1889925553aaaaa;
T7*ms17_11318747;
T7*ms39_0aaaaa;
T7*ms17_47441125;
T7*ms17_1977034835;
T7*ms39_530877013;
T7*ms39_415107;
T7*ms17_1090aaaaaaaaaaa;
T7*ms17_1396646724;
T7*ms52_2140009595;
T7*ms39_0aaa;
T7*ms39_0;
T7*ms17_1998835793;
T7*ms17_11253a;
T7*ms37_1711985232;
T7*ms17_1613624149;
T7*ms19_329;
T7*ms39_860169684;
T7*ms39_1570aaa;
T7*ms17_1168848885;
T7*ms17_1978328933;
T7*ms39_304;
T7*ms39_324;
T7*ms39_326;
T7*ms39_218174;
T7*ms39_340;
T7*ms39_336;
T7*ms39_341;
T7*ms39_293;
T7*ms39_297;
T7*ms17_936442223;
T7*ms39_603;
T7*ms39_594;
T7*ms39_1236979201;
T7*ms17_56612951;
T7*ms39_674;
T7*ms39_689;
T7*ms39_426884100;
T7*ms17_414933715a;
T7*ms39_1102814319;
T7*ms39_223953;
T7*ms39_0aa;
T7*ms17_1090aa;
T7*ms17_11253;
T7*ms39_270309168;
T7*ms17_2030897129;
T7*ms17_12117a;
T7*ms17_2092305;
T7*ms17_10aaaa;
T7*ms17_1090a;
T7*ms17_596025978;
T7*ms17_12117;
T7*ms39_1631212670;
T7*ms39_0aaaaaaa;
T7*ms17_56806204;
T7*ms39_57487;
T7*ms17_13028aaa;
T7*ms39_968120;
T7*ms17_1784783943;
T7*ms17_825023736;
T7*ms17_13028;
T7*ms17_52773091;
T7*ms20_56612951;
T7*ms17_1772235aaaa;
T7*ms17_1979141;
T7*ms39_382130;
T7*ms39_1866433364;
T7*ms17_3554640a;
T7*ms17_392246664;
T7*ms39_59731;
T7*ms17_404024442;
T7*ms17_1395a;
T7*ms17_1236979201;
T7*ms17_39617954a;
T7*ms17_1102814319;
T7*ms17_13028a;
T7*ms17_1620a;
T7*ms39_721564652;
T7*ms39_2075119688;
T7*ms17_1680762272;
T7*ms17_499966698;
T7*ms17_1789524802;
T7*ms17_1772235aa;
T7*ms39_1772235;
T7*ms17_2178a;
T7*ms17_1889925553a;
T7*ms17_1889925553aaaaaa;
T7*ms17_57487aa;
T7*ms37_3556890;
T7*ms17_106668511;
T7*ms17_1090aaaaa;
T7*ms17_2073823;
T7*ms17_896093333;
T7*ms17_2440a;
T7*ms17_1090aaaaaaa;
T7*ms17_180aa;
T7*ms39_76405;
T7*ms36_1121830;
T7*ms17_1772235;
T7*ms17_2618a;
T7*ms17_1308497832;
T7*ms39_679150617;
T7*ms17_10aaa;
T7*ms39_3498891;
T7*ms17_802100104;
T7*ms37_141444;
T7*ms36_2593;
T7*ms17_3169a;
T7*ms17_142550;
T7*ms36_276a;
T7*ms17_261527319;
T7*ms39_1826831355;
T7*ms37_1520107011;
T7*ms17_261527539;
T7*ms17_13028aaaa;
T7*ms17_1264449352;
T7*ms17_835722674;
T7*ms17_1887845192;
T7*ms37_44975894;
T7*ms39_467476687;
T7*ms17_38415354;
T7*ms17_3554640;
T7*ms39_447734;
T7*ms17_3499443;
T7*ms17_1118238740;
T7*ms20_1071750288;
T7*ms39_91157;
T7*ms17_1889925553aaa;
T7*ms36_403016243;
T7*ms37_27561173;
T7*ms17_10aaaaa;
T7*ms17_56806204a;
T7*ms39_39617954;
T7*ms17_1471850305;
T7*ms17_1042405932;
T7*ms39_0aaaaaaaa;
T7*ms17_52892944;
T7*ms17_1457509747;
T7*ms39_448859;
T7*ms17_1583821555;
T7*ms17_3595a;
T7*ms17_1378771941;
T7*ms17_401244;
T7*ms17_56806204aa;
T7*ms17_1090aaaaaaaa;
T7*ms39_1023953763;
T7*ms17_1090aaa;
T7*ms17_10;
T7*ms17_34;
T7*ms39_51699930;
T7*ms39_1570aaaaa;
T7*ms17_45411;
T7*ms17_1090aaaaaaaaaaaa;
T7*ms17_923558719;
T7*ms39_1570aaaa;
T7*ms20_300594;
T7*ms39_876917780;
T7*ms39_1494914262;
T7*ms17_2102329;
T7*ms37_210310269;
T7*ms17_414933715;
T7*ms17_1090aaaa;
T7*ms17_1772235aaa;
T7*ms17_176208679;
T7*ms17_1447048624;
T7*ms17_424217529;
T7*ms39_1091987;
T7*ms17_444078490;
T7*ms17_1889925553aa;
T7*ms39_11253;
T7*ms17_564929999;
T7*ms39_179868158;
T7*ms17_1472409390;
T7*ms17_1927443312;
T7*ms39_39204698;
T7*ms17_264638762;
T7*ms39_13028;
T7*ms39_1429938878;


T7*se_ms(int c,char*e){
/* Allocation of a Manifest STRING.*/
T7*s=((T7*)se_malloc(sizeof(T7)));
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}


T7*se_string(char*e){
/* Creation of an Eiffel STRING by copying C char*e */
int c=strlen(e);
T7*s;s=((T7*)se_malloc(sizeof(*s))/*12*/);
*s=M7;
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}


void se_msi1(void){
ms39_581585530=se_ms(36,"Hope this is a Windows like system.\n");
ms17_1014578011=se_ms(19,"-skip_c_compilation");
ms39_12782=se_ms(4,"Link");
ms17_1711985232=se_ms(19,"Cannot write file \"");
ms17_274475447=se_ms(10,"selected: ");
ms37_1680762272=se_ms(13,"\" not found.\n");
ms17_51699930aa=se_ms(9,"lcc-win32");
ms20_216=se_ms(2,"\".");
ms17_762404314=se_ms(64,"Enter now one single line for extra option(s) or an empty line:\n");
ms17_57487=se_ms(5,"Amiga");
ms17_1891780586=se_ms(56,"\".\nCheck this absolute path as well as read permission.\n");
ms17_3595aa=se_ms(3,"sys");
ms36_46=se_ms(1,".");
ms36_63=se_ms(1,"?");
ms17_1753448889=se_ms(17,"GC file path is \"");
ms17_78495aa=se_ms(5,"clean");
ms17_1816967047=se_ms(13,"\" and \"sys\".\n");
ms17_219216=se_ms(6,"-boost");
ms17_1889925553aaaaaaa=se_ms(12,"compile_to_c");
ms17_817978331=se_ms(17,"Selected GC for \"");
ms17_10461399=se_ms(8,"lib_show");
ms17_418426=se_ms(6,"lib_se");
ms17_218888=se_ms(6,"-debug");
ms17_2093873910=se_ms(29,"System seems to be an Amiga.\n");
ms39_15721=se_ms(4,"dice");
ms39_1570a=se_ms(3,"-O2");
ms39_0aaaa=se_ms(0,"");
ms20_1090=se_ms(3,"\".\n");
ms17_1908435986=se_ms(16,"C Compiling in \"");
ms17_167987030=se_ms(14,"m68k-amigaos.c");
ms39_0a=se_ms(0,"");
ms17_1090=se_ms(3,"\".\n");
ms39_18144=se_ms(4,"vpcc");
ms17_1090aaaaaaaaa=se_ms(3,"\".\n");
ms17_1927398937=se_ms(25,"System seems to be BeOS.\n");
ms17_1395=se_ms(3,"./\n");
ms39_17794=se_ms(4,"vbcc");
ms17_1661597104=se_ms(32,"   c_compiler_linker_options = \"");
ms17_2057=se_ms(3,"C:\\");
ms17_1620=se_ms(3,".\\\n");
ms39_1125006=se_ms(7,"-lmieee");
ms17_1719=se_ms(3,"-cc");
ms17_1816967047a=se_ms(13,"\" and \"sys\".\n");
ms39_698995372=se_ms(19,"SmallCode SmallData");
ms17_2178=se_ms(3,"DOS");
ms20_3085=se_ms(3,"bin");
ms17_57487a=se_ms(5,"Amiga");
ms39_836475934=se_ms(32,"-5 -w-aus -w-par -w-rvl -O2 -O-v");
ms17_11253aa=se_ms(4,"BeOS");
ms17_2440=se_ms(3,"OS2");
se_msi2();
}


void se_msi2(void){
ms17_180a=se_ms(2,"\"\n");
ms17_2052172647=se_ms(12,"lib_iterator");
ms17_1772235a=se_ms(7,"Windows");
ms17_1366827671=se_ms(21,"--- Written data ---\n");
ms17_2618=se_ms(3,"VMS");
ms17_10aa=se_ms(1,"\n");
ms17_3085=se_ms(3,"bin");
ms17_3169=se_ms(3,"gcc");
ms37_136264778=se_ms(21,"Reading one word in \"");
ms17_39617954=se_ms(9,"Macintosh");
ms20_3595=se_ms(3,"sys");
ms36_276=se_ms(2,"..");
ms17_747883329=se_ms(14,"MacintoshPPC.c");
ms17_1889925553=se_ms(12,"compile_to_c");
ms17_1320038759=se_ms(45,"Checking \"SmallEiffel\" environment variable:\n");
ms17_156524099=se_ms(48,"Checking that the SmallEiffel directory exists:\n");
ms36_548=se_ms(2,"[]");
ms17_106668511a=se_ms(40,"Unable to compute parent directory \nof \"");
ms17_329a=se_ms(2,".c");
ms17_1090aaaaaa=se_ms(3,"\".\n");
ms36_46a=se_ms(1,".");
ms17_3595=se_ms(3,"sys");
ms17_817978331a=se_ms(17,"Selected GC for \"");
ms17_1457010570=se_ms(18,"s:startup-sequence");
ms37_1800535743=se_ms(13,"System call \"");
ms17_1097633494a=se_ms(11,"Update of \"");
ms17_1188940911=se_ms(138,"Hint: It is possible to change some default option(s) for the C compiler\njust after the compiler name in the very first line of the\nfile \"");
ms17_1565343603=se_ms(62,"---\nSummary of gathered information :\n   installation_path = \"");
ms17_5515=se_ms(4,"\").\n");
ms39_1090=se_ms(3,"\".\n");
ms17_1090aaaaaaaaaaaaaaa=se_ms(3,"\".\n");
ms39_304aa=se_ms(2,"-O");
ms17_5712=se_ms(4," -o ");
ms39_1438=se_ms(3,".00");
ms17_1324228360=se_ms(40,"---\nSmallEiffel\'s bootstrap started ...\n");
ms17_51699930=se_ms(9,"lcc-win32");
ms17_1090aaaaaaaaaaaaaa=se_ms(3,"\".\n");
ms39_1570=se_ms(3,"-O2");
ms39_2178=se_ms(3,"DOS");
ms39_1744=se_ms(3,".cc");
ms37_210141519=se_ms(10,"Renaming \"");
ms39_1774=se_ms(3,"-lm");
ms39_228399374=se_ms(41," : unknown compiler name after -cc flag.\n");
ms17_1097633494aa=se_ms(11,"Update of \"");
ms17_180=se_ms(2,"\"\n");
ms17_10a=se_ms(1,"\n");
ms17_300=se_ms(2,":\n");
ms17_252=se_ms(2,", ");
ms39_2440=se_ms(3,"OS2");
ms17_51699930a=se_ms(9,"lcc-win32");
se_msi3();
}


void se_msi3(void){
ms17_329=se_ms(2,".c");
ms39_2618=se_ms(3,"VMS");
ms39_3069=se_ms(3,"ccc");
ms39_3094=se_ms(3,"dcc");
ms17_77699=se_ms(5,"bin_c");
ms17_1121830=se_ms(7,"/bin/ls");
ms39_3169=se_ms(3,"gcc");
ms39_304a=se_ms(2,"-O");
ms17_614=se_ms(2,"gc");
ms17_424198040=se_ms(298,"Please, set this variable with the absolute path of\nthe \"SmallEiffel/sys/system.se\" file.\nFor example, on Linux, the value is\noften \"/usr/lib/SmallEiffel/sys/system.se\".\nOn Windows, \"C:\\SmallEiffel\\sys\\system.se\" is a correct value\nwhen the SmallEiffel directory is at toplevel of the C hard disk.\n");
ms17_1460571212=se_ms(24,"\"\n   c_compiler_name = \"");
ms39_2833=se_ms(3,"g++");
ms17_597=se_ms(3,"\n? ");
ms17_78495a=se_ms(5,"clean");
ms39_3294=se_ms(3,"lcc");
ms17_87473026=se_ms(16,"compile_to_c.bat");
ms17_7692=se_ms(4,":\n  ");
ms17_437476=se_ms(6,"pretty");
ms17_78495=se_ms(5,"clean");
ms39_340a=se_ms(2,"-s");
ms17_432336586=se_ms(15,"print_jvm_class");
ms17_1926767382=se_ms(23,"System name detection:\n");
ms17_870813064=se_ms(129,"***************************************************************\nFix the previously described problem and launch again `install\'.\n");
ms17_1472591913=se_ms(22,"\n--- Written data ---\n");
ms17_1097633494=se_ms(11,"Update of \"");
ms39_98806116=se_ms(10," Data=Auto");
ms17_1090aaaaaaaaaaaaa=se_ms(3,"\".\n");
ms17_1889925553aaaa=se_ms(12,"compile_to_c");
ms17_66309112=se_ms(31,"SmallEiffel installation done.\n");
ms39_115188994=se_ms(34,"/usr/lib/SmallEiffel/sys/system.se");
ms17_415268032=se_ms(41,"Unable to compute subdirectory \"sys\" of \"");
ms19_8897=se_ms(4,".cpp");
ms39_1721407046=se_ms(34,"Math=IEEE Parameters=Both Code=Far");
ms17_273256990=se_ms(56,"Type <Enter> to continue installation.\nType <Enter> now ");
ms39_137550186=se_ms(21,"-O2 -nologo -D\"WIN32\"");
ms17_923558719a=se_ms(11,"Directory \"");
ms17_1432574655=se_ms(15,"Try to update \"");
ms17_111984535=se_ms(32,"Install of SmallEiffel started.\n");
ms17_1392904185=se_ms(30,"\".\nThere is no readable file \"");
ms17_52892944a=se_ms(13,"-boost -no_gc");
ms39_128214728=se_ms(27,"Hope this is a VMS system.\n");
ms17_1529073275=se_ms(18,"Launching script \"");
ms39_1106932385=se_ms(13,"Last chance.\n");
ms39_6687=se_ms(4," To ");
ms17_1550993158=se_ms(24,"   garbage_collector = \"");
ms39_19761224=se_ms(9," Data=Far");
ms17_789957814=se_ms(24,"Computing GC file path:\n");
ms17_88336=se_ms(5,"short");
ms36_1457010570=se_ms(18,"s:startup-sequence");
ms17_1744496991=se_ms(23,"-boost -no_split -no_gc");
se_msi4();
}


void se_msi4(void){
ms17_2028227069=se_ms(27,"\".\nCheck write permissions.");
ms17_22597211=se_ms(20,"C compiler selection");
ms39_9121=se_ms(4,".obj");
ms39_0aaaaaa=se_ms(0,"");
ms17_13028aa=se_ms(4,"UNIX");
ms39_1570aa=se_ms(3,"-O2");
ms17_50246554=se_ms(9,"generic.c");
ms17_0=se_ms(0,"");
ms17_1643948856=se_ms(44,"compiler name must be specified after \"-cc\"\n");
ms17_922420739=se_ms(34,"Writing default loadpath.se file:\n");
ms39_8976=se_ms(4,".exe");
ms17_1090aaaaaaaaaa=se_ms(3,"\".\n");
ms17_1889925553aaaaa=se_ms(12,"compile_to_c");
ms17_11318747=se_ms(8,"usage : ");
ms39_0aaaaa=se_ms(0,"");
ms17_47441125=se_ms(44,"In order to reset \"compile_to_c\" -no_gc in \"");
ms17_1977034835=se_ms(13,"C compiling \"");
ms39_530877013=se_ms(11," StripDebug");
ms39_415107=se_ms(6,"lcclnk");
ms17_1090aaaaaaaaaaa=se_ms(3,"\".\n");
ms17_1396646724=se_ms(48,"Unable to change current working directory \nto \"");
ms52_2140009595=se_ms(225,"SmallEiffel The GNU Eiffel Compiler\nRelease -0.76 (Saturday 11th november 2000)\nCopyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE\nDominique COLNET and Suzanne COLLIN - colnet@loria.fr\nhttp://SmallEiffel.loria.fr\n");
ms39_0aaa=se_ms(0,"");
ms39_0=se_ms(0,"");
ms17_1998835793=se_ms(90,"-----\nIt is possible to add some default option(s) to be passed\nto the C compiler/linker.\n");
ms17_11253a=se_ms(4,"BeOS");
ms37_1711985232=se_ms(19,"Cannot write file \"");
ms17_1613624149=se_ms(22,"Do not forget to add \"");
ms19_329=se_ms(2,".c");
ms39_860169684=se_ms(74,"System environment variable \"SmallEiffel\" not set.\nTrying default value: \"");
ms39_1570aaa=se_ms(3,"-O2");
ms17_1168848885=se_ms(23,"\".\nTry to update file \"");
ms17_1978328933=se_ms(16,"-boost -no_split");
ms39_304=se_ms(2,"-O");
ms39_324=se_ms(2,"-c");
ms39_326=se_ms(2,"-e");
ms39_218174=se_ms(6,"-s -d1");
ms39_340=se_ms(2,"-s");
ms39_336=se_ms(2,"-o");
ms39_341=se_ms(2,".o");
ms39_293=se_ms(2,"/:");
ms39_297=se_ms(2,".C");
ms17_936442223=se_ms(60," [-interactive] [-skip_c_compilation] [-cc <name>] [-debug]\n");
ms39_603=se_ms(2,"cl");
ms39_594=se_ms(2,"cc");
ms39_1236979201=se_ms(11,"compiler.se");
ms17_56612951=se_ms(9,"system.se");
ms39_674=se_ms(2,"sc");
ms39_689=se_ms(2,"vc");
ms39_426884100=se_ms(22,"Optimize OptimizerTime");
se_msi5();
}


void se_msi5(void){
ms17_414933715a=se_ms(21,"System name selection");
ms39_1102814319=se_ms(11,"System is \"");
ms39_223953=se_ms(6,"-lcpml");
ms39_0aa=se_ms(0,"");
ms17_1090aa=se_ms(3,"\".\n");
ms17_11253=se_ms(4,"BeOS");
ms39_270309168=se_ms(34,"Currently handled compiler names:\n");
ms17_2030897129=se_ms(52,"Value of the Environment variable \"SmallEiffel\"\nis \"");
ms17_12117a=se_ms(4,"PATH");
ms17_2092305=se_ms(7,"lib_std");
ms17_10aaaa=se_ms(1,"\n");
ms17_1090a=se_ms(3,"\".\n");
ms17_596025978=se_ms(33,"\" in \nyour system path variable.\n");
ms17_12117=se_ms(4,"PATH");
ms39_1631212670=se_ms(38,"Hope this is a Macintosh like system.\n");
ms39_0aaaaaaa=se_ms(0,"");
ms17_56806204=se_ms(9,"windows.c");
ms39_57487=se_ms(5,"Amiga");
ms17_13028aaa=se_ms(4,"UNIX");
ms39_968120=se_ms(7,"-DAMIGA");
ms17_1784783943=se_ms(27,"Unable to find executable \"");
ms17_825023736=se_ms(33,"Unkown SYSTEM_TOOLS.system_name \"");
ms17_13028=se_ms(4,"UNIX");
ms17_52773091=se_ms(9,"loadpath.");
ms20_56612951=se_ms(9,"system.se");
ms17_1772235aaaa=se_ms(7,"Windows");
ms17_1979141=se_ms(7,"compile");
ms39_382130=se_ms(6,"bcc32i");
ms39_1866433364=se_ms(36,"\".\nCurrently handled system names :\n");
ms17_3554640a=se_ms(8,"\" done.\n");
ms17_392246664=se_ms(152,"With gcc the -pipe option is recommended (unfortunately\nthis is not supported for all platforms).\nThe -pipe option is supported on all Linux platforms.\n");
ms39_59731=se_ms(5,"Elate");
ms17_404024442=se_ms(25,"/boot/beos/system/Tracker");
ms17_1395a=se_ms(3,"./\n");
ms17_1236979201=se_ms(11,"compiler.se");
ms17_39617954a=se_ms(9,"Macintosh");
ms17_1102814319=se_ms(11,"System is \"");
ms17_13028a=se_ms(4,"UNIX");
ms17_1620a=se_ms(3,".\\\n");
ms39_721564652=se_ms(18," NoVersion NoIcons");
ms39_2075119688=se_ms(22,"#1#2#3#4#5#6#7#8#9#?.o");
ms17_1680762272=se_ms(13,"\" not found.\n");
ms17_499966698=se_ms(41,"\" done.\nThe default loadpath is updated.\n");
ms17_1789524802=se_ms(94,"Value of the Environment variable \"SmallEiffel\" is correctly set\nto some existing file\npath (\"");
ms17_1772235aa=se_ms(7,"Windows");
ms39_1772235=se_ms(7,"Windows");
ms17_2178a=se_ms(3,"DOS");
ms17_1889925553a=se_ms(12,"compile_to_c");
ms17_1889925553aaaaaa=se_ms(12,"compile_to_c");
ms17_57487aa=se_ms(5,"Amiga");
se_msi6();
}


void se_msi6(void){
ms37_3556890=se_ms(8,"\" file.\n");
ms17_106668511=se_ms(40,"Unable to compute parent directory \nof \"");
ms17_1090aaaaa=se_ms(3,"\".\n");
ms17_2073823=se_ms(7,"install");
ms17_896093333=se_ms(13,"sys/system.se");
ms17_2440a=se_ms(3,"OS2");
ms17_1090aaaaaaa=se_ms(3,"\".\n");
ms17_180aa=se_ms(2,"\"\n");
ms39_76405=se_ms(5,"bcc32");
ms36_1121830=se_ms(7,"/bin/ls");
ms17_1772235=se_ms(7,"Windows");
ms17_2618a=se_ms(3,"VMS");
ms17_1308497832=se_ms(58,"Value of the Environment variable \"SmallEiffel\" value\nis \"");
ms39_679150617=se_ms(269,"You should update the value of the \"SmallEiffel\" system environment variable.\nSince release -0.79, the \"SmallEiffel\" system environment variable must be the absolute path of the \"system.se\" file.\nFor example \"/usr/lib/SmallEiffel/sys/system.se\" under Unix like system.\n");
ms17_10aaa=se_ms(1,"\n");
ms39_3498891=se_ms(14,"compile_to_c: ");
ms17_802100104=se_ms(12,"-interactive");
ms37_141444=se_ms(6,"\" as \"");
ms36_2593=se_ms(3,"[-]");
ms17_3169a=se_ms(3,"gcc");
ms17_142550=se_ms(6,"\" is:\n");
ms36_276a=se_ms(2,"..");
ms17_261527319=se_ms(10,"lib_number");
ms39_1826831355=se_ms(27,"-5 -w-aus -w-par -w-rvl -O2");
ms37_1520107011=se_ms(39,"Unexpected end_of_input while reading \"");
ms17_261527539=se_ms(10,"lib_random");
ms17_13028aaaa=se_ms(4,"UNIX");
ms17_1264449352=se_ms(31,"SmallEiffel directory path is \"");
ms17_835722674=se_ms(42,"Unable to open current working directory.\n");
ms17_1887845192=se_ms(25,"\" is not a valid choice.\n");
ms37_44975894=se_ms(9,"Writing \"");
ms39_467476687=se_ms(33,"Hope this is a Unix like system.\n");
ms17_38415354=se_ms(29,"Garbage collector selection:\n");
ms17_3554640=se_ms(8,"\" done.\n");
ms39_447734=se_ms(6,"wcc386");
ms17_3499443=se_ms(14,"compile_to_jvm");
ms17_1118238740=se_ms(122,"\".\nFor example, the very first line can be \"gcc -pipe -O3\".\nIf you are no an expert of C compilation, do not add options.\n");
ms20_1071750288=se_ms(11,"SmallEiffel");
ms39_91157=se_ms(5,"wlink");
ms17_1889925553aaa=se_ms(12,"compile_to_c");
ms36_403016243=se_ms(15,"C:\\AUTOEXEC.BAT");
ms37_27561173=se_ms(21,"Trying to read file \"");
ms17_10aaaaa=se_ms(1,"\n");
ms17_56806204a=se_ms(9,"windows.c");
ms39_39617954=se_ms(9,"Macintosh");
ms17_1471850305=se_ms(24,"Selected C compiler is \"");
ms17_1042405932=se_ms(20,"Version of command \"");
ms39_0aaaaaaaa=se_ms(0,"");
ms17_52892944=se_ms(13,"-boost -no_gc");
ms17_1457509747=se_ms(20,"\"\n   system_name = \"");
se_msi7();
}


void se_msi7(void){
ms39_448859=se_ms(6,"wcl386");
ms17_1583821555=se_ms(12,"*.c\" files.\n");
ms17_3595a=se_ms(3,"sys");
ms17_1378771941=se_ms(226,"Environment variable \"SmallEiffel\" is not set.\nPlease, set this variable with the absolute path of \nthe \"SmallEiffel/sys/system.se\" file.\nA file \"system.se\" must exists in the sub-directory \"sys\" of the\nSmallEiffel directory.\n");
ms17_401244=se_ms(6,"finder");
ms17_56806204aa=se_ms(9,"windows.c");
ms17_1090aaaaaaaa=se_ms(3,"\".\n");
ms39_1023953763=se_ms(13,"SmallEiffel=\"");
ms17_1090aaa=se_ms(3,"\".\n");
ms17_10=se_ms(1,"\n");
ms17_34=se_ms(1,"\"");
ms39_51699930=se_ms(9,"lcc-win32");
ms39_1570aaaaa=se_ms(3,"-O2");
ms17_45411=se_ms(5,"-pipe");
ms17_1090aaaaaaaaaaaa=se_ms(3,"\".\n");
ms17_923558719=se_ms(11,"Directory \"");
ms39_1570aaaa=se_ms(3,"-O2");
ms20_300594=se_ms(6,"File \"");
ms39_876917780=se_ms(31,"Unknown compiler name in file\n\"");
ms39_1494914262=se_ms(18," Ignore=93,194,304");
ms17_2102329=se_ms(7,"linux.c");
ms37_210310269=se_ms(10,"Removing \"");
ms17_414933715=se_ms(21,"System name selection");
ms17_1090aaaa=se_ms(3,"\".\n");
ms17_1772235aaa=se_ms(7,"Windows");
ms17_176208679=se_ms(10,"BeOS_x86.c");
ms17_1447048624=se_ms(39,"Unable to compute directory path with \"");
ms17_424217529=se_ms(219,"*** Fatal problem during installation of SmallEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n");
ms39_1091987=se_ms(7,"-mD -mC");
ms17_444078490=se_ms(11,"\" created.\n");
ms17_1889925553aa=se_ms(12,"compile_to_c");
ms39_11253=se_ms(4,"BeOS");
ms17_564929999=se_ms(22,"C compiler selection:\n");
ms39_179868158=se_ms(29,"Unknown system name in file\n\"");
ms17_1472409390=se_ms(26,"Type <Enter> to continue.\n");
ms17_1927443312=se_ms(25,"System seems to be UNIX.\n");
ms39_39204698=se_ms(9,"SCOPTIONS");
ms17_264638762=se_ms(10,"misc/GC.SH");
ms39_13028=se_ms(4,"UNIX");
ms39_1429938878=se_ms(244,"Unable to find file \"system.se\".\nPlease, set the environment variable \"SmallEiffel\" with the appropriate absolute path to this file.\nExample for Unix: \"/usr/lib/SmallEiffel/sys/system.se\"\nExample for DOS/Windows: \"C:\\SmallEiffel\\sys\\system.se\"\n");
}


void*se_ma44(int argc,...){
T44*m;
va_list pa;
T0**s;
m=se_malloc(sizeof(*m));
*m=M44;
if(argc){
s=se_malloc(argc*sizeof(*s));
m->_storage=s;
m->_capacity=argc;
m->_lower=1;
m->_upper=argc;
va_start(pa,argc);
while(argc--){
*(s++)=((void*)(va_arg(pa,char*)));
}
va_end(pa);
}
else{
m->_storage=NULL;
m->_capacity=0;
m->_lower=1;
m->_upper=0;
}
return m;
}


void X47add_last(T0*C,T0* a1){
{Tid id=((T0*)C)->id;
if(id<=44){
r44add_last(((T44*)C),a1);
}
else{
r54add_last(((T54*)C),a1);
}}
}

#ifdef __cplusplus
}
#endif
