#!/usr/bin/env python
# Copyright (c) 2002 Nathan Sharfi
# Copyright terms are included in a file called 'license.txt'.
"I contain functions for manipulating ogg vorbis files via os.system()."

import os, shutil, traceback
import metadata

class Compressor:
    "I encode .wav files to .ogg files."
    def __init__(self, inFile, outFile=None, quality=None, comments=None):
        """
        inFile    -- The name of the file to encode.
        outFile   -- Overrides the default output filename.
        quality   -- a real number between -1 and 10, inclusive
        comments  -- a Comments object
        """

        if not os.path.isfile(inFile):
            raise IOError, "inFile must be a valid filename, you gave me " + \
                           inFile

        if outFile: outFileCmd = ' --output="%s" ' % (outFile)
        else:       outFileCmd = ''

        if quality: qualityCmd = ' --quality %s ' % (_validateQuality(quality))
        else:       qualityCmd = ''

        if comments: commentsCmd = oggencizeComments(comments)
        else:        commentsCmd = ''

        self.cmd = 'oggenc %s %s %s "%s"' % \
                   (qualityCmd, outFileCmd, commentsCmd, inFile)

    def compress(self): os.system(self.cmd)

def oggencizeComments(c):
    "I turn a Comments object into a string that oggenc understands."

    l = []
    for k, v in c.items():
        l.append(' --comment="%s=%s" ' % (k,v))

    return ''.join(l)

def _validateQuality(arg):
    """Raises an ArgumentError if arg is not on the range [-1, 10]."""

    if not -1 <= float(arg) <= 10:
        raise ArgumentError("quality argument isn't on the range [-1, 10]")

    return float(arg)

if __name__ == '__main__':
    pass

