import os
import sys
import getopt

class Options:
    """All the options for sonice."""
    def __init__(self):
        """Set defaults."""
        self.silent = False
        self.quiet = False
        self.verbose = False
        self.quality = '3'
        self.doFlac = True
        self.doVorbisgain = True
        self.doCdparanoia = False # unimplemented

        # used to use os.path.join(os.curdir, x)
        self.flacDir = 'flac'
        self.infoDir = 'info'
        self.wavDir = 'wav'
        self.oggDir = 'ogg'

        self.filenameTags = "version part".split()

    def parseOptions(self, argv):
        """ """
        # letters to reserve:
        #  -j (like make -j 2) for --jobs (unless something else comes along)
        #  -d (--device for cdparanoia)
        try:
            opts, args = \
                  getopt.getopt(argv,
                                'hQVq:kf:i:w:o:',
                                ("help quiet verbose quality= skip-flac " +
                                 "flac-dir= info-dir= wav-dir= ogg-dir="
                                 ).split())
        except getopt.GetoptError:
            printUsage()
            sys.exit(1)
        for o, a in opts:
            if o in ('-h', '--help'):
                printUsage()
                sys.exit(1)
                
            if o in ('-Q', '--quiet'):     self.quiet = True
            if o in ('-V', '--verbose'):   self.verbose = True
            if o in ('-q', '--quality'):   self.quality = a
            if o in ('-k', '--skip-flac'): self.doFlac = False
            if o in ('-f', '--flac-dir'):  self.flacDir = a
            if o in ('-i', '--info-dir'):  self.infoDir = a
            if o in ('-w', '--wav-dir'):   self.wavDir = a
            if o in ('-o', '--ogg-dir'):   self.oggDir = a
        
def printUsage():
    "prints out a helpful message detailing what options work"
    print \
"""This is sonice, the make for compressed audio.
Usage:    sonice [options]

General:
  -h, --help         prints this help message
  -Q, --quiet        prints less to standard out

Control Flow:
  -k, --skip-flac    don't decode from FLAC
  -q, --quality      sets the encoding quality (3.0 by default)

Directory Settings:
  -f, --flac-dir     directory that holds .flac files 
  -i, --info-dir     directory that holds metadata files
  -w, --wav-dir      directory that holds (intermediary) .wav files
  -o, --ogg-dir      directory where .ogg files are placed
"""
       
options = Options()
