#!/usr/bin/env python
# Copyright (c) 2002 Nathan Sharfi
# Copyright terms are included in a file called 'license.txt'.
import os
def priorityManager(cmd):
    """I modify cmd to add in process priority information.

    I automatically select the most appropriate priority manager for the
    operating system."""
    f = None
    if   os.name == 'nt':
        return nt(cmd)
    elif os.name == 'posix':
        return posix(cmd)
    else:
        return unmanaged(cmd)

def unmanaged(cmd):
    return cmd

def posix(cmd):
    "I modify cmd to run niced."
    return 'nice ' + cmd

def nt(cmd):
    "I modify cmd to run at low priority with start /low /b."
    return unmanaged(cmd)
    # the following is buggy; deferring to unmanaged
    return 'start /low /b ' + cmd
