/*=============================================================================
    Parser operators

    Spirit V1.2
    Copyright (c) 2001, Joel de Guzman

    This software is provided 'as-is', without any express or implied
    warranty. In no event will the copyright holder be held liable for
    any damages arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute
    it freely, subject to the following restrictions:

    1.  The origin of this software must not be misrepresented; you must
        not claim that you wrote the original software. If you use this
        software in a product, an acknowledgment in the product documentation
        would be appreciated but is not required.

    2.  Altered source versions must be plainly marked as such, and must
        not be misrepresented as being the original software.

    3.  This notice may not be removed or altered from any source
        distribution.

    Acknowledgements:

        Special thanks to Dan Nuffer, John (EBo) David, Chris Uzdavinis,
        and Doug Gregor. These people are most instrumental in steering
        Spirit in the right direction.

        Special thanks also to people who have contributed to the code base
        and sample code, ported Spirit to various platforms and compilers,
        gave suggestions, reported and provided bug fixes. Alexander
        Hirner, Andy Elvey, Bogdan Kushnir, Brett Calcott, Bruce Florman,
        Changzhe Han, Colin McPhail, Hakki Dogusan, Jan Bares, Joseph
        Smith, Martijn W. van der Lee, Raghavendra Satish, Remi Delcos, Tom
        Spilman, Vladimir Prus, W. Scott Dillman, David A. Greene, Bob
        Bailey, Hartmut Kaiser.

        Finally special thanks also to people who gave feedback and
        valuable comments, particularly members of Spirit's Source Forge
        mailing list and boost.org.

    URL: http://spirit.sourceforge.net/

=============================================================================*/
#ifndef SPIRIT_OPERATORS_IPP
#define SPIRIT_OPERATORS_IPP

///////////////////////////////////////////////////////////////////////////////

#include "boost/spirit/operators.hpp"
#include "boost/spirit/primitives.hpp"

///////////////////////////////////////////////////////////////////////////////
namespace spirit {

///////////////////////////////////////////////////////////////////////////////
//
//  sequence class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename A, typename B>
inline sequence<A, B>
operator>>(parser<A> const& a, parser<B> const& b)
{
    return sequence<A, B>(a.derived(), b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, chlit<char> >
operator>>(parser<A> const& a, char b)
{
    return sequence<A, chlit<char> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<chlit<char>, B>
operator>>(char a, parser<B> const& b)
{
    return sequence<chlit<char>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, strlit<cstring<char> > >
operator>>(parser<A> const& a, char const* b)
{
    return sequence<A, strlit<cstring<char> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<strlit<cstring<char> >, B>
operator>>(char const* a, parser<B> const& b)
{
    return sequence<strlit<cstring<char> >, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, chlit<wchar_t> >
operator>>(parser<A> const& a, wchar_t b)
{
    return sequence<A, chlit<wchar_t> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<chlit<wchar_t>, B>
operator>>(wchar_t a, parser<B> const& b)
{
    return sequence<chlit<wchar_t>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, strlit<cstring<wchar_t> > >
operator>>(parser<A> const& a, wchar_t const* b)
{
    return sequence<A, strlit<cstring<wchar_t> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<strlit<cstring<wchar_t> >, B>
operator>>(wchar_t const* a, parser<B> const& b)
{
    return sequence<strlit<cstring<wchar_t> >, B>(a, b.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  sequential-and operators implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename A, typename B>
inline sequence<A, B>
operator&&(parser<A> const& a, parser<B> const& b)
{
    return sequence<A, B>(a.derived(), b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, chlit<char> >
operator&&(parser<A> const& a, char b)
{
    return sequence<A, chlit<char> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<chlit<char>, B>
operator&&(char a, parser<B> const& b)
{
    return sequence<chlit<char>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, strlit<cstring<char> > >
operator&&(parser<A> const& a, char const* b)
{
    return sequence<A, strlit<cstring<char> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<strlit<cstring<char> >, B>
operator&&(char const* a, parser<B> const& b)
{
    return sequence<strlit<cstring<char> >, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, chlit<wchar_t> >
operator&&(parser<A> const& a, wchar_t b)
{
    return sequence<A, chlit<wchar_t> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<chlit<wchar_t>, B>
operator&&(wchar_t a, parser<B> const& b)
{
    return sequence<chlit<wchar_t>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequence<A, strlit<cstring<wchar_t> > >
operator&&(parser<A> const& a, wchar_t const* b)
{
    return sequence<A, strlit<cstring<wchar_t> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequence<strlit<cstring<wchar_t> >, B>
operator&&(wchar_t const* a, parser<B> const& b)
{
    return sequence<strlit<cstring<wchar_t> >, B>(a, b.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  sequential-or class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename A, typename B>
inline sequential_or<A, B>
operator||(parser<A> const& a, parser<B> const& b)
{
    return sequential_or<A, B>(a.derived(), b.derived());
}

//////////////////////////////////
template <typename A>
inline sequential_or<A, chlit<char> >
operator||(parser<A> const& a, char b)
{
    return sequential_or<A, chlit<char> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequential_or<chlit<char>, B>
operator||(char a, parser<B> const& b)
{
    return sequential_or<chlit<char>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequential_or<A, strlit<cstring<char> > >
operator||(parser<A> const& a, char const* b)
{
    return sequential_or<A, strlit<cstring<char> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequential_or<strlit<cstring<char> >, B>
operator||(char const* a, parser<B> const& b)
{
    return sequential_or<strlit<cstring<char> >, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequential_or<A, chlit<wchar_t> >
operator||(parser<A> const& a, wchar_t b)
{
    return sequential_or<A, chlit<wchar_t> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequential_or<chlit<wchar_t>, B>
operator||(wchar_t a, parser<B> const& b)
{
    return sequential_or<chlit<wchar_t>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline sequential_or<A, strlit<cstring<wchar_t> > >
operator||(parser<A> const& a, wchar_t const* b)
{
    return sequential_or<A, strlit<cstring<wchar_t> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline sequential_or<strlit<cstring<wchar_t> >, B>
operator||(wchar_t const* a, parser<B> const& b)
{
    return sequential_or<strlit<cstring<wchar_t> >, B>(a, b.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  alternative class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename A, typename B>
inline alternative<A, B>
operator|(parser<A> const& a, parser<B> const& b)
{
    return alternative<A, B>(a.derived(), b.derived());
}

//////////////////////////////////
template <typename A>
inline alternative<A, chlit<char> >
operator|(parser<A> const& a, char b)
{
    return alternative<A, chlit<char> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline alternative<chlit<char>, B>
operator|(char a, parser<B> const& b)
{
    return alternative<chlit<char>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline alternative<A, strlit<cstring<char> > >
operator|(parser<A> const& a, char const* b)
{
    return alternative<A, strlit<cstring<char> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline alternative<strlit<cstring<char> >, B>
operator|(char const* a, parser<B> const& b)
{
    return alternative<strlit<cstring<char> >, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline alternative<A, chlit<wchar_t> >
operator|(parser<A> const& a, wchar_t b)
{
    return alternative<A, chlit<wchar_t> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline alternative<chlit<wchar_t>, B>
operator|(wchar_t a, parser<B> const& b)
{
    return alternative<chlit<wchar_t>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline alternative<A, strlit<cstring<wchar_t> > >
operator|(parser<A> const& a, wchar_t const* b)
{
    return alternative<A, strlit<cstring<wchar_t> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline alternative<strlit<cstring<wchar_t> >, B>
operator|(wchar_t const* a, parser<B> const& b)
{
    return alternative<strlit<cstring<wchar_t> >, B>(a, b.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  intersection class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename A, typename B>
inline intersection<A, B>
operator&(parser<A> const& a, parser<B> const& b)
{
    return intersection<A, B>(a.derived(), b.derived());
}

//////////////////////////////////
template <typename A>
inline intersection<A, chlit<char> >
operator&(parser<A> const& a, char b)
{
    return intersection<A, chlit<char> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline intersection<chlit<char>, B>
operator&(char a, parser<B> const& b)
{
    return intersection<chlit<char>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline intersection<A, strlit<cstring<char> > >
operator&(parser<A> const& a, char const* b)
{
    return intersection<A, strlit<cstring<char> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline intersection<strlit<cstring<char> >, B>
operator&(char const* a, parser<B> const& b)
{
    return intersection<strlit<cstring<char> >, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline intersection<A, chlit<wchar_t> >
operator&(parser<A> const& a, wchar_t b)
{
    return intersection<A, chlit<wchar_t> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline intersection<chlit<wchar_t>, B>
operator&(wchar_t a, parser<B> const& b)
{
    return intersection<chlit<wchar_t>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline intersection<A, strlit<cstring<wchar_t> > >
operator&(parser<A> const& a, wchar_t const* b)
{
    return intersection<A, strlit<cstring<wchar_t> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline intersection<strlit<cstring<wchar_t> >, B>
operator&(wchar_t const* a, parser<B> const& b)
{
    return intersection<strlit<cstring<wchar_t> >, B>(a, b.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  difference class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename A, typename B>
inline difference<A, B>
operator-(parser<A> const& a, parser<B> const& b)
{
    return difference<A, B>(a.derived(), b.derived());
}

//////////////////////////////////
template <typename A>
inline difference<A, chlit<char> >
operator-(parser<A> const& a, char b)
{
    return difference<A, chlit<char> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline difference<chlit<char>, B>
operator-(char a, parser<B> const& b)
{
    return difference<chlit<char>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline difference<A, strlit<cstring<char> > >
operator-(parser<A> const& a, char const* b)
{
    return difference<A, strlit<cstring<char> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline difference<strlit<cstring<char> >, B>
operator-(char const* a, parser<B> const& b)
{
    return difference<strlit<cstring<char> >, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline difference<A, chlit<wchar_t> >
operator-(parser<A> const& a, wchar_t b)
{
    return difference<A, chlit<wchar_t> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline difference<chlit<wchar_t>, B>
operator-(wchar_t a, parser<B> const& b)
{
    return difference<chlit<wchar_t>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline difference<A, strlit<cstring<wchar_t> > >
operator-(parser<A> const& a, wchar_t const* b)
{
    return difference<A, strlit<cstring<wchar_t> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline difference<strlit<cstring<wchar_t> >, B>
operator-(wchar_t const* a, parser<B> const& b)
{
    return difference<strlit<cstring<wchar_t> >, B>(a, b.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  exclusive_or class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename A, typename B>
inline exclusive_or<A, B>
operator^(parser<A> const& a, parser<B> const& b)
{
    return exclusive_or<A, B>(a.derived(), b.derived());
}

//////////////////////////////////
template <typename A>
inline exclusive_or<A, chlit<char> >
operator^(parser<A> const& a, char b)
{
    return exclusive_or<A, chlit<char> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline exclusive_or<chlit<char>, B>
operator^(char a, parser<B> const& b)
{
    return exclusive_or<chlit<char>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline exclusive_or<A, strlit<cstring<char> > >
operator^(parser<A> const& a, char const* b)
{
    return exclusive_or<A, strlit<cstring<char> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline exclusive_or<strlit<cstring<char> >, B>
operator^(char const* a, parser<B> const& b)
{
    return exclusive_or<strlit<cstring<char> >, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline exclusive_or<A, chlit<wchar_t> >
operator^(parser<A> const& a, wchar_t b)
{
    return exclusive_or<A, chlit<wchar_t> >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline exclusive_or<chlit<wchar_t>, B>
operator^(wchar_t a, parser<B> const& b)
{
    return exclusive_or<chlit<wchar_t>, B>(a, b.derived());
}

//////////////////////////////////
template <typename A>
inline exclusive_or<A, strlit<cstring<wchar_t> > >
operator^(parser<A> const& a, wchar_t const* b)
{
    return exclusive_or<A, strlit<cstring<wchar_t> > >(a.derived(), b);
}

//////////////////////////////////
template <typename B>
inline exclusive_or<strlit<cstring<wchar_t> >, B>
operator^(wchar_t const* a, parser<B> const& b)
{
    return exclusive_or<strlit<cstring<wchar_t> >, B>(a, b.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  optional class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename S>
optional<S>
operator!(parser<S> const& a)
{
    return optional<S>(a.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  kleene_star class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename S>
inline kleene_star<S>
operator*(parser<S> const& a)
{
    return kleene_star<S>(a.derived());
}

///////////////////////////////////////////////////////////////////////////////
//
//  positive class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename S>
inline positive<S>
operator+(parser<S> const& a)
{
    return positive<S>(a.derived());
}

///////////////////////////////////////////////////////////////////////////////
}   //  namespace Spirit

#endif
