
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: keyhndl.h,v 1.7 2002/07/26 01:39:40 darkmoon Exp $ */

/* Project:     Terminality
 * File:	keyhndl.h
 * Author:      Michal Safranek
 * Description: Keyboard handler
 */

#ifndef __KEYHNDL_H__
#define __KEYHNDL_H__

#include <tn.h>
#include <list.h>
#include <string.h>
#include <assert.h>

/*
 * Please, see note about key binding in gui.h
 */


#ifdef __cplusplus
extern "C" {
#endif

/* global keys */
extern tn_list *handled_keys;

/* key struct */
typedef struct {
	key name;
	int (*fce)(key, element_type, void *);
} key_struct;

/* Returns position # in list by key, -1 if not found */
int real_get_key_position(tn_list *v, key k);

/* Registers key into v */
int real_register_key(tn_list **v, key k, key (*fce)(key, element_type, void *),
		int overwrite);

/* Unregisters key */
int real_unregister_key(tn_list **v, key k);

/* Set default keys */
void default_keys(void);

/* Delete all keys */
void real_delete_keys(tn_list **v);

/* Handles pressed key (from element type=type, address=ptr) */
int real_handle_key(tn_list **v, key k, element_type type, void *ptr);

/* Here are 'global' defs - definitions for 'global' keys */
#define get_key_position(k)		real_get_key_position(handled_keys, k)
#define register_key(k, f, o)	real_register_key(&handled_keys, k, f, o)
#define unregister_key(k)		real_unregister_key(&handled_keys, k)
#define delete_keys()			real_delete_keys(&handled_keys)
#define handle_key(k, t, p)		real_handle_key(&handled_keys, k, t, p)
	

#ifdef __cplusplus
}
#endif

#endif

