
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: register.h,v 1.5 2002/07/26 01:39:40 darkmoon Exp $ */

/* Project:     Terminality
 * File:	register.h
 * Author:      Michal Safranek
 * Description: Element register
 */

#ifndef __REGISTER_H__
#define __REGISTER_H__

#include "tn.h"
#include "list.h"

#ifdef __cplusplus
extern "C" {
#endif



#ifdef __REGISTER_INTERNAL__

/* Element register list - here are elements stored */
extern tn_list *register_list;

/* Max elem id now */
extern int register_maxid;



/* Struct stored in reg. list */
typedef struct {
	element_type type;
	int id;
	void *elem;
} register_elem;



#endif



/* Add element to register */
int register_add(element_type type, void *ptr);

/* Del element from register */
int register_del(int id);

/* Free whole register */
void register_free(void);

/* Call-back function for all elements */
void register_callback(void (*fce)(element_type, void *));

#ifdef __cplusplus
}
#endif

#endif

