
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: tn_h_w32.h,v 1.1 2002/07/26 08:18:14 darkmoon Exp $ */

/* File:	tn_w32.h
 * Project:     Terminality
 * Author:      Emil Mikulic
 * Description: Provide some help for the Win32 implementation
 */

#ifndef _tn_w32_h_
#define _tn_w32_h_
#define TN_H_IMPLEMENTED

/* confuse Borland C */
#define textcolor	_textcolor
#define textbackground	_textbackground
#define textattr	_textattr

/* --- platform-dependent include files */
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

/* unconfuse Borland C */
#undef textcolor
#undef textbackground
#undef textattr

/* --- color bitmasks --- */
#define FG_MASK		240 /* 11110000 */
#define BG_MASK		15  /* 00001111 */
#define TEXT_BOLD	8   /* 00001000 */
#define BG_BITS		4

/* some debugging */
#ifdef NDEBUG
#define PERR(x) x
#else
#define PERR(x) if (!(x)) conserr(__FILE__, __LINE__)
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Console size */
extern int CON_COLS, CON_ROWS;

/* Win32 Specifics */
void conserr(char *, int);

#ifdef __cplusplus
};
#endif

/* Special character set */
#define _c(x) ((char)(x))

#define HLINE	_c(196)
#define VLINE	_c(179)
#define CROSS	_c(197)
#define C_UL	_c(218)
#define C_UR	_c(191)
#define C_LL	_c(192)
#define C_LR	_c(217)
#define BLOCK_1	_c(176)
#define BLOCK_2	_c(177)
#define BLOCK_3 _c(178)
#define BLOCK_4 _c(219)
#define TEE_L	_c(180)
#define TEE_R	_c(195)
#define TEE_U	_c(193)
#define TEE_D	_c(194)
#define ARROW_L	_c(27)
#define ARROW_R	_c(26)
#define ARROW_U	_c(24)
#define ARROW_D	_c(25)

/* Keys */
#define key		int
#define chtype		unsigned char
#define KEY_BACKSPACE	8 /*'\b'*/
#define KEY_ENTER	'\r'
#define KEY_TAB		'\t'
#define KEY_ESC		27

#define KEY_REDRAW 12
#define KEY_NOTHING 32101
#define KEY_SUPERVISE (KEY_NOTHING + 1) /* Virtual key */

#ifdef __BORLANDC__
#define CONTROL_KEY	0
#else
#define CONTROL_KEY	(224 << 8)
#endif
#define KEY_UP		(CONTROL_KEY | 72)
#define KEY_DOWN	(CONTROL_KEY | 80)
#define KEY_RIGHT	(CONTROL_KEY | 77)
#define KEY_LEFT	(CONTROL_KEY | 75)
#define KEY_INS		(CONTROL_KEY | 82)
#define KEY_DEL		(CONTROL_KEY | 83)
#define KEY_PGUP	(CONTROL_KEY | 73)
#define KEY_PGDOWN	(CONTROL_KEY | 81)
#define KEY_HOME	(CONTROL_KEY | 71)
#define KEY_END		(CONTROL_KEY | 79)

#endif

