#!/usr/bin/env python
''' 
threeDS.py - Python Module for loading and displaying 3DStudio format modules
Copyright (C) 2000 Jason Petrone <jp@demonseed.net>
'''
blending = None
smoothing = None
#blending = 1
#smoothing = 1

import sys

try:
  from OpenGL.Tk import *
  from OpenGL.GL import *
except:
  print '''
ERROR: PyOpenGL is not installed properly.  This needs fixed for this program
       to continue.  PyOpenGL can be found at: http://pyopengl.sourceforge.net
        '''
  sys.exit()

try:
  import threeDS
except:
  print '''
ERROR: Can't find the threeDS.py module that should have come with this 
       program.  Please make sure it is within your Python path.
        '''
  sys.exit()

model = None


def draw(o):
  'OpenGL redraw callback'
  global model, blending, smoothing

  o.report_opengl_errors()

  white = [.3, 1, .3, 1]
  glMaterialfv(GL_FRONT, GL_AMBIENT, white)
  glMaterialfv(GL_FRONT, GL_DIFFUSE, white)
  glMaterialfv(GL_FRONT, GL_SPECULAR, white)
  if model: 
    model.draw()


try:
  modelName = sys.argv[1]
except:
  print '''
ERROR: No model specified!
  '''
  sys.exit()


o = Opengl(width = 640, height = 480, double = 1)

print 'Loading ' + modelName
model = threeDS.Scene(modelName)
print modelName + ': ' + str(len(model.objects)) + ' objects, ' + str(len(model.materials.keys())) + ' materials, ' + str(len(model.lights)) + ' lights.'
o.redraw  = draw
o.pack(side = 'top', expand = 1, fill = 'both')
if not model.lighting():
  print 'Using default lighting.'
  o.basic_lighting()

# use gray background
o.set_background(.3, .3, .3)

# enable autospin with middle click
o.autospin_allowed = 1

# set back clipping plane WAY back
o.far = 20000

if smoothing: glShadeModel(GL_SMOOTH)
else: glShadeModel(GL_FLAT)

if blending: 
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
else:
  glDisable(GL_BLEND)

o.mainloop()
