#
# Tcl Library for TkCVS
#

#
# $Id: import.tcl,v 1.30 2001/10/08 05:39:46 dorothyr Exp $
#
# Adds a new document to the repository.
#

proc import_setup {} {
  global cvsglb
  global cvscfg

  gen_log:log T "ENTER"
  # Give it a default
  set cvsglb(newvers) 1
  set cvsglb(newdir) $cvsglb(newcode)

  toplevel .import
  frame .import.top

  message .import.top.explain -justify left -aspect 400 -relief groove \
    -text "This will import the current directory and its sub-directories\
          into CVS, creating a new module."
  label .import.top.lnewcode -text "Module Name" -anchor w
  label .import.top.lnewdir  -text "Module path relative to \$CVSROOT" -anchor w
  label .import.top.lnewdesc -text "Descriptive Title" -anchor w
  label .import.top.lnewvers  -text "Version Number" -anchor w

  entry .import.top.tnewcode -textvariable cvsglb(newcode) -width 40 \
    -state disabled -borderwidth 1
  entry .import.top.tnewdir -textvariable cvsglb(newdir) -width 40
  entry .import.top.tnewdesc -textvariable cvsglb(newdesc) -width 40
  entry .import.top.tnewvers -textvariable cvsglb(newvers) -width 40

  grid .import.top.explain -column 0 -row 0 -columnspan 2 -sticky ew
  grid .import.top.lnewcode -column 0 -row 1 -sticky w
  grid .import.top.tnewcode -column 1 -row 1 -sticky ew
  grid .import.top.lnewdir -column 0 -row 2 -sticky w
  grid .import.top.tnewdir -column 1 -row 2 -sticky ew
  grid .import.top.lnewdesc -column 0 -row 3 -sticky w
  grid .import.top.tnewdesc -column 1 -row 3 -sticky ew
  grid .import.top.lnewvers -column 0 -row 4 -sticky w
  grid .import.top.tnewvers -column 1 -row 4 -sticky ew

  frame .import.down -relief groove -border 2
  button .import.down.ok -text "OK" \
    -command do_import
  button .import.down.quit -text "Cancel" \
    -command { wm withdraw .import }

  pack .import.down -side bottom -expand yes -fill x
  pack .import.top -side top -expand yes -fill x
  pack .import.down.ok -side left -expand yes
  pack .import.down.quit -side left -expand yes

  # Needed for slower framebuffers
  #tkwait visibility .import

  wm withdraw .import
  wm title .import "Create a New Module"
  wm minsize .import 1 1

  gen_log:log T "LEAVE"
}

proc import_run {} {
  global cvsglb
  global cwd
  global incvs

  gen_log:log T "ENTER"
  cvsroot_check
  if {$incvs} {
    cvsok "This directory is already in CVS.\nCan\'t import here!"
    return 1
  }
  set cvsglb(newcode) [file tail $cwd]
  if {! [winfo exists .import]} {
    import_setup
  }
  wm deiconify .import
  raise .import
  gen_log:log T "LEAVE"
}

proc do_import {} {
  global cvs
  global cvsglb
  global cvscfg
  global cwd
  global modlist_sorted
  global feedback


  gen_log:log T "ENTER"
  set imdir [pwd]

  # Error checks
  if { $cvsglb(newdir) == "" } {
    cvsok "You must type in a directory."
    return 1
  }
  if { $cvsglb(newvers) == "" } {
    cvsok "You must type in a version number."
    return 1
  }
  if { $cvsglb(newcode) == "" } {
    cvsok "You must type in a module."
    return 1
  }

  # Make sure it isn't a duplicate key
  set commandline "$cvs -d $cvscfg(cvsroot) checkout -c"
  gen_log:log C $commandline
  set ret [catch {eval "exec $commandline"} view_this]
  if {$ret} {
    cvsfail "$view_this"
    return 1
  }

  # See if all apropriate Directories in newdirname exist.  CVS import will
  # create them, but we'll want to make a #D entry.
  set cvsglb(newdir) [string trimleft $cvsglb(newdir) "/"]
  set pathname [file dirname $cvsglb(newdir)]
  set need_Dir 0
  if {$pathname != "."} {
    foreach idx $modlist_sorted {
      lappend knowndirs [lindex $idx 0]
    }
    gen_log:log D "looking for $pathname in known directories ($knowndirs)"
    if {[lsearch -exact $knowndirs $pathname] == -1} {
      set need_Dir 1
    }
  }

  # Make a baseline tag
  set versions [split $cvsglb(newvers) ".,/ -"]
  set baseline "baseline-[join $versions {_}]"

  feedback_cvs $feedback(mod) "Importing $imdir, please wait"
  set commandline "$cvs -d $cvscfg(cvsroot) import -m \"Imported using TkCVS\" \
	    $cvsglb(newdir) VENDOR $baseline"
  gen_log:log C "$commandline"
  exec_command "CVS Import" "$commandline"
  feedback_cvs $feedback(mod) ""

  # Update the modules file.
  set commandline "$cvs -d $cvscfg(cvsroot) checkout CVSROOT/modules"
  exec_command "Checkout New Module" "$commandline"

  cd CVSROOT
  gen_log:log F "CD [pwd]"
  set modfile [open modules a]
  if {$need_Dir} {
    puts $modfile ""
    gen_log:log D "#D	$pathname\t$cvsglb(newdesc)"
    puts $modfile "#D	$pathname\t$cvsglb(newdesc)"
  }
  gen_log:log D "#M\t$cvsglb(newcode)\t$cvsglb(newdesc)"
  puts $modfile "#M\t$cvsglb(newcode)\t$cvsglb(newdesc)"
  gen_log:log D "$cvsglb(newcode)\t$cvsglb(newdir)"
  puts $modfile "$cvsglb(newcode)\t$cvsglb(newdir)"
  close $modfile
  set commandline "$cvs -d $cvscfg(cvsroot) ci -m \"added $cvsglb(newcode)\" modules"
  gen_log:log C "$commandline"
  exec_command "CVS Checkin CVSROOT" "$commandline"
  cd ../
  gen_log:log F "CD [pwd]"
  set commandline "$cvs -d $cvscfg(cvsroot) -Q release -d CVSROOT"
  gen_log:log C "$commandline"
  eval exec "$commandline"
  cd $cwd
  gen_log:log F "CD [pwd]"

  modbrowse_run $cvscfg(cvsroot)
  wm withdraw .import

  # Now check out the new module
  cd ..
  gen_log:log F "CD [pwd]"
  # We have to move the original stuff entirely out of the way.
  # Otherwise checkout won't do the whole tree.
  gen_log:log F "MOVE $imdir $imdir.orig"
  file rename $imdir $imdir.orig
  set commandline \
          "$cvs -d $cvscfg(cvsroot) checkout -R $cvsglb(newcode)"
  gen_log:log C "$commandline"
  exec_command "CVS Checkout" "$commandline"

  cd $cwd
  gen_log:log F "CD [pwd]"
 
  if {$cvscfg(auto_status)} {
    setup_dir
  }
  gen_log:log T "LEAVE"
}

