/*
 * Tiny Vector Matrix Library
 * Dense Vector Matrix Libary of Tiny size using Expression Templates
 *
 * Copyright (C) 2001, 2002 Olaf Petzold <opetzold@wit.regiocom.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * "$Id:"
 */

#ifndef TVMET_VECTOR_IMPL_H
#define TVMET_VECTOR_IMPL_H

#include <iomanip>			// setw

#include <tvmet/Functional.h>

namespace tvmet {

/*
 * member operators for i/o
 */
template<class T, std::size_t Sz>
inline
std::ostream& Vector<T, Sz>::print_on(std::ostream& os) const
{
  std::streamsize w = os.width();

  os << std::setw(0) << "Vector<" << typeid(T).name() << ", " << Sz << ">[";
  for(std::size_t i = 0; i < (Sz - 1); ++i) {
    os << std::setw(w) << m_data[i] << ", ";
  }
  os << std::setw(w) << m_data[Sz - 1] << "]";

  return os;
}

/*
 * member operators with scalars
 */
#define IMPLEMENT_BINARY_OPERATOR(OP)					\
template<class T, std::size_t Sz>					\
inline									\
Vector<T, Sz>& Vector<T, Sz>::operator OP (value_type rhs) {		\
  typedef XprLiteral<value_type> expr_type;				\
  *this OP XprVector<expr_type, Sz>(expr_type(rhs));			\
  return *this;								\
}

IMPLEMENT_BINARY_OPERATOR(+=)
IMPLEMENT_BINARY_OPERATOR(-=)
IMPLEMENT_BINARY_OPERATOR(*=)
IMPLEMENT_BINARY_OPERATOR(/=)
#undef IMPLEMENT_BINARY_OPERATOR

/**
 * \internal bit ops only with int's defined. Aynway, specializing
 * isn't usefull/possible - You will get here an error like
 * invalid operands `double' and `unsigned int' to binary `operator %'
 */
#define IMPLEMENT_BINARY_OPERATOR(OP)					\
template<class T, std::size_t Sz>					\
inline									\
Vector<T, Sz>& Vector<T, Sz>::operator OP (std::size_t rhs) {		\
  typedef XprLiteral<value_type> expr_type;				\
  *this OP XprVector<expr_type, Sz>(expr_type(rhs));			\
  return *this;								\
}

IMPLEMENT_BINARY_OPERATOR(%=)
IMPLEMENT_BINARY_OPERATOR(^=)
IMPLEMENT_BINARY_OPERATOR(&=)
IMPLEMENT_BINARY_OPERATOR(|=)
IMPLEMENT_BINARY_OPERATOR(<<=)
IMPLEMENT_BINARY_OPERATOR(>>=)
#undef IMPLEMENT_BINARY_OPERATOR

/*
 * member operators with vectors
 */
#define IMPLEMENT_BINARY_OPERATOR(OP)					\
template<class T1, std::size_t Sz>					\
template <class T2>					                \
inline									\
Vector<T1, Sz>& Vector<T1, Sz>::operator OP (const Vector<T2, Sz>& rhs) { \
  *this OP XprVector<typename Vector<T2, Sz>::ConstReference, Sz>(rhs.cref()); \
  return *this;					                	\
}

IMPLEMENT_BINARY_OPERATOR(=)
IMPLEMENT_BINARY_OPERATOR(+=)
IMPLEMENT_BINARY_OPERATOR(-=)
IMPLEMENT_BINARY_OPERATOR(*=)
#ifdef KICK_MATH_SENSE // not inside regression tests
IMPLEMENT_BINARY_OPERATOR(/=)
IMPLEMENT_BINARY_OPERATOR(%=)
IMPLEMENT_BINARY_OPERATOR(^=)
IMPLEMENT_BINARY_OPERATOR(&=)
IMPLEMENT_BINARY_OPERATOR(|=)
IMPLEMENT_BINARY_OPERATOR(<<=)
IMPLEMENT_BINARY_OPERATOR(>>=)
#endif // KICK_MATH_SENSE
#undef IMPLEMENT_BINARY_OPERATOR

/*
 * member operators with expressions
 */
#define IMPLEMENT_BINARY_OPERATOR(OPNAME, OP)				\
template<class T, std::size_t Sz>					\
template <class E>                                                    	\
inline									\
Vector<T, Sz>& Vector<T, Sz>::operator OP (XprVector<E, Sz> expr) {	\
  assign(expr, OPNAME<value_type, typename E::value_type>());         	\
  return *this;                                                       	\
}

IMPLEMENT_BINARY_OPERATOR(fcnl_Assign, =)
IMPLEMENT_BINARY_OPERATOR(fcnl_AddUpd, +=)
IMPLEMENT_BINARY_OPERATOR(fcnl_SubUpd, -=)
IMPLEMENT_BINARY_OPERATOR(fcnl_MulUpd, *=)
IMPLEMENT_BINARY_OPERATOR(fcnl_DivUpd, /=)
IMPLEMENT_BINARY_OPERATOR(fcnl_ModUpd, %=)
IMPLEMENT_BINARY_OPERATOR(fcnl_BitwiseXorUpd, ^=)
IMPLEMENT_BINARY_OPERATOR(fcnl_BitwiseAndUpd, &=)
IMPLEMENT_BINARY_OPERATOR(fcnl_BitwiseOrUpd, |=)
IMPLEMENT_BINARY_OPERATOR(fcnl_ShlUpd, <<=)
IMPLEMENT_BINARY_OPERATOR(fcnl_ShrUpd, >>=)
#undef IMPLEMENT_BINARY_OPERATOR

} // namespace tvmet

#endif // TVMET_VECTOR_IMPL_H

// Local Variables:
// mode:C++
// End:
